/*
 * Decompiled with CFR 0.152.
 */
public final class CubeReader4 {
    private static final String[] midString = new String[]{"U", "D", "F", "B", "L", "R"};
    private static final String[] edgeString = new String[]{"UF", "UR", "UB", "UL", "DF", "DR", "DB", "DL", "FR", "FL", "BR", "BL", "FU", "RU", "BU", "LU", "FD", "RD", "BD", "LD", "RF", "LF", "RB", "LB"};
    private static final String[] cornString = new String[]{"UFR", "URB", "UBL", "ULF", "DRF", "DFL", "DLB", "DBR", "FRU", "RBU", "BLU", "LFU", "RFD", "FLD", "LBD", "BRD", "RUF", "BUR", "LUB", "FUL", "FDR", "LDF", "BDL", "RDB", "URF", "UBR", "ULB", "UFL", "DFR", "DLF", "DBL", "DRB", "FUR", "RUB", "BUL", "LUF", "RDF", "FDL", "LDB", "BDR", "RFU", "BRU", "LBU", "FLU", "FRD", "LFD", "BLD", "RBD"};
    private static final int[] revbits = new int[]{0, 4, 2, 6, 1, 5, 3, 7};
    private static final int[] edgeor = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1};
    private int[] e = new int[24];
    private int[] ep1 = new int[24];
    private int[] c = new int[7];
    private int[] cp = new int[7];
    private int[] cp1 = new int[7];
    private int[] co = new int[7];
    private int[] co1 = new int[7];
    private int[] m = new int[24];
    private int[] mp1 = new int[24];
    private Solution4 solution;
    private CubeState4 state;
    private String input;
    private int inputPos;

    public String init(String string) {
        this.state = new CubeState4();
        String string2 = this.enter(string);
        if (string2 != "OK") {
            return string2;
        }
        this.preprocess();
        return "OK";
    }

    public void solve() {
        System.gc();
        TurnList4 turnList4 = new TurnList4(200000, this.state.turnMask);
        System.gc();
        Transform4 transform4 = new Transform4(this.state);
        Prune4 prune4 = new Prune4(transform4, this.state);
        this.solution = new Solution4(transform4, prune4, turnList4);
        this.solution.solve(this.state);
    }

    private String enter(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.input = string;
        this.inputPos = 0;
        this.state.turnMask = 262143;
        String[] stringArray = new String[24];
        int n7 = 0;
        while (n7 < 24) {
            stringArray[n7] = this.getInputToken();
            if (stringArray[n7].equals("Q") || stringArray[n7].equals("q")) {
                return "QUIT";
            }
            if (stringArray[n7].equals("N") || stringArray[n7].equals("n")) {
                return "NEW";
            }
            if (stringArray[n7].equals("")) {
                return "Insufficient number of edges";
            }
            if (stringArray[n7].charAt(0) >= '0' && stringArray[n7].charAt(0) <= '7') {
                this.state.turnMask = this.state.turnMask & 0x3FFF8 | revbits[stringArray[n7].charAt(0) - 48];
                if (stringArray[n7].length() > 1 && stringArray[n7].charAt(1) >= '0' && stringArray[n7].charAt(1) <= '7') {
                    this.state.turnMask = this.state.turnMask & 0x3FFC7 | revbits[stringArray[n7].charAt(1) - 48] << 3;
                }
                if (stringArray[n7].length() > 2 && stringArray[n7].charAt(2) >= '0' && stringArray[n7].charAt(2) <= '7') {
                    this.state.turnMask = this.state.turnMask & 0x3FE3F | revbits[stringArray[n7].charAt(2) - 48] << 6;
                }
                if (stringArray[n7].length() > 3 && stringArray[n7].charAt(3) >= '0' && stringArray[n7].charAt(3) <= '7') {
                    this.state.turnMask = this.state.turnMask & 0x3F1FF | revbits[stringArray[n7].charAt(3) - 48] << 9;
                }
                if (stringArray[n7].length() > 4 && stringArray[n7].charAt(4) >= '0' && stringArray[n7].charAt(4) <= '7') {
                    this.state.turnMask = this.state.turnMask & 0x38FFF | revbits[stringArray[n7].charAt(4) - 48] << 12;
                }
                if (stringArray[n7].length() > 5 && stringArray[n7].charAt(5) >= '0' && stringArray[n7].charAt(5) <= '7') {
                    this.state.turnMask = this.state.turnMask & Short.MAX_VALUE | revbits[stringArray[n7].charAt(5) - 48] << 15;
                }
                --n7;
            } else if (stringArray[n7].equals("!!")) {
                while (n7 < 24) {
                    stringArray[n7] = "!";
                    ++n7;
                }
            } else if (stringArray[n7].equals("??")) {
                while (n7 < 24) {
                    stringArray[n7] = "?";
                    ++n7;
                }
            }
            ++n7;
        }
        String[] stringArray2 = new String[7];
        int n8 = 0;
        while (n8 < 7) {
            stringArray2[n8] = this.getInputToken();
            if (stringArray2[n8].equals("Q") || stringArray2[n8].equals("q")) {
                return "QUIT";
            }
            if (stringArray2[n8].equals("N") || stringArray2[n8].equals("n")) {
                return "NEW";
            }
            if (stringArray2[n8].equals("")) {
                return "Insufficient number of corners";
            }
            if (stringArray2[n8].equals("!!")) {
                while (n8 < 7) {
                    stringArray2[n8] = "!";
                    ++n8;
                }
            } else if (stringArray2[n8].equals("@!!")) {
                while (n8 < 7) {
                    stringArray2[n8] = "@!";
                    ++n8;
                }
            } else if (stringArray2[n8].equals("??")) {
                while (n8 < 7) {
                    stringArray2[n8] = "?";
                    ++n8;
                }
            } else if (stringArray2[n8].equals("@??")) {
                while (n8 < 7) {
                    stringArray2[n8] = "@?";
                    ++n8;
                }
            }
            ++n8;
        }
        String[] stringArray3 = new String[24];
        int n9 = 0;
        while (n9 < 24) {
            stringArray3[n9] = this.getInputToken();
            if (stringArray3[n9].equals("Q") || stringArray3[n9].equals("q")) {
                return "QUIT";
            }
            if (stringArray3[n9].equals("N") || stringArray3[n9].equals("n")) {
                return "NEW";
            }
            if (stringArray3[n9].equals("")) {
                return "Insufficient number of edges";
            }
            if (stringArray3[n9].equals("!!")) {
                while (n9 < 24) {
                    stringArray3[n9] = "!";
                    ++n9;
                }
            } else if (stringArray3[n9].equals("??")) {
                while (n9 < 24) {
                    stringArray3[n9] = "?";
                    ++n9;
                }
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < 24) {
            this.e[n10] = 0;
            this.ep1[n10] = 1;
            ++n10;
        }
        int n11 = 0;
        while (n11 < 24) {
            if (stringArray[n11].equals("!")) {
                this.e[n11] = n11 + 1;
                this.ep1[n11] = 0;
            } else if (!stringArray[n11].equals("?")) {
                n6 = 0;
                n5 = 0;
                while (n5 < edgeString.length) {
                    if (stringArray[n11].equals(edgeString[n5])) {
                        n4 = n11 & 1 ^ n5 / 12 ^ (edgeor[n11 / 2] ^ edgeor[n5 % 12]);
                        this.e[n11] = n5 % 12 * 2 + n4 + 1;
                        this.ep1[this.e[n11] - 1] = 0;
                        n6 = 1;
                        break;
                    }
                    ++n5;
                }
                if (n6 == 0) {
                    return "Improper edge: " + stringArray[n11];
                }
            }
            ++n11;
        }
        n6 = 0;
        while (n6 < 7) {
            this.c[n6] = 0;
            this.cp[n6] = 0;
            this.co[n6] = 0;
            this.cp1[n6] = 1;
            this.co1[n6] = -1;
            ++n6;
        }
        n5 = 0;
        while (n5 < 7) {
            if (stringArray2[n5].equals("!")) {
                this.c[n5] = n5 + 1;
                this.cp[n5] = n5 + 1;
                this.co[n5] = 1;
                this.cp1[n5] = 0;
                this.co1[n5] = 0;
            } else if (stringArray2[n5].equals("@!")) {
                this.c[n5] = n5 + 1;
                this.cp[n5] = n5 + 1;
                this.cp1[n5] = 0;
                this.co1[n5] = 1;
            } else if (stringArray2[n5].equals("+!")) {
                this.c[n5] = n5 + 8 + 1;
                this.cp[n5] = n5 + 1;
                this.co[n5] = 2;
                this.cp1[n5] = 0;
                this.co1[n5] = 0;
            } else if (stringArray2[n5].equals("-!")) {
                this.c[n5] = n5 + 16 + 1;
                this.cp[n5] = n5 + 1;
                this.co[n5] = 3;
                this.cp1[n5] = 0;
                this.co1[n5] = 0;
            } else if (stringArray2[n5].equals("?")) {
                this.co[n5] = 1;
            } else if (!stringArray2[n5].equals("@?")) {
                if (stringArray2[n5].equals("+?")) {
                    this.co[n5] = 2;
                } else if (stringArray2[n5].equals("-?")) {
                    this.co[n5] = 3;
                } else if (stringArray2[n5].charAt(0) == '@') {
                    n4 = 0;
                    n3 = 0;
                    while (n3 < cornString.length) {
                        if (stringArray2[n5].substring(1).equals(cornString[n3])) {
                            if (n3 % 8 == 7) {
                                return "Fixed corner: " + stringArray2[n5];
                            }
                            this.c[n5] = n3 % 24 % 8 + 1;
                            this.cp[n5] = (this.c[n5] - 1) % 8 + 1;
                            this.cp1[this.cp[n5] - 1] = 0;
                            this.co1[this.cp[n5] - 1] = 1;
                            n4 = 1;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 == 0) {
                        return "Improper corner: " + stringArray2[n5];
                    }
                } else if (stringArray2[n5].charAt(0) == '+') {
                    n4 = 0;
                    n3 = 0;
                    while (n3 < cornString.length) {
                        if (stringArray2[n5].substring(1).equals(cornString[n3])) {
                            if (n3 % 8 == 7) {
                                return "Fixed corner: " + stringArray2[n5];
                            }
                            this.c[n5] = (n3 + 8) % 24 + 1;
                            this.cp[n5] = (this.c[n5] - 1) % 8 + 1;
                            this.co[n5] = (this.c[n5] - 1) / 8 + 1;
                            this.cp1[this.cp[n5] - 1] = 0;
                            this.co1[this.cp[n5] - 1] = 0;
                            n4 = 1;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 == 0) {
                        return "Improper corner: " + stringArray2[n5];
                    }
                } else if (stringArray2[n5].charAt(0) == '-') {
                    n4 = 0;
                    n3 = 0;
                    while (n3 < cornString.length) {
                        if (stringArray2[n5].substring(1).equals(cornString[n3])) {
                            if (n3 % 8 == 7) {
                                return "Fixed corner: " + stringArray2[n5];
                            }
                            this.c[n5] = (n3 + 16) % 24 + 1;
                            this.cp[n5] = (this.c[n5] - 1) % 8 + 1;
                            this.co[n5] = (this.c[n5] - 1) / 8 + 1;
                            this.cp1[this.cp[n5] - 1] = 0;
                            this.co1[this.cp[n5] - 1] = 0;
                            n4 = 1;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 == 0) {
                        return "Improper corner: " + stringArray2[n5];
                    }
                } else {
                    n4 = 0;
                    n3 = 0;
                    while (n3 < cornString.length) {
                        if (stringArray2[n5].equals(cornString[n3])) {
                            if (n3 % 8 == 7) {
                                return "Fixed corner: " + stringArray2[n5];
                            }
                            this.c[n5] = n3 % 24 + 1;
                            this.cp[n5] = (this.c[n5] - 1) % 8 + 1;
                            this.co[n5] = (this.c[n5] - 1) / 8 + 1;
                            this.cp1[this.cp[n5] - 1] = 0;
                            this.co1[this.cp[n5] - 1] = 0;
                            n4 = 1;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 == 0) {
                        return "Improper corner: " + stringArray2[n5];
                    }
                }
            }
            ++n5;
        }
        n4 = 0;
        while (n4 < 7) {
            if (this.cp[n4] == 0) {
                if (this.co[n4] != 0) {
                    n3 = 0;
                    n2 = 0;
                    while (n2 < 7) {
                        if (this.co1[n2] == -1) {
                            this.co1[n2] = 0;
                            n3 = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 == 0) {
                        return "Bad corner format";
                    }
                } else {
                    n3 = 0;
                    n2 = 0;
                    while (n2 < 7) {
                        if (this.co1[n2] == -1) {
                            this.co1[n2] = 1;
                            n3 = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 == 0) {
                        return "Bad corner format";
                    }
                }
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < 7) {
            if (this.co1[n3] == -1) {
                return "Bad corner format";
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 24) {
            this.m[n2] = 0;
            ++n2;
        }
        int n12 = 0;
        while (n12 < 24) {
            if (stringArray3[n12].equals("!")) {
                this.m[n12] = n12 / 4 + 1;
            } else if (!stringArray3[n12].equals("?")) {
                boolean bl = false;
                n = 0;
                while (n < midString.length) {
                    if (stringArray3[n12].equals(midString[n])) {
                        this.m[n12] = n + 1;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    return "Improper center: " + stringArray3[n12];
                }
            }
            ++n12;
        }
        int[] nArray = new int[6];
        n = 0;
        while (n < 24) {
            this.mp1[n] = 1;
            ++n;
        }
        int n13 = 0;
        while (n13 < 24) {
            if (this.m[n13] > 0) {
                int n14 = this.m[n13] - 1;
                nArray[n14] = nArray[n14] + 1;
                this.mp1[(this.m[n13] - 1) * 4 + n15] = 0;
            }
            ++n13;
        }
        int n15 = 0;
        while (n15 < 6) {
            if (nArray[n15] > 4) {
                return nArray[n15] + " " + midString[n15] + " centers";
            }
            ++n15;
        }
        return this.check();
    }

    private String check() {
        Comb comb = new Comb(24);
        comb.fill(this.e);
        if (!comb.checkVar()) {
            return "Bad edges";
        }
        Comb comb2 = new Comb(7);
        comb2.fill(this.cp);
        if (!comb2.checkVar()) {
            return "Bad corners";
        }
        int n = comb2.varParity();
        int n2 = comb.varParity();
        if (n == -1) {
            return "Specify the position of the last corner";
        }
        if (n2 == -1) {
            return "Specify the position of the last edge";
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < 7) {
            if (this.co[n4] == 0) {
                n3 = -1;
                break;
            }
            n3 += this.co[n4] - 1;
            ++n4;
        }
        if (n3 >= 0 && n3 % 3 != 0) {
            return "Twist any corner " + (n3 % 3 == 1 ? "counter " : "") + "clock-wise";
        }
        return "OK";
    }

    private void preprocess() {
        this.state.minimum = 101;
        this.state.depth = 0;
        System.err.println("Edge:");
        int n = 0;
        while (n < 24) {
            System.err.print(this.e[n] == 0 ? "  ." : CubeReader4.padInt(this.e[n] - 1, 3));
            ++n;
        }
        System.err.println();
        int n2 = 0;
        while (n2 < 24) {
            System.err.print("  " + (this.ep1[n2] == 0 ? "#" : "?"));
            ++n2;
        }
        System.err.println();
        System.err.println("Corner:");
        int n3 = 0;
        while (n3 < 7) {
            System.err.print(this.c[n3] == 0 ? "  ." : CubeReader4.padInt(this.c[n3] - 1, 3));
            ++n3;
        }
        System.err.println();
        int n4 = 0;
        while (n4 < 7) {
            System.err.print(this.cp[n4] == 0 ? "  ." : CubeReader4.padInt(this.cp[n4] - 1, 3));
            ++n4;
        }
        System.err.println();
        int n5 = 0;
        while (n5 < 7) {
            System.err.print("  " + (this.cp1[n5] == 0 ? "#" : "?"));
            ++n5;
        }
        System.err.println();
        int n6 = 0;
        while (n6 < 7) {
            System.err.print(this.co[n6] == 0 ? "  ." : CubeReader4.padInt(this.co[n6] % 3 - 1, 3));
            ++n6;
        }
        System.err.println();
        int n7 = 0;
        while (n7 < 7) {
            System.err.print("  " + (this.co1[n7] == 0 ? "#" : "?"));
            ++n7;
        }
        System.err.println();
        System.err.println("Center:");
        int n8 = 0;
        while (n8 < 24) {
            System.err.print(this.m[n8] == 0 ? "  ." : CubeReader4.padInt(this.m[n8] - 1, 3));
            ++n8;
        }
        System.err.println();
        int n9 = 0;
        while (n9 < 24) {
            System.err.print("  " + (this.mp1[n9] == 0 ? "#" : "?"));
            ++n9;
        }
        System.err.println();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < 7) {
            n10 |= this.co1[n12] << n12;
            n11 |= this.cp1[n12] << n12;
            ++n12;
        }
        this.state.coActive = n10 |= n11 << 8;
        this.state.cActive = n11;
        PackCornTwist4 packCornTwist4 = new PackCornTwist4(n10);
        packCornTwist4.fill(this.co);
        this.state.cornTwist = packCornTwist4.pack();
        PackCornPerm4 packCornPerm4 = new PackCornPerm4(n11);
        packCornPerm4.fill(this.cp);
        this.state.cornPerm = packCornPerm4.pack();
        int n13 = 0;
        int n14 = 0;
        while (n14 < 24) {
            n13 |= this.ep1[n14] << n14;
            ++n14;
        }
        this.state.eActive = n13;
        int[] nArray = new int[24];
        int n15 = 1;
        int n16 = 0;
        while (n16 < 24) {
            nArray[n16] = 0;
            ++n16;
        }
        int n17 = 0;
        while (n17 < 24) {
            if (this.e[n17] == 1) {
                nArray[n17] = n15++;
            }
            ++n17;
        }
        int n18 = 0;
        while (n18 < 24) {
            if (this.e[n18] == 2) {
                nArray[n18] = n15;
            }
            ++n18;
        }
        PackEdgePos4 packEdgePos4 = new PackEdgePos4(n13, 0);
        packEdgePos4.fill(nArray);
        this.state.edgePosUF = packEdgePos4.pack();
        n15 = 1;
        int n19 = 0;
        while (n19 < 24) {
            nArray[n19] = 0;
            ++n19;
        }
        int n20 = 0;
        while (n20 < 24) {
            if (this.e[n20] == 3) {
                nArray[n20] = n15++;
            }
            ++n20;
        }
        int n21 = 0;
        while (n21 < 24) {
            if (this.e[n21] == 4) {
                nArray[n21] = n15;
            }
            ++n21;
        }
        PackEdgePos4 packEdgePos42 = new PackEdgePos4(n13, 2);
        packEdgePos42.fill(nArray);
        this.state.edgePosUR = packEdgePos42.pack();
        n15 = 1;
        int n22 = 0;
        while (n22 < 24) {
            nArray[n22] = 0;
            ++n22;
        }
        int n23 = 0;
        while (n23 < 24) {
            if (this.e[n23] == 5) {
                nArray[n23] = n15++;
            }
            ++n23;
        }
        int n24 = 0;
        while (n24 < 24) {
            if (this.e[n24] == 6) {
                nArray[n24] = n15;
            }
            ++n24;
        }
        PackEdgePos4 packEdgePos43 = new PackEdgePos4(n13, 4);
        packEdgePos43.fill(nArray);
        this.state.edgePosUB = packEdgePos43.pack();
        n15 = 1;
        int n25 = 0;
        while (n25 < 24) {
            nArray[n25] = 0;
            ++n25;
        }
        int n26 = 0;
        while (n26 < 24) {
            if (this.e[n26] == 7) {
                nArray[n26] = n15++;
            }
            ++n26;
        }
        int n27 = 0;
        while (n27 < 24) {
            if (this.e[n27] == 8) {
                nArray[n27] = n15;
            }
            ++n27;
        }
        PackEdgePos4 packEdgePos44 = new PackEdgePos4(n13, 6);
        packEdgePos44.fill(nArray);
        this.state.edgePosUL = packEdgePos44.pack();
        n15 = 1;
        int n28 = 0;
        while (n28 < 24) {
            nArray[n28] = 0;
            ++n28;
        }
        int n29 = 0;
        while (n29 < 24) {
            if (this.e[n29] == 9) {
                nArray[n29] = n15++;
            }
            ++n29;
        }
        int n30 = 0;
        while (n30 < 24) {
            if (this.e[n30] == 10) {
                nArray[n30] = n15;
            }
            ++n30;
        }
        PackEdgePos4 packEdgePos45 = new PackEdgePos4(n13, 8);
        packEdgePos45.fill(nArray);
        this.state.edgePosDF = packEdgePos45.pack();
        n15 = 1;
        int n31 = 0;
        while (n31 < 24) {
            nArray[n31] = 0;
            ++n31;
        }
        int n32 = 0;
        while (n32 < 24) {
            if (this.e[n32] == 11) {
                nArray[n32] = n15++;
            }
            ++n32;
        }
        int n33 = 0;
        while (n33 < 24) {
            if (this.e[n33] == 12) {
                nArray[n33] = n15;
            }
            ++n33;
        }
        PackEdgePos4 packEdgePos46 = new PackEdgePos4(n13, 10);
        packEdgePos46.fill(nArray);
        this.state.edgePosDR = packEdgePos46.pack();
        n15 = 1;
        int n34 = 0;
        while (n34 < 24) {
            nArray[n34] = 0;
            ++n34;
        }
        int n35 = 0;
        while (n35 < 24) {
            if (this.e[n35] == 13) {
                nArray[n35] = n15++;
            }
            ++n35;
        }
        int n36 = 0;
        while (n36 < 24) {
            if (this.e[n36] == 14) {
                nArray[n36] = n15;
            }
            ++n36;
        }
        PackEdgePos4 packEdgePos47 = new PackEdgePos4(n13, 12);
        packEdgePos47.fill(nArray);
        this.state.edgePosDB = packEdgePos47.pack();
        n15 = 1;
        int n37 = 0;
        while (n37 < 24) {
            nArray[n37] = 0;
            ++n37;
        }
        int n38 = 0;
        while (n38 < 24) {
            if (this.e[n38] == 15) {
                nArray[n38] = n15++;
            }
            ++n38;
        }
        int n39 = 0;
        while (n39 < 24) {
            if (this.e[n39] == 16) {
                nArray[n39] = n15;
            }
            ++n39;
        }
        PackEdgePos4 packEdgePos48 = new PackEdgePos4(n13, 14);
        packEdgePos48.fill(nArray);
        this.state.edgePosDL = packEdgePos48.pack();
        n15 = 1;
        int n40 = 0;
        while (n40 < 24) {
            nArray[n40] = 0;
            ++n40;
        }
        int n41 = 0;
        while (n41 < 24) {
            if (this.e[n41] == 17) {
                nArray[n41] = n15++;
            }
            ++n41;
        }
        int n42 = 0;
        while (n42 < 24) {
            if (this.e[n42] == 18) {
                nArray[n42] = n15;
            }
            ++n42;
        }
        PackEdgePos4 packEdgePos49 = new PackEdgePos4(n13, 16);
        packEdgePos49.fill(nArray);
        this.state.edgePosFR = packEdgePos49.pack();
        n15 = 1;
        int n43 = 0;
        while (n43 < 24) {
            nArray[n43] = 0;
            ++n43;
        }
        int n44 = 0;
        while (n44 < 24) {
            if (this.e[n44] == 19) {
                nArray[n44] = n15++;
            }
            ++n44;
        }
        int n45 = 0;
        while (n45 < 24) {
            if (this.e[n45] == 20) {
                nArray[n45] = n15;
            }
            ++n45;
        }
        PackEdgePos4 packEdgePos410 = new PackEdgePos4(n13, 18);
        packEdgePos410.fill(nArray);
        this.state.edgePosFL = packEdgePos410.pack();
        n15 = 1;
        int n46 = 0;
        while (n46 < 24) {
            nArray[n46] = 0;
            ++n46;
        }
        int n47 = 0;
        while (n47 < 24) {
            if (this.e[n47] == 21) {
                nArray[n47] = n15++;
            }
            ++n47;
        }
        int n48 = 0;
        while (n48 < 24) {
            if (this.e[n48] == 22) {
                nArray[n48] = n15;
            }
            ++n48;
        }
        PackEdgePos4 packEdgePos411 = new PackEdgePos4(n13, 20);
        packEdgePos411.fill(nArray);
        this.state.edgePosBR = packEdgePos411.pack();
        n15 = 1;
        int n49 = 0;
        while (n49 < 24) {
            nArray[n49] = 0;
            ++n49;
        }
        int n50 = 0;
        while (n50 < 24) {
            if (this.e[n50] == 23) {
                nArray[n50] = n15++;
            }
            ++n50;
        }
        int n51 = 0;
        while (n51 < 24) {
            if (this.e[n51] == 24) {
                nArray[n51] = n15;
            }
            ++n51;
        }
        PackEdgePos4 packEdgePos412 = new PackEdgePos4(n13, 22);
        packEdgePos412.fill(nArray);
        this.state.edgePosBL = packEdgePos412.pack();
        int n52 = 0;
        int n53 = 0;
        while (n53 < 24) {
            n52 |= this.mp1[n53] << n53;
            ++n53;
        }
        this.state.mActive = n52;
        int[] nArray2 = new int[24];
        int n54 = 0;
        while (n54 < 24) {
            nArray2[n54] = this.m[n54] == 1 ? 1 : 0;
            ++n54;
        }
        PackMidLoc4 packMidLoc4 = new PackMidLoc4(n52, 0);
        packMidLoc4.fill(nArray2);
        this.state.midLocU = packMidLoc4.pack();
        int n55 = 0;
        while (n55 < 24) {
            nArray2[n55] = this.m[n55] == 2 ? 1 : 0;
            ++n55;
        }
        PackMidLoc4 packMidLoc42 = new PackMidLoc4(n52, 4);
        packMidLoc42.fill(nArray2);
        this.state.midLocD = packMidLoc42.pack();
        int n56 = 0;
        while (n56 < 24) {
            nArray2[n56] = this.m[n56] == 3 ? 1 : 0;
            ++n56;
        }
        PackMidLoc4 packMidLoc43 = new PackMidLoc4(n52, 8);
        packMidLoc43.fill(nArray2);
        this.state.midLocF = packMidLoc43.pack();
        int n57 = 0;
        while (n57 < 24) {
            nArray2[n57] = this.m[n57] == 4 ? 1 : 0;
            ++n57;
        }
        PackMidLoc4 packMidLoc44 = new PackMidLoc4(n52, 12);
        packMidLoc44.fill(nArray2);
        this.state.midLocB = packMidLoc44.pack();
        int n58 = 0;
        while (n58 < 24) {
            nArray2[n58] = this.m[n58] == 5 ? 1 : 0;
            ++n58;
        }
        PackMidLoc4 packMidLoc45 = new PackMidLoc4(n52, 16);
        packMidLoc45.fill(nArray2);
        this.state.midLocL = packMidLoc45.pack();
        int n59 = 0;
        while (n59 < 24) {
            nArray2[n59] = this.m[n59] == 6 ? 1 : 0;
            ++n59;
        }
        PackMidLoc4 packMidLoc46 = new PackMidLoc4(n52, 20);
        packMidLoc46.fill(nArray2);
        this.state.midLocR = packMidLoc46.pack();
        int[] nArray3 = new int[7];
        int n60 = 0;
        while (n60 < 7) {
            nArray3[n60] = this.cp[n60] == 1 || this.cp[n60] == 3 || this.cp[n60] == 4 || this.cp[n60] == 6 ? this.cp[n60] : 0;
            ++n60;
        }
        PackACornPerm4 packACornPerm4 = new PackACornPerm4(n11);
        packACornPerm4.fill(nArray3);
        this.state.aCornPerm = packACornPerm4.pack();
        int n61 = 0;
        while (n61 < 7) {
            nArray3[n61] = this.cp[n61] == 2 || this.cp[n61] == 4 || this.cp[n61] == 5 || this.cp[n61] == 7 ? this.cp[n61] : 0;
            ++n61;
        }
        PackOCornPerm4 packOCornPerm4 = new PackOCornPerm4(n11);
        packOCornPerm4.fill(nArray3);
        this.state.oCornPerm = packOCornPerm4.pack();
    }

    private String getInputToken() {
        String string = "";
        while (this.inputPos < this.input.length() && this.input.charAt(this.inputPos) <= ' ') {
            ++this.inputPos;
        }
        while (this.inputPos < this.input.length() && this.input.charAt(this.inputPos) > ' ') {
            string = string + this.input.charAt(this.inputPos);
            ++this.inputPos;
        }
        return string;
    }

    public static String padInt(int n, int n2) {
        String string = "" + n;
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }
}

