/*
 * Decompiled with CFR 0.152.
 */
public final class Solution4 {
    public static final String[] turnSymbol = new String[]{"U", "U2", "U'", "F", "F2", "F'", "L", "L2", "L'", "Uu", "U2u2", "U'u'", "Ff", "F2f2", "F'f'", "Ll", "L2l2", "L'l'", "u", "u2", "u'", "d", "d2", "d'", "f", "f2", "f'", "b", "b2", "b'", "l", "l2", "l'", "r", "r2", "r'", "ud'", "u2d2", "u'd", "fb'", "f2b2", "f'b", "lr'", "l2r2", "l'r", "Uud'", "U2u2d2", "U'u'd", "Ffb'", "F2f2b2", "F'f'b", "Llr'", "L2l2r2", "L'l'r"};
    private Transform4 transform;
    private Prune4 prune;
    private TurnList4 turnList;
    private CubeState4 state;
    private int minLength;
    private Node[] stack = new Node[100];
    private int stackn;
    private long soln;
    private long prn;
    private long pry;

    public Solution4(Transform4 transform4, Prune4 prune4, TurnList4 turnList4) {
        this.transform = transform4;
        this.prune = prune4;
        this.turnList = turnList4;
        int n = 0;
        while (n < this.stack.length) {
            this.stack[n] = new Node();
            ++n;
        }
    }

    public void solve(CubeState4 cubeState4) {
        this.state = cubeState4;
        this.solve();
    }

    private void solve() {
        this.minLength = this.state.minimum;
        this.prn = 0L;
        this.pry = 0L;
        this.soln = 0L;
        Node node = this.stack[0];
        node.cornTwist = this.state.cornTwist;
        node.cornPerm = this.state.cornPerm;
        node.midLocU = this.state.midLocU;
        node.midLocD = this.state.midLocD;
        node.midLocF = this.state.midLocF;
        node.midLocB = this.state.midLocB;
        node.midLocL = this.state.midLocL;
        node.midLocR = this.state.midLocR;
        node.edgePosUF = this.state.edgePosUF;
        node.edgePosUR = this.state.edgePosUR;
        node.edgePosUB = this.state.edgePosUB;
        node.edgePosUL = this.state.edgePosUL;
        node.edgePosDF = this.state.edgePosDF;
        node.edgePosDR = this.state.edgePosDR;
        node.edgePosDB = this.state.edgePosDB;
        node.edgePosDL = this.state.edgePosDL;
        node.edgePosFR = this.state.edgePosFR;
        node.edgePosFL = this.state.edgePosFL;
        node.edgePosBR = this.state.edgePosBR;
        node.edgePosBL = this.state.edgePosBL;
        node.aCornPerm = this.state.aCornPerm;
        node.oCornPerm = this.state.oCornPerm;
        node.turn = -2;
        node.turnList = 0;
        int n = this.prune.distance(node.cornTwist, node.cornPerm, node.midLocU, node.midLocD, node.midLocF, node.midLocB, node.midLocL, node.midLocR, node.edgePosUF, node.edgePosUR, node.edgePosUB, node.edgePosUL, node.edgePosDF, node.edgePosDR, node.edgePosDB, node.edgePosDL, node.edgePosFR, node.edgePosFL, node.edgePosBR, node.edgePosBL, node.aCornPerm, node.oCornPerm);
        if (n < this.state.depth) {
            n = this.state.depth;
        }
        int n2 = n;
        while (n2 <= this.minLength) {
            System.err.println("depth " + n2 + "...");
            this.search(n2);
            ++n2;
        }
        System.err.println("Done. (" + this.soln + " solutions found)");
        if (this.prn > 0L) {
            long l = this.prn < 10000L ? this.pry * 100L / this.prn : this.pry / (this.prn / 100L);
            System.err.println(" (" + l + "% save - " + this.pry + " of " + this.prn + " entries)");
        }
    }

    private void search(int n) {
        this.stackn = 0;
        this.stack[0].restDepth = n;
        this.stack[1].turn = -1;
        while (this.stackn >= 0) {
            if (this.stack[this.stackn].restDepth == 0) {
                this.display();
                this.minLength = this.stack[0].restDepth;
                ++this.soln;
                --this.stackn;
                continue;
            }
            Node node = this.stack[this.stackn];
            Node node2 = this.stack[this.stackn + 1];
            int n2 = node2.turn + 1;
            while (n2 < 54) {
                int n3 = this.turnList.next[node.turnList * 54 + n2];
                if (n3 == -1) {
                    ++n2;
                    continue;
                }
                node2.restDepth = node.restDepth - 1;
                node2.cornTwist = this.transform.cornTwist.turn[n2][node.cornTwist];
                node2.cornPerm = this.transform.cornPerm.turn[n2][node.cornPerm];
                node2.midLocU = this.transform.midLoc[0].turn[n2][node.midLocU];
                node2.midLocD = this.transform.midLoc[1].turn[n2][node.midLocD];
                node2.midLocF = this.transform.midLoc[2].turn[n2][node.midLocF];
                node2.midLocB = this.transform.midLoc[3].turn[n2][node.midLocB];
                node2.midLocL = this.transform.midLoc[4].turn[n2][node.midLocL];
                node2.midLocR = this.transform.midLoc[5].turn[n2][node.midLocR];
                node2.edgePosUF = this.transform.edgePos[0].turn[n2][node.edgePosUF];
                node2.edgePosUR = this.transform.edgePos[1].turn[n2][node.edgePosUR];
                node2.edgePosUB = this.transform.edgePos[2].turn[n2][node.edgePosUB];
                node2.edgePosUL = this.transform.edgePos[3].turn[n2][node.edgePosUL];
                node2.edgePosDF = this.transform.edgePos[4].turn[n2][node.edgePosDF];
                node2.edgePosDR = this.transform.edgePos[5].turn[n2][node.edgePosDR];
                node2.edgePosDB = this.transform.edgePos[6].turn[n2][node.edgePosDB];
                node2.edgePosDL = this.transform.edgePos[7].turn[n2][node.edgePosDL];
                node2.edgePosFR = this.transform.edgePos[8].turn[n2][node.edgePosFR];
                node2.edgePosFL = this.transform.edgePos[9].turn[n2][node.edgePosFL];
                node2.edgePosBR = this.transform.edgePos[10].turn[n2][node.edgePosBR];
                node2.edgePosBL = this.transform.edgePos[11].turn[n2][node.edgePosBL];
                node2.aCornPerm = this.transform.aCornPerm.turn[n2][node.aCornPerm];
                node2.oCornPerm = this.transform.oCornPerm.turn[n2][node.oCornPerm];
                ++this.prn;
                if (this.prune.over(node2.restDepth, node2.cornTwist, node2.cornPerm, node2.midLocU, node2.midLocD, node2.midLocF, node2.midLocB, node2.midLocL, node2.midLocR, node2.edgePosUF, node2.edgePosUR, node2.edgePosUB, node2.edgePosUL, node2.edgePosDF, node2.edgePosDR, node2.edgePosDB, node2.edgePosDL, node2.edgePosFR, node2.edgePosFL, node2.edgePosBR, node2.edgePosBL, node2.aCornPerm, node2.oCornPerm)) {
                    ++this.pry;
                    ++n2;
                    continue;
                }
                node2.turn = n2;
                node2.turnList = n3;
                break;
            }
            if (n2 == 54) {
                --this.stackn;
                continue;
            }
            ++this.stackn;
            this.stack[this.stackn + 1].turn = -1;
        }
    }

    private void display() {
        int n = 0;
        int n2 = 1;
        while (n2 <= this.stackn) {
            int n3 = this.stack[n2].turn;
            ++n;
            System.out.print(turnSymbol[n3] + " ");
            ++n2;
        }
        System.out.println("(" + n + ")");
    }

    private final class Node {
        public int restDepth;
        public int turn;
        public int turnList;
        public int cornTwist;
        public int cornPerm;
        public int midLocU;
        public int midLocD;
        public int midLocF;
        public int midLocB;
        public int midLocL;
        public int midLocR;
        public int edgePosUF;
        public int edgePosUR;
        public int edgePosUB;
        public int edgePosUL;
        public int edgePosDF;
        public int edgePosDR;
        public int edgePosDB;
        public int edgePosDL;
        public int edgePosFR;
        public int edgePosFL;
        public int edgePosBR;
        public int edgePosBL;
        public int aCornPerm;
        public int oCornPerm;

        private Node() {
        }
    }
}

