/**
 * 2 edge ordered positions for 4x4x4.
 */
public class PackEdgePos4 {
  private final Comb comb;
  private int active;
  private int pos;

  public PackEdgePos4(int active, int pos) {
    this.active = active;
    this.pos = pos;
    comb = new Comb(24, active(active, pos));
  }

  private static int active(int active, int pos) {
    int r = 0;
    if ((active & (1 << pos)) == 0) r++;
    if ((active & (2 << pos)) == 0) r++;
    return r;
  }

  public int pack() {
    return comb.varPack();
  }

  public void unpack(int s) {
    comb.varUnpack(s);
  }

  public int len() {
    return comb.var;
  }

  public int startLen() {
    return 1;
  }

  public int start(int s) {
    int r = 1;
    comb.clear();
    if ((active & (1 << pos)) == 0) comb.a[pos] = r++;
    if ((active & (2 << pos)) == 0) comb.a[pos + 1] = r++;
    return pack();
  }

  public void cycle(int i1, int i2, int i3, int i4) {
    comb.cycle(i1, i2, i3, i4);
  }

  public void fill(int[] a) {
    comb.fill(a);
  }
}
