/**
 * 4 center locations for 4x4x4.
 */
public class PackMidLoc4 {
  private final Comb comb;
  private int active;
  private int pos;

  public PackMidLoc4(int active, int pos) {
    this.active = active;
    this.pos = pos;
    comb = new Comb(24, active(active, pos));
  }

  private static int active(int active, int pos) {
    int r = 0;
    if ((active & (1 << pos)) == 0) r++;
    if ((active & (2 << pos)) == 0) r++;
    if ((active & (4 << pos)) == 0) r++;
    if ((active & (8 << pos)) == 0) r++;
    return r;
  }

  public int pack() {
    return comb.combPack();
  }

  public void unpack(int e) {
    comb.combUnpack(e);
  }

  public int len() {
    return comb.comb;
  }

  public int startLen() {
    return comb.comb(4, active(active, pos));
  }

  public int start(int s) {
    Comb c = new Comb(4, active(active, pos));
    c.combUnpack(s);
    comb.clear();
    comb.a[pos] = c.a[0];
    comb.a[pos + 1] = c.a[1];
    comb.a[pos + 2] = c.a[2];
    comb.a[pos + 3] = c.a[3];
    return pack();
  }

  public void cycle(int i1, int i2, int i3, int i4) {
    comb.cycle(i1, i2, i3, i4);
  }

  public void fill(int[] a) {
    comb.fill(a);
  }
}
