
final class PruneACornEdge4 {
  private byte[] distance;
  private int len;

  private static final String[] txt =
    {"UF", "UR", "UB", "UL", "DF", "DR", "DB", "DL", "FR", "FL", "BR", "BL"};

  public int distance(int ac, int ep) {
    return distance[ac * len + (ep >> 1)] >> (ep & 1) * 4 & 15;
  }

  public PruneACornEdge4(Transform4 transform, int cActive, int eActive, int pos, int mask) {
    PackACornPerm4 packACornPerm = new PackACornPerm4(cActive);
    int acLen = packACornPerm.len();
    int acStart = packACornPerm.startLen();
    PackEdgePos4 packEdgePos = new PackEdgePos4(eActive, pos);
    int epLen = packEdgePos.len();
    int epStart = packEdgePos.startLen();
    len = epLen + 1 >> 1;
    distance = new byte[acLen * len];
    for (int ac = 0; ac < acLen; ac++)
      for (int ep = 0; ep < len; ep++)
        distance[ac * len + ep] = (byte)255;
    System.err.print(" adjacent corner - " + txt[pos / 2] + " edge position:");
    System.err.print(" " + acStart + "x" + epStart + "=" + acStart * epStart);
    for (int ac = 0; ac < acStart; ac++) {
      for (int ep = 0; ep < epStart; ep++) {
        int s1 = packACornPerm.start(ac);
        int s2 = packEdgePos.start(ep);
        distance[s1 * len + (s2 >> 1)] ^= 15 << (s2 & 1) * 4;
      }
    }
    int states = acStart * epStart;
    byte depth = 0;
    int total = 0;
    while (states > 0) {
      total += states;
      //System.err.println("   " + CubeReader4.padInt(depth, 2) + " " +
       //CubeReader4.padInt(states, 8) + " " + CubeReader4.padInt(total, 10));
      states = 0;
      depth++;
      for (int ac = 0; ac < acLen; ac++) {
        for (int ep = 0; ep < epLen; ep++) {
          if (distance(ac, ep) == depth - 1) {
            for (int t = 0; t < Turn4.NUM; t++) {
              if ((Turn4.turnMask[t] & mask) != 0) {
                int nac = transform.aCornPerm.turn[t][ac];
                int nep = transform.edgePos[pos / 2].turn[t][ep];
                int ind = nac * len + (nep >> 1);
                int sh = (nep & 1) * 4;
                if ((distance[ind] >> sh & 15) > depth) {
                  distance[ind] = (byte)(distance[ind] & ~(15 << sh) | depth << sh);
                  states++;
                }
              }
            }
          }
        }
      }
    }
    System.err.println(" -> " + total + " / " + (depth - 1));
  }
}
