
public final class TransformOCornPerm4 {
  public short[][] turn;
  private PackOCornPerm4 pack;

  public TransformOCornPerm4(int cActive) {
    System.err.print(" opposite corner permutation:");
    pack = new PackOCornPerm4(cActive);
    int n = pack.len();
    turn = new short[Turn4.NUM][n];
    for (int i = 0; i < n; i++) {
      turn[Turn4.U1][i] = turn[Turn4.Uu1][i] = turn[Turn4.UU1][i] = up(i);
      turn[Turn4.F1][i] = turn[Turn4.Ff1][i] = turn[Turn4.FF1][i] = front(i);
      turn[Turn4.L1][i] = turn[Turn4.Ll1][i] = turn[Turn4.LL1][i] = left(i);
      turn[Turn4.ud1][i] = turn[Turn4.ud2][i] = turn[Turn4.ud3][i] = (short)i;
      turn[Turn4.fb1][i] = turn[Turn4.fb2][i] = turn[Turn4.fb3][i] = (short)i;
      turn[Turn4.lr1][i] = turn[Turn4.lr2][i] = turn[Turn4.lr3][i] = (short)i;
      turn[Turn4.u1][i] = turn[Turn4.u2][i] = turn[Turn4.u3][i] = (short)i;
      turn[Turn4.d1][i] = turn[Turn4.d2][i] = turn[Turn4.d3][i] = (short)i;
      turn[Turn4.f1][i] = turn[Turn4.f2][i] = turn[Turn4.f3][i] = (short)i;
      turn[Turn4.b1][i] = turn[Turn4.b2][i] = turn[Turn4.b3][i] = (short)i;
      turn[Turn4.l1][i] = turn[Turn4.l2][i] = turn[Turn4.l3][i] = (short)i;
      turn[Turn4.r1][i] = turn[Turn4.r2][i] = turn[Turn4.r3][i] = (short)i;
    }
    for (int i = 0; i < n; i++) {
      turn[Turn4.U2][i] = turn[Turn4.U1][turn[Turn4.U1][i]];
      turn[Turn4.F2][i] = turn[Turn4.F1][turn[Turn4.F1][i]];
      turn[Turn4.L2][i] = turn[Turn4.L1][turn[Turn4.L1][i]];
      turn[Turn4.Uu2][i] = turn[Turn4.Uu1][turn[Turn4.Uu1][i]];
      turn[Turn4.Ff2][i] = turn[Turn4.Ff1][turn[Turn4.Ff1][i]];
      turn[Turn4.Ll2][i] = turn[Turn4.Ll1][turn[Turn4.Ll1][i]];
      turn[Turn4.UU2][i] = turn[Turn4.UU1][turn[Turn4.UU1][i]];
      turn[Turn4.FF2][i] = turn[Turn4.FF1][turn[Turn4.FF1][i]];
      turn[Turn4.LL2][i] = turn[Turn4.LL1][turn[Turn4.LL1][i]];
    }
    for (int i = 0; i < n; i++) {
      turn[Turn4.U3][i] = turn[Turn4.U2][turn[Turn4.U1][i]];
      turn[Turn4.F3][i] = turn[Turn4.F2][turn[Turn4.F1][i]];
      turn[Turn4.L3][i] = turn[Turn4.L2][turn[Turn4.L1][i]];
      turn[Turn4.Uu3][i] = turn[Turn4.Uu2][turn[Turn4.Uu1][i]];
      turn[Turn4.Ff3][i] = turn[Turn4.Ff2][turn[Turn4.Ff1][i]];
      turn[Turn4.Ll3][i] = turn[Turn4.Ll2][turn[Turn4.Ll1][i]];
      turn[Turn4.UU3][i] = turn[Turn4.UU2][turn[Turn4.UU1][i]];
      turn[Turn4.FF3][i] = turn[Turn4.FF2][turn[Turn4.FF1][i]];
      turn[Turn4.LL3][i] = turn[Turn4.LL2][turn[Turn4.LL1][i]];
    }
    System.err.println(" " + n + " items per turn.");
  }

  private short up(int c) {
    pack.unpack(c);
    pack.cycle(1, 2, 3, 0); // URB UBL ULF UFR
    return (short)pack.pack();
  }

  private short front(int c) {
    pack.unpack(c);
    pack.cycle(5, 4, 0, 3); // DFL DRF UFR ULF
    return (short)pack.pack();
  }

  private short left(int c) {
    pack.unpack(c);
    pack.cycle(6, 5, 3, 2); // DLB DFL ULF UBL
    return (short)pack.pack();
  }
}
