/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class OptionsMenu
extends JFrame
implements ActionListener,
MouseListener {
    JTabbedPane tabs;
    JPanel defaultTab;
    JPanel viewScrambleTab;
    JPanel bestTab;
    JPanel sessionTab;
    JButton saveButton;
    JButton cancelButton;
    JButton restoreDefaultsButton;
    JComboBox cubeCombo;
    JComboBox countdownCombo;
    JLabel cubeTypeLabel;
    JLabel countdownLabel;
    JLabel averageSyntaxLabel;
    JLabel sessionSyntaxLabel;
    JLabel startupLabel;
    JLabel colorLabel;
    JLabel timerCLabel;
    JLabel fastestCLabel;
    JLabel slowestCLabel;
    JLabel currentCLabel;
    JLabel countdownCLabel;
    JLabel fCLabel;
    JLabel bCLabel;
    JLabel lCLabel;
    JLabel rCLabel;
    JLabel dCLabel;
    JLabel uCLabel;
    JLabel faceColorLabel;
    JLabel previewLabel;
    JCheckBox confirmBox;
    JCheckBox showMinutesBox;
    JTextArea averageText;
    JTextArea sessionText;
    JTextArea countdownColor;
    JTextArea timerColor;
    JTextArea fastestColor;
    JTextArea slowestColor;
    JTextArea currentColor;
    JTextArea fColor;
    JTextArea bColor;
    JTextArea lColor;
    JTextArea rColor;
    JTextArea dColor;
    JTextArea uColor;
    JTextArea[] fScramblePreview;
    JTextArea[] bScramblePreview;
    JTextArea[] lScramblePreview;
    JTextArea[] rScramblePreview;
    JTextArea[] dScramblePreview;
    JTextArea[] uScramblePreview;

    public OptionsMenu() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.setTitle("Options");
        this.setSize(700, 310);
        this.setIconImage(new ImageIcon(this.getClass().getResource("Cow.gif")).getImage());
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.timerColor = new JTextArea();
        this.timerColor.setEditable(false);
        this.timerColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.timerCLabel = new JLabel("Timing Display Color");
        this.countdownColor = new JTextArea();
        this.countdownColor.setEditable(false);
        this.countdownColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.countdownCLabel = new JLabel("Countdown Display Color");
        this.fastestColor = new JTextArea();
        this.fastestColor.setEditable(false);
        this.fastestColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fastestCLabel = new JLabel("Fastest Time In Average Color");
        this.slowestColor = new JTextArea();
        this.slowestColor.setEditable(false);
        this.slowestColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.slowestCLabel = new JLabel("Slowest Time In Average Color");
        this.currentColor = new JTextArea();
        this.currentColor.setEditable(false);
        this.currentColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.currentCLabel = new JLabel("Current Place In Average Color");
        this.fColor = new JTextArea();
        this.fColor.setEditable(false);
        this.fColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fCLabel = new JLabel("Front Face Color");
        this.bColor = new JTextArea();
        this.bColor.setEditable(false);
        this.bColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.bCLabel = new JLabel("Back Face Color");
        this.lColor = new JTextArea();
        this.lColor.setEditable(false);
        this.lColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.lCLabel = new JLabel("Left Face Color");
        this.rColor = new JTextArea();
        this.rColor.setEditable(false);
        this.rColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.rCLabel = new JLabel("Right Face Color");
        this.dColor = new JTextArea();
        this.dColor.setEditable(false);
        this.dColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.dCLabel = new JLabel("Down Face Color");
        this.uColor = new JTextArea();
        this.uColor.setEditable(false);
        this.uColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.uCLabel = new JLabel("Up Face Color");
        this.faceColorLabel = new JLabel();
        this.faceColorLabel.setBorder(BorderFactory.createTitledBorder("Scramble View Cube Face Colors"));
        this.previewLabel = new JLabel();
        this.previewLabel.setBorder(BorderFactory.createTitledBorder("Cube Preview"));
        this.fScramblePreview = new JTextArea[9];
        this.bScramblePreview = new JTextArea[9];
        this.lScramblePreview = new JTextArea[9];
        this.rScramblePreview = new JTextArea[9];
        this.dScramblePreview = new JTextArea[9];
        this.uScramblePreview = new JTextArea[9];
        for (int i = 0; i < 9; ++i) {
            this.fScramblePreview[i] = new JTextArea();
            this.fScramblePreview[i].setEditable(false);
            this.fScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
            this.bScramblePreview[i] = new JTextArea();
            this.bScramblePreview[i].setEditable(false);
            this.bScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
            this.lScramblePreview[i] = new JTextArea();
            this.lScramblePreview[i].setEditable(false);
            this.lScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
            this.rScramblePreview[i] = new JTextArea();
            this.rScramblePreview[i].setEditable(false);
            this.rScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
            this.dScramblePreview[i] = new JTextArea();
            this.dScramblePreview[i].setEditable(false);
            this.dScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
            this.uScramblePreview[i] = new JTextArea();
            this.uScramblePreview[i].setEditable(false);
            this.uScramblePreview[i].setBorder(BorderFactory.createLineBorder(Color.black));
        }
        this.startupLabel = new JLabel();
        this.startupLabel.setBorder(BorderFactory.createTitledBorder("Start-up Options"));
        this.colorLabel = new JLabel();
        this.colorLabel.setBorder(BorderFactory.createTitledBorder("Color Options"));
        this.saveButton = new JButton("Save Options");
        this.cancelButton = new JButton("Cancel");
        this.restoreDefaultsButton = new JButton("Reset Options To Chris' Favorite");
        String[] stringArray = new String[]{"2x2x2", "3x3x3", "4x4x4", "5x5x5", "Pyraminx"};
        this.cubeCombo = new JComboBox<String>(stringArray);
        this.cubeCombo.setSelectedIndex(1);
        String[] stringArray2 = new String[]{"0", "4", "5", "7", "10", "15", "20"};
        this.countdownCombo = new JComboBox<String>(stringArray2);
        this.countdownCombo.setSelectedIndex(5);
        this.cubeTypeLabel = new JLabel("Cube Type");
        this.countdownLabel = new JLabel("Countdown Time");
        this.averageSyntaxLabel = new JLabel("<HTML>%A - Average<br>%D - Standard Deviation<br>%F - Fastest Time<br>%I - Times And Scrambles<br>%O - Times Only<br>%T - Date And Time<br>%S - Slowest Time</HTML>");
        this.averageSyntaxLabel.setBorder(BorderFactory.createTitledBorder("Syntax"));
        this.sessionSyntaxLabel = new JLabel("<HTML>%A - Average<br>%C - Cubes Solved<br>%D - Standard Deviation<br>%F - Fastest Time<br>%I - Times And Scrambles<br>%O - Times Only<br>%P - Number Of Pops<br>%S - Slowest Time<br>%T - Date And Time</HTML>");
        this.sessionSyntaxLabel.setBorder(BorderFactory.createTitledBorder("Syntax"));
        this.confirmBox = new JCheckBox("Confirmation Window On Session Reset");
        this.showMinutesBox = new JCheckBox("Show Minutes When Time Exceeds 60 Seconds");
        this.averageText = new JTextArea();
        this.averageText.setBackground(new Color(255, 200, 150));
        JScrollPane jScrollPane = new JScrollPane(this.averageText);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.sessionText = new JTextArea();
        this.sessionText.setBackground(new Color(255, 200, 150));
        JScrollPane jScrollPane2 = new JScrollPane(this.sessionText);
        jScrollPane2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.defaultTab = new JPanel();
        this.defaultTab.setLayout(null);
        this.defaultTab.add(this.startupLabel);
        this.defaultTab.add(this.colorLabel);
        this.defaultTab.add(this.cubeTypeLabel);
        this.defaultTab.add(this.countdownLabel);
        this.defaultTab.add(this.cubeCombo);
        this.defaultTab.add(this.countdownCombo);
        this.defaultTab.add(this.confirmBox);
        this.defaultTab.add(this.showMinutesBox);
        this.defaultTab.add(this.restoreDefaultsButton);
        this.defaultTab.add(this.countdownColor);
        this.defaultTab.add(this.timerColor);
        this.defaultTab.add(this.fastestColor);
        this.defaultTab.add(this.slowestColor);
        this.defaultTab.add(this.currentColor);
        this.defaultTab.add(this.currentCLabel);
        this.defaultTab.add(this.fastestCLabel);
        this.defaultTab.add(this.slowestCLabel);
        this.defaultTab.add(this.countdownCLabel);
        this.defaultTab.add(this.timerCLabel);
        this.viewScrambleTab = new JPanel();
        this.viewScrambleTab.setLayout(null);
        this.viewScrambleTab.add(this.faceColorLabel);
        this.viewScrambleTab.add(this.previewLabel);
        this.viewScrambleTab.add(this.fColor);
        this.viewScrambleTab.add(this.bColor);
        this.viewScrambleTab.add(this.lColor);
        this.viewScrambleTab.add(this.rColor);
        this.viewScrambleTab.add(this.dColor);
        this.viewScrambleTab.add(this.uColor);
        this.viewScrambleTab.add(this.fCLabel);
        this.viewScrambleTab.add(this.bCLabel);
        this.viewScrambleTab.add(this.lCLabel);
        this.viewScrambleTab.add(this.rCLabel);
        this.viewScrambleTab.add(this.dCLabel);
        this.viewScrambleTab.add(this.uCLabel);
        for (int i = 0; i < 9; ++i) {
            this.viewScrambleTab.add(this.fScramblePreview[i]);
            this.viewScrambleTab.add(this.bScramblePreview[i]);
            this.viewScrambleTab.add(this.lScramblePreview[i]);
            this.viewScrambleTab.add(this.rScramblePreview[i]);
            this.viewScrambleTab.add(this.dScramblePreview[i]);
            this.viewScrambleTab.add(this.uScramblePreview[i]);
        }
        this.bestTab = new JPanel();
        this.bestTab.setLayout(null);
        this.bestTab.add(this.averageSyntaxLabel);
        this.bestTab.add(jScrollPane);
        this.sessionTab = new JPanel();
        this.sessionTab.setLayout(null);
        this.sessionTab.add(this.sessionSyntaxLabel);
        this.sessionTab.add(jScrollPane2);
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.defaultTab, "JNetCube Options");
        this.tabs.add((Component)this.viewScrambleTab, "Scramble View Color Options");
        this.tabs.add((Component)this.bestTab, "Best Average Output");
        this.tabs.add((Component)this.sessionTab, "Session Times Output");
        this.tabs.setBounds(10, 5, 679, 240);
        this.saveButton.setBounds(10, 255, 334, 20);
        this.cancelButton.setBounds(353, 255, 334, 20);
        this.restoreDefaultsButton.setBounds(30, 160, 280, 20);
        this.cubeCombo.setBounds(30, 45, 82, 20);
        this.countdownCombo.setBounds(122, 45, 112, 20);
        this.cubeTypeLabel.setBounds(30, 25, 82, 20);
        this.countdownLabel.setBounds(122, 25, 112, 20);
        this.averageSyntaxLabel.setBounds(478, 5, 180, 190);
        this.sessionSyntaxLabel.setBounds(478, 5, 180, 190);
        this.confirmBox.setBounds(30, 90, 280, 20);
        this.showMinutesBox.setBounds(30, 114, 280, 20);
        jScrollPane.setBounds(12, 10, 458, 183);
        jScrollPane2.setBounds(12, 10, 458, 183);
        this.startupLabel.setBounds(10, 5, 319, 190);
        this.colorLabel.setBounds(339, 5, 319, 190);
        this.countdownColor.setBounds(359, 30, 20, 20);
        this.countdownCLabel.setBounds(384, 30, 250, 20);
        this.timerColor.setBounds(359, 60, 20, 20);
        this.timerCLabel.setBounds(384, 60, 250, 20);
        this.currentColor.setBounds(359, 90, 20, 20);
        this.currentCLabel.setBounds(384, 90, 250, 20);
        this.fastestColor.setBounds(359, 120, 20, 20);
        this.fastestCLabel.setBounds(384, 120, 250, 20);
        this.slowestColor.setBounds(359, 150, 20, 20);
        this.slowestCLabel.setBounds(384, 150, 250, 20);
        this.faceColorLabel.setBounds(10, 5, 319, 190);
        this.previewLabel.setBounds(339, 5, 319, 190);
        this.fColor.setBounds(30, 30, 20, 20);
        this.fCLabel.setBounds(55, 30, 300, 20);
        this.bColor.setBounds(30, 55, 20, 20);
        this.bCLabel.setBounds(55, 55, 300, 20);
        this.lColor.setBounds(30, 80, 20, 20);
        this.lCLabel.setBounds(55, 80, 300, 20);
        this.rColor.setBounds(30, 105, 20, 20);
        this.rCLabel.setBounds(55, 105, 300, 20);
        this.dColor.setBounds(30, 130, 20, 20);
        this.dCLabel.setBounds(55, 130, 300, 20);
        this.uColor.setBounds(30, 155, 20, 20);
        this.uCLabel.setBounds(55, 155, 300, 20);
        this.fScramblePreview[0].setBounds(450, 75, 15, 15);
        this.fScramblePreview[1].setBounds(465, 75, 15, 15);
        this.fScramblePreview[2].setBounds(480, 75, 15, 15);
        this.fScramblePreview[3].setBounds(450, 90, 15, 15);
        this.fScramblePreview[4].setBounds(465, 90, 15, 15);
        this.fScramblePreview[5].setBounds(480, 90, 15, 15);
        this.fScramblePreview[6].setBounds(450, 105, 15, 15);
        this.fScramblePreview[7].setBounds(465, 105, 15, 15);
        this.fScramblePreview[8].setBounds(480, 105, 15, 15);
        this.bScramblePreview[0].setBounds(550, 75, 15, 15);
        this.bScramblePreview[1].setBounds(565, 75, 15, 15);
        this.bScramblePreview[2].setBounds(580, 75, 15, 15);
        this.bScramblePreview[3].setBounds(550, 90, 15, 15);
        this.bScramblePreview[4].setBounds(565, 90, 15, 15);
        this.bScramblePreview[5].setBounds(580, 90, 15, 15);
        this.bScramblePreview[6].setBounds(550, 105, 15, 15);
        this.bScramblePreview[7].setBounds(565, 105, 15, 15);
        this.bScramblePreview[8].setBounds(580, 105, 15, 15);
        this.lScramblePreview[0].setBounds(400, 75, 15, 15);
        this.lScramblePreview[1].setBounds(415, 75, 15, 15);
        this.lScramblePreview[2].setBounds(430, 75, 15, 15);
        this.lScramblePreview[3].setBounds(400, 90, 15, 15);
        this.lScramblePreview[4].setBounds(415, 90, 15, 15);
        this.lScramblePreview[5].setBounds(430, 90, 15, 15);
        this.lScramblePreview[6].setBounds(400, 105, 15, 15);
        this.lScramblePreview[7].setBounds(415, 105, 15, 15);
        this.lScramblePreview[8].setBounds(430, 105, 15, 15);
        this.rScramblePreview[0].setBounds(500, 75, 15, 15);
        this.rScramblePreview[1].setBounds(515, 75, 15, 15);
        this.rScramblePreview[2].setBounds(530, 75, 15, 15);
        this.rScramblePreview[3].setBounds(500, 90, 15, 15);
        this.rScramblePreview[4].setBounds(515, 90, 15, 15);
        this.rScramblePreview[5].setBounds(530, 90, 15, 15);
        this.rScramblePreview[6].setBounds(500, 105, 15, 15);
        this.rScramblePreview[7].setBounds(515, 105, 15, 15);
        this.rScramblePreview[8].setBounds(530, 105, 15, 15);
        this.dScramblePreview[0].setBounds(450, 125, 15, 15);
        this.dScramblePreview[1].setBounds(465, 125, 15, 15);
        this.dScramblePreview[2].setBounds(480, 125, 15, 15);
        this.dScramblePreview[3].setBounds(450, 140, 15, 15);
        this.dScramblePreview[4].setBounds(465, 140, 15, 15);
        this.dScramblePreview[5].setBounds(480, 140, 15, 15);
        this.dScramblePreview[6].setBounds(450, 155, 15, 15);
        this.dScramblePreview[7].setBounds(465, 155, 15, 15);
        this.dScramblePreview[8].setBounds(480, 155, 15, 15);
        this.uScramblePreview[0].setBounds(450, 25, 15, 15);
        this.uScramblePreview[1].setBounds(465, 25, 15, 15);
        this.uScramblePreview[2].setBounds(480, 25, 15, 15);
        this.uScramblePreview[3].setBounds(450, 40, 15, 15);
        this.uScramblePreview[4].setBounds(465, 40, 15, 15);
        this.uScramblePreview[5].setBounds(480, 40, 15, 15);
        this.uScramblePreview[6].setBounds(450, 55, 15, 15);
        this.uScramblePreview[7].setBounds(465, 55, 15, 15);
        this.uScramblePreview[8].setBounds(480, 55, 15, 15);
        container.add(this.tabs);
        container.add(this.saveButton);
        container.add(this.cancelButton);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.restoreDefaultsButton.addActionListener(this);
        this.countdownColor.addMouseListener(this);
        this.timerColor.addMouseListener(this);
        this.currentColor.addMouseListener(this);
        this.fastestColor.addMouseListener(this);
        this.slowestColor.addMouseListener(this);
        this.fColor.addMouseListener(this);
        this.bColor.addMouseListener(this);
        this.lColor.addMouseListener(this);
        this.rColor.addMouseListener(this);
        this.dColor.addMouseListener(this);
        this.uColor.addMouseListener(this);
        this.loadOptions();
        this.averageText.setCaretPosition(0);
        this.sessionText.setCaretPosition(0);
        this.updateScramblePreview();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.saveOptions();
            Standalone.loadOptions();
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.restoreDefaultsButton) {
            this.resetOptions();
            this.averageText.setCaretPosition(0);
            this.sessionText.setCaretPosition(0);
        }
    }

    private void saveOptions() {
        String string = "";
        string = string + this.cubeCombo.getSelectedItem() + "" + "~";
        string = string + this.countdownCombo.getSelectedItem() + "" + "~";
        string = string + this.confirmBox.isSelected() + "" + "~";
        string = string + this.showMinutesBox.isSelected() + "" + "~";
        string = string + this.countdownColor.getBackground().getRGB() + "" + "~";
        string = string + this.timerColor.getBackground().getRGB() + "~";
        string = string + this.currentColor.getBackground().getRGB() + "~";
        string = string + this.fastestColor.getBackground().getRGB() + "~";
        string = string + this.slowestColor.getBackground().getRGB() + "~";
        string = string + this.fColor.getBackground().getRGB() + "~";
        string = string + this.bColor.getBackground().getRGB() + "~";
        string = string + this.lColor.getBackground().getRGB() + "~";
        string = string + this.rColor.getBackground().getRGB() + "~";
        string = string + this.dColor.getBackground().getRGB() + "~";
        string = string + this.uColor.getBackground().getRGB() + "~";
        string = string + this.averageText.getText() + "~";
        string = string + this.sessionText.getText();
        try {
            FileWriter fileWriter = new FileWriter("jnc.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "There was an error saving. You may not have write permissions.");
        }
    }

    private void loadOptions() {
        String string = "";
        try {
            String string2;
            FileReader fileReader = new FileReader("jnc.conf");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + "\n";
            }
            bufferedReader.close();
            string = string.substring(0, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
            this.cubeCombo.setSelectedItem(stringTokenizer.nextToken());
            this.countdownCombo.setSelectedItem(stringTokenizer.nextToken());
            if (stringTokenizer.nextToken().equalsIgnoreCase("true")) {
                this.confirmBox.setSelected(true);
            } else {
                this.confirmBox.setSelected(false);
            }
            if (stringTokenizer.nextToken().equalsIgnoreCase("true")) {
                this.showMinutesBox.setSelected(true);
            } else {
                this.showMinutesBox.setSelected(false);
            }
            this.countdownColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.timerColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.currentColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.fastestColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.slowestColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.fColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.bColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.lColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.rColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.dColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.uColor.setBackground(new Color(Integer.parseInt(stringTokenizer.nextToken())));
            this.averageText.setText(stringTokenizer.nextToken());
            this.sessionText.setText(stringTokenizer.nextToken());
        }
        catch (IOException iOException) {
            this.resetOptions();
            return;
        }
    }

    private void resetOptions() {
        this.cubeCombo.setSelectedItem("3x3x3");
        this.countdownCombo.setSelectedItem("15");
        this.confirmBox.setSelected(true);
        this.showMinutesBox.setSelected(true);
        this.countdownColor.setBackground(Color.red);
        this.timerColor.setBackground(Color.blue);
        this.currentColor.setBackground(new Color(0, 110, 0));
        this.fastestColor.setBackground(Color.blue);
        this.slowestColor.setBackground(Color.red);
        this.fColor.setBackground(Color.white);
        this.bColor.setBackground(Color.yellow);
        this.lColor.setBackground(Color.red);
        this.rColor.setBackground(Color.orange);
        this.dColor.setBackground(Color.blue);
        this.uColor.setBackground(Color.green);
        this.updateScramblePreview();
        this.averageText.setText("----- JNetCube Best Average for %T -----\r\n\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\nStandard Deviation: %D\r\n\r\nIndividual Times:\r\n%I");
        this.sessionText.setText("----- JNetCube Session Statistics for %T -----\r\n\r\nCubes Solved: %C \r\nTotal Pops: %P \r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\nStandard Deviation: %D\r\n\r\nIndividual Times:\r\n%I");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Color color;
        Object object = mouseEvent.getSource();
        if (object == this.countdownColor) {
            Color color2 = JColorChooser.showDialog(this, "Choose Color For Countdown Display", this.countdownColor.getBackground());
            if (color2 != null) {
                this.countdownColor.setBackground(color2);
            }
        } else if (object == this.timerColor) {
            Color color3 = JColorChooser.showDialog(this, "Choose Color For Timing Display", this.timerColor.getBackground());
            if (color3 != null) {
                this.timerColor.setBackground(color3);
            }
        } else if (object == this.currentColor) {
            Color color4 = JColorChooser.showDialog(this, "Choose Color For Current Place In Average", this.currentColor.getBackground());
            if (color4 != null) {
                this.currentColor.setBackground(color4);
            }
        } else if (object == this.fastestColor) {
            Color color5 = JColorChooser.showDialog(this, "Choose Color For Fastest Time In Average", this.fastestColor.getBackground());
            if (color5 != null) {
                this.fastestColor.setBackground(color5);
            }
        } else if (object == this.slowestColor) {
            Color color6 = JColorChooser.showDialog(this, "Choose Color For Slowest Time In Average", this.slowestColor.getBackground());
            if (color6 != null) {
                this.slowestColor.setBackground(color6);
            }
        } else if (object == this.fColor) {
            Color color7 = JColorChooser.showDialog(this, "Choose Color For Front Face", this.fColor.getBackground());
            if (color7 != null) {
                this.fColor.setBackground(color7);
                this.updateScramblePreview();
            }
        } else if (object == this.bColor) {
            Color color8 = JColorChooser.showDialog(this, "Choose Color For Back Face", this.bColor.getBackground());
            if (color8 != null) {
                this.bColor.setBackground(color8);
                this.updateScramblePreview();
            }
        } else if (object == this.lColor) {
            Color color9 = JColorChooser.showDialog(this, "Choose Color For Left Face", this.lColor.getBackground());
            if (color9 != null) {
                this.lColor.setBackground(color9);
                this.updateScramblePreview();
            }
        } else if (object == this.rColor) {
            Color color10 = JColorChooser.showDialog(this, "Choose Color For Right Face", this.rColor.getBackground());
            if (color10 != null) {
                this.rColor.setBackground(color10);
                this.updateScramblePreview();
            }
        } else if (object == this.dColor) {
            Color color11 = JColorChooser.showDialog(this, "Choose Color For Down Face", this.dColor.getBackground());
            if (color11 != null) {
                this.dColor.setBackground(color11);
                this.updateScramblePreview();
            }
        } else if (object == this.uColor && (color = JColorChooser.showDialog(this, "Choose Color For Up Face", this.uColor.getBackground())) != null) {
            this.uColor.setBackground(color);
            this.updateScramblePreview();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    private void updateScramblePreview() {
        for (int i = 0; i < 9; ++i) {
            this.fScramblePreview[i].setBackground(this.fColor.getBackground());
            this.bScramblePreview[i].setBackground(this.bColor.getBackground());
            this.lScramblePreview[i].setBackground(this.lColor.getBackground());
            this.rScramblePreview[i].setBackground(this.rColor.getBackground());
            this.dScramblePreview[i].setBackground(this.dColor.getBackground());
            this.uScramblePreview[i].setBackground(this.uColor.getBackground());
        }
    }
}

