/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Server
extends JFrame
implements ActionListener,
KeyListener,
MouseListener,
Runnable {
    JLabel usernameLabel;
    JLabel serverIpLabel;
    JLabel serverPortLabel;
    JLabel handicapLabel;
    JLabel useThisAlgLabel;
    JLabel timerLabel;
    JLabel localTimeLabel;
    JLabel remoteTimeLabel;
    JLabel localTimeUsernameLabel;
    JLabel remoteTimeUsernameLabel;
    JLabel countdownLabel;
    JLabel remoteStatusLabel;
    JLabel bigPicture;
    JLabel smallPicture;
    JLabel userIsTyping;
    JTextField usernameText;
    JTextField serverIpText;
    JTextField serverPortText;
    JTextField handicapText;
    JTextField chatText;
    JButton connectButton;
    JButton sendMessageButton;
    JButton localSessionDetailButton;
    JButton localAverageDetailButton;
    JButton remoteSessionDetailButton;
    JButton remoteAverageDetailButton;
    JButton startButton;
    JButton popButton;
    JTextPane chatPane;
    StyledDocument chatDoc;
    Style redStyle;
    Style blueStyle;
    Style blackStyle;
    AudioClip chatSound;
    AudioClip countdownClip;
    AudioClip bing1;
    AudioClip bing2;
    AudioClip readyClip;
    AudioClip startupClip;
    JTextField scrambleText;
    String remoteUsername;
    JComboBox countdownCombo;
    JTextArea readyColor;
    JScrollPane chatScrollPane;
    ScrambleAlgorithm scrambleAlg;
    Timer timerThread;
    int countdown;
    double startTime;
    double stopTime;
    DecimalFormat timeFormat;
    NumberFormat nf;
    String remoteTime;
    boolean isTyping;
    boolean remoteIsTyping;
    ImageIcon typeOn;
    ImageIcon typeOff;
    ServerSocket serverSocket;
    Socket clientSocket;
    BufferedReader in;
    PrintWriter out;
    String[] localSessionTimes;
    String[] remoteSessionTimes;
    String[] sessionScrambles;
    String[] localCurrentAverage;
    String[] remoteCurrentAverage;
    String[] localCurrentScrambles;
    String[] remoteCurrentScrambles;
    int localCubesSolved;
    int remoteCubesSolved;
    int sessionIndex;
    int localCurrentPlaceInAverage;
    int remoteCurrentPlaceInAverage;
    int localNumOfPops;
    int remoteNumOfPops;
    int localScore;
    int remoteScore;
    int acceptsSincePop;
    double localSessionFastest;
    double remoteSessionFastest;
    double localSessionSlowest;
    double remoteSessionSlowest;
    double localCurrentFastest;
    double remoteCurrentFastest;
    double localCurrentSlowest;
    double remoteCurrentSlowest;
    double localTotalTime;
    double remoteTotalTime;
    double localCurrentRollingAverage;
    double remoteCurrentRollingAverage;
    double localCurrentSessionAverage;
    double remoteCurrentSessionAverage;
    Thread chatListener;

    public Server() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.setTitle("JNetCube Server");
        this.setSize(727, 542);
        this.setIconImage(new ImageIcon(this.getClass().getResource("Cow.gif")).getImage());
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        try {
            this.chatSound = Applet.newAudioClip(this.getClass().getResource("blip.wav"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "blip.wav not found. There will be no audio when a message is recieved.");
        }
        try {
            this.countdownClip = Applet.newAudioClip(this.getClass().getResource("count.mid"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "count.mid not found. There will be no audio during countdown.");
        }
        try {
            this.bing1 = Applet.newAudioClip(this.getClass().getResource("bing1.wav"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "bing1.wav not found. There will be no 'ready' sound.");
        }
        this.timeFormat = new DecimalFormat("00.00");
        try {
            this.bing2 = Applet.newAudioClip(this.getClass().getResource("bing2.wav"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "bing2.wav not found. There will be no 'ready' sound.");
        }
        try {
            this.readyClip = Applet.newAudioClip(this.getClass().getResource("ready.wav"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "ready.wav not found. There will be no 'ready' sound.");
        }
        try {
            this.startupClip = Applet.newAudioClip(this.getClass().getResource("startup.wav"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "startup.wav not found. There will be no startup sound.");
        }
        this.nf = NumberFormat.getNumberInstance(new Locale("en", "US"));
        this.timeFormat = (DecimalFormat)this.nf;
        this.timeFormat.applyPattern("00.00");
        this.usernameLabel = new JLabel("Username:");
        this.serverIpLabel = new JLabel("Server Ip:");
        this.serverPortLabel = new JLabel("Server Port:");
        this.handicapLabel = new JLabel("Handicap:");
        this.usernameText = new JTextField();
        this.serverIpText = new JTextField("N/A");
        this.serverPortText = new JTextField();
        this.handicapText = new JTextField();
        this.connectButton = new JButton("Start Server");
        this.typeOff = new ImageIcon(this.getClass().getResource("typeOff.gif"));
        this.typeOn = new ImageIcon(this.getClass().getResource("typeOn.gif"));
        this.userIsTyping = new JLabel(this.typeOff);
        this.chatDoc = new DefaultStyledDocument();
        this.chatPane = new JTextPane(this.chatDoc);
        this.chatPane.setEditable(false);
        this.chatScrollPane = new JScrollPane(this.chatPane);
        this.chatScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.chatScrollPane.setVerticalScrollBarPolicy(22);
        this.redStyle = this.chatPane.addStyle("red", null);
        this.blueStyle = this.chatPane.addStyle("blue", null);
        this.blackStyle = this.chatPane.addStyle("black", null);
        StyleConstants.setForeground(this.redStyle, Color.red);
        StyleConstants.setForeground(this.blueStyle, Color.blue);
        StyleConstants.setForeground(this.blackStyle, Color.black);
        this.chatText = new JTextField();
        this.chatText.addKeyListener(this);
        this.sendMessageButton = new JButton("Send");
        this.useThisAlgLabel = new JLabel("Use this algorithm to scramble your cube");
        this.scrambleText = new JTextField("");
        this.useThisAlgLabel.setHorizontalAlignment(0);
        this.scrambleText.setHorizontalAlignment(0);
        this.scrambleText.setFont(new Font("Serif", 1, 16));
        this.scrambleText.setEditable(false);
        this.scrambleText.setBackground(new Color(255, 222, 140));
        this.scrambleText.setBorder(BorderFactory.createLineBorder(Color.black));
        this.timerLabel = new JLabel("");
        this.timerLabel.setHorizontalAlignment(0);
        this.timerLabel.setFont(new Font("Serif", 0, 94));
        this.localTimeUsernameLabel = new JLabel("<html>Rolling Average: <FONT SIZE=\"5\">N/A</FONT><br>Session Average: N/A<br><br>Score: 0<br>Session Fastest Time: N/A<br>Session Slowest Time: N/A</html>");
        this.remoteTimeUsernameLabel = new JLabel("<html>Rolling Average: <FONT SIZE=\"5\">N/A</FONT><br>Session Average: N/A<br><br>Score: 0<br>Session Fastest Time: N/A<br>Session Slowest Time: N/A</html>");
        this.localTimeLabel = new JLabel("");
        this.remoteTimeLabel = new JLabel("");
        this.localTimeUsernameLabel.setVerticalAlignment(3);
        this.remoteTimeUsernameLabel.setVerticalAlignment(3);
        this.localTimeLabel.setHorizontalAlignment(0);
        this.remoteTimeLabel.setHorizontalAlignment(0);
        this.localTimeLabel.setFont(new Font("Serif", 0, 60));
        this.remoteTimeLabel.setFont(new Font("Serif", 0, 60));
        this.localTimeUsernameLabel.setBorder(BorderFactory.createTitledBorder("Local Statistics"));
        this.remoteTimeUsernameLabel.setBorder(BorderFactory.createTitledBorder("Remote Statistics"));
        this.localAverageDetailButton = new JButton("View Rolling");
        this.localSessionDetailButton = new JButton("View Session");
        this.remoteAverageDetailButton = new JButton("View Rolling");
        this.remoteSessionDetailButton = new JButton("View Session");
        this.countdownLabel = new JLabel("Countdown Time");
        String[] stringArray = new String[]{"0", "4", "5", "7", "10", "15", "20"};
        this.countdownCombo = new JComboBox<String>(stringArray);
        this.countdownCombo.setSelectedIndex(5);
        this.startButton = new JButton("Start Timer");
        this.popButton = new JButton("POP");
        this.readyColor = new JTextArea();
        this.readyColor.setEditable(false);
        this.readyColor.setBackground(Color.red);
        this.readyColor.setBorder(BorderFactory.createLineBorder(Color.black));
        this.remoteStatusLabel = new JLabel("Remote Status");
        this.bigPicture = new JLabel(new ImageIcon(this.getClass().getResource("bigPicture.jpg")));
        this.smallPicture = new JLabel(new ImageIcon(this.getClass().getResource("smallPicture.jpg")));
        this.bigPicture.setBorder(BorderFactory.createLineBorder(Color.black));
        this.smallPicture.setBorder(BorderFactory.createLineBorder(Color.black));
        this.scrambleAlg = new ScrambleAlgorithm();
        this.usernameLabel.setBounds(10, 10, 90, 20);
        this.serverIpLabel.setBounds(10, 35, 90, 20);
        this.serverPortLabel.setBounds(10, 60, 90, 20);
        this.handicapLabel.setBounds(10, 85, 90, 20);
        this.usernameText.setBounds(100, 10, 100, 20);
        this.serverIpText.setBounds(100, 35, 100, 20);
        this.serverPortText.setBounds(100, 60, 100, 20);
        this.handicapText.setBounds(100, 85, 100, 20);
        this.connectButton.setBounds(10, 110, 190, 20);
        this.chatScrollPane.setBounds(210, 10, 300, 95);
        this.userIsTyping.setBounds(210, 110, 20, 20);
        this.chatText.setBounds(235, 110, 165, 20);
        this.sendMessageButton.setBounds(410, 110, 100, 20);
        this.useThisAlgLabel.setBounds(10, 150, 700, 20);
        this.scrambleText.setBounds(10, 170, 700, 40);
        this.timerLabel.setBounds(10, 220, 700, 75);
        this.localTimeUsernameLabel.setBounds(10, 305, 345, 200);
        this.remoteTimeUsernameLabel.setBounds(365, 305, 345, 200);
        this.localTimeLabel.setBounds(20, 325, 325, 75);
        this.remoteTimeLabel.setBounds(375, 325, 325, 75);
        this.localAverageDetailButton.setBounds(235, 405, 110, 20);
        this.localSessionDetailButton.setBounds(235, 430, 110, 20);
        this.remoteAverageDetailButton.setBounds(590, 405, 110, 20);
        this.remoteSessionDetailButton.setBounds(590, 430, 110, 20);
        this.countdownLabel.setBounds(520, 10, 190, 20);
        this.countdownCombo.setBounds(520, 35, 190, 20);
        this.startButton.setBounds(520, 60, 190, 20);
        this.popButton.setBounds(520, 85, 190, 20);
        this.readyColor.setBounds(520, 110, 20, 20);
        this.remoteStatusLabel.setBounds(550, 110, 160, 20);
        this.smallPicture.setBounds(210, 10, 500, 120);
        this.bigPicture.setBounds(10, 150, 700, 355);
        container.add(this.usernameLabel);
        container.add(this.serverIpLabel);
        container.add(this.serverPortLabel);
        container.add(this.handicapLabel);
        container.add(this.usernameText);
        container.add(this.serverIpText);
        container.add(this.serverPortText);
        container.add(this.handicapText);
        container.add(this.connectButton);
        container.add(this.chatScrollPane);
        container.add(this.userIsTyping);
        container.add(this.chatText);
        container.add(this.sendMessageButton);
        container.add(this.useThisAlgLabel);
        container.add(this.scrambleText);
        container.add(this.timerLabel);
        container.add(this.localTimeUsernameLabel);
        container.add(this.remoteTimeUsernameLabel);
        container.add(this.localTimeLabel);
        container.add(this.remoteTimeLabel);
        container.add(this.localAverageDetailButton);
        container.add(this.localSessionDetailButton);
        container.add(this.remoteAverageDetailButton);
        container.add(this.remoteSessionDetailButton);
        container.add(this.countdownLabel);
        container.add(this.countdownCombo);
        container.add(this.startButton);
        container.add(this.popButton);
        container.add(this.readyColor);
        container.add(this.remoteStatusLabel);
        container.add(this.smallPicture);
        container.add(this.bigPicture);
        this.sendMessageButton.addActionListener(this);
        this.chatText.addActionListener(this);
        this.startButton.addActionListener(this);
        this.popButton.addActionListener(this);
        this.countdownCombo.addActionListener(this);
        this.localSessionDetailButton.addActionListener(this);
        this.localAverageDetailButton.addActionListener(this);
        this.remoteSessionDetailButton.addActionListener(this);
        this.remoteAverageDetailButton.addActionListener(this);
        this.connectButton.addKeyListener(this);
        this.connectButton.addMouseListener(this);
        this.serverIpText.setEnabled(false);
        this.sendMessageButton.setEnabled(false);
        this.chatText.setEnabled(false);
        this.popButton.setEnabled(false);
        this.localAverageDetailButton.setEnabled(false);
        this.localSessionDetailButton.setEnabled(false);
        this.remoteAverageDetailButton.setEnabled(false);
        this.remoteSessionDetailButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.reset();
        this.hideGUI();
        this.setDefaultCloseOperation(3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sendMessageButton || object == this.chatText) {
            if (this.chatText.getText().equalsIgnoreCase("")) {
                return;
            }
            try {
                this.chatDoc.insertString(this.chatDoc.getLength(), this.usernameText.getText() + ": ", this.redStyle);
                this.chatDoc.insertString(this.chatDoc.getLength(), this.chatText.getText() + "\n", this.blackStyle);
                this.out.println("C" + this.chatText.getText());
                this.out.flush();
                this.chatPane.setCaretPosition(this.chatDoc.getLength());
                this.chatText.setText("");
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
        } else if (object == this.countdownCombo) {
            this.out.println("T" + this.countdownCombo.getSelectedItem());
            this.out.flush();
        } else if (object == this.startButton) {
            if (this.startButton.getText().equals("Start Timer")) {
                this.remoteTime = "none";
                this.localTimeLabel.setText("");
                this.remoteTimeLabel.setText("");
                this.startButton.setText("Stop Timer");
                this.startButton.setEnabled(false);
                this.localSessionDetailButton.setEnabled(false);
                this.localAverageDetailButton.setEnabled(false);
                this.remoteSessionDetailButton.setEnabled(false);
                this.remoteAverageDetailButton.setEnabled(false);
                this.popButton.setEnabled(false);
                this.sendMessageButton.setEnabled(false);
                this.chatText.setEnabled(false);
                this.countdown = Integer.parseInt(this.countdownCombo.getSelectedItem() + "");
                this.timerLabel.setForeground(Color.red);
                this.timerThread = new Timer();
                this.out.println("XGO!");
                this.out.flush();
                this.timerThread.schedule((TimerTask)new RunCountdown(), 0L, 1000L);
            } else if (this.startButton.getText().equals("Stop Timer")) {
                this.stopTime = System.currentTimeMillis();
                this.startButton.setEnabled(false);
                this.popButton.setEnabled(false);
                this.localTimeLabel.setForeground(Color.blue);
                this.timerLabel.setForeground(Color.black);
                this.localTimeLabel.setText(this.timeFormat.format((this.stopTime - this.startTime) / 1000.0));
                this.out.println("N" + this.timeFormat.format((this.stopTime - this.startTime) / 1000.0));
                this.out.flush();
                ++this.acceptsSincePop;
                ++this.localCubesSolved;
                if (!this.remoteTime.equals("none")) {
                    this.timerThread.cancel();
                    this.timerLabel.setText("");
                    this.startButton.setText("Start Timer");
                    this.readyColor.setBackground(Color.red);
                    this.popButton.setEnabled(false);
                    this.chatText.setEnabled(true);
                    this.sendMessageButton.setEnabled(true);
                    this.localSessionDetailButton.setEnabled(true);
                    this.remoteSessionDetailButton.setEnabled(true);
                    if (this.localCubesSolved >= 12) {
                        this.localAverageDetailButton.setEnabled(true);
                    }
                    if (this.remoteCubesSolved >= 12) {
                        this.remoteAverageDetailButton.setEnabled(true);
                    }
                    this.updateStats();
                    this.generateNewScramble();
                }
            }
        } else if (object == this.popButton) {
            this.acceptsSincePop = 0;
            ++this.localNumOfPops;
            this.popButton.setText("Popped");
            this.startButton.setEnabled(false);
            this.popButton.setEnabled(false);
            this.localTimeLabel.setForeground(Color.blue);
            this.timerLabel.setForeground(Color.black);
            this.localTimeLabel.setText("POP");
            this.out.println("NPOP");
            this.out.flush();
            if (!this.remoteTime.equals("none")) {
                this.timerThread.cancel();
                this.timerLabel.setText("");
                this.startButton.setText("Start Timer");
                this.readyColor.setBackground(Color.red);
                this.popButton.setEnabled(false);
                this.chatText.setEnabled(true);
                this.sendMessageButton.setEnabled(true);
                this.localSessionDetailButton.setEnabled(true);
                this.remoteSessionDetailButton.setEnabled(true);
                if (this.localCubesSolved >= 12) {
                    this.localAverageDetailButton.setEnabled(true);
                }
                if (this.remoteCubesSolved >= 12) {
                    this.remoteAverageDetailButton.setEnabled(true);
                }
                this.updateStats();
                this.generateNewScramble();
            }
        } else if (object == this.localSessionDetailButton) {
            DetailedView detailedView = new DetailedView("Session Times", this.getLocalSessionView());
            detailedView.setVisible(true);
        } else if (object == this.localAverageDetailButton) {
            DetailedView detailedView = new DetailedView("Rolling Average", this.getLocalAverageView());
            detailedView.setVisible(true);
        } else if (object == this.remoteSessionDetailButton) {
            DetailedView detailedView = new DetailedView("Session Times", this.getRemoteSessionView());
            detailedView.setVisible(true);
        } else if (object == this.remoteAverageDetailButton) {
            DetailedView detailedView = new DetailedView("Rolling Average", this.getRemoteAverageView());
            detailedView.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                while (true) {
                    String string = this.in.readLine();
                    String string2 = string.substring(0, 1);
                    String string3 = string.substring(1, string.length());
                    this.performAction(string2, string3);
                }
            }
            catch (Exception exception) {
                this.hideGUI();
                JOptionPane.showMessageDialog(this, "Client has disconnected from this server.");
                this.reset();
                this.connectButton.setText("Start Server");
                this.chatText.setText("");
                this.connectButton.setEnabled(true);
                this.usernameText.setEnabled(true);
                this.serverPortText.setEnabled(true);
                this.handicapText.setEnabled(true);
                this.sendMessageButton.setEnabled(false);
                this.chatText.setEnabled(false);
                this.chatListener = null;
                this.validate();
                try {
                    this.in.close();
                    this.out.close();
                    this.clientSocket.close();
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            this.chatListener = null;
            this.validate();
            try {
                this.in.close();
                this.out.close();
                this.clientSocket.close();
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    private void performAction(String string, String string2) {
        if (string.equalsIgnoreCase("C")) {
            try {
                this.chatDoc.insertString(this.chatDoc.getLength(), this.remoteUsername + ": ", this.blueStyle);
                this.chatDoc.insertString(this.chatDoc.getLength(), string2 + "\n", this.blackStyle);
                this.chatPane.setCaretPosition(this.chatDoc.getLength());
                this.chatSound.play();
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
        } else if (string.equalsIgnoreCase("U")) {
            this.remoteUsername = string2;
            this.remoteTimeUsernameLabel.setBorder(BorderFactory.createTitledBorder(this.remoteUsername + "'s Statistics"));
            this.remoteStatusLabel.setText(this.remoteUsername + "'s Status");
        } else if (string.equalsIgnoreCase("R")) {
            if (string2.equalsIgnoreCase("true")) {
                this.readyClip.play();
                this.startButton.setEnabled(true);
                this.readyColor.setBackground(new Color(0, 110, 0));
            } else {
                this.readyClip.play();
                this.startButton.setEnabled(false);
                this.readyColor.setBackground(Color.red);
            }
        } else if (string.equalsIgnoreCase("N")) {
            this.remoteTime = string2;
            if (!this.localTimeLabel.getText().equals("")) {
                this.timerThread.cancel();
                this.timerLabel.setText("");
                this.startButton.setText("Start Timer");
                this.readyColor.setBackground(Color.red);
                this.popButton.setEnabled(false);
                this.chatText.setEnabled(true);
                this.sendMessageButton.setEnabled(true);
                this.localSessionDetailButton.setEnabled(true);
                this.remoteSessionDetailButton.setEnabled(true);
                if (this.localCubesSolved >= 12) {
                    this.localAverageDetailButton.setEnabled(true);
                }
                if (this.remoteCubesSolved >= 12) {
                    this.remoteAverageDetailButton.setEnabled(true);
                }
                this.updateStats();
                this.generateNewScramble();
            }
        } else if (string.equalsIgnoreCase("I")) {
            boolean bl = this.remoteIsTyping = !this.remoteIsTyping;
            if (this.remoteIsTyping) {
                this.userIsTyping.setIcon(this.typeOn);
            } else {
                this.userIsTyping.setIcon(this.typeOff);
            }
        }
    }

    private void hideGUI() {
        this.bigPicture.setVisible(true);
        this.smallPicture.setVisible(true);
        this.chatScrollPane.setVisible(false);
        this.chatText.setVisible(false);
        this.sendMessageButton.setVisible(false);
        this.countdownLabel.setVisible(false);
        this.countdownCombo.setVisible(false);
        this.startButton.setVisible(false);
        this.popButton.setVisible(false);
        this.useThisAlgLabel.setVisible(false);
        this.scrambleText.setVisible(false);
        this.timerLabel.setVisible(false);
        this.localTimeLabel.setVisible(false);
        this.remoteTimeLabel.setVisible(false);
        this.localTimeUsernameLabel.setVisible(false);
        this.remoteTimeUsernameLabel.setVisible(false);
        this.localAverageDetailButton.setVisible(false);
        this.localSessionDetailButton.setVisible(false);
        this.remoteSessionDetailButton.setVisible(false);
        this.remoteAverageDetailButton.setVisible(false);
        this.readyColor.setVisible(false);
        this.remoteStatusLabel.setVisible(false);
        this.userIsTyping.setVisible(false);
    }

    private void showGUI() {
        this.bigPicture.setVisible(false);
        this.smallPicture.setVisible(false);
        this.chatScrollPane.setVisible(true);
        this.chatText.setVisible(true);
        this.sendMessageButton.setVisible(true);
        this.countdownLabel.setVisible(true);
        this.countdownCombo.setVisible(true);
        this.startButton.setVisible(true);
        this.popButton.setVisible(true);
        this.useThisAlgLabel.setVisible(true);
        this.scrambleText.setVisible(true);
        this.timerLabel.setVisible(true);
        this.localTimeLabel.setVisible(true);
        this.remoteTimeLabel.setVisible(true);
        this.localTimeUsernameLabel.setVisible(true);
        this.remoteTimeUsernameLabel.setVisible(true);
        this.localAverageDetailButton.setVisible(true);
        this.localSessionDetailButton.setVisible(true);
        this.remoteSessionDetailButton.setVisible(true);
        this.remoteAverageDetailButton.setVisible(true);
        this.readyColor.setVisible(true);
        this.remoteStatusLabel.setVisible(true);
        this.userIsTyping.setVisible(true);
    }

    private void generateNewScramble() {
        String string = this.scrambleAlg.generateAlg("3x3x3");
        this.scrambleText.setText(string);
        this.out.println("S" + string);
        this.out.flush();
    }

    private void updateStats() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        int n2;
        double d5;
        double d6;
        this.remoteTimeLabel.setText(this.remoteTime);
        try {
            d6 = Double.parseDouble(this.localTimeLabel.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d6 = 0.0;
        }
        try {
            d5 = Double.parseDouble(this.remoteTimeLabel.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d5 = 0.0;
        }
        if (d5 == 0.0) {
            ++this.remoteNumOfPops;
        } else {
            ++this.remoteCubesSolved;
        }
        if ((d6 < d5 || d5 == 0.0) && d6 != 0.0) {
            this.localTimeLabel.setForeground(new Color(0, 110, 0));
            this.remoteTimeLabel.setForeground(Color.red);
            ++this.localScore;
        } else if ((d5 < d6 || d6 == 0.0) && d5 != 0.0) {
            this.localTimeLabel.setForeground(Color.red);
            this.remoteTimeLabel.setForeground(new Color(0, 110, 0));
            ++this.remoteScore;
        } else {
            this.localTimeLabel.setForeground(Color.blue);
            this.remoteTimeLabel.setForeground(Color.blue);
        }
        this.sessionScrambles[this.sessionIndex] = this.scrambleText.getText();
        this.localSessionTimes[this.sessionIndex] = this.localTimeLabel.getText();
        this.remoteSessionTimes[this.sessionIndex] = this.remoteTimeLabel.getText();
        if (d6 != 0.0) {
            this.localCurrentAverage[this.localCurrentPlaceInAverage] = this.localTimeLabel.getText();
            this.localCurrentScrambles[this.localCurrentPlaceInAverage] = this.scrambleText.getText();
            ++this.localCurrentPlaceInAverage;
            if (this.localCurrentPlaceInAverage == 12) {
                this.localCurrentPlaceInAverage = 0;
            }
        }
        if (d5 != 0.0) {
            this.remoteCurrentAverage[this.remoteCurrentPlaceInAverage] = this.remoteTimeLabel.getText();
            this.remoteCurrentScrambles[this.remoteCurrentPlaceInAverage] = this.scrambleText.getText();
            ++this.remoteCurrentPlaceInAverage;
            if (this.remoteCurrentPlaceInAverage == 12) {
                this.remoteCurrentPlaceInAverage = 0;
            }
        }
        if (this.localSessionSlowest == 0.0 && d6 != 0.0) {
            this.localSessionSlowest = d6;
            this.localSessionFastest = d6;
        } else if (d6 > this.localSessionSlowest && d6 != 0.0) {
            this.localSessionSlowest = d6;
        } else if (d6 < this.localSessionFastest && d6 != 0.0) {
            this.localSessionFastest = d6;
        }
        if (this.remoteSessionSlowest == 0.0 && d5 != 0.0) {
            this.remoteSessionSlowest = d5;
            this.remoteSessionFastest = d5;
        } else if (d5 > this.remoteSessionSlowest && d5 != 0.0) {
            this.remoteSessionSlowest = d5;
        } else if (d5 < this.remoteSessionFastest && d5 != 0.0) {
            this.remoteSessionFastest = d5;
        }
        if (d6 != 0.0) {
            this.localTotalTime += d6;
            this.localCurrentSessionAverage = this.localTotalTime / (double)this.localCubesSolved;
        }
        if (d5 != 0.0) {
            this.remoteTotalTime += d5;
            this.remoteCurrentSessionAverage = this.remoteTotalTime / (double)this.remoteCubesSolved;
        }
        if (this.localCubesSolved >= 12) {
            int n3 = 0;
            n2 = 0;
            for (int i = 0; i < 12; ++i) {
                d4 = Double.parseDouble(this.localCurrentAverage[n3]);
                d3 = Double.parseDouble(this.localCurrentAverage[n2]);
                d2 = Double.parseDouble(this.localCurrentAverage[i]);
                if (d2 > d3) {
                    n2 = i;
                }
                if (!(d2 < d4)) continue;
                n3 = i;
            }
            this.localCurrentSlowest = Double.parseDouble(this.localCurrentAverage[n2]);
            this.localCurrentFastest = Double.parseDouble(this.localCurrentAverage[n3]);
            d = 0.0;
            for (n = 0; n < 12; ++n) {
                if (n == n3 || n == n2) continue;
                d += Double.parseDouble(this.localCurrentAverage[n]);
            }
            this.localCurrentRollingAverage = d / 10.0;
        }
        if (this.remoteCubesSolved >= 12) {
            int n4 = 0;
            n2 = 0;
            for (int i = 0; i < 12; ++i) {
                d4 = Double.parseDouble(this.remoteCurrentAverage[n4]);
                d3 = Double.parseDouble(this.remoteCurrentAverage[n2]);
                d2 = Double.parseDouble(this.remoteCurrentAverage[i]);
                if (d2 > d3) {
                    n2 = i;
                }
                if (!(d2 < d4)) continue;
                n4 = i;
            }
            this.remoteCurrentSlowest = Double.parseDouble(this.remoteCurrentAverage[n2]);
            this.remoteCurrentFastest = Double.parseDouble(this.remoteCurrentAverage[n4]);
            d = 0.0;
            for (n = 0; n < 12; ++n) {
                if (n == n4 || n == n2) continue;
                d += Double.parseDouble(this.remoteCurrentAverage[n]);
            }
            this.remoteCurrentRollingAverage = d / 10.0;
        }
        ++this.sessionIndex;
        String string7 = this.localCubesSolved >= 12 ? this.timeFormat.format(this.localCurrentRollingAverage) : "N/A";
        String string8 = this.remoteCubesSolved >= 12 ? this.timeFormat.format(this.remoteCurrentRollingAverage) : "N/A";
        if (this.localCubesSolved >= 1) {
            string6 = this.timeFormat.format(this.localCurrentSessionAverage);
            string5 = this.timeFormat.format(this.localSessionFastest);
            string4 = this.timeFormat.format(this.localSessionSlowest);
        } else {
            string6 = "N/A";
            string5 = "N/A";
            string4 = "N/A";
        }
        if (this.remoteCubesSolved >= 1) {
            string3 = this.timeFormat.format(this.remoteCurrentSessionAverage);
            string2 = this.timeFormat.format(this.remoteSessionFastest);
            string = this.timeFormat.format(this.remoteSessionSlowest);
        } else {
            string3 = "N/A";
            string2 = "N/A";
            string = "N/A";
        }
        this.localTimeUsernameLabel.setText("<html>Rolling Average: <FONT SIZE=\"5\">" + string7 + "</FONT><br>Session Average: " + string6 + "<br><br>Score: " + this.localScore + "<br>Session Fastest Time: " + string5 + "<br>Session Slowest Time: " + string4 + "</html>");
        this.remoteTimeUsernameLabel.setText("<html>Rolling Average: <FONT SIZE=\"5\">" + string8 + "</FONT><br>Session Average: " + string3 + "<br><br>Score: " + this.remoteScore + "<br>Session Fastest Time: " + string2 + "<br>Session Slowest Time: " + string + "</html>");
    }

    private void reset() {
        this.isTyping = false;
        this.remoteIsTyping = false;
        this.localSessionTimes = new String[100];
        this.remoteSessionTimes = new String[100];
        this.sessionScrambles = new String[100];
        this.localCurrentAverage = new String[12];
        this.remoteCurrentAverage = new String[12];
        this.localCurrentScrambles = new String[12];
        this.remoteCurrentScrambles = new String[12];
        this.localCubesSolved = 0;
        this.remoteCubesSolved = 0;
        this.localSessionFastest = 0.0;
        this.remoteSessionFastest = 0.0;
        this.localSessionSlowest = 0.0;
        this.remoteSessionSlowest = 0.0;
        this.localCurrentFastest = 0.0;
        this.remoteCurrentFastest = 0.0;
        this.localCurrentSlowest = 0.0;
        this.remoteCurrentSlowest = 0.0;
        this.localCurrentPlaceInAverage = 0;
        this.remoteCurrentPlaceInAverage = 0;
        this.localNumOfPops = 0;
        this.remoteNumOfPops = 0;
        this.localScore = 0;
        this.remoteScore = 0;
        this.sessionIndex = 0;
        this.localCurrentRollingAverage = 0.0;
        this.remoteCurrentRollingAverage = 0.0;
        this.localCurrentSessionAverage = 0.0;
        this.remoteCurrentSessionAverage = 0.0;
        this.localTotalTime = 0.0;
        this.remoteTotalTime = 0.0;
        this.acceptsSincePop = 13;
        this.timerLabel.setText("");
        this.localTimeUsernameLabel.setText("<html>Rolling Average: <FONT SIZE=\"5\">N/A</FONT><br>Session Average: N/A<br><br>Score: 0<br>Session Fastest Time: N/A<br>Session Slowest Time: N/A</html>");
        this.remoteTimeUsernameLabel.setText("<html>Rolling Average: <FONT SIZE=\"5\">N/A</FONT><br>Session Average: N/A<br><br>Score: 0<br>Session Fastest Time: N/A<br>Session Slowest Time: N/A</html>");
        this.localTimeLabel.setText("");
        this.remoteTimeLabel.setText("");
        this.chatText.setText("");
    }

    private String getLocalSessionView() {
        String string = "----- JNetCube Session Statistics for %T -----\r\n\r\nUsername: %U\r\n\r\nCubes Solved: %C\r\nTotal Pops: %P\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\n\r\nIndividual Times:\r\n%I";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < this.sessionIndex; ++i) {
            string2 = string2 + (i + 1) + ")          " + this.localSessionTimes[i] + "          " + this.sessionScrambles[i] + "\r\n";
            string3 = string3 + this.localSessionTimes[i] + "\r\n";
        }
        String string4 = string;
        string4 = this.findAndReplace(string4, "%T", new Date() + "");
        string4 = this.findAndReplace(string4, "%U", this.usernameText.getText());
        string4 = this.findAndReplace(string4, "%A", this.timeFormat.format(this.localCurrentSessionAverage));
        string4 = this.findAndReplace(string4, "%I", string2);
        string4 = this.findAndReplace(string4, "%O", string3);
        string4 = this.findAndReplace(string4, "%F", this.timeFormat.format(this.localSessionFastest));
        string4 = this.findAndReplace(string4, "%S", this.timeFormat.format(this.localSessionSlowest));
        string4 = this.findAndReplace(string4, "%C", this.localCubesSolved + "");
        string4 = this.findAndReplace(string4, "%P", this.localNumOfPops + "");
        return string4;
    }

    private String getLocalAverageView() {
        String string = "----- JNetCube Best Average for %T -----\r\n\r\nUsername: %U\r\n\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\n\r\nIndividual Times:\r\n%I";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 12; ++i) {
            String string4 = this.localCurrentAverage[i];
            if (Double.parseDouble(string4) == this.localCurrentFastest || Double.parseDouble(string4) == this.localCurrentSlowest) {
                string4 = "(" + string4 + ")";
            }
            string2 = string2 + (i + 1) + ")          " + string4 + "          " + this.localCurrentScrambles[i] + "\r\n";
            string3 = string3 + string4 + "\r\n";
        }
        String string5 = string;
        string5 = this.findAndReplace(string5, "%T", new Date() + "");
        string5 = this.findAndReplace(string5, "%U", this.usernameText.getText());
        string5 = this.findAndReplace(string5, "%A", this.timeFormat.format(this.localCurrentRollingAverage));
        string5 = this.findAndReplace(string5, "%I", string2);
        string5 = this.findAndReplace(string5, "%O", string3);
        string5 = this.findAndReplace(string5, "%F", this.timeFormat.format(this.localCurrentFastest));
        string5 = this.findAndReplace(string5, "%S", this.timeFormat.format(this.localCurrentSlowest));
        return string5;
    }

    private String getRemoteSessionView() {
        String string = "----- JNetCube Session Statistics for %T -----\r\n\r\nUsername: %U\r\n\r\nCubes Solved: %C\r\nTotal Pops: %P\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\n\r\nIndividual Times:\r\n%I";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < this.sessionIndex; ++i) {
            string2 = string2 + (i + 1) + ")          " + this.remoteSessionTimes[i] + "          " + this.sessionScrambles[i] + "\r\n";
            string3 = string3 + this.remoteSessionTimes[i] + "\r\n";
        }
        String string4 = string;
        string4 = this.findAndReplace(string4, "%T", new Date() + "");
        string4 = this.findAndReplace(string4, "%U", this.remoteUsername);
        string4 = this.findAndReplace(string4, "%A", this.timeFormat.format(this.remoteCurrentSessionAverage));
        string4 = this.findAndReplace(string4, "%I", string2);
        string4 = this.findAndReplace(string4, "%O", string3);
        string4 = this.findAndReplace(string4, "%F", this.timeFormat.format(this.remoteSessionFastest));
        string4 = this.findAndReplace(string4, "%S", this.timeFormat.format(this.remoteSessionSlowest));
        string4 = this.findAndReplace(string4, "%C", this.remoteCubesSolved + "");
        string4 = this.findAndReplace(string4, "%P", this.remoteNumOfPops + "");
        return string4;
    }

    private String getRemoteAverageView() {
        String string = "----- JNetCube Best Average for %T -----\r\n\r\nUsername: %U\r\n\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\n\r\nIndividual Times:\r\n%I";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 12; ++i) {
            String string4 = this.remoteCurrentAverage[i];
            if (Double.parseDouble(string4) == this.remoteCurrentFastest || Double.parseDouble(string4) == this.remoteCurrentSlowest) {
                string4 = "(" + string4 + ")";
            }
            string2 = string2 + (i + 1) + ")          " + string4 + "          " + this.remoteCurrentScrambles[i] + "\r\n";
            string3 = string3 + string4 + "\r\n";
        }
        String string5 = string;
        string5 = this.findAndReplace(string5, "%T", new Date() + "");
        string5 = this.findAndReplace(string5, "%U", this.remoteUsername);
        string5 = this.findAndReplace(string5, "%A", this.timeFormat.format(this.remoteCurrentRollingAverage));
        string5 = this.findAndReplace(string5, "%I", string2);
        string5 = this.findAndReplace(string5, "%O", string3);
        string5 = this.findAndReplace(string5, "%F", this.timeFormat.format(this.remoteCurrentFastest));
        string5 = this.findAndReplace(string5, "%S", this.timeFormat.format(this.remoteCurrentSlowest));
        return string5;
    }

    private String findAndReplace(String string, String string2, String string3) {
        int n;
        while ((n = string.indexOf(string2)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length(), string.length());
        }
        return string;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.connectButton) {
            this.connectButton.setText("LISTENING");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.connectButton) {
            try {
                this.serverSocket = new ServerSocket(Integer.parseInt(this.serverPortText.getText()));
                this.clientSocket = this.serverSocket.accept();
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                this.out = new PrintWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
                this.localTimeUsernameLabel.setBorder(BorderFactory.createTitledBorder(this.usernameText.getText() + "'s Statistics"));
                this.out.println("U" + this.usernameText.getText());
                this.out.flush();
                this.generateNewScramble();
                this.showGUI();
                this.startupClip.play();
                this.chatListener = new Thread(this);
                this.chatListener.start();
                this.connectButton.setText("CONNECTED");
                this.connectButton.setEnabled(false);
                this.usernameText.setEnabled(false);
                this.serverPortText.setEnabled(false);
                this.handicapText.setEnabled(false);
                this.sendMessageButton.setEnabled(true);
                this.chatText.setEnabled(true);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Server information is not correctly formatted.");
                this.hideGUI();
                this.connectButton.setText("Start Server");
                this.connectButton.setEnabled(true);
                this.usernameText.setEnabled(true);
                this.serverPortText.setEnabled(true);
                this.handicapText.setEnabled(true);
                this.sendMessageButton.setEnabled(false);
                this.chatText.setEnabled(false);
                return;
            }
        } else if (object == this.chatText) {
            if (this.chatText.getText().equals("")) {
                if (this.isTyping) {
                    this.isTyping = false;
                    this.out.println("I");
                    this.out.flush();
                }
            } else if (!this.isTyping) {
                this.isTyping = true;
                this.out.println("I");
                this.out.flush();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.connectButton) {
            this.connectButton.setText("LISTENING");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.connectButton) {
            try {
                this.serverSocket = new ServerSocket(Integer.parseInt(this.serverPortText.getText()));
                this.clientSocket = this.serverSocket.accept();
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                this.out = new PrintWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
                this.localTimeUsernameLabel.setBorder(BorderFactory.createTitledBorder(this.usernameText.getText() + "'s Statistics"));
                this.out.println("U" + this.usernameText.getText());
                this.out.flush();
                this.generateNewScramble();
                this.showGUI();
                this.startupClip.play();
                this.chatListener = new Thread(this);
                this.chatListener.start();
                this.connectButton.setText("CONNECTED");
                this.connectButton.setEnabled(false);
                this.usernameText.setEnabled(false);
                this.serverPortText.setEnabled(false);
                this.handicapText.setEnabled(false);
                this.sendMessageButton.setEnabled(true);
                this.chatText.setEnabled(true);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Server information is not correctly formatted.");
                this.hideGUI();
                this.connectButton.setText("Start Server");
                this.connectButton.setEnabled(true);
                this.usernameText.setEnabled(true);
                this.serverPortText.setEnabled(true);
                this.handicapText.setEnabled(true);
                this.sendMessageButton.setEnabled(false);
                this.chatText.setEnabled(false);
                return;
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    class RunTimer
    extends TimerTask {
        RunTimer() {
        }

        public void run() {
            double d = ((double)System.currentTimeMillis() - Server.this.startTime) / 1000.0;
            Server.this.timerLabel.setText(Server.this.timeFormat.format(d));
        }
    }

    class RunCountdown
    extends TimerTask {
        int readyTime = 2;

        RunCountdown() {
        }

        public void run() {
            if (this.readyTime == 2) {
                Server.this.bing2.play();
                Server.this.timerLabel.setFont(new Font("Serif", 0, 64));
                Server.this.timerLabel.setText("Get Ready!...2");
                --this.readyTime;
            } else if (this.readyTime == 1) {
                Server.this.timerLabel.setText("Get Ready!...1");
                --this.readyTime;
            } else {
                Server.this.timerLabel.setFont(new Font("Serif", 0, 94));
                if (this.readyTime == 0) {
                    Server.this.bing1.play();
                    --this.readyTime;
                }
                if (Server.this.countdown == 0) {
                    Server.this.timerLabel.setForeground(Color.blue);
                    Server.this.startButton.setEnabled(true);
                    if (Server.this.acceptsSincePop >= 12) {
                        Server.this.popButton.setText("POP");
                        Server.this.popButton.setEnabled(true);
                    }
                    Server.this.timerThread = new Timer();
                    Server.this.startButton.requestFocus();
                    Server.this.startTime = System.currentTimeMillis();
                    Server.this.timerThread.schedule((TimerTask)new RunTimer(), 0L, 120L);
                    this.cancel();
                } else if (Server.this.countdown == 3) {
                    try {
                        Server.this.countdownClip.play();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    Server.this.timerLabel.setText("" + Server.this.countdown);
                    --Server.this.countdown;
                } else {
                    Server.this.timerLabel.setText("" + Server.this.countdown);
                    --Server.this.countdown;
                }
            }
        }
    }
}

