/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Standalone
extends JFrame
implements ActionListener,
Runnable {
    static JButton startButton;
    static JButton discardButton;
    static JButton popButton;
    static JButton addTimeButton;
    static JButton sessionResetButton;
    static JButton sessionDetailedViewButton;
    static JButton averageDetailedViewButton;
    static JButton insertTimeButton;
    JLabel cubeTypeLabel;
    JLabel countdownTimeLabel;
    JLabel useThisAlgLabel;
    JLabel timerLabel;
    JLabel sessionStatsLabel;
    JLabel rollingAverageLabel;
    JLabel bestAverageLabel;
    JMenuBar jMenuBar;
    JMenu fileMenu;
    JMenu toolsMenu;
    JMenu networkMenu;
    JMenu helpMenu;
    JMenuItem saveBestItem;
    JMenuItem saveSessionItem;
    JMenuItem optionsItem;
    JMenuItem exitItem;
    JMenuItem importItem;
    JMenuItem generatorItem;
    JMenuItem aboutItem;
    JMenuItem serverItem;
    JMenuItem clientItem;
    JMenuItem viewScrambleItem;
    static JComboBox cubeCombo;
    static JComboBox countdownCombo;
    JTextArea bestAverageText;
    static JTextArea scrambleLabel;
    JLabel[] averageLabels;
    JLabel[] timeLabels;
    static String sessionViewFormat;
    static String averageViewFormat;
    static boolean showResetConfirm;
    static boolean showMinutes;
    static Color countdownColor;
    static Color timerColor;
    static Color currentColor;
    static Color fastestColor;
    static Color slowestColor;
    static Color fColor;
    static Color bColor;
    static Color lColor;
    static Color rColor;
    static Color dColor;
    static Color uColor;
    volatile Thread timerThread;
    AudioClip countdownClip = null;
    DecimalFormat timeFormat;
    NumberFormat nf;
    boolean runningCountdown;
    double startTime = 0.0;
    double stopTime = 0.0;
    double sessionTotalTime = 0.0;
    double bestAverage = 0.0;
    double bestStandardDeviation = 0.0;
    double sessionFastest = 0.0;
    double sessionSlowest = 0.0;
    double bestFastest = 0.0;
    double bestSlowest = 0.0;
    double previousAverage = 0.0;
    int countdown = 0;
    int cubesSolved = 0;
    int placeInAverage = 0;
    int sessionIndex = 0;
    int acceptsSincePop = 12;
    int numberOfPops = 0;
    String[] bestAverageTimes = new String[12];
    String[] bestAverageScrambles = new String[12];
    String[] currentAverageScrambles = new String[12];
    String[] currentAverageTimes = new String[12];
    String[] sessionTimes = new String[100];
    String[] sessionScrambles = new String[100];
    JFileChooser fc = new JFileChooser();
    ScrambleAlgorithm algGenerator;
    static ViewScramble viewScramble;
    String[] importedAlgs;
    boolean hasImported = false;
    int importedIndex;

    public static void main(String[] stringArray) {
        String string = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Standalone standalone = new Standalone();
        standalone.setVisible(true);
        startButton.requestFocus();
    }

    public Standalone() {
        int n;
        int n2;
        this.nf = NumberFormat.getNumberInstance(new Locale("en", "US"));
        this.timeFormat = (DecimalFormat)this.nf;
        this.timeFormat.applyPattern("00.00");
        this.fc.setFileFilter(new TextFileFilter());
        this.fc.setAcceptAllFileFilterUsed(false);
        this.algGenerator = new ScrambleAlgorithm();
        Container container = this.getContentPane();
        container.setLayout(null);
        try {
            this.countdownClip = Applet.newAudioClip(this.getClass().getResource("count.mid"));
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, "count.mid not found. There will be no countdown audio.");
        }
        this.setTitle("JNetCube Standalone Timer");
        this.setSize(840, 565);
        this.setIconImage(new ImageIcon(this.getClass().getResource("Cow.gif")).getImage());
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        this.setLocation((dimension.width - n3) / 2, (dimension.height - n4) / 2);
        this.saveBestItem = new JMenuItem("Save Best Average As");
        this.saveSessionItem = new JMenuItem("Save Session Average As");
        this.optionsItem = new JMenuItem("Options...");
        this.exitItem = new JMenuItem("Exit");
        this.importItem = new JMenuItem("Import Scrambles");
        this.generatorItem = new JMenuItem("Scramble Generator");
        this.aboutItem = new JMenuItem("About");
        this.serverItem = new JMenuItem("Start Server");
        this.clientItem = new JMenuItem("Connect To Server");
        this.viewScrambleItem = new JMenuItem("View Scramble");
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(this.saveBestItem);
        this.fileMenu.add(this.saveSessionItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.optionsItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.add(this.importItem);
        this.toolsMenu.add(this.generatorItem);
        this.toolsMenu.add(this.viewScrambleItem);
        this.networkMenu = new JMenu("Network Timer");
        this.networkMenu.add(this.serverItem);
        this.networkMenu.add(this.clientItem);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(this.aboutItem);
        this.jMenuBar = new JMenuBar();
        this.jMenuBar.add(this.fileMenu);
        this.jMenuBar.add(this.toolsMenu);
        this.jMenuBar.add(this.networkMenu);
        this.jMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar);
        this.cubeTypeLabel = new JLabel("Cube Type");
        String[] stringArray = new String[]{"2x2x2", "3x3x3", "4x4x4", "5x5x5", "Pyraminx"};
        cubeCombo = new JComboBox<String>(stringArray);
        cubeCombo.setSelectedIndex(1);
        this.countdownTimeLabel = new JLabel("Countdown Time");
        String[] stringArray2 = new String[]{"0", "4", "5", "7", "10", "15", "20"};
        countdownCombo = new JComboBox<String>(stringArray2);
        countdownCombo.setSelectedIndex(5);
        startButton = new JButton("Start Timer");
        discardButton = new JButton("Discard Time");
        discardButton.setEnabled(false);
        popButton = new JButton("POP");
        popButton.setEnabled(false);
        addTimeButton = new JButton("+2");
        addTimeButton.setEnabled(false);
        this.averageLabels = new JLabel[12];
        this.averageLabels[0] = new JLabel("1st");
        this.averageLabels[1] = new JLabel("2nd");
        this.averageLabels[2] = new JLabel("3rd");
        this.averageLabels[3] = new JLabel("4th");
        this.averageLabels[4] = new JLabel("5th");
        this.averageLabels[5] = new JLabel("6th");
        this.averageLabels[6] = new JLabel("7th");
        this.averageLabels[7] = new JLabel("8th");
        this.averageLabels[8] = new JLabel("9th");
        this.averageLabels[9] = new JLabel("10th");
        this.averageLabels[10] = new JLabel("11th");
        this.averageLabels[11] = new JLabel("12th");
        this.useThisAlgLabel = new JLabel("Use this algorithm to scramble your cube");
        this.useThisAlgLabel.setHorizontalAlignment(0);
        scrambleLabel = new JTextArea("");
        scrambleLabel.setEditable(false);
        scrambleLabel.setLineWrap(true);
        scrambleLabel.setWrapStyleWord(true);
        scrambleLabel.setBackground(new Color(255, 222, 140));
        scrambleLabel.setForeground(Color.black);
        scrambleLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        scrambleLabel.setFont(new Font("Serif", 1, 16));
        this.timerLabel = new JLabel("");
        this.timerLabel.setVisible(false);
        this.timerLabel.setHorizontalAlignment(0);
        this.timerLabel.setFont(new Font("Serif", 0, 94));
        this.sessionStatsLabel = new JLabel("<HTML>Recent Time: N/A<br>Previous Time: N/A<br>Progress: N/A<br><br>Cubes Solved: 0<br>Session Average: N/A</HTML>");
        this.sessionStatsLabel.setBorder(BorderFactory.createTitledBorder("Session Statistics"));
        this.rollingAverageLabel = new JLabel("<HTML>Current Average: <FONT SIZE=\"5\">N/A</FONT><br>Progress: N/A<br><br>Fastest Time: N/A<br>Slowest Time: N/A<br>Standard Deviation: N/A</HTML>");
        this.rollingAverageLabel.setBorder(BorderFactory.createTitledBorder("Rolling Average"));
        this.bestAverageLabel = new JLabel("");
        this.bestAverageLabel.setBorder(BorderFactory.createTitledBorder("Best Average"));
        this.bestAverageText = new JTextArea("Average: N/A\nIndividual Times: N/A");
        this.bestAverageText.setFont(new Font("Serif", 0, 14));
        this.bestAverageText.setBorder(BorderFactory.createLineBorder(Color.black));
        this.bestAverageText.setBackground(new Color(220, 220, 255));
        this.bestAverageText.setEditable(false);
        insertTimeButton = new JButton("Add Time");
        sessionDetailedViewButton = new JButton("Detail");
        sessionDetailedViewButton.setEnabled(false);
        averageDetailedViewButton = new JButton("Detail");
        averageDetailedViewButton.setEnabled(false);
        sessionResetButton = new JButton("Reset");
        this.timeLabels = new JLabel[12];
        for (n2 = 0; n2 < 12; ++n2) {
            this.timeLabels[n2] = new JLabel("none");
        }
        viewScramble = new ViewScramble();
        this.cubeTypeLabel.setBounds(10, 5, 82, 20);
        cubeCombo.setBounds(10, 25, 82, 20);
        this.countdownTimeLabel.setBounds(102, 5, 112, 20);
        countdownCombo.setBounds(102, 25, 112, 20);
        startButton.setBounds(10, 50, 204, 20);
        discardButton.setBounds(10, 75, 204, 20);
        popButton.setBounds(10, 100, 99, 20);
        addTimeButton.setBounds(115, 100, 99, 20);
        this.timerLabel.setBounds(10, 125, 810, 75);
        this.useThisAlgLabel.setBounds(224, 5, 601, 20);
        scrambleLabel.setBounds(224, 25, 601, 95);
        this.sessionStatsLabel.setBounds(10, 270, 402, 130);
        this.rollingAverageLabel.setBounds(422, 270, 402, 130);
        this.bestAverageLabel.setBounds(10, 410, 815, 100);
        this.bestAverageText.setBounds(20, 454, 795, 46);
        sessionDetailedViewButton.setBounds(311, 286, 90, 20);
        averageDetailedViewButton.setBounds(724, 426, 90, 20);
        insertTimeButton.setBounds(311, 311, 90, 20);
        sessionResetButton.setBounds(311, 336, 90, 20);
        n2 = 11;
        int n5 = 50;
        int n6 = 19;
        for (n = 0; n < 12; ++n) {
            this.averageLabels[n].setBounds(n2, 220, n5, 20);
            this.averageLabels[n].setHorizontalAlignment(0);
            this.timeLabels[n].setBounds(n2, 240, n5, 20);
            this.timeLabels[n].setHorizontalAlignment(0);
            n2 = n2 + n5 + n6;
        }
        this.saveBestItem.addActionListener(this);
        this.saveSessionItem.addActionListener(this);
        this.optionsItem.addActionListener(this);
        this.exitItem.addActionListener(this);
        this.importItem.addActionListener(this);
        this.generatorItem.addActionListener(this);
        this.aboutItem.addActionListener(this);
        this.serverItem.addActionListener(this);
        this.clientItem.addActionListener(this);
        cubeCombo.addActionListener(this);
        countdownCombo.addActionListener(this);
        startButton.addActionListener(this);
        discardButton.addActionListener(this);
        popButton.addActionListener(this);
        addTimeButton.addActionListener(this);
        sessionDetailedViewButton.addActionListener(this);
        averageDetailedViewButton.addActionListener(this);
        sessionResetButton.addActionListener(this);
        insertTimeButton.addActionListener(this);
        this.viewScrambleItem.addActionListener(this);
        container.add(this.cubeTypeLabel);
        container.add(cubeCombo);
        container.add(this.countdownTimeLabel);
        container.add(countdownCombo);
        container.add(startButton);
        container.add(discardButton);
        container.add(popButton);
        container.add(addTimeButton);
        container.add(this.useThisAlgLabel);
        container.add(scrambleLabel);
        container.add(this.timerLabel);
        container.add(this.sessionStatsLabel);
        container.add(this.rollingAverageLabel);
        container.add(this.bestAverageLabel);
        container.add(this.bestAverageText);
        container.add(sessionDetailedViewButton);
        container.add(averageDetailedViewButton);
        container.add(sessionResetButton);
        container.add(insertTimeButton);
        for (n = 0; n < 12; ++n) {
            container.add(this.averageLabels[n]);
            container.add(this.timeLabels[n]);
        }
        scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
        viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
        Standalone.loadOptions();
        this.timeLabels[0].setForeground(new Color(0, 110, 0));
        this.setDefaultCloseOperation(3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == startButton) {
            if (startButton.getText().equals("Start Timer")) {
                startButton.setText("Stop Timer");
                this.runningCountdown = true;
                this.countdown = Integer.parseInt(countdownCombo.getSelectedItem() + "");
                this.timerLabel.setForeground(countdownColor);
                this.timerLabel.setVisible(true);
                insertTimeButton.setEnabled(false);
                sessionResetButton.setEnabled(false);
                sessionDetailedViewButton.setEnabled(false);
                averageDetailedViewButton.setEnabled(false);
                cubeCombo.setEnabled(false);
                countdownCombo.setEnabled(false);
                this.timerThread = new Thread(this);
                this.timerThread.start();
            } else if (startButton.getText().equals("Stop Timer")) {
                if (this.runningCountdown) {
                    this.timerThread = null;
                    if (this.cubesSolved >= 1 || this.numberOfPops >= 1) {
                        sessionDetailedViewButton.setEnabled(true);
                    }
                    insertTimeButton.setEnabled(true);
                    averageDetailedViewButton.setEnabled(true);
                    sessionResetButton.setEnabled(true);
                    discardButton.setEnabled(false);
                    popButton.setEnabled(false);
                    addTimeButton.setEnabled(false);
                    cubeCombo.setEnabled(true);
                    countdownCombo.setEnabled(true);
                    startButton.setText("Start Timer");
                    this.timerLabel.setText("");
                    this.timerLabel.setVisible(false);
                    this.countdownClip.stop();
                    startButton.requestFocus();
                } else {
                    this.stopTime = System.currentTimeMillis();
                    this.timerThread = null;
                    double d = (this.stopTime - this.startTime) / 1000.0;
                    if (d > 60.0 && showMinutes) {
                        int n = (int)(d / 60.0);
                        this.timerLabel.setText(n + ":" + this.timeFormat.format(d - (double)(n * 60)));
                    } else {
                        this.timerLabel.setText(this.timeFormat.format(d));
                    }
                    startButton.setText("Accept Time");
                    if (this.acceptsSincePop >= 12 || this.acceptsSincePop == -1) {
                        popButton.setText("POP");
                        popButton.setEnabled(true);
                    }
                    discardButton.setEnabled(true);
                    addTimeButton.setEnabled(true);
                }
            } else if (startButton.getText().equals("Accept Time")) {
                ++this.cubesSolved;
                try {
                    this.acceptTime();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "There has been an error, please inform Chris that you saw this message.");
                    System.out.println(numberFormatException);
                }
            }
        } else if (object == discardButton) {
            if (this.cubesSolved >= 1 || this.numberOfPops >= 1) {
                sessionDetailedViewButton.setEnabled(true);
            }
            if (this.cubesSolved >= 12) {
                averageDetailedViewButton.setEnabled(true);
            }
            insertTimeButton.setEnabled(true);
            sessionResetButton.setEnabled(true);
            discardButton.setEnabled(false);
            popButton.setEnabled(false);
            addTimeButton.setEnabled(false);
            cubeCombo.setEnabled(true);
            countdownCombo.setEnabled(true);
            startButton.setText("Start Timer");
            this.timerLabel.setText("");
            this.timerLabel.setVisible(false);
            if (!this.hasImported) {
                scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
                viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            }
            startButton.requestFocus();
        } else if (object == popButton) {
            this.acceptsSincePop = 0;
            ++this.numberOfPops;
            popButton.setText("Popped");
            if (this.sessionIndex > this.sessionTimes.length - 1) {
                String[] stringArray = new String[this.sessionTimes.length * 2];
                String[] stringArray2 = new String[this.sessionTimes.length * 2];
                for (int i = 0; i < this.sessionTimes.length; ++i) {
                    stringArray[i] = this.sessionTimes[i];
                    stringArray2[i] = this.sessionScrambles[i];
                }
                this.sessionTimes = stringArray;
                this.sessionScrambles = stringArray2;
            }
            this.sessionTimes[this.sessionIndex] = "POP";
            this.sessionScrambles[this.sessionIndex] = scrambleLabel.getText();
            ++this.sessionIndex;
            if (this.cubesSolved >= 12) {
                averageDetailedViewButton.setEnabled(true);
            }
            insertTimeButton.setEnabled(true);
            sessionDetailedViewButton.setEnabled(true);
            sessionResetButton.setEnabled(true);
            discardButton.setEnabled(false);
            popButton.setEnabled(false);
            addTimeButton.setEnabled(false);
            cubeCombo.setEnabled(true);
            countdownCombo.setEnabled(true);
            startButton.setText("Start Timer");
            this.timerLabel.setText("");
            this.timerLabel.setVisible(false);
            if (!this.hasImported) {
                scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
                viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            } else {
                this.updateImportedAlgs();
            }
            startButton.requestFocus();
        } else if (object == addTimeButton) {
            this.stopTime += 2000.0;
            ++this.cubesSolved;
            try {
                this.acceptTime();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "There has been an error, please inform Chris that you saw this message.");
                System.out.println(numberFormatException);
            }
        } else if (object == sessionResetButton) {
            int n;
            if (showResetConfirm && (n = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset this session and lose all times?", "Reset Session", 0)) == 1) {
                startButton.requestFocus();
                return;
            }
            this.placeInAverage = 0;
            this.sessionIndex = 0;
            this.bestAverage = 0.0;
            this.cubesSolved = 0;
            this.sessionTotalTime = 0.0;
            this.sessionFastest = 0.0;
            this.sessionSlowest = 0.0;
            this.acceptsSincePop = 12;
            this.sessionTimes = new String[100];
            this.sessionScrambles = new String[100];
            this.bestAverageText.setText("Average: N/A\nIndividual Times: N/A");
            for (n = 0; n < 12; ++n) {
                this.timeLabels[n].setText("none");
                this.timeLabels[n].setForeground(Color.black);
            }
            this.timeLabels[0].setForeground(currentColor);
            this.sessionStatsLabel.setText("<HTML>Recent Time: N/A<br>Previous Time: N/A<br>Progress: N/A<br><br>Cubes Solved: 0<br>Session Average: N/A</HTML>");
            this.rollingAverageLabel.setText("<HTML>Current Average: <FONT SIZE=\"5\">N/A</FONT><br>Progress: N/A<br><br>Fastest Time: N/A<br>Slowest Time: N/A<br>Standard Deviation: N/A</HTML>");
            insertTimeButton.setEnabled(true);
            sessionDetailedViewButton.setEnabled(false);
            averageDetailedViewButton.setEnabled(false);
            discardButton.setEnabled(false);
            popButton.setEnabled(false);
            addTimeButton.setEnabled(false);
            cubeCombo.setEnabled(true);
            countdownCombo.setEnabled(true);
            startButton.setText("Start Timer");
            this.timerLabel.setText("");
            this.timerLabel.setVisible(false);
            scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            this.hasImported = false;
            startButton.requestFocus();
        } else if (object == cubeCombo) {
            if (!this.hasImported) {
                scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
                viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            }
            startButton.requestFocus();
        } else if (object == countdownCombo) {
            startButton.requestFocus();
        } else if (object == sessionDetailedViewButton) {
            DetailedView detailedView = new DetailedView("Session Times", this.getSessionView());
            detailedView.setVisible(true);
        } else if (object == averageDetailedViewButton) {
            DetailedView detailedView = new DetailedView("Best Average", this.getAverageView());
            detailedView.setVisible(true);
        } else if (object == this.saveSessionItem) {
            if (this.cubesSolved >= 1) {
                int n = this.fc.showSaveDialog(this);
                if (n == 0) {
                    this.saveToFile(this.getSessionView(), this.fc.getSelectedFile());
                }
            } else {
                JOptionPane.showMessageDialog(this, "No times have been recorded for this session.");
            }
        } else if (object == this.saveBestItem) {
            if (this.cubesSolved >= 12) {
                int n = this.fc.showSaveDialog(this);
                if (n == 0) {
                    this.saveToFile(this.getAverageView(), this.fc.getSelectedFile());
                }
            } else {
                JOptionPane.showMessageDialog(this, "Not enough cubes have been solved to calculate an average.");
            }
        } else if (object == this.exitItem) {
            System.exit(0);
        } else if (object == this.generatorItem) {
            ScrambleGenerator scrambleGenerator = new ScrambleGenerator();
            scrambleGenerator.setVisible(true);
        } else if (object == this.aboutItem) {
            AboutScreen aboutScreen = new AboutScreen();
            aboutScreen.setVisible(true);
        } else if (object == this.importItem) {
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                Object object2;
                String string = "";
                try {
                    String string2;
                    object2 = new FileReader(this.fc.getSelectedFile());
                    BufferedReader bufferedReader = new BufferedReader((Reader)object2);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string = string + string2 + "%";
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "There was an error opening the file.");
                }
                object2 = new StringTokenizer(string, "%");
                this.importedAlgs = new String[((StringTokenizer)object2).countTokens()];
                for (int i = 0; i < this.importedAlgs.length; ++i) {
                    this.importedAlgs[i] = ((StringTokenizer)object2).nextToken();
                }
                this.hasImported = true;
                this.importedIndex = 0;
                this.updateImportedAlgs();
            }
        } else if (object == insertTimeButton) {
            String string = JOptionPane.showInputDialog(this, (Object)"Enter time to add in seconds or POP:");
            if (string.equalsIgnoreCase("POP")) {
                ++this.numberOfPops;
                if (this.sessionIndex > this.sessionTimes.length - 1) {
                    String[] stringArray = new String[this.sessionTimes.length * 2];
                    String[] stringArray3 = new String[this.sessionTimes.length * 2];
                    for (int i = 0; i < this.sessionTimes.length; ++i) {
                        stringArray[i] = this.sessionTimes[i];
                        stringArray3[i] = this.sessionScrambles[i];
                    }
                    this.sessionTimes = stringArray;
                    this.sessionScrambles = stringArray3;
                }
                this.sessionTimes[this.sessionIndex] = "POP";
                this.sessionScrambles[this.sessionIndex] = scrambleLabel.getText();
                ++this.sessionIndex;
                if (!this.hasImported) {
                    scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
                    viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
                } else {
                    this.updateImportedAlgs();
                }
                sessionDetailedViewButton.setEnabled(true);
                return;
            }
            double d = 0.0;
            if (string != null) {
                try {
                    d = Double.parseDouble(this.timeFormat.format(Double.parseDouble(string))) * 1000.0;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid number entered. No time was added to the session.");
                    return;
                }
                this.startTime = 0.0;
                this.stopTime = d;
                ++this.cubesSolved;
                try {
                    this.acceptTime();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "There has been an error, please inform Chris that you saw this message.");
                    System.out.println(numberFormatException);
                }
                insertTimeButton.requestFocus();
            }
        } else if (object == this.optionsItem) {
            OptionsMenu optionsMenu = new OptionsMenu();
            optionsMenu.setVisible(true);
        } else if (object == this.serverItem) {
            Server server = new Server();
            server.setVisible(true);
            this.dispose();
        } else if (object == this.clientItem) {
            Client client = new Client();
            client.setVisible(true);
            this.dispose();
        } else if (object == this.viewScrambleItem) {
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            viewScramble.setVisible(true);
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.timerThread == thread) {
            if (this.runningCountdown) {
                if (this.countdown == 0) {
                    this.runningCountdown = false;
                    startButton.setEnabled(true);
                    startButton.requestFocus();
                    this.timerLabel.setForeground(timerColor);
                    this.startTime = System.currentTimeMillis();
                    continue;
                }
                if (this.countdown == 3) {
                    try {
                        this.countdownClip.play();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.timerLabel.setText("" + this.countdown);
                    --this.countdown;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.timerLabel.setText("" + this.countdown);
                --this.countdown;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            double d = ((double)System.currentTimeMillis() - this.startTime) / 1000.0;
            if (d > 60.0 && showMinutes) {
                int n = (int)(d / 60.0);
                this.timerLabel.setText(n + ":" + this.timeFormat.format(d - (double)(n * 60)));
            } else {
                this.timerLabel.setText(this.timeFormat.format(d));
            }
            try {
                Thread.sleep(120L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }
    }

    private void acceptTime() throws NumberFormatException {
        String string;
        String string2;
        int n;
        Object object;
        int n2;
        double d = (this.stopTime - this.startTime) / 1000.0;
        if (d >= 60.0 && showMinutes) {
            n2 = (int)(d / 60.0);
            this.timeLabels[this.placeInAverage].setText(n2 + ":" + this.timeFormat.format(d - (double)(n2 * 60)));
        } else {
            this.timeLabels[this.placeInAverage].setText(this.timeFormat.format(d));
        }
        if (this.sessionIndex > this.sessionTimes.length - 1) {
            String[] stringArray = new String[this.sessionTimes.length * 2];
            object = new String[this.sessionTimes.length * 2];
            for (n = 0; n < this.sessionTimes.length; ++n) {
                stringArray[n] = this.sessionTimes[n];
                object[n] = this.sessionScrambles[n];
            }
            this.sessionTimes = stringArray;
            this.sessionScrambles = object;
        }
        this.sessionTotalTime += Double.parseDouble(this.timeFormat.format(d));
        this.sessionTimes[this.sessionIndex] = this.timeFormat.format(d);
        this.sessionScrambles[this.sessionIndex] = scrambleLabel.getText();
        this.currentAverageScrambles[this.placeInAverage] = scrambleLabel.getText();
        this.currentAverageTimes[this.placeInAverage] = this.timeFormat.format(d);
        if (Double.parseDouble(this.sessionTimes[this.sessionIndex]) < this.sessionFastest || Double.parseDouble(this.sessionTimes[this.sessionIndex]) > this.sessionSlowest || this.sessionFastest == 0.0 || this.sessionSlowest == 0.0) {
            if (this.sessionFastest == 0.0 || this.sessionSlowest == 0.0) {
                this.sessionFastest = Double.parseDouble(this.sessionTimes[this.sessionIndex]);
                this.sessionSlowest = Double.parseDouble(this.sessionTimes[this.sessionIndex]);
            } else if (Double.parseDouble(this.sessionTimes[this.sessionIndex]) < this.sessionFastest) {
                this.sessionFastest = Double.parseDouble(this.sessionTimes[this.sessionIndex]);
            } else if (Double.parseDouble(this.sessionTimes[this.sessionIndex]) > this.sessionSlowest) {
                this.sessionSlowest = Double.parseDouble(this.sessionTimes[this.sessionIndex]);
            }
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.timeLabels[n2].setForeground(Color.black);
        }
        if (this.cubesSolved >= 12) {
            String string3;
            String string4;
            n2 = 0;
            int n3 = 0;
            for (n = 0; n < 12; ++n) {
                if (Double.parseDouble(this.currentAverageTimes[n]) < Double.parseDouble(this.currentAverageTimes[n2])) {
                    n2 = n;
                    continue;
                }
                if (!(Double.parseDouble(this.currentAverageTimes[n]) > Double.parseDouble(this.currentAverageTimes[n3]))) continue;
                n3 = n;
            }
            this.timeLabels[n2].setForeground(fastestColor);
            this.timeLabels[n3].setForeground(slowestColor);
            double d2 = 0.0;
            for (int i = 0; i < 12; ++i) {
                if (i == n2 || i == n3) continue;
                d2 += Double.parseDouble(this.currentAverageTimes[i]);
            }
            d2 /= 10.0;
            double d3 = 0.0;
            for (int i = 0; i < 12; ++i) {
                if (i == n2 || i == n3) continue;
                d3 += (d2 - Double.parseDouble(this.currentAverageTimes[i])) * (d2 - Double.parseDouble(this.currentAverageTimes[i]));
            }
            d3 = Math.sqrt(d3 / 9.0);
            String string5 = this.timeFormat.format(d2 - this.previousAverage);
            try {
                if (Double.parseDouble(string5) > 0.0) {
                    string4 = "#FF0000";
                } else if (Double.parseDouble(string5) < 0.0) {
                    string4 = "#0000FF";
                } else {
                    string4 = "#000000";
                    string5 = "00.00";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string4 = "#000000";
            }
            if (d2 >= 60.0 && showMinutes) {
                int n4 = (int)(d2 / 60.0);
                string3 = n4 + ":" + this.timeFormat.format(d2 - (double)(n4 * 60));
            } else {
                string3 = this.timeFormat.format(d2) + " seconds";
            }
            this.rollingAverageLabel.setText("<HTML>Current Average: <FONT SIZE=\"5\">" + string3 + "</FONT><br>Progress: <font color=\"" + string4 + "\">" + string5 + " seconds</font><br><br>Fastest Time: " + this.timeLabels[n2].getText() + "<br>Slowest Time: " + this.timeLabels[n3].getText() + "<br>Standard Deviation: " + this.timeFormat.format(d3) + "</HTML>");
            this.previousAverage = d2;
            if (d2 < this.bestAverage || this.bestAverage == 0.0) {
                int n5;
                int n6;
                String string6;
                this.bestAverage = d2;
                if (this.bestAverage >= 60.0 && showMinutes) {
                    int n7 = (int)(this.bestAverage / 60.0);
                    string6 = n7 + ":" + this.timeFormat.format(this.bestAverage - (double)(n7 * 60));
                } else {
                    string6 = this.timeFormat.format(this.bestAverage) + " seconds";
                }
                this.bestFastest = Double.parseDouble(this.currentAverageTimes[n2]);
                this.bestSlowest = Double.parseDouble(this.currentAverageTimes[n3]);
                this.bestStandardDeviation = d3;
                String[] stringArray = new String[12];
                String[] stringArray2 = new String[12];
                for (n6 = 0; n6 < 12; ++n6) {
                    if (Double.parseDouble(this.currentAverageTimes[n6]) >= 60.0 && showMinutes) {
                        n5 = (int)(Double.parseDouble(this.currentAverageTimes[n6]) / 60.0);
                        stringArray[n6] = n5 + ":" + this.timeFormat.format(Double.parseDouble(this.currentAverageTimes[n6]) - (double)(n5 * 60));
                    } else {
                        stringArray[n6] = this.currentAverageTimes[n6];
                    }
                    if (n6 == n2 || n6 == n3) {
                        stringArray[n6] = "(" + stringArray[n6] + ")";
                    }
                    stringArray2[n6] = this.currentAverageScrambles[n6];
                }
                n6 = 0;
                for (n5 = this.placeInAverage + 1; n5 < 12; ++n5) {
                    this.bestAverageTimes[n6] = stringArray[n5];
                    this.bestAverageScrambles[n6] = stringArray2[n5];
                    ++n6;
                }
                for (n5 = 0; n5 < this.placeInAverage + 1; ++n5) {
                    this.bestAverageTimes[n6] = stringArray[n5];
                    this.bestAverageScrambles[n6] = stringArray2[n5];
                    ++n6;
                }
                String string7 = "";
                for (int i = 0; i < 12; ++i) {
                    string7 = string7 + this.bestAverageTimes[i] + ", ";
                }
                string7 = string7.substring(0, string7.length() - 2);
                this.bestAverageText.setText("Average: " + string6 + "\nIndividual Times: " + string7);
            }
        }
        if (this.cubesSolved > 1) {
            if (this.placeInAverage == 0) {
                string2 = this.timeLabels[11].getText();
                object = this.timeFormat.format(Double.parseDouble(this.currentAverageTimes[this.placeInAverage]) - Double.parseDouble(this.currentAverageTimes[11]));
            } else {
                string2 = this.timeLabels[this.placeInAverage - 1].getText();
                object = this.timeFormat.format(Double.parseDouble(this.currentAverageTimes[this.placeInAverage]) - Double.parseDouble(this.currentAverageTimes[this.placeInAverage - 1]));
            }
        } else {
            string2 = "N/A";
            object = "N/A";
        }
        String string8 = this.timeFormat.format(this.sessionTotalTime / (double)this.cubesSolved);
        if (Double.parseDouble(string8) > 60.0 && showMinutes) {
            int n8 = (int)(Double.parseDouble(string8) / 60.0);
            string8 = n8 + ":" + this.timeFormat.format(Double.parseDouble(string8) - (double)(n8 * 60));
        } else {
            string8 = string8 + " seconds";
        }
        try {
            if (Double.parseDouble((String)object) > 0.0) {
                string = "#FF0000";
                object = (String)object + " seconds";
            } else if (Double.parseDouble((String)object) < 0.0) {
                string = "#0000FF";
                object = (String)object + " seconds";
            } else {
                string = "#000000";
                object = "00.00 seconds";
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = "#000000";
        }
        this.sessionStatsLabel.setText("<HTML>Recent Time: " + this.timeLabels[this.placeInAverage].getText() + "<br>Previous Time: " + string2 + "<br>Progress: <font color=\"" + string + "\">" + (String)object + "</font><br><br>Cubes Solved: " + this.cubesSolved + "<br>Session Average: " + string8 + "</HTML>");
        ++this.placeInAverage;
        ++this.sessionIndex;
        ++this.acceptsSincePop;
        if (this.placeInAverage == 12) {
            this.placeInAverage = 0;
        }
        this.timeLabels[this.placeInAverage].setForeground(currentColor);
        if (this.cubesSolved >= 12) {
            averageDetailedViewButton.setEnabled(true);
        }
        insertTimeButton.setEnabled(true);
        sessionDetailedViewButton.setEnabled(true);
        sessionResetButton.setEnabled(true);
        discardButton.setEnabled(false);
        popButton.setEnabled(false);
        addTimeButton.setEnabled(false);
        cubeCombo.setEnabled(true);
        countdownCombo.setEnabled(true);
        startButton.setText("Start Timer");
        this.timerLabel.setText("");
        this.timerLabel.setVisible(false);
        if (!this.hasImported) {
            scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
        } else {
            this.updateImportedAlgs();
        }
        startButton.requestFocus();
    }

    private String getSessionView() {
        String string;
        int n;
        String string2;
        String string3;
        int n2;
        String string4 = "";
        String string5 = "";
        double d = 0.0;
        double d2 = 0.0;
        if (this.cubesSolved >= 1) {
            d2 = this.sessionTotalTime / (double)this.cubesSolved;
        }
        if (d2 >= 60.0 && showMinutes) {
            n2 = (int)(d2 / 60.0);
            string3 = n2 + ":" + this.timeFormat.format(d2 - (double)(n2 * 60));
        } else {
            string3 = this.timeFormat.format(d2);
        }
        for (n2 = 0; n2 < this.sessionIndex; ++n2) {
            string2 = "";
            if (!this.sessionTimes[n2].equals("POP") && Double.parseDouble(this.sessionTimes[n2]) >= 60.0 && showMinutes) {
                n = (int)(Double.parseDouble(this.sessionTimes[n2]) / 60.0);
                string2 = n + ":" + this.timeFormat.format(Double.parseDouble(this.sessionTimes[n2]) - (double)(n * 60));
            } else {
                string2 = this.sessionTimes[n2];
            }
            string4 = string4 + (n2 + 1) + ")          " + string2 + "          " + this.sessionScrambles[n2] + "\r\n";
            string5 = string5 + string2 + "\r\n";
            if (this.cubesSolved < 2 || this.sessionTimes[n2].equals("POP")) continue;
            d += (d2 - Double.parseDouble(this.sessionTimes[n2])) * (d2 - Double.parseDouble(this.sessionTimes[n2]));
        }
        if (this.cubesSolved >= 2) {
            d = Math.sqrt(d / (double)(this.cubesSolved - 1));
        }
        if (this.sessionFastest >= 60.0 && showMinutes) {
            n = (int)(this.sessionFastest / 60.0);
            string = n + ":" + this.timeFormat.format(this.sessionFastest - (double)(n * 60));
        } else {
            string = this.timeFormat.format(this.sessionFastest);
        }
        if (this.sessionSlowest >= 60.0 && showMinutes) {
            n = (int)(this.sessionSlowest / 60.0);
            string2 = n + ":" + this.timeFormat.format(this.sessionSlowest - (double)(n * 60));
        } else {
            string2 = this.timeFormat.format(this.sessionSlowest);
        }
        String string6 = sessionViewFormat;
        string6 = this.findAndReplace(string6, "%T", new Date() + "");
        string6 = this.findAndReplace(string6, "%A", string3);
        string6 = this.findAndReplace(string6, "%I", string4);
        string6 = this.findAndReplace(string6, "%O", string5);
        string6 = this.findAndReplace(string6, "%F", string);
        string6 = this.findAndReplace(string6, "%S", string2);
        string6 = this.findAndReplace(string6, "%D", this.timeFormat.format(d));
        string6 = this.findAndReplace(string6, "%C", this.cubesSolved + "");
        string6 = this.findAndReplace(string6, "%P", this.numberOfPops + "");
        return string6;
    }

    private String getAverageView() {
        String string;
        String string2;
        int n;
        String string3;
        String string4 = "";
        String string5 = "";
        for (int i = 0; i < 12; ++i) {
            string4 = string4 + (i + 1) + ")          " + this.bestAverageTimes[i] + "          " + this.bestAverageScrambles[i] + "\r\n";
            string5 = string5 + this.bestAverageTimes[i] + "\r\n";
        }
        if (this.bestAverage >= 60.0 && showMinutes) {
            int n2 = (int)(this.bestAverage / 60.0);
            string3 = n2 + ":" + this.timeFormat.format(this.bestAverage - (double)(n2 * 60));
        } else {
            string3 = this.timeFormat.format(this.bestAverage);
        }
        if (this.bestFastest >= 60.0 && showMinutes) {
            n = (int)(this.bestFastest / 60.0);
            string2 = n + ":" + this.timeFormat.format(this.bestFastest - (double)(n * 60));
        } else {
            string2 = this.timeFormat.format(this.bestFastest);
        }
        if (this.bestSlowest >= 60.0 && showMinutes) {
            n = (int)(this.bestSlowest / 60.0);
            string = n + ":" + this.timeFormat.format(this.bestSlowest - (double)(n * 60));
        } else {
            string = this.timeFormat.format(this.bestSlowest);
        }
        String string6 = averageViewFormat;
        string6 = this.findAndReplace(string6, "%T", new Date() + "");
        string6 = this.findAndReplace(string6, "%A", string3);
        string6 = this.findAndReplace(string6, "%I", string4);
        string6 = this.findAndReplace(string6, "%O", string5);
        string6 = this.findAndReplace(string6, "%D", this.timeFormat.format(this.bestStandardDeviation));
        string6 = this.findAndReplace(string6, "%F", string2);
        string6 = this.findAndReplace(string6, "%S", string);
        return string6;
    }

    private String findAndReplace(String string, String string2, String string3) {
        int n;
        while ((n = string.indexOf(string2)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length(), string.length());
        }
        return string;
    }

    private void saveToFile(String string, File file) {
        File file2 = new File(file + ".txt");
        try {
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "There was an error saving. You may not have write permissions.");
        }
    }

    private void updateImportedAlgs() {
        if (this.importedIndex < this.importedAlgs.length) {
            scrambleLabel.setText(this.importedAlgs[this.importedIndex]);
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
            ++this.importedIndex;
        } else {
            JOptionPane.showMessageDialog(this, "All imported algs have been used. Random scrambles will now be displayed.");
            this.hasImported = false;
            scrambleLabel.setText(this.algGenerator.generateAlg(cubeCombo.getSelectedItem() + ""));
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
        }
    }

    public static void loadOptions() {
        String string = "";
        try {
            String string2;
            FileReader fileReader = new FileReader("jnc.conf");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + "\n";
            }
            bufferedReader.close();
            string = string.substring(0, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
            cubeCombo.setSelectedItem(stringTokenizer.nextToken());
            countdownCombo.setSelectedItem(stringTokenizer.nextToken());
            showResetConfirm = stringTokenizer.nextToken().equalsIgnoreCase("true");
            showMinutes = stringTokenizer.nextToken().equalsIgnoreCase("true");
            countdownColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            timerColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            currentColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            fastestColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            slowestColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            fColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            bColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            lColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            rColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            dColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            uColor = new Color(Integer.parseInt(stringTokenizer.nextToken()));
            averageViewFormat = stringTokenizer.nextToken();
            sessionViewFormat = stringTokenizer.nextToken();
            viewScramble.setColors(fColor, bColor, lColor, rColor, dColor, uColor);
            viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
        }
        catch (IOException iOException) {
            Standalone.resetOptions();
            return;
        }
    }

    private static void resetOptions() {
        cubeCombo.setSelectedItem("3x3x3");
        countdownCombo.setSelectedItem("15");
        showResetConfirm = true;
        showMinutes = true;
        countdownColor = Color.red;
        timerColor = Color.blue;
        currentColor = new Color(0, 110, 0);
        fastestColor = Color.blue;
        slowestColor = Color.red;
        fColor = Color.white;
        bColor = Color.yellow;
        lColor = Color.red;
        rColor = Color.orange;
        dColor = Color.blue;
        uColor = Color.green;
        averageViewFormat = "----- JNetCube Best Average for %T -----\r\n\r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\nStandard Deviation: %D\r\n\r\nIndividual Times:\r\n%I";
        sessionViewFormat = "----- JNetCube Session Statistics for %T -----\r\n\r\nCubes Solved: %C \r\nTotal Pops: %P \r\nAverage: %A\r\n\r\nFastest Time: %F\r\nSlowest Time: %S\r\nStandard Deviation: %D \r\n\r\nIndividual Times:\r\n%I";
        viewScramble.setColors(fColor, bColor, lColor, rColor, dColor, uColor);
        viewScramble.newScramble(cubeCombo.getSelectedItem() + "", scrambleLabel.getText());
    }
}

