
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <vector>
#include "checks.h"

using namespace std;

// Check if a vector of length n is a permutation 
// of 1,..,n
bool uniquePermutation( vector<int> test)
{
   for(int i = 0; i < test.size(); i++)
      if( test[i] <= 0 || test[i] > test.size() )
         return false; // Number to large or small
         

   vector<bool> temp;
   for(int i = 0; i < test.size(); i++)
      temp.push_back(false);
   for(int i = 0; i < test.size(); i++)
      temp[ test[i] - 1] = true;
   for(int i = 0; i < temp.size(); i++)
      if( !temp[i] )
         return false; // Numbers not unique

   return true;
}

bool uniquePermutation(int test[], int size)
{
   for(int i = 0; i < size; i++)
      if( test[i] <= 0 || test[i] > size )
         return false; // Number to large or small
         

   vector<bool> temp;
   for(int i = 0; i < size; i++)
      temp.push_back(false);
   for(int i = 0; i < size; i++)
      temp[ test[i] - 1] = true;
   for(int i = 0; i < size; i++)
      if( !temp[i] )
         return false; // Numbers not unique

   return true;
}
