//
// data.h
// Defines the datastructure for storing all the moves of a puzzle.
//

#include <map>
#include <set>
#include <vector>
#include <string>
using namespace std;

#ifndef DATA_H
#define DATA_H

// The three different types of puzzle pieces. Not used at the moment.
const int TYPE_PERMUTE = 1;   // Data to permute
const int TYPE_ORIENT = 2; // Data to orient
const int TYPE_PURE = 3;   // Data to orient witch does not permute

// Max size table for one set of pieces. Size in number of elements, not actual bytes.
const int MAX_COMPLETE_PERMUTATION_TABLE_SIZE = 10000000; // >10! (perm of 10 pieces)
const int MAX_COMPLETE_ORIENTATION_TABLE_SIZE = 10000000; // Complete tables contain one int (4 byte) per entry.
const int MAX_PARTIAL_PERMUTATION_TABLE_SIZE = 1000000; // Max number of entries in a partial table.
const int MAX_PARTIAL_ORIENTATION_TABLE_SIZE = 1000000; // SIZE is number of entries.

//const int MAX_HUGE_COMPLETE_PERMUTATION_TABLE_SIZE = 40000000; // 10! (perm of 10 pieces)
//const int MAX_HUGE_PARTIAL_PERMUTATION_TABLE_SIZE = 10000000; // Partial tables contain two int (8 byte) per entry.

// The types of pruning tables. 
const int TABLE_TYPE_NONE = 0;
const int TABLE_TYPE_COMPLETE = 1;
const int TABLE_TYPE_PARTIAL = 2;

// A submove contains the effect of a given move on one data group 
// Eg how corners are changed after a R-turn
//struct submove 
struct submove
{
//   public:
//   vector<int> orient;
//   vector<int> permute;
   int *orient;
   int *permute;
   int size;
};

// Some general data for a set of pieces
struct dataset{
   int type;
   int size;
   int omod; // Orientations are calculated mod this value         
   int ptabletype;
   int otabletype;
   bool uniqueperm; // Perm of unique numbers (1,2,3,...), or repeated (1,3,1,2)
};

// Stores a forbidden move-pair
struct movepair{
   string a;
   string b;
};

struct substate {
//   vector<int> orientation;
//   vector<int> permutation;
   int *orientation;
   int *permutation;
   int size;
};

struct subprune{
   vector<char> orientation;
   vector<char> permutation;
   map<vector<long long>, char> partialorientation;
   map<vector<long long>, char> partialpermutation;
   int partialpermutation_depth;
   int partialorientation_depth;
};

#endif
