
// Functions for translating permutations and orientations to index
// and inverses


using namespace std;

#ifndef INDEXING_H
#define INDEXING_H

int oVector2Index(vector<int> orientations, int omod);
int pVector2Index(vector<int> permutation);
vector<int> oIndex2Vector(int index, int size, int omod);
vector<int> pIndex2Vector(int index, int size);

// The 3-versions is for permutations with several identical pieces
long long pVector3Index(vector<int> permutation);
vector<int> pIndex3Vector(long long index, vector<int> solved);

long long combinations(vector<int> vec);
long long factorial(long long x);

vector<long long> packVector(vector<int> vec);
long long packSubVector(vector <int> vec);
vector<int> unpackVector(vector<long long> vec);
vector<int> unpackSubVector(long long number);


// New versions trying to avoid some stl
int oVector2Index(int orientations[], int size, int omod);
int pVector2Index(int permutation[], int size);
vector<long long> packVector(int vec[], int size);
long long pVector3Index(int permutation[], int size);
long long combinations(int vec[], int size);

#endif
