
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <map>
#include <vector>
#include <iostream>
#include "move.h"
#include "data.h"

using namespace std;

/*struct sub_deb{
   vector<int> orientation;
   vector<int> permutation;
};

map<string, substate> applyMove(map<string, substate> state2, map<string, submove>& move, map<string, dataset>& datasets){

   map<string, sub_deb> state;
   map<string, submove>::iterator iter;   
   for(iter = move.begin(); iter != move.end(); iter++){
      for(int j = 0; j < state2[(*iter).first].size; j++){
         state[(*iter).first].permutation.push_back( state2[(*iter).first].permutation[j] );
         state[(*iter).first].orientation.push_back( state2[(*iter).first].orientation[j] );
      }
      int size = iter->second.orient.size();


      // Copy the vectors to be uppdated to avoid to many slow template-calls 
      vector<int> tmp_o1, tmp_o2, tmp_p1, tmp_p2, tmp_extra; // test
      int tmpi; // test
      tmp_o1 = state[(*iter).first].orientation;
//      tmp_o2 = move[(*iter).first].orient;
      tmp_p1 = state[(*iter).first].permutation;
//      tmp_p2 = move[(*iter).first].permute;
      tmp_o2 = iter->second.orient;
      tmp_p2 = iter->second.permute;
      tmpi = datasets[(*iter).first].omod;

      for(int i = 0; i < size; i++){
         tmp_o1[i] = ( tmp_o1[i] + tmp_o2[i] ) % tmpi;
      }

      tmp_extra.resize(size);  
      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_p1[ tmp_p2[i] - 1 ];        
      }
      state[(*iter).first].permutation = tmp_extra; 

      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_o1[ tmp_p2[i] - 1 ];        
      }
      state[(*iter).first].orientation = tmp_extra;

      for(int j = 0; j < state2[(*iter).first].size; j++){
         state2[(*iter).first].permutation[j] = state[(*iter).first].permutation[j];
         state2[(*iter).first].orientation[j] = state[(*iter).first].orientation[j];
      }
   }
   
   
   return state2;
}*/

void applyMove(map<string, substate>& state, map<string, substate>& new_state, map<string, submove>& move, map<string, dataset>& datasets){
   map<string, submove>::iterator iter;   
   for(iter = move.begin(); iter != move.end(); iter++){
      int size = iter->second.size;


      // Copy the vectors to be uppdated to avoid to many slow template-calls 
      int *tmp_o1, *tmp_p1, *tmp_o2, *tmp_p2, *tmp_extra;
      int tmpi; // test
      tmp_o1 = new int[size];
      tmp_p1 = new int[size];
      tmp_o2 = new int[size];
      tmp_p2 = new int[size];
      memcpy( tmp_o1, state[(*iter).first].orientation, size*sizeof(int) );
      memcpy( tmp_p1, state[(*iter).first].permutation, size*sizeof(int) );
      memcpy( tmp_o2, iter->second.orient, size*sizeof(int) );
      memcpy( tmp_p2, iter->second.permute, size*sizeof(int) );
//      tmp_o2 = move[(*iter).first].orient;
//      tmp_p2 = move[(*iter).first].permute;
//      tmp_o2 = iter->second.orient;
//      tmp_p2 = iter->second.permute;
      tmpi = datasets[(*iter).first].omod;

      for(int i = 0; i < size; i++){
         tmp_o1[i] = ( tmp_o1[i] + tmp_o2[i] ) % tmpi;
      }

      tmp_extra = new int[size];
      if(tmp_extra == NULL){
         cerr << "Can't allocate memore in applyMove()" << endl;
         exit(-1);
      }
      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_p1[ tmp_p2[i] - 1 ];        
      }
//      state[(*iter).first].permutation = tmp_extra; 
      memcpy( new_state[(*iter).first].permutation, tmp_extra, size*sizeof(int) );
//      state[(*iter).first].permutation = tmp_p1;

      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_o1[ tmp_p2[i] - 1 ];        
      }
//      state[(*iter).first].orientation = tmp_extra;
      memcpy( new_state[(*iter).first].orientation, tmp_extra, size*sizeof(int) );
//      state[(*iter).first].orientation = tmp_o1;
      delete tmp_o1;
      delete tmp_p1;
      delete tmp_o2;
      delete tmp_p2;
      delete tmp_extra;
   }
//   return state;
}

/*map<string, substate> applyMove(map<string, substate> state, map<string, submove>& move, map<string, dataset>& datasets){
   map<string, submove>::iterator iter;   
   for(iter = move.begin(); iter != move.end(); iter++){
      int size = iter->second.orient.size();


      // Copy the vectors to be uppdated to avoid to many slow template-calls 
      vector<int> tmp_o2, tmp_p2; // test
      int *tmp_o1, *tmp_p1, *tmp_extra;
      int tmpi; // test
      tmp_o1 = new int[size];
      tmp_p1 = new int[size];
      memcpy( tmp_o1, state[(*iter).first].orientation, size*sizeof(int) );
      memcpy( tmp_p1, state[(*iter).first].permutation, size*sizeof(int) );
//      tmp_o2 = move[(*iter).first].orient;
//      tmp_p2 = move[(*iter).first].permute;
      tmp_o2 = iter->second.orient;
      tmp_p2 = iter->second.permute;
      tmpi = datasets[(*iter).first].omod;

      for(int i = 0; i < size; i++){
         tmp_o1[i] = ( tmp_o1[i] + tmp_o2[i] ) % tmpi;
      }

      tmp_extra = new int[size];
      if(tmp_extra == NULL){
         cerr << "Can't allocate memore in applyMove()" << endl;
         exit(-1);
      }
      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_p1[ tmp_p2[i] - 1 ];        
      }
//      state[(*iter).first].permutation = tmp_extra; 
      memcpy( tmp_p1, tmp_extra, size*sizeof(int) );
      state[(*iter).first].permutation = tmp_p1;

      for(int i = 0; i < size; i++){
         tmp_extra[i] = tmp_o1[ tmp_p2[i] - 1 ];        
      }
//      state[(*iter).first].orientation = tmp_extra;
      memcpy( tmp_o1, tmp_extra, size*sizeof(int) );
      state[(*iter).first].orientation = tmp_o1;
      delete tmp_extra;
   }
   return state;
}*/

vector<int> applySubmoveO(vector<int> orientation, int change_o[], int change_p[], int size, int omod){
   if( size != orientation.size() ){
      cerr << "Vectors not matching in size in call to applySubmoveO(...)" << endl;
      exit(-1);
   }
   for(int i = 0; i < size; i++)
      orientation[i] = (orientation[i] + change_o[i]) % omod;
   vector<int> temp;
   temp.resize( size );
   for(int i = 0; i < size; i++)
      temp[i] = orientation[ change_p[i] - 1 ];        
   return temp;  
}

vector<int> applySubmoveP(vector<int> permutation, int change_p[], int size)
{
   if( size != permutation.size() ){
      cerr << "Vectors not matching in size in call to applySubmoveP(...)" << endl;
      cerr << "size = " << size << ", permutation.size() = " << permutation.size() << endl;
      exit(-1);
   }
   vector<int> temp;
   temp.resize( size );
   for(int i = 0; i < size; i++)
      temp[i] = permutation[ change_p[i] - 1 ];        
   return temp;  
}

int* applySubmoveP(int permutation[], int change_p[], int size)
{
   int* temp = new int[size];
   for(int i = 0; i < size; i++)
      temp[i] = permutation[ change_p[i] - 1 ];        
   return temp;  
}

map<string, submove> mergeMoves(map<string, submove> move1, map<string, submove> move2, map<string, dataset>& datasets){
   map<string, submove> ans;
   map<string, submove>::iterator iter;   
   for(iter = move1.begin(); iter != move1.end(); iter++){
      submove temp;
      temp.permute = applySubmoveP( move1[ (*iter).first ].permute, move2[ (*iter).first ].permute, move2[ (*iter).first ].size);

      int* pinv = new int[move1[ (*iter).first ].size];
      for(int i = 0; i < move1[ (*iter).first].size; i++){
         for(int j = 0; j < move1[ (*iter).first].size; j++){
            if( move1[ (*iter).first].permute[j] == i + 1 )
               pinv[i] = j + 1;
         }
      }
      
      temp.orient = applySubmoveP( move2[ (*iter).first ].orient, pinv, move2[ (*iter).first ].size);
      for(int i = 0; i < move1[ (*iter).first].size; i++)
         temp.orient[i] = (temp.orient[i] + move1[ (*iter).first].orient[i]) % datasets[(*iter).first].omod;
      ans[ (*iter).first ].permute = temp.permute;
      ans[ (*iter).first ].orient = temp.orient;
      ans[ (*iter).first ].size = move2[ (*iter).first ].size;
   }
   return ans;
}
