
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

// Code for reading the puzzle state to be solved

#include "scramble.h"
#include <iostream>
#include <fstream>
using namespace std;

scramble::scramble(string filename, map<string, dataset> datasets){
   sent = 0;
   int current_max = 999;
   map<string, substate> state;
   ifstream fin(filename.c_str());
   if(!fin.good()){
      cout << "Cant open scramble file!" << endl;
      exit(-1);
   }
   
   while( !fin.eof() ){
      string command;
      fin >> command;
      

      if(command == "Scramble"){
         string name;
         getline(fin, name);
         names.push_back(name);
         
         string setname;
         fin >> setname;
         state.clear();
         while(setname != "End"){
            if( fin.fail() ){
               cerr << "Error reading scramble sets." << endl;
               exit(-1);
            }
            map<string, substate>::iterator iter = state.find(setname);
            if( iter != state.end() ){
               cerr << "Set " << setname << " declared more than once in scrambled position. " << endl;
               exit(-1);
            }
            map<string, dataset>::iterator iter2 = datasets.find(setname);
            if( iter2 == datasets.end() ){
               cerr << "Set " << setname << " in scramble not found in def-file." << endl;
               exit(-1);
            }
//            substate tmps;
            state[setname].permutation = new int[datasets[setname].size];
            state[setname].orientation = new int[datasets[setname].size];
            state[setname].size = datasets[setname].size;
            if( state[setname].permutation == NULL || state[setname].permutation == NULL){
               cerr << "Can't allocate memory in scramble::scramble(...)" << endl;
               exit(-1);
            }

            for(int i = 0; i < datasets[setname].size; i++){
               int tmp;
               fin >> tmp;
               if( fin.fail() ){
                  cerr << "Error reading " << setname << " permutation for the scramble." << endl;
                  exit(-1);
               }
               state[setname].permutation[i] = tmp;    
            }
            for(int i = 0; i < datasets[setname].size; i++){
               int tmp;
               fin >> tmp;
               if( fin.fail() ){
                  cerr << "Error reading " << setname << " orientation for the scramble." << endl;
                  exit(-1);
               }
               tmp = tmp % datasets[setname].omod;
               if(tmp < 0)
                  tmp += datasets[setname].omod;

               state[setname].orientation[i] = tmp;
            }
//            state[setname] = tmps;
            fin >> setname;
         }
         states.push_back( state );
         max_depths.push_back( current_max );
      }
      else if(command == "MaxDepth"){
         fin >> current_max;
         if( fin.fail() ){
            cerr << "Error reading MaxDepth" << endl;
            exit(-1);
         }
      }
      else if(command == ""){}  // To avoid trouble with extra rows on the end.
      else {
         cerr << "Unknown command \"" << command << "\" in scramble file." << endl;  
         exit(-1);
      }
   }               
}

// Print the stored scramble. Usefull for debugging.
/*void scramble::print(void)
{
   cout << "Scramble name: "  << name << endl;
   map<string, substate>::iterator iter;   
   for(iter = state.begin(); iter != state.end(); iter++){
      cout << (*iter).first << endl;
      for( int i = 0; i < iter->second.permutation.size(); i++)
         cout << iter->second.permutation[i];         
      cout << endl;
      for( int i = 0; i < iter->second.orientation.size(); i++)
         cout << iter->second.orientation[i];         
      cout << endl;
   }
} */  

map<string, substate> scramble::getScramble(){
   if( states.size() > sent ){
      sent++;
      return states[sent-1];
   }
   map<string, substate> tmp;
   return tmp;
}

int scramble::getMaxDepth(){
   if( max_depths.size() >= sent && sent > 0)
      return max_depths[sent-1];
   return 999;
}

string scramble::getName(){
   return names[sent-1];       
}
