
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "search.h"
#include "blocks.h"
#include "move.h"
#include "indexing.h"
#include "pruning.h"
#include <iostream>

//#define PROFILE_K
#ifdef PROFILE_K
#include <windows.h>
double Global_test, Global_prune, Global_self_a, Global_self_b, Global_self_c, Global_self_d;
long calls;
#endif

using namespace std;

bool TreeSolve(map<string, substate> state, map<string, substate>& solved, map<string, map<string, submove> >& moves, map<string, dataset>& datasets, map<string, subprune>& prunetables, set< pair<string, string> >& forbiddenPairs, map<string, substate>& ignore, set<map<string, set<int> > >& blocks, int depth, string sequence, string old_move){
#ifdef PROFILE_K
calls++;
//cout << "TreeSolve() start" << endl;
   LARGE_INTEGER lFreq, lStart, lEnd;
   QueryPerformanceFrequency(&lFreq);
   QueryPerformanceCounter(&lStart);
#endif
   if( depth == 0 ){
      if( isSolved(state, solved, ignore) ){
         cout << endl << sequence;
         #ifdef PROFILE_K
            QueryPerformanceCounter(&lEnd);
            Global_test += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
         #endif
         return true;
      }
      else{
         #ifdef PROFILE_K
            QueryPerformanceCounter(&lEnd);
            Global_test += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
         #endif
         return false;    
      }
   }

    #ifdef PROFILE_K
       QueryPerformanceCounter(&lEnd);
       Global_test += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
       QueryPerformanceCounter(&lStart);
    #endif

   if( prune(state, depth, datasets, prunetables) )
      return false;
   
    #ifdef PROFILE_K
       QueryPerformanceCounter(&lEnd);
       Global_prune += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
       QueryPerformanceCounter(&lStart);
    #endif
 
   // Apply new legal moves
   map<string, substate>::iterator iter2;
   bool success = false;
   map<string, substate> new_state;
   for(iter2 = state.begin(); iter2 != state.end(); iter2++){
      new_state[(*iter2).first].permutation = new int[ iter2->second.size ];
      new_state[(*iter2).first].orientation = new int[ iter2->second.size ];
      new_state[(*iter2).first].size = iter2->second.size;
   }
   
   bool using_blocks;
   if( blocks.size() == 0)
      using_blocks = false;
   else
      using_blocks = true;

   map<string, map<string, submove> >::iterator iter;
   for(iter = moves.begin(); iter != moves.end(); iter++){
      // Test for forbidden pair
//      bool forbidden = false;
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         Global_self_a += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
         QueryPerformanceCounter(&lStart);
      #endif
      if( forbiddenPairs.find( pair<string, string>(old_move, (*iter).first) ) != forbiddenPairs.end() ){
         continue; // forbidden = true;
      }
      if( using_blocks )
         if( !blocklegal(state, blocks, iter->second) ) // New test for blocks
            continue; //forbidden = true;
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         Global_self_b += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
         QueryPerformanceCounter(&lStart);
      #endif
      applyMove(state, new_state, iter->second, datasets );
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         //cout << "Anropar sig sjlv: " << double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart << endl;
         Global_self_c += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
      #endif
      if(TreeSolve( new_state, solved, moves, datasets, prunetables, forbiddenPairs, ignore, blocks, depth-1, sequence + " " + (*iter).first, (*iter).first))
         success = true;
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lStart);
      #endif
   }
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lStart);
      #endif

   for(iter2 = state.begin(); iter2 != state.end(); iter2++){
      delete new_state[(*iter2).first].permutation;
      delete new_state[(*iter2).first].orientation;
   }
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         Global_self_d += double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart;
      #endif

#ifdef PROFILE_K
   if( calls > 2050000 ){
       cout << "Global test:  " << Global_test << endl;
       cout << "Global prune: " << Global_prune << endl;
       cout << "Global self a:  " << Global_self_a << endl;
       cout << "Test forbidden:  " << Global_self_b << endl;
       cout << "Apply moves:  " << Global_self_c << endl;
       cout << "Delete allocated memory:  " << Global_self_d << endl;
       cout << "Calls: " << calls << endl;
   }
#endif

   return success;   
}

bool isSolved(map<string, substate> state1, map<string, substate>& state2, map<string, substate>& ignore){
   map<string, substate>::iterator iter, iter2;
   if(ignore.size() == 0){
       for(iter = state1.begin(); iter != state1.end(); iter++){
/*          for(int i = 0; i < iter->second.size; i++)
             if( iter->second.permutation[i] != state2[(*iter).first].permutation[i] )
                return false;
          for(int i = 0; i < iter->second.size; i++)
             if( iter->second.orientation[i] != state2[(*iter).first].orientation[i] )
                return false;*/
          if( memcmp( iter->second.permutation, state2[(*iter).first].permutation, iter->second.size*sizeof(int)) != 0 )
             return false;
          if( memcmp( iter->second.orientation, state2[(*iter).first].orientation, iter->second.size*sizeof(int)) != 0 )
             return false;
//         if( iter->second.permutation != state2[(*iter).first].permutation || 
//             iter->second.orientation != state2[(*iter).first].orientation)
//                return false;
       }
   }
   else{
       for(iter = state1.begin(); iter != state1.end(); iter++){
    /*      if( state1[(*iter).first].permutation != state2[(*iter).first].permutation || 
              state1[(*iter).first].orientation != state2[(*iter).first].orientation)
                 return false; */
          iter2 = ignore.find((*iter).first);
          if( iter2 != ignore.end() ){
             for(int i = 0; i < state1[(*iter).first].size; i++){
                if( ignore[(*iter).first].permutation[i] == 0 && state1[(*iter).first].permutation[i] != state2[(*iter).first].permutation[i])
                   return false;
                if( ignore[(*iter).first].orientation[i] == 0 && state1[(*iter).first].orientation[i] != state2[(*iter).first].orientation[i])
                   return false;
             }
          }
          else{
             if( memcmp( iter->second.permutation, state2[(*iter).first].permutation, iter->second.size*sizeof(int)) != 0 )
                return false;
             if( memcmp( iter->second.orientation, state2[(*iter).first].orientation, iter->second.size*sizeof(int)) != 0 )
                return false;
//             if( state1[(*iter).first].permutation != state2[(*iter).first].permutation || 
//                 state1[(*iter).first].orientation != state2[(*iter).first].orientation)
//                    return false;
          }
       }
   }
   return true;
}
