#include  <stdio.h>
#include  <string.h>
#include  "main.h"
#include  "rotate_center.h"
#include  "rotate_corner_orient.h"
#include  "rotate_corner_perm.h"
#include  "rotate_edge.h"
#include  "input.h"
#include  "pack.h"

#define TO_ROTATE(x) ROTATE_ ## x

char opposite_color(char c)
{
	switch(c)
	{
		case 'G':
			return 'B';
		case 'B':
			return 'G';
		case 'Y':
			return 'W';
		case 'W':
			return 'Y';
		case 'R':
			return 'O';
		default: // case 'O', to avoid warnings
			return 'R';
	}
}

state input(int allowed_moves[])
{
	char front[4][4];
	char back[4][4];
	char right[4][4];
	char left[4][4];
	char up[4][4];
	char down[4][4];
	state s;

	int ok = 1, i, j;
	char orient_zero, orient_one, orient_two;
	char c, d = '#';
	int macro = 0;

	char color_order[6];
	char corner_orient_order[2][7];
	char corner_perm_order[7][3];
	char edge_order[24][2];

	int centers[CENTER_NUMBER];
	int corners_orient[CORNER_ORIENT_NUMBER];
	int corners_perm[CORNER_PERM_NUMBER];
	int edges[EDGE_PACK_NUMBER][EDGE_NUMBER];
	
	char res[3];


	while (ok)

	{
		macro = 0;

		printf("Enter a cube\n");
		printf("Give the colors on every face (G, B, Y, W, O, R) in this order,\nassuming that you have a standard BOY(Blue, Orange, Yellow) color scheme :\n\n");
	
		printf("            U                        D\n  ________________             ________________\n  |\\_1   2   3   4 \\_          |\\_49  50  51  52\\_\n  |33\\_5   6   7   8 \\_        |81\\_53  54  55  56\\_\n  |  34\\_9   10  11  12\\_      |  82\\_57  58  59  60\\_\n  |37  35\\_13  14  15  16\\_    |85  83\\_61  62  63  64\\_\n  |  38  36\\---------------\\   |  86  84\\---------------\\\n  |41  39  |17  18  19  20 |   |89  87  |65  66  67  68 |\nL |  42  40|               |  B|  90  88|               |\n  |45  43  |21  22  23  24 |   |93  91  |69  70  71  72 |\n   \\_46  44|               |F   \\_94  92|               | R\n     \\_47  |25  26  27  28 |      \\_95  |73  74  75  76 |\n       \\_48|               |        \\_96|               |\n         \\_|29  30  31  32 |          \\_|77  78  79  80 |\n           \\---------------|            \\---------------|\n");

		printf("(Nice ascii art, isn't it ?)\n");
		printf("Here we go ! : ");
	
		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					up[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						up[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						up[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;

					}
					else
						printf("unknown caracter");
				}
			}

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					front[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						front[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						front[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;
					}
					else
						printf("unknown caracter");
				}
			}

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					left[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						left[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						left[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;
					}
					else
						printf("unknown caracter");
				}
			}

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					down[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						down[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						down[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;
					}
					else
						printf("unknown caracter");
				}
			}

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					right[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						right[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						right[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;
					}
					else
						printf("unknown caracter");
				}
			}

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
			{
				if (macro)
				{
					back[i][j] = d;
					macro--;
				}
				else
				{
					scanf("%c",&c);
					if (c > 'A' && c < 'Z')
					{
						back[i][j] = c;
						d = c;
					}
					else if (c == '(')
					{
						back[i][j] = d;
						scanf("%c",&c);
						macro = (int)(c - '0');
						scanf("%c",&c);
						if (c != ')')
						{
							macro *= 10;
							macro += (int)(c - '0') - 2;
							scanf("%c",&c);
						}
						else
							macro -= 2;
					}
					else
						printf("unknown caracter");
				}
			}


		printf("Ok, so you have entered this :\n\n");

		printf("     U\n   _____\n  |\\%c%c%c%c\\\n  |%c\\%c%c%c%c\\\nL |%c%c\\%c%c%c%c\\\n  |%c%c%c\\%c%c%c%c\\\n  |%c%c%c%c\\----\\\n   \\%c%c%c|%c%c%c%c|\n    \\%c%c|%c%c%c%c|\n     \\%c|%c%c%c%c| F\n      \\|%c%c%c%c|\n       \\----|\n\n",up[0][0], up[0][1], up[0][2], up[0][3], left[0][0], up[1][0], up[1][1], up[1][2], up[1][3], left[1][0], left[0][1], up[2][0], up[2][1], up[2][2], up[2][3], left[2][0], left[1][1], left[0][2], up[3][0], up[3][1], up[3][2], up[3][3], left[3][0], left[2][1], left[1][2], left[0][3], left[3][1], left[2][2], left[1][3], front[0][0], front[0][1], front[0][2], front[0][3], left[3][2], left[2][3], front[1][0], front[1][1], front[1][2], front[1][3], left[3][3], front[2][0], front[2][1], front[2][2], front[2][3], front[3][0], front[3][1], front[3][2], front[3][3]);

		printf("     D\n   _____\n  |\\%c%c%c%c\\\n  |%c\\%c%c%c%c\\\nB |%c%c\\%c%c%c%c\\\n  |%c%c%c\\%c%c%c%c\\\n  |%c%c%c%c\\----\\\n   \\%c%c%c|%c%c%c%c|\n    \\%c%c|%c%c%c%c|\n     \\%c|%c%c%c%c| R\n      \\|%c%c%c%c|\n       \\----|\n\n",down[0][0], down[0][1], down[0][2], down[0][3], back[0][0], down[1][0], down[1][1], down[1][2], down[1][3], back[1][0], back[0][1], down[2][0], down[2][1], down[2][2], down[2][3], back[2][0], back[1][1], back[0][2], down[3][0], down[3][1], down[3][2], down[3][3], back[3][0], back[2][1], back[1][2], back[0][3], back[3][1], back[2][2], back[1][3], right[0][0], right[0][1], right[0][2], right[0][3], back[3][2], back[2][3], right[1][0], right[1][1], right[1][2], right[1][3], back[3][3], right[2][0], right[2][1], right[2][2], right[2][3], right[3][0], right[3][1], right[3][2], right[3][3]);

		scanf("%c", &c);
		printf("Is it what you want ? (Y/n)");
		scanf("%c", &c);
		if (c == 'n' || c == 'N')
			ok = 1;
		else
			ok = 0;
	}
	scanf("%c", &c);

	for (i=0; i < ROTATE_NUMBER;i++)
		allowed_moves[i] = 1;

	printf("Forbidden moves ? (R,R',R2,r,r',r2,...)\n");
	printf("Put a space between each forbid move, then the word 'end'\n");
	scanf("%s",res);
	while (res[0] != 'e' || res[1] != 'n' || res[2] != 'd')
	{
		if (!strcmp(res,"F"))
			allowed_moves[ROTATE_F] = 0;
		if (!strcmp(res,"R"))
			allowed_moves[ROTATE_R] = 0;
		if (!strcmp(res,"U"))
			allowed_moves[ROTATE_U] = 0;
		if (!strcmp(res,"F2"))
			allowed_moves[ROTATE_F2] = 0;
		if (!strcmp(res,"R2"))
			allowed_moves[ROTATE_R2] = 0;
		if (!strcmp(res,"U2"))
			allowed_moves[ROTATE_U2] = 0;
		if (!strcmp(res,"F'"))
			allowed_moves[ROTATE_F3] = 0;
		if (!strcmp(res,"R'"))
			allowed_moves[ROTATE_R3] = 0;
		if (!strcmp(res,"U'"))
			allowed_moves[ROTATE_U3] = 0;
		if (!strcmp(res,"f"))
			allowed_moves[ROTATE_f] = 0;
		if (!strcmp(res,"b"))
			allowed_moves[ROTATE_b] = 0;
		if (!strcmp(res,"r"))
			allowed_moves[ROTATE_r] = 0;
		if (!strcmp(res,"l"))
			allowed_moves[ROTATE_l] = 0;
		if (!strcmp(res,"u"))
			allowed_moves[ROTATE_u] = 0;
		if (!strcmp(res,"d"))
			allowed_moves[ROTATE_d] = 0;
		if (!strcmp(res,"f2"))
			allowed_moves[ROTATE_f2] = 0;
		if (!strcmp(res,"b2"))
			allowed_moves[ROTATE_b2] = 0;
		if (!strcmp(res,"r2"))
			allowed_moves[ROTATE_r2] = 0;
		if (!strcmp(res,"l2"))
			allowed_moves[ROTATE_l2] = 0;
		if (!strcmp(res,"u2"))
			allowed_moves[ROTATE_u2] = 0;
		if (!strcmp(res,"d2"))
			allowed_moves[ROTATE_d2] = 0;
		if (!strcmp(res,"f'"))
			allowed_moves[ROTATE_f3] = 0;
		if (!strcmp(res,"b'"))
			allowed_moves[ROTATE_b3] = 0;
		if (!strcmp(res,"r'"))
			allowed_moves[ROTATE_r3] = 0;
		if (!strcmp(res,"l'"))
			allowed_moves[ROTATE_l3] = 0;
		if (!strcmp(res,"u'"))
			allowed_moves[ROTATE_u3] = 0;
		if (!strcmp(res,"d'"))
			allowed_moves[ROTATE_d3] = 0;
		if (!strcmp(res,"B"))
			allowed_moves[ROTATE_Ffb] = 0;
		if (!strcmp(res,"L"))
			allowed_moves[ROTATE_Rrl] = 0;
		if (!strcmp(res,"D"))
			allowed_moves[ROTATE_Uud] = 0;
		if (!strcmp(res,"B2"))
			allowed_moves[ROTATE_Ffb2] = 0;
		if (!strcmp(res,"L2"))
			allowed_moves[ROTATE_Rrl2] = 0;
		if (!strcmp(res,"D2"))
			allowed_moves[ROTATE_Uud2] = 0;
		if (!strcmp(res,"B'"))
			allowed_moves[ROTATE_Ffb3] = 0;
		if (!strcmp(res,"L'"))
			allowed_moves[ROTATE_Rrl3] = 0;
		if (!strcmp(res,"D'"))
			allowed_moves[ROTATE_Uud3] = 0;
		scanf("%s",res);
	}	

	#if DEBUG_LEVEL > 1
	for (i=0; i < ROTATE_NUMBER; i++)
		printf("%d - ",allowed_moves[i]);
	printf("\n");
	#endif

	/**
	 * Finds the color of the future faces
	 * determined by the colors of the BLD center
	 */

	color_order[CENTER_PACK_U] = opposite_color(down[0][0]);
	color_order[CENTER_PACK_D] = down[0][0];
	color_order[CENTER_PACK_F] = opposite_color(back[0][0]);
	color_order[CENTER_PACK_B] = back[0][0];
	color_order[CENTER_PACK_R] = opposite_color(left[3][0]);
	color_order[CENTER_PACK_L] = left[3][0];

	/**
	 * Fills the centers
	 */

	for (i = 0; i < CENTER_PACK_NUMBER; i++)
	{
		centers[CENTER_UBL] = (up[1][1] == color_order[i]);
		centers[CENTER_UBR] = (up[1][2] == color_order[i]);
		centers[CENTER_UFL] = (up[2][1] == color_order[i]);
		centers[CENTER_UFR] = (up[2][2] == color_order[i]);
		centers[CENTER_DBL] = (down[1][1] == color_order[i]);
		centers[CENTER_DFL] = (down[1][2] == color_order[i]);
		centers[CENTER_DBR] = (down[2][1] == color_order[i]);
		centers[CENTER_DFR] = (down[2][2] == color_order[i]);
		centers[CENTER_FUL] = (front[1][1] == color_order[i]);
		centers[CENTER_FUR] = (front[1][2] == color_order[i]);
		centers[CENTER_FDL] = (front[2][1] == color_order[i]);
		centers[CENTER_FDR] = (front[2][2] == color_order[i]);
		centers[CENTER_BDL] = (back[1][1] == color_order[i]);
		centers[CENTER_BDR] = (back[1][2] == color_order[i]);
		centers[CENTER_BUL] = (back[2][1] == color_order[i]);
		centers[CENTER_BUR] = (back[2][2] == color_order[i]);
		centers[CENTER_LUB] = (left[1][1] == color_order[i]);
		centers[CENTER_LUF] = (left[1][2] == color_order[i]);
		centers[CENTER_LDB] = (left[2][1] == color_order[i]);
		centers[CENTER_LDF] = (left[2][2] == color_order[i]);
		centers[CENTER_RDB] = (right[1][1] == color_order[i]);
		centers[CENTER_RDF] = (right[1][2] == color_order[i]);
		centers[CENTER_RUB] = (right[2][1] == color_order[i]);
		centers[CENTER_RUF] = (right[2][2] == color_order[i]);
		s.center[i] = pack_comb(centers, CENTER_NUMBER_IN_PACK, CENTER_NUMBER);
		#if DEBUG_LEVEL > 1
		printf("pack center %d : %d\n", i, pack_comb(centers, CENTER_NUMBER_IN_PACK, CENTER_NUMBER));
		#endif
	}

	/**
	 * Fills corner orient
	 */

	orient_zero = down[0][0];
	orient_one = left[3][0];
	orient_two = back[0][0];

	corner_orient_order[0][CORNER_UBL] = up[0][0];
	corner_orient_order[0][CORNER_UBR] = up[0][3];
	corner_orient_order[0][CORNER_UFL] = up[3][0];
	corner_orient_order[0][CORNER_UFR] = up[3][3];
	corner_orient_order[0][CORNER_DFL] = down[0][3];
	corner_orient_order[0][CORNER_DBR] = down[3][0];
	corner_orient_order[0][CORNER_DFR] = down[3][3];

	corner_orient_order[1][CORNER_UBL] = left[0][0];
	corner_orient_order[1][CORNER_UBR] = back[3][3];
	corner_orient_order[1][CORNER_UFL] = front[0][0];
	corner_orient_order[1][CORNER_UFR] = right[3][3];
	corner_orient_order[1][CORNER_DFL] = left[3][3];
	corner_orient_order[1][CORNER_DBR] = right[0][0];
	corner_orient_order[1][CORNER_DFR] = front[3][3];

	for (i = 0; i < CORNER_ORIENT_NUMBER; i++)
	{
		if (corner_orient_order[0][i] ==  orient_zero)
			corners_orient[i] = 0;
		else if (corner_orient_order[0][i] ==  opposite_color(orient_zero))
			corners_orient[i] = 0;
		else if (corner_orient_order[1][i] ==  orient_zero)
			corners_orient[i] = 1;
		else if (corner_orient_order[1][i] ==  opposite_color(orient_zero))
			corners_orient[i] = 1;
		else
			corners_orient[i] = 2;
	}

	s.corner_orient = pack_full(corners_orient, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
	#if DEBUG_LEVEL > 1
	printf("pack corner orient : %d\n", pack_full(corners_orient, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST));
	#endif

	/**
	 * Fills corner perm
	 */

	corner_perm_order[CORNER_UBL][0] = corner_perm_order[CORNER_UFL][0] = corner_perm_order[CORNER_UBR][0] = corner_perm_order[CORNER_UFR][0] = color_order[CENTER_PACK_U];
	corner_perm_order[CORNER_DBR][0] = corner_perm_order[CORNER_DFR][0] = corner_perm_order[CORNER_DFL][0] = color_order[CENTER_PACK_D];
	corner_perm_order[CORNER_UBL][1] = corner_perm_order[CORNER_UBR][1] = corner_perm_order[CORNER_DBR][1] = color_order[CENTER_PACK_B];
	corner_perm_order[CORNER_DFL][1] = corner_perm_order[CORNER_UFL][1] = corner_perm_order[CORNER_UFR][1] = corner_perm_order[CORNER_DFR][1] = color_order[CENTER_PACK_F];
	corner_perm_order[CORNER_UBL][2] = corner_perm_order[CORNER_UFL][2] = corner_perm_order[CORNER_DFL][2] = color_order[CENTER_PACK_L];
	corner_perm_order[CORNER_UBR][2] = corner_perm_order[CORNER_UFR][2] = corner_perm_order[CORNER_DFR][2] = corner_perm_order[CORNER_DBR][2] = color_order[CENTER_PACK_R];

	for (i = 0; i < CORNER_PERM_NUMBER; i++)
	{
		if ((up[0][0] == corner_perm_order[i][0] || up[0][0] == corner_perm_order[i][1] || up[0][0] == corner_perm_order[i][2]) && (left[0][0] == corner_perm_order[i][0] || left[0][0] == corner_perm_order[i][1] || left[0][0] == corner_perm_order[i][2]) && (back[3][0] == corner_perm_order[i][0] || back[3][0] == corner_perm_order[i][1] || back[3][0] == corner_perm_order[i][2]))
		corners_perm[CORNER_UBL] = i;

		if ((up[0][3] == corner_perm_order[i][0] || up[0][3] == corner_perm_order[i][1] || up[0][3] == corner_perm_order[i][2]) && (right[3][0] == corner_perm_order[i][0] || right[3][0] == corner_perm_order[i][1] || right[3][0] == corner_perm_order[i][2]) && (back[3][3] == corner_perm_order[i][0] || back[3][3] == corner_perm_order[i][1] || back[3][3] == corner_perm_order[i][2]))
		corners_perm[CORNER_UBR] = i;

		if ((up[3][0] == corner_perm_order[i][0] || up[3][0] == corner_perm_order[i][1] || up[3][0] == corner_perm_order[i][2]) && (left[0][3] == corner_perm_order[i][0] || left[0][3] == corner_perm_order[i][1] || left[0][3] == corner_perm_order[i][2]) && (front[0][0] == corner_perm_order[i][0] || front[0][0] == corner_perm_order[i][1] || front[0][0] == corner_perm_order[i][2]))
		corners_perm[CORNER_UFL] = i;

		if ((up[3][3] == corner_perm_order[i][0] || up[3][3] == corner_perm_order[i][1] || up[3][3] == corner_perm_order[i][2]) && (right[3][3] == corner_perm_order[i][0] || right[3][3] == corner_perm_order[i][1] || right[3][3] == corner_perm_order[i][2]) && (front[0][3] == corner_perm_order[i][0] || front[0][3] == corner_perm_order[i][1] || front[0][3] == corner_perm_order[i][2]))
		corners_perm[CORNER_UFR] = i;

		if ((down[0][3] == corner_perm_order[i][0] || down[0][3] == corner_perm_order[i][1] || down[0][3] == corner_perm_order[i][2]) && (left[3][3] == corner_perm_order[i][0] || left[3][3] == corner_perm_order[i][1] || left[3][3] == corner_perm_order[i][2]) && (front[3][0] == corner_perm_order[i][0] || front[3][0] == corner_perm_order[i][1] || front[3][0] == corner_perm_order[i][2]))
		corners_perm[CORNER_DFL] = i;

		if ((down[3][3] == corner_perm_order[i][0] || down[3][3] == corner_perm_order[i][1] || down[3][3] == corner_perm_order[i][2]) && (right[0][3] == corner_perm_order[i][0] || right[0][3] == corner_perm_order[i][1] || right[0][3] == corner_perm_order[i][2]) && (front[3][3] == corner_perm_order[i][0] || front[3][3] == corner_perm_order[i][1] || front[3][3] == corner_perm_order[i][2]))
		corners_perm[CORNER_DFR] = i;

		if ((down[3][0] == corner_perm_order[i][0] || down[3][0] == corner_perm_order[i][1] || down[3][0] == corner_perm_order[i][2]) && (right[0][0] == corner_perm_order[i][0] || right[0][0] == corner_perm_order[i][1] || right[0][0] == corner_perm_order[i][2]) && (back[0][3] == corner_perm_order[i][0] || back[0][3] == corner_perm_order[i][1] || back[0][3] == corner_perm_order[i][2]))
		corners_perm[CORNER_DBR] = i;
	}

	s.corner_perm = pack_perm(corners_perm, CORNER_PERM_NUMBER);
	#if DEBUG_LEVEL > 1
	printf("pack corner perm : %d\n", pack_perm(corners_perm, CORNER_PERM_NUMBER));
	#endif	

	/**
	 * Fills edge
	 */

	edge_order[EDGE_UFR][0] = edge_order[EDGE_UFL][1] = edge_order[EDGE_ULF][0] = edge_order[EDGE_ULB][1] = edge_order[EDGE_UBL][0] = edge_order[EDGE_UBR][1] = edge_order[EDGE_URB][0] = edge_order[EDGE_URF][1] = color_order[CENTER_PACK_U];
	edge_order[EDGE_DFL][0] = edge_order[EDGE_DFR][1] = edge_order[EDGE_DLB][0] = edge_order[EDGE_DLF][1] = edge_order[EDGE_DBR][0] = edge_order[EDGE_DBL][1] = edge_order[EDGE_DRF][0] = edge_order[EDGE_DRB][1] = color_order[CENTER_PACK_D];
	edge_order[EDGE_UFR][1] = edge_order[EDGE_UFL][0] = edge_order[EDGE_FLU][1] = edge_order[EDGE_FLD][0] = edge_order[EDGE_DFL][1] = edge_order[EDGE_DFR][0] = edge_order[EDGE_FRD][1] = edge_order[EDGE_FRU][0] = color_order[CENTER_PACK_F];
	edge_order[EDGE_UBR][0] = edge_order[EDGE_UBL][1] = edge_order[EDGE_BLU][0] = edge_order[EDGE_BLD][1] = edge_order[EDGE_DBL][0] = edge_order[EDGE_DBR][1] = edge_order[EDGE_BRD][0] = edge_order[EDGE_BRU][1] = color_order[CENTER_PACK_B];
	edge_order[EDGE_URF][0] = edge_order[EDGE_URB][1] = edge_order[EDGE_BRU][0] = edge_order[EDGE_BRD][1] = edge_order[EDGE_DRB][0] = edge_order[EDGE_DRF][1] = edge_order[EDGE_FRD][0] = edge_order[EDGE_FRU][1] = color_order[CENTER_PACK_R];
	edge_order[EDGE_ULF][1] = edge_order[EDGE_ULB][0] = edge_order[EDGE_BLU][1] = edge_order[EDGE_BLD][0] = edge_order[EDGE_DLB][1] = edge_order[EDGE_DLF][0] = edge_order[EDGE_FLD][1] = edge_order[EDGE_FLU][0] = color_order[CENTER_PACK_L];


	for (i = 0; i < EDGE_PACK_NUMBER; i++)
		for (j = 0; j < EDGE_NUMBER; j++)
			edges[i][j] = 0;


	for (i = 0; i < EDGE_NUMBER; i++)
	{
		if (up[3][2] == edge_order[i][0] && front[0][2] == edge_order[i][1])
			edges[i/3][EDGE_UFR] = (i%3) + 1;
		if (up[3][1] == edge_order[i][1] && front[0][1] == edge_order[i][0])
			edges[i/3][EDGE_UFL] = (i%3) + 1;
		if (up[2][0] == edge_order[i][0] && left[0][2] == edge_order[i][1])
			edges[i/3][EDGE_ULF] = (i%3) + 1;
		if (up[1][0] == edge_order[i][1] && left[0][1] == edge_order[i][0])
			edges[i/3][EDGE_ULB] = (i%3) + 1;
		if (up[0][1] == edge_order[i][0] && back[3][1] == edge_order[i][1])
			edges[i/3][EDGE_UBL] = (i%3) + 1;
		if (up[0][2] == edge_order[i][1] && back[3][2] == edge_order[i][0])
			edges[i/3][EDGE_UBR] = (i%3) + 1;
		if (up[1][3] == edge_order[i][0] && right[3][1] == edge_order[i][1])
			edges[i/3][EDGE_URB] = (i%3) + 1;
		if (up[2][3] == edge_order[i][1] && right[3][2] == edge_order[i][0])
			edges[i/3][EDGE_URF] = (i%3) + 1;
		if (left[1][3] == edge_order[i][0] && front[1][0] == edge_order[i][1])
			edges[i/3][EDGE_FLU] = (i%3) + 1;
		if (left[2][3] == edge_order[i][1] && front[2][0] == edge_order[i][0])
			edges[i/3][EDGE_FLD] = (i%3) + 1;
		if (left[1][0] == edge_order[i][1] && back[2][0] == edge_order[i][0])
			edges[i/3][EDGE_BLU] = (i%3) + 1;
		if (left[2][0] == edge_order[i][0] && back[1][0] == edge_order[i][1])
			edges[i/3][EDGE_BLD] = (i%3) + 1;
		if (right[2][0] == edge_order[i][0] && back[2][3] == edge_order[i][1])
			edges[i/3][EDGE_BRU] = (i%3) + 1;
		if (right[1][0] == edge_order[i][1] && back[1][3] == edge_order[i][0])
			edges[i/3][EDGE_BRD] = (i%3) + 1;
		if (right[2][3] == edge_order[i][1] && front[1][3] == edge_order[i][0])
			edges[i/3][EDGE_FRU] = (i%3) + 1;
		if (right[1][3] == edge_order[i][0] && front[2][3] == edge_order[i][1])
			edges[i/3][EDGE_FRD] = (i%3) + 1;
		if (down[2][3] == edge_order[i][1] && front[3][2] == edge_order[i][0])
			edges[i/3][EDGE_DFR] = (i%3) + 1;
		if (down[1][3] == edge_order[i][0] && front[3][1] == edge_order[i][1])
			edges[i/3][EDGE_DFL] = (i%3) + 1;
		if (down[0][2] == edge_order[i][1] && left[3][2] == edge_order[i][0])
			edges[i/3][EDGE_DLF] = (i%3) + 1;
		if (down[0][1] == edge_order[i][0] && left[3][1] == edge_order[i][1])
			edges[i/3][EDGE_DLB] = (i%3) + 1;
		if (down[1][0] == edge_order[i][1] && back[0][1] == edge_order[i][0])
			edges[i/3][EDGE_DBL] = (i%3) + 1;
		if (down[2][0] == edge_order[i][0] && back[0][2] == edge_order[i][1])
			edges[i/3][EDGE_DBR] = (i%3) + 1;
		if (down[3][1] == edge_order[i][1] && right[0][1] == edge_order[i][0])
			edges[i/3][EDGE_DRB] = (i%3) + 1;
		if (down[3][2] == edge_order[i][0] && right[0][2] == edge_order[i][1])
			edges[i/3][EDGE_DRF] = (i%3) + 1;
	}

	for (i = 0; i < EDGE_PACK_NUMBER; i++)
	{
		s.edge[i] = pack_var(edges[i], EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
		#if DEBUG_LEVEL > 1
		printf("pack edge %d : %d\n", i, pack_var(edges[i], EDGE_NUMBER_IN_PACK, EDGE_NUMBER));
		#endif
	}

	s.moves = 0;

	return s;
}
