#include "fill_rotate.h"
#include "rotate_edge.h"
#include "rotate_center.h"
#include <stdint.h>
#include <stdlib.h>

using namespace std;

/* Configuration */


#define  DEBUG_LEVEL  1
/* Defines the quantity of debug messages.
 * 0 : Prints nothing.
 * 1 : Prints memory and depths.
 * 2 : Prints information about some states.
 * 3 : Prints every searched sequences.
 * 4 : Prints states of every sequence.
 */


#define  PRUNE_LEVEL  0
/* Defines the power of the pruning.
 * 0 : Pruning regarding corners.
 * 1 : Pruning regarding corners, random edges and random centers.
 * 2 : Pruning regarding all corners, edges and centers.
 */



#define  MAX_ROTATION 30
/* Defines the maximum depth of solutions.
 */

#define  QUEUE_DEPTH 7
/* Defines the depth of the search around the solved state.
 */

#define  HASH_NUMBER 5000000
/* Defines the size of the hash table for storing postions around solved state.
 */


/* End of Configuration */

#define  CENTER_PACK_U  0
#define  CENTER_PACK_D  1
#define  CENTER_PACK_F  2
#define  CENTER_PACK_B  3
#define  CENTER_PACK_L  4
#define  CENTER_PACK_R  5

#define  EDGE_PACK_NUMBER EDGE_NUMBER/EDGE_NUMBER_IN_PACK
#define  CENTER_PACK_NUMBER CENTER_NUMBER/CENTER_NUMBER_IN_PACK

#define  EDGE_SOLVED(x) x == 0 ? 12138 : x == 1 ? 7974 : x == 2 ? 4890 : x == 3 ? 2724 : x == 4 ? 1314 : x == 5 ? 498 : x == 6 ? 114 : 0

#define  CENTER_SOLVED(x) x == 0 ? 10625 : x == 1 ? 4844 : x == 2 ? 1819 : x == 3 ? 494 : x == 4 ? 69 : 0

#define  CORNER_PERM_SOLVED  0
#define  CORNER_ORIENT_SOLVED  0


#ifndef  STATE_DEF
#define  STATE_DEF
struct state
{
	unsigned short edge[EDGE_PACK_NUMBER];
	unsigned short corner_orient;
	unsigned short corner_perm;
	unsigned short center[CENTER_PACK_NUMBER];
	int64_t moves;

	state() {}

	bool operator == (const state &deux) const
	{
		return (center[0] == deux.center[0] && center[1] == deux.center[1] && center[2] == deux.center[2] && center[3] == deux.center[3] && center[4] == deux.center[4] && center[5] == deux.center[5] && edge[0] == deux.edge[0] && edge[1] == deux.edge[1] && edge[2] == deux.edge[2] && edge[3] == deux.edge[3] && edge[4] == deux.edge[4] && edge[5] == deux.edge[5] && edge[6] == deux.edge[6] && edge[7] == deux.edge[7] && corner_perm == deux.corner_perm && corner_orient == deux.corner_orient);
	}

	size_t operator () (const state& s) const
	{
			return (((s.edge[3] + 10) * (s.center[2] + 10) * (s.corner_perm + 10)) % HASH_NUMBER);
	}

};

#endif
