#include "output.h"
#include "main.h"
#include <stdio.h>

int inverse(int s)
{
	switch(s)
	{
		case ROTATE_F:
			return ROTATE_F3;
		case ROTATE_F3:
			return ROTATE_F;
		case ROTATE_R:
			return ROTATE_R3;
		case ROTATE_R3:
			return ROTATE_R;
		case ROTATE_U:
			return ROTATE_U3;
		case ROTATE_U3:
			return ROTATE_U;
		case ROTATE_f:
			return ROTATE_f3;
		case ROTATE_f3:
			return ROTATE_f;
		case ROTATE_b:
			return ROTATE_b3;
		case ROTATE_b3:
			return ROTATE_b;
		case ROTATE_r:
			return ROTATE_r3;
		case ROTATE_r3:
			return ROTATE_r;
		case ROTATE_l:
			return ROTATE_l3;
		case ROTATE_l3:
			return ROTATE_l;
		case ROTATE_u:
			return ROTATE_u3;
		case ROTATE_u3:
			return ROTATE_u;
		case ROTATE_d:
			return ROTATE_d3;
		case ROTATE_d3:
			return ROTATE_d;
		case ROTATE_Ffb:
			return ROTATE_Ffb3;
		case ROTATE_Ffb3:
			return ROTATE_Ffb;
		case ROTATE_Rrl:
			return ROTATE_Rrl3;
		case ROTATE_Rrl3:
			return ROTATE_Rrl;
		case ROTATE_Uud:
			return ROTATE_Uud3;
		case ROTATE_Uud3:
			return ROTATE_Uud;
		default:
			return s;
	}
}

void print_rotate(int rotate)
{
	switch(rotate)
	{
		case ROTATE_F:
			printf(" F");break;
		case ROTATE_F2:
			printf(" F2");break;
		case ROTATE_F3:
			printf(" F'");break;
		case ROTATE_R:
			printf(" R");break;
		case ROTATE_R2:
			printf(" R2");break;
		case ROTATE_R3:
			printf(" R'");break;
		case ROTATE_U:
			printf(" U");break;
		case ROTATE_U2:
			printf(" U2");break;
		case ROTATE_U3:
			printf(" U'");break;
		case ROTATE_f:
			printf(" f");break;
		case ROTATE_f2:
			printf(" f2");break;
		case ROTATE_f3:
			printf(" f'");break;
		case ROTATE_b:
			printf(" b");break;
		case ROTATE_b2:
			printf(" b2");break;
		case ROTATE_b3:
			printf(" b'");break;
		case ROTATE_r:
			printf(" r");break;
		case ROTATE_r2:
			printf(" r2");break;
		case ROTATE_r3:
			printf(" r'");break;
		case ROTATE_l:
			printf(" l");break;
		case ROTATE_l2:
			printf(" l2");break;
		case ROTATE_l3:
			printf(" l'");break;
		case ROTATE_u:
			printf(" u");break;
		case ROTATE_u2:
			printf(" u2");break;
		case ROTATE_u3:
			printf(" u'");break;
		case ROTATE_d:
			printf(" d");break;
		case ROTATE_d2:
			printf(" d2");break;
		case ROTATE_d3:
			printf(" d'");break;
		case ROTATE_Ffb:
			printf(" Ffb");break;
		case ROTATE_Ffb2:
			printf(" Ffb2");break;
		case ROTATE_Ffb3:
			printf(" Ffb'");break;
		case ROTATE_Rrl:
			printf(" Rrl");break;
		case ROTATE_Rrl2:
			printf(" Rrl2");break;
		case ROTATE_Rrl3:
			printf(" Rrl'");break;
		case ROTATE_Uud:
			printf(" Uud");break;
		case ROTATE_Uud2:
			printf(" Uud2");break;
		case ROTATE_Uud3:
			printf(" Uud'");break;
		default:
			printf(" unknown rotation");break;
	}	
}

void print_solution(state s, state i, char next_good_rotate[][ROTATE_NUMBER+1], int snbr, int inbr)
{
	int tab[30];
	int64_t mov = s.moves;
	int k;

	if (next_good_rotate[s.moves % ROTATE_NUMBER][inverse(i.moves % ROTATE_NUMBER)] != inverse(i.moves % ROTATE_NUMBER) && snbr > 0 && inbr > 0)
		return;

	for (k=0;k<snbr;k++)
	{
		tab[snbr - k - 1] = mov % ROTATE_NUMBER;
		mov /= (int64_t)ROTATE_NUMBER;
	}
	
	for (int k=0;k<snbr;k++)
		print_rotate(tab[k]);
	
	mov = i.moves;
	
	for (k=0;k<inbr;k++)
	{
		print_rotate(inverse(mov % ROTATE_NUMBER));
		mov /= (int64_t)ROTATE_NUMBER;
	}
	printf("(%d)\n", snbr + inbr);
}
