//#include "pack.h"

/**
 * Computes factorial of n (n!).
 */

int fac(int n)
{
	int x = 1, i;
	for (i = n; i > 1; i--)
		x *= i;
	return x;
}

/**
 * Computes combinational number n over k (n! / ((n - k)! * k!).
 */

int comb(int n, int k)
{
	int x = 1, y = 1, i, j;
	for (i = n, j = k; j > 0; i--, j--)
	{
		x *= i;
		y *= j;
	}
	return (x / y);
}

/**
 * Computes variational number n over k (n! / (n - k)!).
 */
  
int var(int n, int k)
{
	int x = 1, i, j;
	for (i = n, j = k; j > 0; i--, j--)
		x *= i;
	return x;
}

/**
 * Packs an array of n integers into an int.
 */

unsigned short pack_perm(int array[], int n)
{
	int x = 0, i, j;
	for (i = 0; i < n - 1; i++)
	{
		for (j = i + 1; j < n; j++)
			if (array[j] < array[i])
				x++;
		x *= n - i - 1;
	}
	return (unsigned short)x;
}

/**
 * Unpacks an int into an array of n integers between 0 and n - 1.
 */

void unpack_perm(unsigned short packed, int array[], int n)
{
	int i,j,x = packed;

	array[n - 1] = 0;
	for (i = n - 2; i >= 0; i--)
	{
		array[i] = x % (n - i);
		x /= n - i;
		for (j = n - 1; j > i; j--)
			if (array[j] >= array[i])
				array[j]++;
	}
}


/**
 * Packs an array of non-zero integers into an int
 */

int pack_holeperm(int array[], int n)
{
	int x = 0, i, j, m;

	for (i = 0; i < n - 1; i++)
	{
		if (array[i] > 0)
		{
			m = 0;
			for (j = i + 1; j < n; j++)
			{
				if (array[j] != 0)
				{
					m++;
					if (array[j] < array[i])
						x++;
				}
			}
		if (m <= 1)
			return x;
		x *= m;
		}
	}
return 0; // if we have only zeroes in array
}


/**
 * Unpacks an int into an array with holes (zeros).
 */

void unpack_holeperm(int packed, int array[], int n)
{
	int m = 0, i, j, x = packed;

	for (i = n - 1; i >= 0; i--)
	{
		if (array[i] > 0)
		{
			m++;
			array[i] = x % m + 1;
			x /= m;
			for (j = n - 1; j > i; j--)
				if ((array[j] > 0) && (array[j] >= array[i]))
					array[j]++;
		}
	}
}


/**
 * Packs the binary array with k 1s to its order C(n, k).
 */

unsigned short pack_comb(int array[], int k, int n)
{
	int x = 0, i, j;
	for (i = 0, j = k; i < n - j; i++)
		if (array[i] > 0)
			x += comb(n - i - 1, j--);
	return (unsigned short)x;
}

/**
 * Unpacks order of combination to the binary array with k ones.
 */

void unpack_comb(unsigned short packed, int array[], int k, int n)
{
	int c, i, j, x = packed;

	for (i = 0, j = k; i < n; i++)
	{
		c = comb(n - i - 1, j);
		if (c <= x)
		{
			x -= c;
			array[i] = 1;
			j--;
		}
		else
			array[i] = 0;
	}
}


/**
 * Packs variation of k numbers 0 to k - 1 to its order.
 * The least number: ..00123.., .., ..00..321; the largest one: ..32100..
 */

unsigned short pack_var(int array[], int k, int n)
{
	return (unsigned short)pack_comb(array, k, n) * fac(k) + (unsigned short)pack_holeperm(array, n);
}


/**
 * Depacks order of variation V(n, k) to the array a.
 */

void unpack_var(unsigned short packed, int array[], int k, int n)
{
	unpack_comb(packed / fac(k), array, k, n); // order of comb
	unpack_holeperm(packed % fac(k), array, n); // order of (sub)perm
}

/**
 * Packs an array of values between 0 and m - 1 into an int
 */

unsigned short pack_full(int array[], int n, int m)
{
	int x = 0, i;
	
	for (i = n - 2; i >= 0; i--)
		x = m*x + array[i];
	return (unsigned short)x;
}

/**
 * Unpacks an int into an array of values between 0 and m - 1
 */

void unpack_full(unsigned short packed, int array[], int n, int m)
{
	int x = packed,i;
	for (i = 0; i < n - 1; i++)
	{
		array[i] = x % m;
		x /= m;
	}

	array[n - 1] = 0; 
	for (i = 0; i < n - 1; i++)
		array[n - 1] = (array[n - 1] + 2*array[i]) % m; /* The orientation of the last corner is fixed */
}


/**
 * Does a four cycle over the elements of the array
 */

void four_cycle(int array[], int un, int deux, int trois, int quatre)
{
	int p = array[un];
	array[un] = array[quatre];
	array[quatre] = array[trois];
	array[trois] = array[deux];
	array[deux] = p;
}

/**
 * Orients the corners during a rotation
 */


void orient(int array[], int un, int deux, int trois, int quatre)
{
	array[un] = (array[un] + 2) % 3;
	array[deux] = (array[deux] + 1) % 3;
	array[trois] = (array[trois] + 2) % 3;
	array[quatre] = (array[quatre] + 1) % 3;
}
