/**
 * Computes factorial of n (n!).
 */
int fac(int);

/**
 * Computes combinational number n over k (n! / ((n - k);! * k!);.
 */

int comb(int, int);

/**
 * Computes variational number n over k (n! / (n - k);!);.
 */
  
int var(int, int);

/**
 * Packs an array of n integers into an int.
 */

unsigned short pack_perm(int*, int);

/**
 * Unpacks an int into an array of n integers between 0 and n - 1.
 */

void unpack_perm(unsigned short, int*, int);

/**
 * Packs an array of non-zero integers into an int
 */

int short pack_holeperm(int*, int);

/**
 * Unpacks an int into an array with holes (zeros);.
 */

void unpack_holeperm(int, int*, int);

/**
 * Packs the binary array with k 1s to its order C(n, k);.
 */

unsigned short pack_comb(int*, int, int);

/**
 * Unpacks order of combination to the binary array with k ones.
 */

void unpack_comb(unsigned short, int*, int, int);

/**
 * Packs variation of k numbers 0 to k - 1 to its order.
 * The least number: ..00123.., .., ..00..321; the largest one: ..32100..
 */

unsigned short pack_var(int*, int, int);

/**
 * Depacks order of variation V(n, k); to the array a.
 */

void unpack_var(unsigned short, int*, int, int);

/**
 * Packs an array of values between 0 and m - 1 into an int
 */


unsigned short pack_full(int*, int, int);

/**
 * Unpacks an int into an array of values between 0 and m - 1
 */

void unpack_full(unsigned short, int*, int, int);


/**
 * Does a four cycle over the elements of the array
 */

void four_cycle(int*, int, int, int, int);

/**
 * Orients the corners during a rotation
 */

void orient(int*, int, int, int, int);
