#include "pack.h"
#include "rotate_corner_orient.h"

unsigned short rotate_F_on_corner_orient(unsigned short corner_o)
{
	int orient_array[CORNER_ORIENT_NUMBER];
	unpack_full(corner_o, orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
	four_cycle(orient_array, CORNER_UFL, CORNER_UFR, CORNER_DFR, CORNER_DFL);
	orient(orient_array, CORNER_UFL, CORNER_UFR, CORNER_DFR, CORNER_DFL);
	return pack_full(orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
}

unsigned short rotate_R_on_corner_orient(unsigned short corner_o)
{
	int orient_array[CORNER_ORIENT_NUMBER];
	unpack_full(corner_o, orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
	four_cycle(orient_array, CORNER_UFR, CORNER_UBR, CORNER_DBR, CORNER_DFR);
	orient(orient_array, CORNER_UFR, CORNER_UBR, CORNER_DBR, CORNER_DFR);
	return pack_full(orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
}

unsigned short rotate_U_on_corner_orient(unsigned short corner_o)
{
	int orient_array[CORNER_ORIENT_NUMBER];
	unpack_full(corner_o, orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
	four_cycle(orient_array, CORNER_UFL, CORNER_UBL, CORNER_UBR, CORNER_UFR);
	return pack_full(orient_array, CORNER_ORIENT_NUMBER, CORNER_ORIENT_TWIST);
}
