#include "pack.h"
#include "rotate_corner_perm.h"

unsigned short rotate_F_on_corner_perm(unsigned short corner_p)
{
	int perm[CORNER_PERM_NUMBER];
	unpack_perm(corner_p, perm, CORNER_PERM_NUMBER);
	four_cycle(perm, CORNER_UFL, CORNER_UFR, CORNER_DFR, CORNER_DFL);
	return pack_perm(perm, CORNER_PERM_NUMBER);
}

unsigned short rotate_R_on_corner_perm(unsigned short corner_p)
{
	int perm[CORNER_PERM_NUMBER];
	unpack_perm(corner_p, perm, CORNER_PERM_NUMBER);
	four_cycle(perm, CORNER_UFR, CORNER_UBR, CORNER_DBR, CORNER_DFR);
	return pack_perm(perm, CORNER_PERM_NUMBER);
}

unsigned short rotate_U_on_corner_perm(unsigned short corner_p)
{
	int perm[CORNER_PERM_NUMBER];
	unpack_perm(corner_p, perm, CORNER_PERM_NUMBER);
	four_cycle(perm, CORNER_UFL, CORNER_UBL, CORNER_UBR, CORNER_UFR);
	return pack_perm(perm, CORNER_PERM_NUMBER);
}
