#include "rotate_edge.h"
#include "pack.h"

unsigned short rotate_R_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_URF, EDGE_BRU, EDGE_DRB, EDGE_FRD);
	four_cycle(tab, EDGE_URB, EDGE_BRD, EDGE_DRF, EDGE_FRU);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_U_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_UFR, EDGE_ULF, EDGE_UBL, EDGE_URB);
	four_cycle(tab, EDGE_UFL, EDGE_ULB, EDGE_UBR, EDGE_URF);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_F_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_UFR, EDGE_FRD, EDGE_DFL, EDGE_FLU);
	four_cycle(tab, EDGE_UFL, EDGE_FRU, EDGE_DFR, EDGE_FLD);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_r_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_UFR, EDGE_UBR, EDGE_DBR, EDGE_DFR);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_l_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_UBL, EDGE_UFL, EDGE_DFL, EDGE_DBL);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_u_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_FRU, EDGE_FLU, EDGE_BLU, EDGE_BRU);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_d_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_FLD, EDGE_FRD, EDGE_BRD, EDGE_BLD);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_f_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_ULF, EDGE_URF, EDGE_DRF, EDGE_DLF);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}

unsigned short rotate_b_on_edge(unsigned short edge)
{
	int tab[EDGE_NUMBER];
	unpack_var(edge, tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
	four_cycle(tab, EDGE_URB, EDGE_ULB, EDGE_DLB, EDGE_DRB);
	return pack_var(tab, EDGE_NUMBER_IN_PACK, EDGE_NUMBER);
}
