/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.graphics;

import com.puzzletimer.graphics.Face;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.graphics.geometry.Intersection;
import com.puzzletimer.graphics.geometry.LineSegment;
import com.puzzletimer.graphics.geometry.Plane;
import java.awt.Color;
import java.util.ArrayList;

public class Mesh {
    public ArrayList<Vector3> vertices;
    public ArrayList<Face> faces;

    public Mesh(ArrayList<Vector3> vertices, ArrayList<Face> faces) {
        this.vertices = vertices;
        this.faces = faces;
    }

    public Mesh transform(Matrix44 m) {
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), this.faces);
        for (Vector3 v : this.vertices) {
            mesh.vertices.add(m.mul(v));
        }
        return mesh;
    }

    public Mesh transformHalfspace(Matrix44 m, Plane p) {
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), this.faces);
        for (Vector3 v : this.vertices) {
            if (Intersection.pointHalfspace(v, p)) {
                mesh.vertices.add(m.mul(v));
                continue;
            }
            mesh.vertices.add(v);
        }
        return mesh;
    }

    public Mesh union(Mesh m) {
        int i;
        Face f;
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        for (Face face : this.faces) {
            f = new Face(new ArrayList<Integer>(), face.color);
            i = 0;
            while (i < face.vertexIndices.size()) {
                mesh.vertices.add(this.vertices.get(face.vertexIndices.get(i)));
                f.vertexIndices.add(mesh.vertices.size() - 1);
                ++i;
            }
            mesh.faces.add(f);
        }
        for (Face face : m.faces) {
            f = new Face(new ArrayList<Integer>(), face.color);
            i = 0;
            while (i < face.vertexIndices.size()) {
                mesh.vertices.add(m.vertices.get(face.vertexIndices.get(i)));
                f.vertexIndices.add(mesh.vertices.size() - 1);
                ++i;
            }
            mesh.faces.add(f);
        }
        return mesh;
    }

    public Mesh clip(Plane p) {
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        for (Face face : this.faces) {
            Face f = new Face(new ArrayList<Integer>(), face.color);
            int i = 0;
            while (i < face.vertexIndices.size()) {
                Vector3 v1 = this.vertices.get(face.vertexIndices.get(i));
                Vector3 v2 = this.vertices.get(face.vertexIndices.get((i + 1) % face.vertexIndices.size()));
                if (Intersection.pointHalfspace(v1, p)) {
                    if (Intersection.pointHalfspace(v2, p)) {
                        mesh.vertices.add(v2);
                        f.vertexIndices.add(mesh.vertices.size() - 1);
                    } else {
                        mesh.vertices.add(Intersection.planeLine(p, new LineSegment(v1, v2)));
                        f.vertexIndices.add(mesh.vertices.size() - 1);
                    }
                } else if (Intersection.pointHalfspace(v2, p)) {
                    mesh.vertices.add(Intersection.planeLine(p, new LineSegment(v1, v2)));
                    f.vertexIndices.add(mesh.vertices.size() - 1);
                    mesh.vertices.add(v2);
                    f.vertexIndices.add(mesh.vertices.size() - 1);
                }
                ++i;
            }
            if (f.vertexIndices.size() < 3) continue;
            mesh.faces.add(f);
        }
        return mesh;
    }

    public Mesh cut(Plane p, double gap) {
        Plane p1 = new Plane(p.p.add(p.n.mul(gap / 2.0)), p.n);
        Plane p2 = new Plane(p.p.sub(p.n.mul(gap / 2.0)), p.n.neg());
        return this.clip(p1).union(this.clip(p2));
    }

    public Mesh shortenFaces(double gap) {
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        for (Face face : this.faces) {
            Vector3 centroid = new Vector3(0.0, 0.0, 0.0);
            for (int i : face.vertexIndices) {
                centroid = centroid.add(this.vertices.get(i));
            }
            centroid = centroid.mul(1.0 / (double)face.vertexIndices.size());
            Face f = new Face(new ArrayList<Integer>(), face.color);
            for (int i : face.vertexIndices) {
                mesh.vertices.add(this.vertices.get(i).add(centroid.sub(this.vertices.get(i)).normalized().mul(gap)));
                f.vertexIndices.add(mesh.vertices.size() - 1);
            }
            mesh.faces.add(f);
        }
        return mesh;
    }

    public Mesh softenFaces(double distanceFromCorners) {
        Mesh mesh = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        for (Face face : this.faces) {
            Face f = new Face(new ArrayList<Integer>(), face.color);
            int i = 0;
            while (i < face.vertexIndices.size()) {
                Vector3 v1 = this.vertices.get(face.vertexIndices.get(i));
                Vector3 v2 = this.vertices.get(face.vertexIndices.get((i + 1) % face.vertexIndices.size()));
                if (v2.sub(v1).norm() > 2.0 * distanceFromCorners) {
                    mesh.vertices.add(v1.add(v2.sub(v1).normalized().mul(distanceFromCorners)));
                    f.vertexIndices.add(mesh.vertices.size() - 1);
                    mesh.vertices.add(v2.add(v1.sub(v2).normalized().mul(distanceFromCorners)));
                    f.vertexIndices.add(mesh.vertices.size() - 1);
                } else {
                    mesh.vertices.add(v1.add(v2).mul(0.5));
                    f.vertexIndices.add(mesh.vertices.size() - 1);
                }
                ++i;
            }
            mesh.faces.add(f);
        }
        return mesh;
    }

    private static ArrayList<Integer> toArrayList(int[] xs) {
        ArrayList<Integer> ys = new ArrayList<Integer>();
        int[] nArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            ys.add(x);
            ++n2;
        }
        return ys;
    }

    public static Mesh cube(Color[] colors) {
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        vertices.add(new Vector3(-0.5, -0.5, -0.5));
        vertices.add(new Vector3(-0.5, -0.5, 0.5));
        vertices.add(new Vector3(-0.5, 0.5, -0.5));
        vertices.add(new Vector3(-0.5, 0.5, 0.5));
        vertices.add(new Vector3(0.5, -0.5, -0.5));
        vertices.add(new Vector3(0.5, -0.5, 0.5));
        vertices.add(new Vector3(0.5, 0.5, -0.5));
        vertices.add(new Vector3(0.5, 0.5, 0.5));
        ArrayList<Face> faces = new ArrayList<Face>();
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        faces.add(new Face(Mesh.toArrayList(nArray), colors[0]));
        faces.add(new Face(Mesh.toArrayList(new int[]{1, 5, 7, 3}), colors[1]));
        int[] nArray2 = new int[4];
        nArray2[1] = 4;
        nArray2[2] = 5;
        nArray2[3] = 1;
        faces.add(new Face(Mesh.toArrayList(nArray2), colors[2]));
        faces.add(new Face(Mesh.toArrayList(new int[]{4, 6, 7, 5}), colors[3]));
        int[] nArray3 = new int[4];
        nArray3[1] = 2;
        nArray3[2] = 6;
        nArray3[3] = 4;
        faces.add(new Face(Mesh.toArrayList(nArray3), colors[4]));
        faces.add(new Face(Mesh.toArrayList(new int[]{2, 3, 7, 6}), colors[5]));
        return new Mesh(vertices, faces);
    }

    public static Mesh tetrahedron(Color[] colors) {
        double a = 1.5;
        double h = Math.sqrt(3.0) / 2.0 * a;
        double h1 = 2.0 * Math.sqrt(2.0) / 3.0 * h;
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        vertices.add(new Vector3(0.0, -h1 / 4.0, 2.0 * h / 3.0));
        vertices.add(new Vector3(-a / 2.0, -h1 / 4.0, -h / 3.0));
        vertices.add(new Vector3(a / 2.0, -h1 / 4.0, -h / 3.0));
        vertices.add(new Vector3(0.0, 3.0 * h1 / 4.0, 0.0));
        ArrayList<Face> faces = new ArrayList<Face>();
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        faces.add(new Face(Mesh.toArrayList(nArray), colors[0]));
        int[] nArray2 = new int[3];
        nArray2[1] = 3;
        nArray2[2] = 1;
        faces.add(new Face(Mesh.toArrayList(nArray2), colors[1]));
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 3;
        faces.add(new Face(Mesh.toArrayList(nArray3), colors[2]));
        faces.add(new Face(Mesh.toArrayList(new int[]{1, 3, 2}), colors[3]));
        return new Mesh(vertices, faces);
    }

    public static Mesh dodecahedron(Color[] colors) {
        double a = 0.85 / Math.sqrt(3.0);
        double b = 0.85 * Math.sqrt((3.0 - Math.sqrt(5.0)) / 6.0);
        double c = 0.85 * Math.sqrt((3.0 + Math.sqrt(5.0)) / 6.0);
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        vertices.add(new Vector3(a, a, a));
        vertices.add(new Vector3(b, c, 0.0));
        vertices.add(new Vector3(-b, c, 0.0));
        vertices.add(new Vector3(-a, a, a));
        vertices.add(new Vector3(0.0, b, c));
        vertices.add(new Vector3(a, a, a));
        vertices.add(new Vector3(0.0, b, c));
        vertices.add(new Vector3(0.0, -b, c));
        vertices.add(new Vector3(a, -a, a));
        vertices.add(new Vector3(c, 0.0, b));
        vertices.add(new Vector3(c, 0.0, b));
        vertices.add(new Vector3(a, -a, a));
        vertices.add(new Vector3(b, -c, 0.0));
        vertices.add(new Vector3(a, -a, -a));
        vertices.add(new Vector3(c, 0.0, -b));
        vertices.add(new Vector3(-b, c, 0.0));
        vertices.add(new Vector3(-a, a, -a));
        vertices.add(new Vector3(-c, 0.0, -b));
        vertices.add(new Vector3(-c, 0.0, b));
        vertices.add(new Vector3(-a, a, a));
        vertices.add(new Vector3(a, -a, -a));
        vertices.add(new Vector3(0.0, -b, -c));
        vertices.add(new Vector3(0.0, b, -c));
        vertices.add(new Vector3(a, a, -a));
        vertices.add(new Vector3(c, 0.0, -b));
        vertices.add(new Vector3(-a, -a, -a));
        vertices.add(new Vector3(-b, -c, 0.0));
        vertices.add(new Vector3(-a, -a, a));
        vertices.add(new Vector3(-c, 0.0, b));
        vertices.add(new Vector3(-c, 0.0, -b));
        vertices.add(new Vector3(a, a, a));
        vertices.add(new Vector3(c, 0.0, b));
        vertices.add(new Vector3(c, 0.0, -b));
        vertices.add(new Vector3(a, a, -a));
        vertices.add(new Vector3(b, c, 0.0));
        vertices.add(new Vector3(b, c, 0.0));
        vertices.add(new Vector3(a, a, -a));
        vertices.add(new Vector3(0.0, b, -c));
        vertices.add(new Vector3(-a, a, -a));
        vertices.add(new Vector3(-b, c, 0.0));
        vertices.add(new Vector3(0.0, b, c));
        vertices.add(new Vector3(-a, a, a));
        vertices.add(new Vector3(-c, 0.0, b));
        vertices.add(new Vector3(-a, -a, a));
        vertices.add(new Vector3(0.0, -b, c));
        vertices.add(new Vector3(-a, -a, a));
        vertices.add(new Vector3(-b, -c, 0.0));
        vertices.add(new Vector3(b, -c, 0.0));
        vertices.add(new Vector3(a, -a, a));
        vertices.add(new Vector3(0.0, -b, c));
        vertices.add(new Vector3(-a, -a, -a));
        vertices.add(new Vector3(-c, 0.0, -b));
        vertices.add(new Vector3(-a, a, -a));
        vertices.add(new Vector3(0.0, b, -c));
        vertices.add(new Vector3(0.0, -b, -c));
        vertices.add(new Vector3(-a, -a, -a));
        vertices.add(new Vector3(0.0, -b, -c));
        vertices.add(new Vector3(a, -a, -a));
        vertices.add(new Vector3(b, -c, 0.0));
        vertices.add(new Vector3(-b, -c, 0.0));
        ArrayList<Face> faces = new ArrayList<Face>();
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        faces.add(new Face(Mesh.toArrayList(nArray), colors[0]));
        faces.add(new Face(Mesh.toArrayList(new int[]{5, 6, 7, 8, 9}), colors[1]));
        faces.add(new Face(Mesh.toArrayList(new int[]{10, 11, 12, 13, 14}), colors[2]));
        faces.add(new Face(Mesh.toArrayList(new int[]{15, 16, 17, 18, 19}), colors[3]));
        faces.add(new Face(Mesh.toArrayList(new int[]{20, 21, 22, 23, 24}), colors[4]));
        faces.add(new Face(Mesh.toArrayList(new int[]{25, 26, 27, 28, 29}), colors[5]));
        faces.add(new Face(Mesh.toArrayList(new int[]{30, 31, 32, 33, 34}), colors[6]));
        faces.add(new Face(Mesh.toArrayList(new int[]{35, 36, 37, 38, 39}), colors[7]));
        faces.add(new Face(Mesh.toArrayList(new int[]{40, 41, 42, 43, 44}), colors[8]));
        faces.add(new Face(Mesh.toArrayList(new int[]{45, 46, 47, 48, 49}), colors[9]));
        faces.add(new Face(Mesh.toArrayList(new int[]{50, 51, 52, 53, 54}), colors[10]));
        faces.add(new Face(Mesh.toArrayList(new int[]{55, 56, 57, 58, 59}), colors[11]));
        return new Mesh(vertices, faces);
    }
}

