/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.gui.CategoryEditorDialog;
import com.puzzletimer.gui.CategoryEditorListener;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryListener;
import com.puzzletimer.state.CategoryManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;

public class CategoryManagerFrame
extends JFrame {
    private JTable table;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonRemove;
    private JButton buttonOk;

    public CategoryManagerFrame(final PuzzleProvider puzzleProvider, final ScramblerProvider scramblerProvider, final CategoryManager categoryManager) {
        this.setTitle("Category Manager");
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addCategoryListener(new CategoryListener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                DefaultTableModel tableModel = new DefaultTableModel(){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                Object[] objectArray = new String[]{"Description", "Puzzle", "Scrambler"};
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = objectArray[n2];
                    tableModel.addColumn(column);
                    ++n2;
                }
                objectArray = categories;
                n = categories.length;
                n2 = 0;
                while (n2 < n) {
                    Object category = objectArray[n2];
                    ScramblerInfo scramblerInfo = scramblerProvider.get(((Category)category).getScramblerId()).getScramblerInfo();
                    PuzzleInfo puzzleInfo = puzzleProvider.get(scramblerInfo.getPuzzleId()).getPuzzleInfo();
                    tableModel.addRow(new Object[]{((Category)category).getDescription(), puzzleInfo.getDescription(), scramblerInfo.getDescription()});
                    ++n2;
                }
                CategoryManagerFrame.this.table.setModel(tableModel);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                if (selectedIndex < 0) {
                    CategoryManagerFrame.this.buttonEdit.setEnabled(false);
                    CategoryManagerFrame.this.buttonRemove.setEnabled(false);
                } else {
                    Category category = categoryManager.getCategories()[selectedIndex];
                    boolean enabled = category.isUserDefined() && category != categoryManager.getCurrentCategory();
                    CategoryManagerFrame.this.buttonEdit.setEnabled(enabled);
                    CategoryManagerFrame.this.buttonRemove.setEnabled(enabled);
                }
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Category category = new Category(UUID.randomUUID(), "RUBIKS-CUBE-RANDOM", "New category", true);
                CategoryEditorListener listener = new CategoryEditorListener(){

                    @Override
                    public void categoryEdited(Category category) {
                        categoryManager.addCategory(category);
                    }
                };
                CategoryEditorDialog dialog = new CategoryEditorDialog(CategoryManagerFrame.this, true, puzzleProvider.getAll(), scramblerProvider.getAll(), category, true, listener);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                Category category = categoryManager.getCategories()[selectedIndex];
                CategoryEditorListener listener = new CategoryEditorListener(){

                    @Override
                    public void categoryEdited(Category category) {
                        categoryManager.updateCategory(category);
                    }
                };
                CategoryEditorDialog dialog = new CategoryEditorDialog(CategoryManagerFrame.this, true, puzzleProvider.getAll(), scramblerProvider.getAll(), category, false, listener);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                Category category = categoryManager.getCategories()[selectedIndex];
                categoryManager.removeCategory(category);
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CategoryManagerFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CategoryManagerFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[grow][pref!]", "[pref!]8[grow]16[pref!]"));
        JLabel labelCategories = new JLabel("Categories");
        this.add((Component)labelCategories, "span 2, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonAdd = new JButton("Add...");
        this.add((Component)this.buttonAdd, "top, growx, split, flowy");
        this.buttonEdit = new JButton("Edit...");
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, "growx");
        this.buttonRemove = new JButton("Remove");
        this.buttonRemove.setEnabled(false);
        this.add((Component)this.buttonRemove, "growx, wrap");
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "right, width 100, span 2");
    }
}

