/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.graphics.Panel3D;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.state.ColorListener;
import com.puzzletimer.state.ColorManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class ColorSchemeFrame
extends JFrame {
    private JComboBox comboBoxPuzzle;
    private Panel3D panel3D;
    private JTable table;
    private JButton buttonEdit;
    private JButton buttonDefault;
    private JButton buttonOk;

    public ColorSchemeFrame(PuzzleProvider puzzleProvider, final ColorManager colorManager) {
        this.setMinimumSize(new Dimension(480, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.setTitle("Color Scheme");
        this.createComponents();
        Puzzle defaultPuzzle = null;
        Puzzle[] puzzleArray = puzzleProvider.getAll();
        int n = puzzleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Puzzle puzzle = puzzleArray[n2];
            if (puzzle.getPuzzleInfo().getPuzzleId().equals("RUBIKS-CUBE")) {
                defaultPuzzle = puzzle;
            }
            this.comboBoxPuzzle.addItem(puzzle);
            ++n2;
        }
        this.comboBoxPuzzle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                ColorSchemeFrame.this.update(puzzle, colorScheme);
            }
        });
        this.comboBoxPuzzle.setSelectedItem(defaultPuzzle);
        this.buttonEdit.setEnabled(false);
        this.buttonDefault.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int nSelected = ColorSchemeFrame.this.table.getSelectedRowCount();
                ColorSchemeFrame.this.buttonEdit.setEnabled(nSelected == 1);
                ColorSchemeFrame.this.buttonDefault.setEnabled(nSelected > 0);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                ColorScheme.FaceColor faceColor = colorScheme.getFaceColors()[ColorSchemeFrame.this.table.getSelectedRow()];
                Color color = JColorChooser.showDialog(ColorSchemeFrame.this, String.valueOf(faceColor.getFaceDescription()) + " Color", faceColor.getColor());
                if (color != null) {
                    faceColor.setColor(color);
                    colorManager.setColorScheme(colorScheme);
                }
            }
        });
        this.buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                int[] nArray = ColorSchemeFrame.this.table.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ColorScheme.FaceColor faceColor = colorScheme.getFaceColors()[index];
                    faceColor.setColor(faceColor.getDefaultColor());
                    ++n2;
                }
                colorManager.setColorScheme(colorScheme);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorSchemeFrame.this.setVisible(false);
            }
        });
        colorManager.addColorListener(new ColorListener(){

            @Override
            public void colorSchemeUpdated(ColorScheme colorScheme) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                if (puzzle.getPuzzleInfo().getPuzzleId().equals(colorScheme.getPuzzleId())) {
                    ColorSchemeFrame.this.update(puzzle, colorScheme);
                }
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorSchemeFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[grow][pref!]", "[pref!][pref!][pref!]12[pref!][]16[pref!]"));
        this.add((Component)new JLabel("Puzzle"), "growx, span, wrap");
        this.comboBoxPuzzle = new JComboBox();
        this.add((Component)this.comboBoxPuzzle, "growx, span, wrap");
        this.panel3D = new Panel3D();
        this.panel3D.setMinimumSize(new Dimension(300, 300));
        this.panel3D.setPreferredSize(this.panel3D.getMinimumSize());
        this.panel3D.cameraPosition = new Vector3(0.0, 0.0, -2.0);
        this.add((Component)this.panel3D, "growx, span, wrap");
        this.add((Component)new JLabel("Colors"), "growx, span, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonEdit = new JButton("Edit...");
        this.add((Component)this.buttonEdit, "growx, top, split, flowy");
        this.buttonDefault = new JButton("Default");
        this.add((Component)this.buttonDefault, "growx, top, wrap");
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "width 100, right, span");
    }

    private void update(Puzzle puzzle, ColorScheme colorScheme) {
        this.panel3D.mesh = puzzle.getScrambledPuzzleMesh(colorScheme, new String[0]);
        this.panel3D.repaint();
        this.table.setDefaultRenderer(Color.class, new ColorRenderer());
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        Object[] objectArray = new String[]{"Face", "Color"};
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = objectArray[n2];
            tableModel.addColumn(column);
            ++n2;
        }
        objectArray = colorScheme.getFaceColors();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object faceColor = objectArray[n2];
            tableModel.addRow(new Object[]{((ColorScheme.FaceColor)faceColor).getFaceDescription(), ((ColorScheme.FaceColor)faceColor).getColor()});
            ++n2;
        }
        this.table.setModel(tableModel);
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, backgroundColor));
            return this;
        }
    }
}

