/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.models.Category;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryListener;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ScrambleListener;
import com.puzzletimer.state.ScrambleManager;
import com.puzzletimer.tips.Tipper;
import com.puzzletimer.tips.TipperProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class TipsFrame
extends JFrame {
    private JTextArea textAreaTips;
    private JButton buttonOk;

    public TipsFrame(final PuzzleProvider puzzleProvider, final TipperProvider tipperProvider, final ScramblerProvider scrambleProvider, CategoryManager categoryManager, ScrambleManager scrambleManager) {
        this.setMinimumSize(new Dimension(480, 320));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addCategoryListener(new CategoryListener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                Scrambler scrambler = scrambleProvider.get(currentCategory.getScramblerId());
                Puzzle puzzle = puzzleProvider.get(scrambler.getScramblerInfo().getPuzzleId());
                TipsFrame.this.setTitle("Tips - " + puzzle.getPuzzleInfo().getDescription());
            }
        });
        categoryManager.notifyListeners();
        scrambleManager.addScrambleListener(new ScrambleListener(){

            @Override
            public void scrambleChanged(Scramble scramble) {
                Scrambler scrambler = scrambleProvider.get(scramble.getScramblerId());
                Puzzle puzzle = puzzleProvider.get(scrambler.getScramblerInfo().getPuzzleId());
                Tipper tipper = tipperProvider.get(puzzle.getPuzzleInfo().getPuzzleId());
                String tips = "";
                if (tipper != null) {
                    tips = tipper.getTips(scramble);
                }
                TipsFrame.this.textAreaTips.setText(tips);
                TipsFrame.this.textAreaTips.setCaretPosition(0);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TipsFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TipsFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "", "[pref!][]16[pref!]"));
        this.add((Component)new JLabel("Tips"), "wrap");
        this.textAreaTips = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textAreaTips);
        this.add((Component)scrollPane, "grow, wrap");
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "width 100, right");
    }
}

