/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.parsers;

import com.puzzletimer.parsers.Parser;
import com.puzzletimer.parsers.ScrambleParser;
import java.util.ArrayList;

public class MegaminxScrambleParser
implements ScrambleParser {
    @Override
    public String getPuzzleId() {
        return "MEGAMINX";
    }

    @Override
    public String[] parse(String input) {
        Parser parser = new Parser(input);
        ArrayList<String> moves = new ArrayList<String>();
        while (true) {
            parser.skipSpaces();
            String move = "";
            String face = parser.anyChar("UDR");
            if (face == null) break;
            move = String.valueOf(move) + face;
            if (face.equals("U")) {
                String prime = parser.anyChar("'");
                if (prime != null) {
                    move = String.valueOf(move) + prime;
                }
            } else {
                String orientation = parser.string("++");
                if (orientation == null) {
                    orientation = parser.string("--");
                }
                if (orientation == null) break;
                move = String.valueOf(move) + orientation;
            }
            moves.add(move);
        }
        String[] movesArray = new String[moves.size()];
        moves.toArray(movesArray);
        return movesArray;
    }
}

