/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.parsers;

import com.puzzletimer.parsers.Parser;
import com.puzzletimer.parsers.ScrambleParser;
import java.util.ArrayList;
import java.util.HashMap;

public class RubiksTowerScramblerParser
implements ScrambleParser {
    @Override
    public String getPuzzleId() {
        return "RUBIKS-TOWER";
    }

    @Override
    public String[] parse(String input) {
        Parser parser = new Parser(input);
        ArrayList<String> moves = new ArrayList<String>();
        while (true) {
            String suffix;
            parser.skipSpaces();
            String move = "";
            String face = parser.anyChar("BDFLRU");
            if (face == null) break;
            move = String.valueOf(move) + face;
            String wide = parser.anyChar("w");
            if (wide != null) {
                move = String.valueOf(move) + wide;
            }
            if ((suffix = parser.anyChar("2'")) != null) {
                move = String.valueOf(move) + suffix;
            }
            moves.add(move);
        }
        if (!this.isValidScramble(moves)) {
            return new String[0];
        }
        String[] movesArray = new String[moves.size()];
        moves.toArray(movesArray);
        return movesArray;
    }

    private boolean isValidScramble(ArrayList<String> moves) {
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        State moveUw = new State(byArray, new byte[8]);
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 5;
        byArray2[5] = 6;
        byArray2[6] = 7;
        byArray2[7] = 4;
        State moveDw = new State(byArray2, new byte[8]);
        byte[] byArray3 = new byte[8];
        byArray3[0] = 4;
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[4] = 7;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 2;
        byArray4[3] = 1;
        byArray4[4] = 1;
        byArray4[7] = 2;
        State moveLw = new State(byArray3, byArray4);
        byte[] byArray5 = new byte[8];
        byArray5[1] = 2;
        byArray5[2] = 6;
        byArray5[3] = 3;
        byArray5[4] = 4;
        byArray5[5] = 1;
        byArray5[6] = 5;
        byArray5[7] = 7;
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[5] = 2;
        byArray6[6] = 1;
        State moveRw = new State(byArray5, byArray6);
        byte[] byArray7 = new byte[8];
        byArray7[1] = 1;
        byArray7[2] = 3;
        byArray7[3] = 7;
        byArray7[4] = 4;
        byArray7[5] = 5;
        byArray7[6] = 2;
        byArray7[7] = 6;
        byte[] byArray8 = new byte[8];
        byArray8[2] = 1;
        byArray8[3] = 2;
        byArray8[6] = 2;
        byArray8[7] = 1;
        State moveFw = new State(byArray7, byArray8);
        byte[] byArray9 = new byte[8];
        byArray9[0] = 1;
        byArray9[1] = 5;
        byArray9[2] = 2;
        byArray9[3] = 3;
        byArray9[5] = 4;
        byArray9[6] = 6;
        byArray9[7] = 7;
        byte[] byArray10 = new byte[8];
        byArray10[0] = 1;
        byArray10[1] = 2;
        byArray10[4] = 2;
        byArray10[5] = 1;
        State moveBw = new State(byArray9, byArray10);
        HashMap<String, State> moveTable = new HashMap<String, State>();
        moveTable.put("Uw", moveUw);
        moveTable.put("Uw2", moveUw.multiply(moveUw));
        moveTable.put("Uw'", moveUw.multiply(moveUw).multiply(moveUw));
        moveTable.put("Dw", moveDw);
        moveTable.put("Dw2", moveDw.multiply(moveDw));
        moveTable.put("Dw'", moveDw.multiply(moveDw).multiply(moveDw));
        moveTable.put("Lw", moveLw);
        moveTable.put("Lw2", moveLw.multiply(moveLw));
        moveTable.put("Lw'", moveLw.multiply(moveLw).multiply(moveLw));
        moveTable.put("Rw", moveRw);
        moveTable.put("Rw2", moveRw.multiply(moveRw));
        moveTable.put("Rw'", moveRw.multiply(moveRw).multiply(moveRw));
        moveTable.put("Fw", moveFw);
        moveTable.put("Fw2", moveFw.multiply(moveFw));
        moveTable.put("Fw'", moveFw.multiply(moveFw).multiply(moveFw));
        moveTable.put("Bw", moveBw);
        moveTable.put("Bw2", moveBw.multiply(moveBw));
        moveTable.put("Bw'", moveBw.multiply(moveBw).multiply(moveBw));
        byte[] byArray11 = new byte[8];
        byArray11[1] = 1;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 4;
        byArray11[5] = 5;
        byArray11[6] = 6;
        byArray11[7] = 7;
        State state = new State(byArray11, new byte[8]);
        for (String move : moves) {
            byte[] validOrientation = null;
            if (move.equals("U") || move.equals("U2") || move.equals("U'")) {
                byte[] byArray12 = new byte[8];
                byArray12[4] = -1;
                byArray12[5] = -1;
                byArray12[6] = -1;
                byArray12[7] = -1;
                validOrientation = byArray12;
            }
            if (move.equals("D") || move.equals("D2") || move.equals("D'")) {
                byte[] byArray13 = new byte[8];
                byArray13[0] = -1;
                byArray13[1] = -1;
                byArray13[2] = -1;
                byArray13[3] = -1;
                validOrientation = byArray13;
            }
            if (move.equals("L") || move.equals("L2") || move.equals("R'")) {
                validOrientation = new byte[]{1, -1, -1, 2, 2, -1, -1, 1};
            }
            if (move.equals("R") || move.equals("R2") || move.equals("R'")) {
                validOrientation = new byte[]{-1, 2, 1, -1, -1, 1, 2, -1};
            }
            if (move.equals("F") || move.equals("F2") || move.equals("F'")) {
                validOrientation = new byte[]{-1, -1, 2, 1, -1, -1, 1, 2};
            }
            if (move.equals("B") || move.equals("B2") || move.equals("B'")) {
                validOrientation = new byte[]{2, 1, -1, -1, 1, 2, -1, -1};
            }
            if (validOrientation != null) {
                int i = 0;
                while (i < state.edgesOrientation.length) {
                    if (validOrientation[i] != -1 && state.edgesOrientation[i] != validOrientation[i]) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            state = state.multiply((State)moveTable.get(move));
        }
        return true;
    }

    private class State {
        public byte[] edgesPermutation;
        public byte[] edgesOrientation;

        public State(byte[] permutation, byte[] orientation) {
            this.edgesOrientation = orientation;
            this.edgesPermutation = permutation;
        }

        public State multiply(State move) {
            byte[] edgesPermutation = new byte[8];
            byte[] edgesOrientation = new byte[8];
            int i = 0;
            while (i < 8) {
                edgesPermutation[i] = this.edgesPermutation[move.edgesPermutation[i]];
                edgesOrientation[i] = (byte)((this.edgesOrientation[move.edgesPermutation[i]] + move.edgesOrientation[i]) % 3);
                ++i;
            }
            return new State(edgesPermutation, edgesOrientation);
        }
    }
}

