/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.geometry.Plane;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class Megaminx
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("MEGAMINX", "Megaminx");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-1").getColor(), colorScheme.getFaceColor("FACE-2").getColor(), colorScheme.getFaceColor("FACE-3").getColor(), colorScheme.getFaceColor("FACE-4").getColor(), colorScheme.getFaceColor("FACE-5").getColor(), colorScheme.getFaceColor("FACE-6").getColor(), colorScheme.getFaceColor("FACE-7").getColor(), colorScheme.getFaceColor("FACE-8").getColor(), colorScheme.getFaceColor("FACE-9").getColor(), colorScheme.getFaceColor("FACE-10").getColor(), colorScheme.getFaceColor("FACE-11").getColor(), colorScheme.getFaceColor("FACE-12").getColor()};
        Mesh mesh = Mesh.dodecahedron(colorArray).shortenFaces(0.025);
        Plane[] planes = new Plane[mesh.faces.size()];
        int i = 0;
        while (i < mesh.faces.size()) {
            Plane p = Plane.fromVectors(mesh.vertices.get(mesh.faces.get((int)i).vertexIndices.get(0)), mesh.vertices.get(mesh.faces.get((int)i).vertexIndices.get(1)), mesh.vertices.get(mesh.faces.get((int)i).vertexIndices.get(2)));
            planes[i] = new Plane(p.p.sub(p.n.mul(0.25)), p.n);
            ++i;
        }
        Plane[] planeArray = planes;
        int n = planes.length;
        int p = 0;
        while (p < n) {
            Plane plane = planeArray[p];
            mesh = mesh.cut(plane, 0.03);
            ++p;
        }
        mesh = mesh.softenFaces(0.01).softenFaces(0.005);
        Plane planeR = new Plane(planes[3].p, planes[3].n.neg());
        Plane planeD = new Plane(planes[7].p, planes[7].n.neg());
        Plane planeU = planes[7];
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("R++", new Twist(planeR, 2.5132741228718345));
        twists.put("R--", new Twist(planeR, -2.5132741228718345));
        twists.put("D++", new Twist(planeD, 2.5132741228718345));
        twists.put("D--", new Twist(planeD, -2.5132741228718345));
        twists.put("U", new Twist(planeU, 1.2566370614359172));
        twists.put("U'", new Twist(planeU, -1.2566370614359172));
        String[] stringArray = sequence;
        int n2 = sequence.length;
        int n3 = 0;
        while (n3 < n2) {
            String move = stringArray[n3];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.transformHalfspace(Matrix44.rotation(t.plane.n, t.angle), t.plane);
            ++n3;
        }
        return mesh.transform(Matrix44.rotationY(0.19634954084936207));
    }

    private static class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

