/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.graphics.geometry.Plane;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class RubiksTower
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("RUBIKS-TOWER", "Rubik's tower");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor(), colorScheme.getFaceColor("FACE-D").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-F").getColor(), colorScheme.getFaceColor("FACE-U").getColor()};
        Mesh mesh = Mesh.cube(colorArray).transform(new Matrix44(new double[][]{{0.5, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.5, 0.0}, {0.0, 0.0, 0.0, 1.0}}));
        Plane planeL = new Plane(new Vector3(-0.25, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeLw = new Plane(new Vector3(-0.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeR = new Plane(new Vector3(0.25, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeRw = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeD = new Plane(new Vector3(0.0, -0.25, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeDw = new Plane(new Vector3(0.0, -0.0, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeU = new Plane(new Vector3(0.0, 0.25, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeUw = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeF = new Plane(new Vector3(0.0, 0.0, -0.25), new Vector3(0.0, 0.0, -1.0));
        Plane planeFw = new Plane(new Vector3(0.0, 0.0, -0.0), new Vector3(0.0, 0.0, -1.0));
        Plane planeB = new Plane(new Vector3(0.0, 0.0, 0.25), new Vector3(0.0, 0.0, 1.0));
        Plane planeBw = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        mesh = mesh.cut(planeLw, 0.0).cut(planeUw, 0.0).cut(planeFw, 0.0).cut(planeU, 0.0).cut(planeD, 0.0).shortenFaces(0.025).softenFaces(0.015).softenFaces(0.005);
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("L", new Twist(planeL, 1.5707963267948966));
        twists.put("Lw", new Twist(planeLw, 1.5707963267948966));
        twists.put("L2", new Twist(planeL, Math.PI));
        twists.put("Lw2", new Twist(planeLw, Math.PI));
        twists.put("L'", new Twist(planeL, -1.5707963267948966));
        twists.put("Lw'", new Twist(planeLw, -1.5707963267948966));
        twists.put("R", new Twist(planeR, 1.5707963267948966));
        twists.put("Rw", new Twist(planeRw, 1.5707963267948966));
        twists.put("R2", new Twist(planeR, Math.PI));
        twists.put("Rw2", new Twist(planeRw, Math.PI));
        twists.put("R'", new Twist(planeR, -1.5707963267948966));
        twists.put("Rw'", new Twist(planeRw, -1.5707963267948966));
        twists.put("D", new Twist(planeD, 1.5707963267948966));
        twists.put("Dw", new Twist(planeDw, 1.5707963267948966));
        twists.put("D2", new Twist(planeD, Math.PI));
        twists.put("Dw2", new Twist(planeDw, Math.PI));
        twists.put("D'", new Twist(planeD, -1.5707963267948966));
        twists.put("Dw'", new Twist(planeDw, -1.5707963267948966));
        twists.put("U", new Twist(planeU, 1.5707963267948966));
        twists.put("Uw", new Twist(planeUw, 1.5707963267948966));
        twists.put("U2", new Twist(planeU, Math.PI));
        twists.put("Uw2", new Twist(planeUw, Math.PI));
        twists.put("U'", new Twist(planeU, -1.5707963267948966));
        twists.put("Uw'", new Twist(planeUw, -1.5707963267948966));
        twists.put("F", new Twist(planeF, 1.5707963267948966));
        twists.put("Fw", new Twist(planeFw, 1.5707963267948966));
        twists.put("F2", new Twist(planeF, Math.PI));
        twists.put("Fw2", new Twist(planeFw, Math.PI));
        twists.put("F'", new Twist(planeF, -1.5707963267948966));
        twists.put("Fw'", new Twist(planeFw, -1.5707963267948966));
        twists.put("B", new Twist(planeB, 1.5707963267948966));
        twists.put("Bw", new Twist(planeBw, 1.5707963267948966));
        twists.put("B2", new Twist(planeB, Math.PI));
        twists.put("Bw2", new Twist(planeBw, Math.PI));
        twists.put("B'", new Twist(planeB, -1.5707963267948966));
        twists.put("Bw'", new Twist(planeBw, -1.5707963267948966));
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.transformHalfspace(Matrix44.rotation(t.plane.n, t.angle), t.plane);
            ++n2;
        }
        return mesh.transform(new Matrix44(new double[][]{{1.4, 0.0, 0.0, 0.0}, {0.0, 1.4, 0.0, 0.0}, {0.0, 0.0, 1.4, 0.0}, {0.0, 0.0, 0.0, 1.0}})).transform(Matrix44.rotationY(-0.5235987755982988)).transform(Matrix44.rotationX(0.4487989505128276));
    }

    private class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

