/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.graphics.geometry.Plane;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Square1
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("SQUARE-1", "Square-1");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor(), colorScheme.getFaceColor("FACE-D").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-F").getColor(), colorScheme.getFaceColor("FACE-U").getColor()};
        Mesh cube = Mesh.cube(colorArray);
        Plane planeD = new Plane(new Vector3(0.0, -0.166, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeU = new Plane(new Vector3(0.0, 0.166, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeR = new Plane(new Vector3(0.0, 0.0, 0.0), Matrix44.rotationY(-0.2617993877991494).mul(new Vector3(1.0, 0.0, 0.0)));
        Plane p1 = new Plane(new Vector3(0.0, 0.0, 0.0), Matrix44.rotationY(0.2617993877991494).mul(new Vector3(1.0, 0.0, 0.0)));
        Plane p2 = new Plane(new Vector3(0.0, 0.0, 0.0), Matrix44.rotationY(-0.2617993877991494).mul(new Vector3(0.0, 0.0, 1.0)));
        Plane p3 = new Plane(new Vector3(0.0, 0.0, 0.0), Matrix44.rotationY(0.2617993877991494).mul(new Vector3(0.0, 0.0, 1.0)));
        Mesh mesh = cube.cut(planeD, 0.01).cut(planeU, 0.01).cut(planeR, 0.01).cut(p1, 0.01).cut(p2, 0.01).cut(p3, 0.01).shortenFaces(0.02).softenFaces(0.015).softenFaces(0.005);
        Mesh topLayer = mesh.clip(planeU);
        Mesh bottomLayer = mesh.clip(planeD);
        Mesh bandagedMesh = cube.cut(planeD, 0.01).cut(planeU, 0.01).cut(planeR, 0.01).shortenFaces(0.02).softenFaces(0.015).softenFaces(0.005);
        Mesh middleLayer = bandagedMesh.clip(new Plane(planeU.p, planeU.n.neg())).clip(new Plane(planeD.p, planeD.n.neg()));
        cube = topLayer.union(middleLayer).union(bottomLayer);
        Pattern p = Pattern.compile("\\((-?\\d+),(-?\\d+)\\)");
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            if (m.equals("/")) {
                cube = cube.transformHalfspace(Matrix44.rotation(planeR.n, Math.PI), planeR);
            } else {
                Matcher matcher = p.matcher(m.toString());
                matcher.find();
                int top = Integer.parseInt(matcher.group(1));
                cube = cube.transformHalfspace(Matrix44.rotation(planeU.n, (double)top * Math.PI / 6.0), planeU);
                int bottom = Integer.parseInt(matcher.group(2));
                cube = cube.transformHalfspace(Matrix44.rotation(planeD.n, (double)bottom * Math.PI / 6.0), planeD);
            }
            ++n2;
        }
        return cube.transform(Matrix44.rotationY(-0.5235987755982988)).transform(Matrix44.rotationX(0.4487989505128276));
    }
}

