/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.graphics.geometry.Plane;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class VCube6
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("6x6x6-CUBE", "6x6x6 cube");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor(), colorScheme.getFaceColor("FACE-D").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-F").getColor(), colorScheme.getFaceColor("FACE-U").getColor()};
        Mesh mesh = Mesh.cube(colorArray);
        Plane planeL = new Plane(new Vector3(-0.3333, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeL2 = new Plane(new Vector3(-0.1666, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeL3 = new Plane(new Vector3(-0.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeR3 = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeR2 = new Plane(new Vector3(0.1666, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeR = new Plane(new Vector3(0.3333, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeD = new Plane(new Vector3(0.0, -0.3333, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeD2 = new Plane(new Vector3(0.0, -0.1666, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeD3 = new Plane(new Vector3(0.0, -0.0, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeU3 = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeU2 = new Plane(new Vector3(0.0, 0.1666, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeU = new Plane(new Vector3(0.0, 0.3333, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeF = new Plane(new Vector3(0.0, 0.0, -0.3333), new Vector3(0.0, 0.0, -1.0));
        Plane planeF2 = new Plane(new Vector3(0.0, 0.0, -0.1666), new Vector3(0.0, 0.0, -1.0));
        Plane planeF3 = new Plane(new Vector3(0.0, 0.0, -0.0), new Vector3(0.0, 0.0, -1.0));
        Plane planeB3 = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        Plane planeB2 = new Plane(new Vector3(0.0, 0.0, 0.1666), new Vector3(0.0, 0.0, 1.0));
        Plane planeB = new Plane(new Vector3(0.0, 0.0, 0.3333), new Vector3(0.0, 0.0, 1.0));
        mesh = mesh.cut(planeL, 0.0).cut(planeL2, 0.0).cut(planeL3, 0.0).cut(planeR2, 0.0).cut(planeR, 0.0).cut(planeD, 0.0).cut(planeD2, 0.0).cut(planeD3, 0.0).cut(planeU2, 0.0).cut(planeU, 0.0).cut(planeF, 0.0).cut(planeF2, 0.0).cut(planeF3, 0.0).cut(planeB2, 0.0).cut(planeB, 0.0).shortenFaces(0.0175).softenFaces(0.01).softenFaces(0.005);
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("L", new Twist(planeL, 1.5707963267948966));
        twists.put("2L", new Twist(planeL2, 1.5707963267948966));
        twists.put("3L", new Twist(planeL3, 1.5707963267948966));
        twists.put("L2", new Twist(planeL, Math.PI));
        twists.put("2L2", new Twist(planeL2, Math.PI));
        twists.put("3L2", new Twist(planeL3, Math.PI));
        twists.put("L'", new Twist(planeL, -1.5707963267948966));
        twists.put("2L'", new Twist(planeL2, -1.5707963267948966));
        twists.put("3L'", new Twist(planeL3, -1.5707963267948966));
        twists.put("R", new Twist(planeR, 1.5707963267948966));
        twists.put("2R", new Twist(planeR2, 1.5707963267948966));
        twists.put("3R", new Twist(planeR3, 1.5707963267948966));
        twists.put("R2", new Twist(planeR, Math.PI));
        twists.put("2R2", new Twist(planeR2, Math.PI));
        twists.put("3R2", new Twist(planeR3, Math.PI));
        twists.put("R'", new Twist(planeR, -1.5707963267948966));
        twists.put("2R'", new Twist(planeR2, -1.5707963267948966));
        twists.put("3R'", new Twist(planeR3, -1.5707963267948966));
        twists.put("D", new Twist(planeD, 1.5707963267948966));
        twists.put("2D", new Twist(planeD2, 1.5707963267948966));
        twists.put("3D", new Twist(planeD3, 1.5707963267948966));
        twists.put("D2", new Twist(planeD, Math.PI));
        twists.put("2D2", new Twist(planeD2, Math.PI));
        twists.put("3D2", new Twist(planeD3, Math.PI));
        twists.put("D'", new Twist(planeD, -1.5707963267948966));
        twists.put("2D'", new Twist(planeD2, -1.5707963267948966));
        twists.put("3D'", new Twist(planeD3, -1.5707963267948966));
        twists.put("U", new Twist(planeU, 1.5707963267948966));
        twists.put("2U", new Twist(planeU2, 1.5707963267948966));
        twists.put("3U", new Twist(planeU3, 1.5707963267948966));
        twists.put("U2", new Twist(planeU, Math.PI));
        twists.put("2U2", new Twist(planeU2, Math.PI));
        twists.put("3U2", new Twist(planeU3, Math.PI));
        twists.put("U'", new Twist(planeU, -1.5707963267948966));
        twists.put("2U'", new Twist(planeU2, -1.5707963267948966));
        twists.put("3U'", new Twist(planeU3, -1.5707963267948966));
        twists.put("F", new Twist(planeF, 1.5707963267948966));
        twists.put("2F", new Twist(planeF2, 1.5707963267948966));
        twists.put("3F", new Twist(planeF3, 1.5707963267948966));
        twists.put("F2", new Twist(planeF, Math.PI));
        twists.put("2F2", new Twist(planeF2, Math.PI));
        twists.put("3F2", new Twist(planeF3, Math.PI));
        twists.put("F'", new Twist(planeF, -1.5707963267948966));
        twists.put("2F'", new Twist(planeF2, -1.5707963267948966));
        twists.put("3F'", new Twist(planeF3, -1.5707963267948966));
        twists.put("B", new Twist(planeB, 1.5707963267948966));
        twists.put("2B", new Twist(planeB2, 1.5707963267948966));
        twists.put("3B", new Twist(planeB3, 1.5707963267948966));
        twists.put("B2", new Twist(planeB, Math.PI));
        twists.put("2B2", new Twist(planeB2, Math.PI));
        twists.put("3B2", new Twist(planeB3, Math.PI));
        twists.put("B'", new Twist(planeB, -1.5707963267948966));
        twists.put("2B'", new Twist(planeB2, -1.5707963267948966));
        twists.put("3B'", new Twist(planeB3, -1.5707963267948966));
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.transformHalfspace(Matrix44.rotation(t.plane.n, t.angle), t.plane);
            ++n2;
        }
        return mesh.transform(Matrix44.rotationY(-0.5235987755982988)).transform(Matrix44.rotationX(0.4487989505128276));
    }

    private class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

