/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.RubiksCubeRandomScrambler;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.IndexMapping;
import com.puzzletimer.solvers.RubiksCubeCrossSolver;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.Random;

public class RubiksCubeEasyCrossScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private int maxDistance;
    private Random random;

    public RubiksCubeEasyCrossScrambler(ScramblerInfo scramblerInfo, int maxDistance) {
        this.scramblerInfo = scramblerInfo;
        this.maxDistance = maxDistance;
        this.random = new Random();
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        int orientation;
        int permutation;
        int combination;
        while (RubiksCubeCrossSolver.distance[combination = this.random.nextInt(495)][permutation = this.random.nextInt(24)][orientation = this.random.nextInt(16)] > this.maxDistance) {
        }
        RubiksCubeCrossSolver.State crossState = new RubiksCubeCrossSolver.State(IndexMapping.indexToCombination(combination, 4, 12), IndexMapping.indexToPermutation(permutation, 4), IndexMapping.indexToOrientation(orientation, 2, 4));
        byte[] byArray = new byte[12];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        RubiksCubeSolver.State cubeState = new RubiksCubeSolver.State(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, -1, -1, -1, -1}, byArray);
        cubeState = cubeState.applySequence(RubiksCubeCrossSolver.generate(crossState));
        RubiksCubeRandomScrambler scrambler = new RubiksCubeRandomScrambler(this.getScramblerInfo(), cubeState.cornersPermutation, cubeState.cornersOrientation, cubeState.edgesPermutation, cubeState.edgesOrientation);
        return scrambler.getNextScramble();
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

