/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class PyraminxSolver {
    public final int N_TIPS_ORIENTATIONS = 81;
    public final int N_VERTICES_ORIENTATIONS = 81;
    public final int N_EDGES_PERMUTATIONS = 360;
    public final int N_EDGES_ORIENTATIONS = 32;
    private int minScrambleLength;
    private boolean initialized;
    private State[] tipMoves;
    private String[] tipMoveNames;
    private State[] moves;
    private String[] moveNames;
    private int[][] tipsOrientationMove;
    private int[][] verticesOrientationMove;
    private int[][] edgesPermutationMove;
    private int[][] edgesOrientationMove;
    private byte[] tipsOrientationDistance;
    private byte[] verticesOrientationDistance;
    private byte[] edgesPermutationDistance;
    private byte[] edgesOrientationDistance;

    public PyraminxSolver(int minScrambleLength) {
        this.minScrambleLength = minScrambleLength;
        this.initialized = false;
    }

    private void initialize() {
        int next;
        int k;
        int i;
        int nVisited;
        int j;
        State state;
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byte[] byArray2 = new byte[6];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        State moveu = new State(byArray, new byte[4], byArray2, new byte[6]);
        byte[] byArray3 = new byte[4];
        byArray3[1] = 1;
        byte[] byArray4 = new byte[6];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = 4;
        byArray4[5] = 5;
        State movel = new State(byArray3, new byte[4], byArray4, new byte[6]);
        byte[] byArray5 = new byte[4];
        byArray5[2] = 1;
        byte[] byArray6 = new byte[6];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[3] = 3;
        byArray6[4] = 4;
        byArray6[5] = 5;
        State mover = new State(byArray5, new byte[4], byArray6, new byte[6]);
        byte[] byArray7 = new byte[4];
        byArray7[3] = 1;
        byte[] byArray8 = new byte[6];
        byArray8[1] = 1;
        byArray8[2] = 2;
        byArray8[3] = 3;
        byArray8[4] = 4;
        byArray8[5] = 5;
        State moveb = new State(byArray7, new byte[4], byArray8, new byte[6]);
        this.tipMoves = new State[]{moveu, moveu.multiply(moveu), movel, movel.multiply(movel), mover, mover.multiply(mover), moveb, moveb.multiply(moveb)};
        this.tipMoveNames = new String[]{"u", "u'", "l", "l'", "r", "r'", "b", "b'"};
        byte[] byArray9 = new byte[4];
        byArray9[0] = 1;
        byte[] byArray10 = new byte[4];
        byArray10[0] = 1;
        byte[] byArray11 = new byte[6];
        byArray11[0] = 2;
        byArray11[2] = 1;
        byArray11[3] = 3;
        byArray11[4] = 4;
        byArray11[5] = 5;
        State moveU = new State(byArray9, byArray10, byArray11, new byte[6]);
        byte[] byArray12 = new byte[4];
        byArray12[1] = 1;
        byte[] byArray13 = new byte[4];
        byArray13[1] = 1;
        byte[] byArray14 = new byte[6];
        byArray14[1] = 1;
        byArray14[2] = 5;
        byArray14[3] = 3;
        byArray14[4] = 2;
        byArray14[5] = 4;
        byte[] byArray15 = new byte[6];
        byArray15[2] = 1;
        byArray15[5] = 1;
        State moveL = new State(byArray12, byArray13, byArray14, byArray15);
        byte[] byArray16 = new byte[4];
        byArray16[2] = 1;
        byte[] byArray17 = new byte[4];
        byArray17[2] = 1;
        byte[] byArray18 = new byte[6];
        byArray18[1] = 4;
        byArray18[2] = 2;
        byArray18[3] = 1;
        byArray18[4] = 3;
        byArray18[5] = 5;
        byte[] byArray19 = new byte[6];
        byArray19[1] = 1;
        byArray19[4] = 1;
        State moveR = new State(byArray16, byArray17, byArray18, byArray19);
        byte[] byArray20 = new byte[4];
        byArray20[3] = 1;
        byte[] byArray21 = new byte[4];
        byArray21[3] = 1;
        byte[] byArray22 = new byte[6];
        byArray22[0] = 3;
        byArray22[1] = 1;
        byArray22[2] = 2;
        byArray22[3] = 5;
        byArray22[4] = 4;
        byte[] byArray23 = new byte[6];
        byArray23[0] = 1;
        byArray23[3] = 1;
        State moveB = new State(byArray20, byArray21, byArray22, byArray23);
        this.moves = new State[]{moveU, moveU.multiply(moveU), moveL, moveL.multiply(moveL), moveR, moveR.multiply(moveR), moveB, moveB.multiply(moveB)};
        this.moveNames = new String[]{"U", "U'", "L", "L'", "R", "R'", "B", "B'"};
        this.tipsOrientationMove = new int[81][this.tipMoveNames.length];
        int i2 = 0;
        while (i2 < this.tipsOrientationMove.length) {
            state = new State(IndexMapping.indexToOrientation(i2, 3, 4), new byte[4], new byte[6], new byte[6]);
            j = 0;
            while (j < this.moves.length) {
                this.tipsOrientationMove[i2][j] = IndexMapping.orientationToIndex(state.multiply((State)this.tipMoves[j]).tipsOrientation, 3);
                ++j;
            }
            ++i2;
        }
        this.verticesOrientationMove = new int[81][this.moves.length];
        i2 = 0;
        while (i2 < this.verticesOrientationMove.length) {
            state = new State(new byte[4], IndexMapping.indexToOrientation(i2, 3, 4), new byte[6], new byte[6]);
            j = 0;
            while (j < this.moves.length) {
                this.verticesOrientationMove[i2][j] = IndexMapping.orientationToIndex(state.multiply((State)this.moves[j]).verticesOrientation, 3);
                ++j;
            }
            ++i2;
        }
        this.edgesPermutationMove = new int[360][this.moves.length];
        i2 = 0;
        while (i2 < this.edgesPermutationMove.length) {
            state = new State(new byte[4], new byte[4], IndexMapping.indexToEvenPermutation(i2, 6), new byte[6]);
            j = 0;
            while (j < this.moves.length) {
                this.edgesPermutationMove[i2][j] = IndexMapping.evenPermutationToIndex(state.multiply((State)this.moves[j]).edgesPermutation);
                ++j;
            }
            ++i2;
        }
        this.edgesOrientationMove = new int[32][this.moves.length];
        i2 = 0;
        while (i2 < this.edgesOrientationMove.length) {
            state = new State(new byte[4], new byte[4], new byte[6], IndexMapping.indexToZeroSumOrientation(i2, 2, 6));
            j = 0;
            while (j < this.moves.length) {
                this.edgesOrientationMove[i2][j] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)this.moves[j]).edgesOrientation, 2);
                ++j;
            }
            ++i2;
        }
        this.tipsOrientationDistance = new byte[81];
        i2 = 0;
        while (i2 < this.tipsOrientationDistance.length) {
            this.tipsOrientationDistance[i2] = -1;
            ++i2;
        }
        this.tipsOrientationDistance[0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.tipsOrientationDistance.length) {
                if (this.tipsOrientationDistance[i] == depth) {
                    k = 0;
                    while (k < this.tipMoves.length) {
                        next = this.tipsOrientationMove[i][k];
                        if (this.tipsOrientationDistance[next] < 0) {
                            this.tipsOrientationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.verticesOrientationDistance = new byte[81];
        i = 0;
        while (i < this.verticesOrientationDistance.length) {
            this.verticesOrientationDistance[i] = -1;
            ++i;
        }
        this.verticesOrientationDistance[0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.verticesOrientationDistance.length) {
                if (this.verticesOrientationDistance[i] == depth) {
                    k = 0;
                    while (k < this.moves.length) {
                        next = this.verticesOrientationMove[i][k];
                        if (this.verticesOrientationDistance[next] < 0) {
                            this.verticesOrientationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.edgesPermutationDistance = new byte[360];
        i = 0;
        while (i < this.edgesPermutationDistance.length) {
            this.edgesPermutationDistance[i] = -1;
            ++i;
        }
        this.edgesPermutationDistance[0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.edgesPermutationDistance.length) {
                if (this.edgesPermutationDistance[i] == depth) {
                    k = 0;
                    while (k < this.moves.length) {
                        next = this.edgesPermutationMove[i][k];
                        if (this.edgesPermutationDistance[next] < 0) {
                            this.edgesPermutationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.edgesOrientationDistance = new byte[32];
        i = 0;
        while (i < this.edgesOrientationDistance.length) {
            this.edgesOrientationDistance[i] = -1;
            ++i;
        }
        this.edgesOrientationDistance[0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.edgesOrientationDistance.length) {
                if (this.edgesOrientationDistance[i] == depth) {
                    k = 0;
                    while (k < this.moves.length) {
                        next = this.edgesOrientationMove[i][k];
                        if (this.edgesOrientationDistance[next] < 0) {
                            this.edgesOrientationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.initialized = true;
    }

    private String[] solveTips(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        int tipsOrientation = IndexMapping.orientationToIndex(state.tipsOrientation, 3);
        int depth = 0;
        while (true) {
            ArrayList<String> solution;
            if (this.searchTips(tipsOrientation, depth, solution = new ArrayList<String>(), -1)) {
                String[] sequence = new String[solution.size()];
                solution.toArray(sequence);
                return sequence;
            }
            ++depth;
        }
    }

    private boolean searchTips(int tipsOrientation, int depth, ArrayList<String> solution, int lastVertex) {
        if (depth == 0) {
            return tipsOrientation == 0;
        }
        if (this.tipsOrientationDistance[tipsOrientation] <= depth) {
            int i = 0;
            while (i < this.tipMoves.length) {
                if (i / 2 != lastVertex) {
                    solution.add(this.tipMoveNames[i]);
                    if (this.searchTips(this.tipsOrientationMove[tipsOrientation][i], depth - 1, solution, i / 2)) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    private String[] solve(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        int verticesOrientation = IndexMapping.orientationToIndex(state.verticesOrientation, 3);
        int edgesPermutation = IndexMapping.evenPermutationToIndex(state.edgesPermutation);
        int edgesOrientation = IndexMapping.zeroSumOrientationToIndex(state.edgesOrientation, 2);
        int depth = this.minScrambleLength;
        while (true) {
            ArrayList<String> solution;
            if (this.search(verticesOrientation, edgesPermutation, edgesOrientation, depth, solution = new ArrayList<String>(), -1)) {
                String[] sequence = new String[solution.size()];
                solution.toArray(sequence);
                return sequence;
            }
            ++depth;
        }
    }

    private boolean search(int verticesOrientation, int edgesPermutation, int edgesOrientation, int depth, ArrayList<String> solution, int lastVertex) {
        if (depth == 0) {
            return verticesOrientation == 0 && edgesPermutation == 0 && edgesOrientation == 0;
        }
        if (this.verticesOrientationDistance[verticesOrientation] <= depth && this.edgesPermutationDistance[edgesPermutation] <= depth && this.edgesOrientationDistance[edgesOrientation] <= depth) {
            int i = 0;
            while (i < this.moves.length) {
                if (i / 2 != lastVertex) {
                    solution.add(this.moveNames[i]);
                    if (this.search(this.verticesOrientationMove[verticesOrientation][i], this.edgesPermutationMove[edgesPermutation][i], this.edgesOrientationMove[edgesOrientation][i], depth - 1, solution, i / 2)) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    public String[] generate(State state) {
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("u", "u'");
        inverseMoveNames.put("u'", "u");
        inverseMoveNames.put("l", "l'");
        inverseMoveNames.put("l'", "l");
        inverseMoveNames.put("r", "r'");
        inverseMoveNames.put("r'", "r");
        inverseMoveNames.put("b", "b'");
        inverseMoveNames.put("b'", "b");
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("L", "L'");
        inverseMoveNames.put("L'", "L");
        inverseMoveNames.put("R", "R'");
        inverseMoveNames.put("R'", "R");
        inverseMoveNames.put("B", "B'");
        inverseMoveNames.put("B'", "B");
        String[] solution = this.solve(state);
        HashMap<String, State> moves = new HashMap<String, State>();
        moves.put("U", this.moves[0]);
        moves.put("U'", this.moves[1]);
        moves.put("L", this.moves[2]);
        moves.put("L'", this.moves[3]);
        moves.put("R", this.moves[4]);
        moves.put("R'", this.moves[5]);
        moves.put("B", this.moves[6]);
        moves.put("B'", this.moves[7]);
        String[] stringArray = solution;
        int n = solution.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            state = state.multiply((State)moves.get(move));
            ++n2;
        }
        String[] tipsSolution = this.solveTips(state);
        String[] sequence = new String[tipsSolution.length + solution.length];
        int i = 0;
        while (i < solution.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - 1 - i]);
            ++i;
        }
        i = 0;
        while (i < tipsSolution.length) {
            sequence[solution.length + i] = (String)inverseMoveNames.get(tipsSolution[tipsSolution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public State getRandomState(Random random) {
        int tipsOrientation = random.nextInt(81);
        int verticesOrientation = random.nextInt(81);
        int edgesPermutation = random.nextInt(360);
        int edgesOrientation = random.nextInt(32);
        return new State(IndexMapping.indexToOrientation(tipsOrientation, 3, 4), IndexMapping.indexToOrientation(verticesOrientation, 3, 4), IndexMapping.indexToEvenPermutation(edgesPermutation, 6), IndexMapping.indexToZeroSumOrientation(edgesOrientation, 2, 6));
    }

    public static class State {
        public byte[] tipsOrientation;
        public byte[] verticesOrientation;
        public byte[] edgesPermutation;
        public byte[] edgesOrientation;

        public State(byte[] tipsOrientation, byte[] verticesOrientation, byte[] edgesPermutation, byte[] edgesOrientation) {
            this.tipsOrientation = tipsOrientation;
            this.verticesOrientation = verticesOrientation;
            this.edgesPermutation = edgesPermutation;
            this.edgesOrientation = edgesOrientation;
        }

        public State multiply(State move) {
            byte[] tipsOrientation = new byte[4];
            int i = 0;
            while (i < 4) {
                tipsOrientation[i] = (byte)((this.tipsOrientation[i] + move.tipsOrientation[i]) % 3);
                ++i;
            }
            byte[] verticesOrientation = new byte[4];
            int i2 = 0;
            while (i2 < 4) {
                verticesOrientation[i2] = (byte)((this.verticesOrientation[i2] + move.verticesOrientation[i2]) % 3);
                ++i2;
            }
            byte[] edgesPermutation = new byte[6];
            byte[] edgesOrientation = new byte[6];
            int i3 = 0;
            while (i3 < 6) {
                edgesPermutation[i3] = this.edgesPermutation[move.edgesPermutation[i3]];
                edgesOrientation[i3] = (byte)((this.edgesOrientation[move.edgesPermutation[i3]] + move.edgesOrientation[i3]) % 2);
                ++i3;
            }
            return new State(tipsOrientation, verticesOrientation, edgesPermutation, edgesOrientation);
        }
    }
}

