/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import java.util.Random;

public class RubiksClockSolver {
    public static String[] generate(State state) {
        int[][] nArrayArray = new int[14][];
        int[] nArray = new int[14];
        nArray[4] = 1;
        nArray[7] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[14];
        nArray2[9] = 1;
        nArray2[11] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[14];
        nArray3[3] = -1;
        nArray3[4] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[14];
        nArray4[10] = 1;
        nArray4[11] = -1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[14];
        nArray5[1] = -1;
        nArray5[4] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[14];
        nArray6[11] = -1;
        nArray6[13] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[14];
        nArray7[4] = 1;
        nArray7[5] = -1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[14];
        nArray8[11] = -1;
        nArray8[12] = 1;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[14];
        nArray9[0] = -1;
        nArray9[1] = 1;
        nArray9[3] = 1;
        nArray9[4] = -1;
        nArray9[9] = -1;
        nArray9[11] = 1;
        nArray9[12] = -1;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[14];
        nArray10[1] = 1;
        nArray10[2] = -1;
        nArray10[4] = -1;
        nArray10[5] = 1;
        nArray10[9] = -1;
        nArray10[10] = -1;
        nArray10[11] = 1;
        nArrayArray[9] = nArray10;
        int[] nArray11 = new int[14];
        nArray11[4] = -1;
        nArray11[5] = 1;
        nArray11[7] = 1;
        nArray11[8] = -1;
        nArray11[10] = -1;
        nArray11[11] = 1;
        nArray11[13] = -1;
        nArrayArray[10] = nArray11;
        int[] nArray12 = new int[14];
        nArray12[3] = 1;
        nArray12[4] = -1;
        nArray12[6] = -1;
        nArray12[7] = 1;
        nArray12[11] = 1;
        nArray12[12] = -1;
        nArray12[13] = -1;
        nArrayArray[11] = nArray12;
        nArrayArray[12] = new int[]{1, -1, 1, -1, 1, -1, 1, -1, 1, 2, 2, -4, 2, 2};
        int[] nArray13 = new int[14];
        nArray13[9] = -1;
        nArray13[10] = -1;
        nArray13[11] = 3;
        nArray13[12] = -1;
        nArray13[13] = -1;
        nArrayArray[13] = nArray13;
        int[][] inverseMatrix = nArrayArray;
        int[] nArray14 = new int[14];
        nArray14[1] = 1;
        nArray14[2] = 2;
        nArray14[3] = 3;
        nArray14[4] = 4;
        nArray14[5] = 5;
        nArray14[6] = 6;
        nArray14[7] = 7;
        nArray14[8] = 8;
        nArray14[9] = 10;
        nArray14[10] = 12;
        nArray14[11] = 13;
        nArray14[12] = 14;
        nArray14[13] = 17;
        int[] independentClocks = nArray14;
        int[] turns = new int[14];
        int i = 0;
        while (i < 14) {
            turns[i] = 0;
            int j = 0;
            while (j < 14) {
                int n = i;
                turns[n] = turns[n] + inverseMatrix[i][j] * state.clocks[independentClocks[j]];
                ++j;
            }
            while (turns[i] < -5 || turns[i] > 6) {
                if (turns[i] < 0) {
                    int n = i;
                    turns[n] = turns[n] + 12;
                    continue;
                }
                int n = i;
                turns[n] = turns[n] - 12;
            }
            ++i;
        }
        String[] sequence = new String[]{"UUdd u=" + turns[0] + ",d=" + turns[1], "dUdU u=" + turns[2] + ",d=" + turns[3], "ddUU u=" + turns[4] + ",d=" + turns[5], "UdUd u=" + turns[6] + ",d=" + turns[7], "dUUU u=" + turns[8], "UdUU u=" + turns[9], "UUUd u=" + turns[10], "UUdU u=" + turns[11], "UUUU u=" + turns[12], "dddd d=" + turns[13]};
        return sequence;
    }

    public static String[] getRandomSequence(Random r) {
        int[] clocks = new int[18];
        int i = 0;
        while (i < clocks.length) {
            clocks[i] = r.nextInt(12);
            ++i;
        }
        String[] generator = RubiksClockSolver.generate(new State(clocks, null));
        String pins = "";
        int i2 = 0;
        while (i2 < 4) {
            pins = String.valueOf(pins) + (r.nextBoolean() ? "U" : "d");
            ++i2;
        }
        String[] sequence = new String[generator.length + 1];
        int i3 = 0;
        while (i3 < generator.length) {
            sequence[i3] = generator[i3];
            ++i3;
        }
        sequence[sequence.length - 1] = pins;
        return sequence;
    }

    public static class State {
        public int[] clocks;
        public boolean[] pinsDown;
        public static int[] wheelsClockFront;
        public static int[] wheelsClockBack;
        public static int[][] pinsClocksFront;
        public static int[][] pinsClocksBack;
        public static State id;

        static {
            int[] nArray = new int[4];
            nArray[1] = 2;
            nArray[2] = 6;
            nArray[3] = 8;
            wheelsClockFront = nArray;
            wheelsClockBack = new int[]{11, 9, 17, 15};
            int[][] nArrayArray = new int[4][];
            int[] nArray2 = new int[4];
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArrayArray[0] = nArray2;
            nArrayArray[1] = new int[]{1, 2, 4, 5};
            nArrayArray[2] = new int[]{3, 4, 6, 7};
            nArrayArray[3] = new int[]{4, 5, 7, 8};
            pinsClocksFront = nArrayArray;
            pinsClocksBack = new int[][]{{10, 11, 13, 14}, {9, 10, 12, 13}, {13, 14, 16, 17}, {12, 13, 15, 16}};
            id = new State(new int[18], new boolean[4]);
        }

        public State(int[] clocks, boolean[] pinsDown) {
            this.clocks = clocks;
            this.pinsDown = pinsDown;
        }

        public State rotateWheel(boolean[] pinsDown, int wheel, int turns) {
            int clock;
            int n;
            int n2;
            int[] nArray;
            int[] newClocks = new int[18];
            int i = 0;
            while (i < newClocks.length) {
                newClocks[i] = this.clocks[i];
                ++i;
            }
            boolean[] affectedClocks = new boolean[18];
            int i2 = 0;
            while (i2 < affectedClocks.length) {
                affectedClocks[i2] = false;
                ++i2;
            }
            if (pinsDown[wheel]) {
                i2 = 0;
                while (i2 < 4) {
                    if (pinsDown[i2]) {
                        affectedClocks[State.wheelsClockFront[i2]] = true;
                    }
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < 4) {
                    if (!pinsDown[i2]) {
                        nArray = pinsClocksFront[i2];
                        n2 = nArray.length;
                        n = 0;
                        while (n < n2) {
                            clock = nArray[n];
                            affectedClocks[clock] = true;
                            ++n;
                        }
                    }
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.clocks.length) {
                if (affectedClocks[i2]) {
                    newClocks[i2] = (newClocks[i2] + 12 + turns) % 12;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < affectedClocks.length) {
                affectedClocks[i2] = false;
                ++i2;
            }
            if (!pinsDown[wheel]) {
                i2 = 0;
                while (i2 < 4) {
                    if (!pinsDown[i2]) {
                        affectedClocks[State.wheelsClockBack[i2]] = true;
                    }
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < 4) {
                    if (pinsDown[i2]) {
                        nArray = pinsClocksBack[i2];
                        n2 = nArray.length;
                        n = 0;
                        while (n < n2) {
                            clock = nArray[n];
                            affectedClocks[clock] = true;
                            ++n;
                        }
                    }
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.clocks.length) {
                if (affectedClocks[i2]) {
                    newClocks[i2] = (newClocks[i2] + 12 - turns) % 12;
                }
                ++i2;
            }
            return new State(newClocks, pinsDown);
        }
    }
}

