/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;

public class RubiksCubeCrossSolver {
    public static final int N_MOVES = 18;
    public static final int N_COMBINATIONS = 495;
    public static final int N_PERMUTATIONS = 24;
    public static final int N_ORIENTATIONS = 16;
    public static byte[][][] distance = new byte[495][24][16];

    static {
        int i = 0;
        while (i < distance.length) {
            int j = 0;
            while (j < distance[i].length) {
                int k = 0;
                while (k < distance[i][j].length) {
                    RubiksCubeCrossSolver.distance[i][j][k] = -1;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        RubiksCubeCrossSolver.distance[0][0][0] = 0;
        Move[] moves = new Move[]{Move.moves.get("U"), Move.moves.get("U2"), Move.moves.get("U'"), Move.moves.get("D"), Move.moves.get("D2"), Move.moves.get("D'"), Move.moves.get("L"), Move.moves.get("L2"), Move.moves.get("L'"), Move.moves.get("R"), Move.moves.get("R2"), Move.moves.get("R'"), Move.moves.get("F"), Move.moves.get("F2"), Move.moves.get("F'"), Move.moves.get("B"), Move.moves.get("B2"), Move.moves.get("B'")};
        byte depth = 0;
        int nVisited = 1;
        while (nVisited < 190080) {
            int i2 = 0;
            while (i2 < 495) {
                boolean[] combination = IndexMapping.indexToCombination(i2, 4, 12);
                int j = 0;
                while (j < 24) {
                    byte[] permutation = IndexMapping.indexToPermutation(j, 4);
                    int k = 0;
                    while (k < 16) {
                        byte[] orientation = IndexMapping.indexToOrientation(k, 2, 4);
                        if (distance[i2][j][k] == depth) {
                            State state = new State(combination, permutation, orientation);
                            int m = 0;
                            while (m < 18) {
                                int orientationIndex;
                                int permutationIndex;
                                State result = state.multiply(moves[m]);
                                int combinationIndex = IndexMapping.combinationToIndex(result.combination, 4);
                                if (distance[combinationIndex][permutationIndex = IndexMapping.permutationToIndex(result.permutation)][orientationIndex = IndexMapping.orientationToIndex(result.orientation, 2)] < 0) {
                                    RubiksCubeCrossSolver.distance[combinationIndex][permutationIndex][orientationIndex] = (byte)(depth + 1);
                                    ++nVisited;
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            ++depth;
        }
    }

    public static String[][] solve(State state) {
        int orientation;
        int permutation;
        int combination = IndexMapping.combinationToIndex(state.combination, 4);
        if (distance[combination][permutation = IndexMapping.permutationToIndex(state.permutation)][orientation = IndexMapping.orientationToIndex(state.orientation, 2)] == 0) {
            return new String[][]{new String[0]};
        }
        ArrayList<String[]> solutions = new ArrayList<String[]>();
        for (String moveName : Move.moves.keySet()) {
            int resultOrientation;
            int resultPermutation;
            State result = state.multiply(Move.moves.get(moveName));
            int resultCombination = IndexMapping.combinationToIndex(result.combination, 4);
            if (distance[resultCombination][resultPermutation = IndexMapping.permutationToIndex(result.permutation)][resultOrientation = IndexMapping.orientationToIndex(result.orientation, 2)] != distance[combination][permutation][orientation] - 1) continue;
            String[][] stringArray = RubiksCubeCrossSolver.solve(result);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] solution = stringArray[n2];
                String[] sequence = new String[solution.length + 1];
                sequence[0] = moveName;
                int i = 1;
                while (i < sequence.length) {
                    sequence[i] = solution[i - 1];
                    ++i;
                }
                solutions.add(sequence);
                ++n2;
            }
        }
        String[][] solutionsArray = new String[solutions.size()][];
        solutions.toArray((T[])solutionsArray);
        return solutionsArray;
    }

    public static String[] generate(State state) {
        String[] solution = RubiksCubeCrossSolver.solve(state)[0];
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U2", "U2");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("D", "D'");
        inverseMoveNames.put("D2", "D2");
        inverseMoveNames.put("D'", "D");
        inverseMoveNames.put("L", "L'");
        inverseMoveNames.put("L2", "L2");
        inverseMoveNames.put("L'", "L");
        inverseMoveNames.put("R", "R'");
        inverseMoveNames.put("R2", "R2");
        inverseMoveNames.put("R'", "R");
        inverseMoveNames.put("F", "F'");
        inverseMoveNames.put("F2", "F2");
        inverseMoveNames.put("F'", "F");
        inverseMoveNames.put("B", "B'");
        inverseMoveNames.put("B2", "B2");
        inverseMoveNames.put("B'", "B");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public static class Move {
        public byte[] permutation;
        public byte[] orientation;
        public static HashMap<String, Move> moves;

        static {
            byte[] byArray = new byte[12];
            byArray[0] = 1;
            byArray[1] = 2;
            byArray[2] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byArray[8] = 8;
            byArray[9] = 9;
            byArray[10] = 10;
            byArray[11] = 11;
            Move moveU = new Move(byArray, new byte[12]);
            byte[] byArray2 = new byte[12];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 4;
            byArray2[5] = 5;
            byArray2[6] = 6;
            byArray2[7] = 7;
            byArray2[8] = 11;
            byArray2[9] = 8;
            byArray2[10] = 9;
            byArray2[11] = 10;
            Move moveD = new Move(byArray2, new byte[12]);
            byte[] byArray3 = new byte[12];
            byArray3[1] = 1;
            byArray3[2] = 2;
            byArray3[3] = 7;
            byArray3[4] = 3;
            byArray3[5] = 5;
            byArray3[6] = 6;
            byArray3[7] = 11;
            byArray3[8] = 8;
            byArray3[9] = 9;
            byArray3[10] = 10;
            byArray3[11] = 4;
            Move moveL = new Move(byArray3, new byte[12]);
            byte[] byArray4 = new byte[12];
            byArray4[1] = 5;
            byArray4[2] = 2;
            byArray4[3] = 3;
            byArray4[4] = 4;
            byArray4[5] = 9;
            byArray4[6] = 1;
            byArray4[7] = 7;
            byArray4[8] = 8;
            byArray4[9] = 6;
            byArray4[10] = 10;
            byArray4[11] = 11;
            Move moveR = new Move(byArray4, new byte[12]);
            byte[] byArray5 = new byte[12];
            byArray5[1] = 1;
            byArray5[2] = 6;
            byArray5[3] = 3;
            byArray5[4] = 4;
            byArray5[5] = 5;
            byArray5[6] = 10;
            byArray5[7] = 2;
            byArray5[8] = 8;
            byArray5[9] = 9;
            byArray5[10] = 7;
            byArray5[11] = 11;
            byte[] byArray6 = new byte[12];
            byArray6[2] = 1;
            byArray6[6] = 1;
            byArray6[7] = 1;
            byArray6[10] = 1;
            Move moveF = new Move(byArray5, byArray6);
            byte[] byArray7 = new byte[12];
            byArray7[0] = 4;
            byArray7[1] = 1;
            byArray7[2] = 2;
            byArray7[3] = 3;
            byArray7[4] = 8;
            byArray7[6] = 6;
            byArray7[7] = 7;
            byArray7[8] = 5;
            byArray7[9] = 9;
            byArray7[10] = 10;
            byArray7[11] = 11;
            byte[] byArray8 = new byte[12];
            byArray8[0] = 1;
            byArray8[4] = 1;
            byArray8[5] = 1;
            byArray8[8] = 1;
            Move moveB = new Move(byArray7, byArray8);
            moves = new HashMap();
            moves.put("U", moveU);
            moves.put("U2", moveU.multiply(moveU));
            moves.put("U'", moveU.multiply(moveU).multiply(moveU));
            moves.put("D", moveD);
            moves.put("D2", moveD.multiply(moveD));
            moves.put("D'", moveD.multiply(moveD).multiply(moveD));
            moves.put("L", moveL);
            moves.put("L2", moveL.multiply(moveL));
            moves.put("L'", moveL.multiply(moveL).multiply(moveL));
            moves.put("R", moveR);
            moves.put("R2", moveR.multiply(moveR));
            moves.put("R'", moveR.multiply(moveR).multiply(moveR));
            moves.put("F", moveF);
            moves.put("F2", moveF.multiply(moveF));
            moves.put("F'", moveF.multiply(moveF).multiply(moveF));
            moves.put("B", moveB);
            moves.put("B2", moveB.multiply(moveB));
            moves.put("B'", moveB.multiply(moveB).multiply(moveB));
        }

        public Move(byte[] permutation, byte[] orientation) {
            this.permutation = permutation;
            this.orientation = orientation;
        }

        public Move multiply(Move move) {
            byte[] permutation = new byte[12];
            byte[] orientation = new byte[12];
            int i = 0;
            while (i < 12) {
                permutation[i] = move.permutation[this.permutation[i]];
                orientation[i] = (byte)((move.orientation[this.permutation[i]] + this.orientation[i]) % 2);
                ++i;
            }
            return new Move(permutation, orientation);
        }
    }

    public static class State {
        public boolean[] combination;
        public byte[] permutation;
        public byte[] orientation;
        public static State id = new State(IndexMapping.indexToCombination(0, 4, 12), IndexMapping.indexToPermutation(0, 4), IndexMapping.indexToOrientation(0, 2, 4));

        public State(boolean[] combination, byte[] permutation, byte[] orientation) {
            this.combination = combination;
            this.permutation = permutation;
            this.orientation = orientation;
        }

        public State multiply(Move move) {
            byte[] position = new byte[this.permutation.length];
            int next = 0;
            int i = 0;
            while (i < this.combination.length) {
                if (this.combination[i]) {
                    position[this.permutation[next++]] = (byte)i;
                }
                ++i;
            }
            byte[] resultPosition = new byte[this.permutation.length];
            byte[] resultOrientation = new byte[this.orientation.length];
            int i2 = 0;
            while (i2 < position.length) {
                resultPosition[i2] = move.permutation[position[i2]];
                resultOrientation[i2] = (byte)((this.orientation[i2] + move.orientation[position[i2]]) % 2);
                ++i2;
            }
            boolean[] resultCombination = new boolean[this.combination.length];
            int i3 = 0;
            while (i3 < resultPosition.length) {
                resultCombination[resultPosition[i3]] = true;
                ++i3;
            }
            byte[] resultPermutation = new byte[this.permutation.length];
            next = 0;
            int i4 = 0;
            while (i4 < resultCombination.length) {
                if (resultCombination[i4]) {
                    int j = 0;
                    while (j < resultPosition.length) {
                        if (resultPosition[j] == i4) {
                            resultPermutation[next++] = (byte)j;
                            break;
                        }
                        ++j;
                    }
                }
                ++i4;
            }
            return new State(resultCombination, resultPermutation, resultOrientation);
        }

        public State applySequence(String[] sequence) {
            State state = this;
            String[] stringArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                String move = stringArray[n2];
                state = state.multiply(Move.moves.get(move));
                ++n2;
            }
            return state;
        }
    }
}

