/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;

public class RubiksCubeSolver {
    public static final int N_CORNERS_ORIENTATIONS = 2187;
    public static final int N_EDGES_ORIENTATIONS = 2048;
    public static final int N_E_EDGES_COMBINATIONS = 495;
    public static final int N_CORNERS_PERMUTATIONS = 40320;
    public static final int N_U_D_EDGES_PERMUTATIONS = 40320;
    public static final int N_E_EDGES_PERMUTATIONS = 24;
    public static final int N_EDGES_PERMUTATIONS = 479001600;
    private static String[] moveNames1;
    private static State[] moves1;
    private static int[] sides1;
    private static int[] axes1;
    private static String[] moveNames2;
    private static State[] moves2;
    private static int[] sides2;
    private static int[] axes2;
    private static int[][] cornersOrientationMove;
    private static int[][] edgesOrientationMove;
    private static int[][] eEdgesCombinationMove;
    private static int[][] cornersPermutationMove;
    private static int[][] uDEdgesPermutationMove;
    private static int[][] eEdgesPermutationMove;
    private static byte[][] cornersOrientationDistance;
    private static byte[][] edgesOrientationDistance;
    private static byte[][] cornersPermutationDistance;
    private static byte[][] uDEdgesPermutationDistance;
    private static int MAX_SOLUTION_LENGTH;
    private static int MAX_PHASE_2_SOLUTION_LENGTH;
    private static State initialState;
    private static ArrayList<Integer> solution1;
    private static ArrayList<Integer> solution2;

    static {
        int k;
        State result;
        int j;
        byte[] permutation;
        int j2;
        State state;
        moveNames1 = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L", "L2", "L'", "R", "R2", "R'", "F", "F2", "F'", "B", "B2", "B'"};
        moves1 = new State[moveNames1.length];
        int i = 0;
        while (i < moves1.length) {
            RubiksCubeSolver.moves1[i] = State.moves.get(moveNames1[i]);
            ++i;
        }
        int[] nArray = new int[18];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 4;
        nArray[13] = 4;
        nArray[14] = 4;
        nArray[15] = 5;
        nArray[16] = 5;
        nArray[17] = 5;
        sides1 = nArray;
        int[] nArray2 = new int[18];
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 1;
        nArray2[11] = 1;
        nArray2[12] = 2;
        nArray2[13] = 2;
        nArray2[14] = 2;
        nArray2[15] = 2;
        nArray2[16] = 2;
        nArray2[17] = 2;
        axes1 = nArray2;
        moveNames2 = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L2", "R2", "F2", "B2"};
        moves2 = new State[moveNames2.length];
        i = 0;
        while (i < moves2.length) {
            RubiksCubeSolver.moves2[i] = State.moves.get(moveNames2[i]);
            ++i;
        }
        int[] nArray3 = new int[10];
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 2;
        nArray3[7] = 3;
        nArray3[8] = 4;
        nArray3[9] = 5;
        sides2 = nArray3;
        int[] nArray4 = new int[10];
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = 2;
        nArray4[9] = 2;
        axes2 = nArray4;
        cornersOrientationMove = new int[2187][moves1.length];
        i = 0;
        while (i < 2187) {
            state = new State(new byte[8], IndexMapping.indexToZeroSumOrientation(i, 3, 8), new byte[12], new byte[12]);
            j2 = 0;
            while (j2 < moves1.length) {
                RubiksCubeSolver.cornersOrientationMove[i][j2] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)RubiksCubeSolver.moves1[j2]).cornersOrientation, 3);
                ++j2;
            }
            ++i;
        }
        edgesOrientationMove = new int[2048][moves1.length];
        i = 0;
        while (i < 2048) {
            state = new State(new byte[8], new byte[8], new byte[12], IndexMapping.indexToZeroSumOrientation(i, 2, 12));
            j2 = 0;
            while (j2 < moves1.length) {
                RubiksCubeSolver.edgesOrientationMove[i][j2] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)RubiksCubeSolver.moves1[j2]).edgesOrientation, 2);
                ++j2;
            }
            ++i;
        }
        eEdgesCombinationMove = new int[495][moves1.length];
        i = 0;
        while (i < 495) {
            boolean[] combination = IndexMapping.indexToCombination(i, 4, 12);
            byte[] edges = new byte[12];
            int nextE = 0;
            int nextUD = 4;
            int j3 = 0;
            while (j3 < edges.length) {
                if (combination[j3]) {
                    nextE = (byte)(nextE + 1);
                } else {
                    nextUD = (byte)(nextUD + 1);
                }
                ++j3;
            }
            State state2 = new State(new byte[8], new byte[8], edges, new byte[12]);
            int j4 = 0;
            while (j4 < moves1.length) {
                State result2 = state2.multiply(moves1[j4]);
                boolean[] isEEdge = new boolean[12];
                int k2 = 0;
                while (k2 < isEEdge.length) {
                    isEEdge[k2] = result2.edgesPermutation[k2] < 4;
                    ++k2;
                }
                RubiksCubeSolver.eEdgesCombinationMove[i][j4] = IndexMapping.combinationToIndex(isEEdge, 4);
                ++j4;
            }
            ++i;
        }
        cornersPermutationMove = new int[40320][moves2.length];
        i = 0;
        while (i < 40320) {
            state = new State(IndexMapping.indexToPermutation(i, 8), new byte[8], new byte[12], new byte[12]);
            int j5 = 0;
            while (j5 < moves2.length) {
                RubiksCubeSolver.cornersPermutationMove[i][j5] = IndexMapping.permutationToIndex(state.multiply((State)RubiksCubeSolver.moves2[j5]).cornersPermutation);
                ++j5;
            }
            ++i;
        }
        uDEdgesPermutationMove = new int[40320][moves2.length];
        i = 0;
        while (i < 40320) {
            permutation = IndexMapping.indexToPermutation(i, 8);
            byte[] edges = new byte[12];
            int j6 = 0;
            while (j6 < edges.length) {
                edges[j6] = j6 >= 4 ? permutation[j6 - 4] : (byte)j6;
                ++j6;
            }
            State state3 = new State(new byte[8], new byte[8], edges, new byte[12]);
            j = 0;
            while (j < moves2.length) {
                result = state3.multiply(moves2[j]);
                byte[] uDEdges = new byte[8];
                int k3 = 0;
                while (k3 < uDEdges.length) {
                    uDEdges[k3] = (byte)(result.edgesPermutation[k3 + 4] - 4);
                    ++k3;
                }
                RubiksCubeSolver.uDEdgesPermutationMove[i][j] = IndexMapping.permutationToIndex(uDEdges);
                ++j;
            }
            ++i;
        }
        eEdgesPermutationMove = new int[24][moves2.length];
        i = 0;
        while (i < 24) {
            permutation = IndexMapping.indexToPermutation(i, 4);
            byte[] edges = new byte[12];
            int j7 = 0;
            while (j7 < edges.length) {
                edges[j7] = j7 >= 4 ? (byte)j7 : permutation[j7];
                ++j7;
            }
            State state4 = new State(new byte[8], new byte[8], edges, new byte[12]);
            j = 0;
            while (j < moves2.length) {
                result = state4.multiply(moves2[j]);
                byte[] eEdges = new byte[4];
                int k4 = 0;
                while (k4 < eEdges.length) {
                    eEdges[k4] = result.edgesPermutation[k4];
                    ++k4;
                }
                RubiksCubeSolver.eEdgesPermutationMove[i][j] = IndexMapping.permutationToIndex(eEdges);
                ++j;
            }
            ++i;
        }
        cornersOrientationDistance = new byte[2187][495];
        i = 0;
        while (i < cornersOrientationDistance.length) {
            int j8 = 0;
            while (j8 < cornersOrientationDistance[i].length) {
                RubiksCubeSolver.cornersOrientationDistance[i][j8] = -1;
                ++j8;
            }
            ++i;
        }
        RubiksCubeSolver.cornersOrientationDistance[0][0] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < 1082565) {
            int i2 = 0;
            while (i2 < 2187) {
                int j9 = 0;
                while (j9 < 495) {
                    if (cornersOrientationDistance[i2][j9] == distance) {
                        k = 0;
                        while (k < moves1.length) {
                            int nextCornersOrientation = cornersOrientationMove[i2][k];
                            int nextEEdgesCombination = eEdgesCombinationMove[j9][k];
                            if (cornersOrientationDistance[nextCornersOrientation][nextEEdgesCombination] < 0) {
                                RubiksCubeSolver.cornersOrientationDistance[nextCornersOrientation][nextEEdgesCombination] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j9;
                }
                ++i2;
            }
            ++distance;
        }
        edgesOrientationDistance = new byte[2048][495];
        int i3 = 0;
        while (i3 < edgesOrientationDistance.length) {
            int j10 = 0;
            while (j10 < edgesOrientationDistance[i3].length) {
                RubiksCubeSolver.edgesOrientationDistance[i3][j10] = -1;
                ++j10;
            }
            ++i3;
        }
        RubiksCubeSolver.edgesOrientationDistance[0][0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 1013760) {
            i3 = 0;
            while (i3 < 2048) {
                int j11 = 0;
                while (j11 < 495) {
                    if (edgesOrientationDistance[i3][j11] == distance) {
                        k = 0;
                        while (k < moves1.length) {
                            int nextEdgesOrientation = edgesOrientationMove[i3][k];
                            int nextEEdgesCombination = eEdgesCombinationMove[j11][k];
                            if (edgesOrientationDistance[nextEdgesOrientation][nextEEdgesCombination] < 0) {
                                RubiksCubeSolver.edgesOrientationDistance[nextEdgesOrientation][nextEEdgesCombination] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j11;
                }
                ++i3;
            }
            ++distance;
        }
        cornersPermutationDistance = new byte[40320][24];
        i3 = 0;
        while (i3 < cornersPermutationDistance.length) {
            int j12 = 0;
            while (j12 < cornersPermutationDistance[i3].length) {
                RubiksCubeSolver.cornersPermutationDistance[i3][j12] = -1;
                ++j12;
            }
            ++i3;
        }
        RubiksCubeSolver.cornersPermutationDistance[0][0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 967680) {
            i3 = 0;
            while (i3 < 40320) {
                int j13 = 0;
                while (j13 < 24) {
                    if (cornersPermutationDistance[i3][j13] == distance) {
                        k = 0;
                        while (k < moves2.length) {
                            int nextCornersPermutation = cornersPermutationMove[i3][k];
                            int nextEEdgesPermutation = eEdgesPermutationMove[j13][k];
                            if (cornersPermutationDistance[nextCornersPermutation][nextEEdgesPermutation] < 0) {
                                RubiksCubeSolver.cornersPermutationDistance[nextCornersPermutation][nextEEdgesPermutation] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j13;
                }
                ++i3;
            }
            ++distance;
        }
        uDEdgesPermutationDistance = new byte[40320][24];
        i3 = 0;
        while (i3 < uDEdgesPermutationDistance.length) {
            int j14 = 0;
            while (j14 < uDEdgesPermutationDistance[i3].length) {
                RubiksCubeSolver.uDEdgesPermutationDistance[i3][j14] = -1;
                ++j14;
            }
            ++i3;
        }
        RubiksCubeSolver.uDEdgesPermutationDistance[0][0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 967680) {
            i3 = 0;
            while (i3 < 40320) {
                int j15 = 0;
                while (j15 < 24) {
                    if (uDEdgesPermutationDistance[i3][j15] == distance) {
                        k = 0;
                        while (k < moves2.length) {
                            int nextUDEdgesPermutation = uDEdgesPermutationMove[i3][k];
                            int nextEEdgesPermutation = eEdgesPermutationMove[j15][k];
                            if (uDEdgesPermutationDistance[nextUDEdgesPermutation][nextEEdgesPermutation] < 0) {
                                RubiksCubeSolver.uDEdgesPermutationDistance[nextUDEdgesPermutation][nextEEdgesPermutation] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j15;
                }
                ++i3;
            }
            ++distance;
        }
        MAX_SOLUTION_LENGTH = 23;
        MAX_PHASE_2_SOLUTION_LENGTH = 12;
    }

    private static String[] solution(State state) {
        initialState = state;
        int cornersOrientation = IndexMapping.zeroSumOrientationToIndex(state.cornersOrientation, 3);
        int edgesOrientation = IndexMapping.zeroSumOrientationToIndex(state.edgesOrientation, 2);
        boolean[] isEEdge = new boolean[12];
        int i = 0;
        while (i < isEEdge.length) {
            isEEdge[i] = state.edgesPermutation[i] < 4;
            ++i;
        }
        int eEdgesCombination = IndexMapping.combinationToIndex(isEEdge, 4);
        int depth = 0;
        while (true) {
            solution1 = new ArrayList(MAX_SOLUTION_LENGTH);
            if (RubiksCubeSolver.search1(cornersOrientation, edgesOrientation, eEdgesCombination, depth)) {
                ArrayList<String> sequence = new ArrayList<String>();
                for (int moveIndex : solution1) {
                    sequence.add(moveNames1[moveIndex]);
                }
                for (int moveIndex : solution2) {
                    sequence.add(moveNames2[moveIndex]);
                }
                String[] sequenceArray = new String[sequence.size()];
                sequence.toArray(sequenceArray);
                return sequenceArray;
            }
            ++depth;
        }
    }

    private static boolean search1(int cornersOrientation, int edgesOrientation, int eEdgesCombinations, int depth) {
        if (depth == 0) {
            if (cornersOrientation == 0 && edgesOrientation == 0 && eEdgesCombinations == 0) {
                State state = initialState;
                for (int moveIndex : solution1) {
                    state = state.multiply(moves1[moveIndex]);
                }
                return RubiksCubeSolver.solution2(state, MAX_SOLUTION_LENGTH - solution1.size());
            }
            return false;
        }
        if (cornersOrientationDistance[cornersOrientation][eEdgesCombinations] <= depth && edgesOrientationDistance[edgesOrientation][eEdgesCombinations] <= depth) {
            int[] lastMoves = new int[]{-1, -1};
            int i = 0;
            while (i < lastMoves.length && i < solution1.size()) {
                lastMoves[i] = solution1.get(solution1.size() - 1 - i);
                ++i;
            }
            i = 0;
            while (i < moves1.length) {
                if (!(lastMoves[0] >= 0 && sides1[i] == sides1[lastMoves[0]] || lastMoves[0] >= 0 && axes1[i] == axes1[lastMoves[0]] && lastMoves[1] >= 0 && axes1[i] == axes1[lastMoves[1]])) {
                    solution1.add(i);
                    if (RubiksCubeSolver.search1(cornersOrientationMove[cornersOrientation][i], edgesOrientationMove[edgesOrientation][i], eEdgesCombinationMove[eEdgesCombinations][i], depth - 1)) {
                        return true;
                    }
                    solution1.remove(solution1.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean solution2(State state, int maxDepth) {
        if (solution1.size() > 0) {
            int lastMove = solution1.get(solution1.size() - 1);
            int i = 0;
            while (i < moveNames2.length) {
                if (moveNames1[lastMove].equals(moveNames2[i])) {
                    return false;
                }
                ++i;
            }
        }
        int cornersPermutation = IndexMapping.permutationToIndex(state.cornersPermutation);
        byte[] uDEdges = new byte[8];
        int i = 0;
        while (i < uDEdges.length) {
            uDEdges[i] = (byte)(state.edgesPermutation[i + 4] - 4);
            ++i;
        }
        int uDEdgesPermutation = IndexMapping.permutationToIndex(uDEdges);
        byte[] eEdges = new byte[4];
        int i2 = 0;
        while (i2 < eEdges.length) {
            eEdges[i2] = state.edgesPermutation[i2];
            ++i2;
        }
        int eEdgesPermutation = IndexMapping.permutationToIndex(eEdges);
        int depth = 0;
        while (depth < Math.min(MAX_PHASE_2_SOLUTION_LENGTH, maxDepth)) {
            solution2 = new ArrayList(MAX_SOLUTION_LENGTH);
            if (RubiksCubeSolver.search2(cornersPermutation, uDEdgesPermutation, eEdgesPermutation, depth)) {
                return true;
            }
            ++depth;
        }
        return false;
    }

    private static boolean search2(int cornersPermutation, int uDEdgesPermutation, int eEdgesPermutation, int depth) {
        block9: {
            if (depth == 0) {
                return cornersPermutation == 0 && uDEdgesPermutation == 0 && eEdgesPermutation == 0;
            }
            if (cornersPermutationDistance[cornersPermutation][eEdgesPermutation] > depth || uDEdgesPermutationDistance[uDEdgesPermutation][eEdgesPermutation] > depth) break block9;
            int lastSide = Integer.MAX_VALUE;
            if (solution2.size() > 0) {
                lastSide = sides2[solution2.get(solution2.size() - 1)];
            }
            int i = 0;
            while (i < moves2.length) {
                block11: {
                    block10: {
                        if (solution2.size() != 0) break block10;
                        int lastPhase1Axis = Integer.MAX_VALUE;
                        if (solution1.size() > 0) {
                            lastPhase1Axis = axes1[solution1.get(solution1.size() - 1)];
                        }
                        if (axes2[i] == lastPhase1Axis) break block11;
                    }
                    if (sides2[i] != lastSide) {
                        solution2.add(i);
                        if (RubiksCubeSolver.search2(cornersPermutationMove[cornersPermutation][i], uDEdgesPermutationMove[uDEdgesPermutation][i], eEdgesPermutationMove[eEdgesPermutation][i], depth - 1)) {
                            return true;
                        }
                        solution2.remove(solution2.size() - 1);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] generate(State state) {
        String[] solution = RubiksCubeSolver.solution(state);
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U2", "U2");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("D", "D'");
        inverseMoveNames.put("D2", "D2");
        inverseMoveNames.put("D'", "D");
        inverseMoveNames.put("L", "L'");
        inverseMoveNames.put("L2", "L2");
        inverseMoveNames.put("L'", "L");
        inverseMoveNames.put("R", "R'");
        inverseMoveNames.put("R2", "R2");
        inverseMoveNames.put("R'", "R");
        inverseMoveNames.put("F", "F'");
        inverseMoveNames.put("F2", "F2");
        inverseMoveNames.put("F'", "F");
        inverseMoveNames.put("B", "B'");
        inverseMoveNames.put("B2", "B2");
        inverseMoveNames.put("B'", "B");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < solution.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - i - 1]);
            ++i;
        }
        return sequence;
    }

    public static class State {
        public byte[] cornersPermutation;
        public byte[] cornersOrientation;
        public byte[] edgesPermutation;
        public byte[] edgesOrientation;
        public static HashMap<String, State> moves;
        public static State id;

        static {
            byte[] byArray = new byte[8];
            byArray[0] = 3;
            byArray[2] = 1;
            byArray[3] = 2;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byte[] byArray2 = new byte[12];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 7;
            byArray2[5] = 4;
            byArray2[6] = 5;
            byArray2[7] = 6;
            byArray2[8] = 8;
            byArray2[9] = 9;
            byArray2[10] = 10;
            byArray2[11] = 11;
            State moveU = new State(byArray, new byte[8], byArray2, new byte[12]);
            byte[] byArray3 = new byte[8];
            byArray3[1] = 1;
            byArray3[2] = 2;
            byArray3[3] = 3;
            byArray3[4] = 5;
            byArray3[5] = 6;
            byArray3[6] = 7;
            byArray3[7] = 4;
            byte[] byArray4 = new byte[12];
            byArray4[1] = 1;
            byArray4[2] = 2;
            byArray4[3] = 3;
            byArray4[4] = 4;
            byArray4[5] = 5;
            byArray4[6] = 6;
            byArray4[7] = 7;
            byArray4[8] = 9;
            byArray4[9] = 10;
            byArray4[10] = 11;
            byArray4[11] = 8;
            State moveD = new State(byArray3, new byte[8], byArray4, new byte[12]);
            byte[] byArray5 = new byte[8];
            byArray5[0] = 4;
            byArray5[1] = 1;
            byArray5[2] = 2;
            byArray5[4] = 7;
            byArray5[5] = 5;
            byArray5[6] = 6;
            byArray5[7] = 3;
            byte[] byArray6 = new byte[8];
            byArray6[0] = 2;
            byArray6[3] = 1;
            byArray6[4] = 1;
            byArray6[7] = 2;
            byte[] byArray7 = new byte[12];
            byArray7[0] = 11;
            byArray7[1] = 1;
            byArray7[2] = 2;
            byArray7[3] = 7;
            byArray7[4] = 4;
            byArray7[5] = 5;
            byArray7[6] = 6;
            byArray7[8] = 8;
            byArray7[9] = 9;
            byArray7[10] = 10;
            byArray7[11] = 3;
            State moveL = new State(byArray5, byArray6, byArray7, new byte[12]);
            byte[] byArray8 = new byte[8];
            byArray8[1] = 2;
            byArray8[2] = 6;
            byArray8[3] = 3;
            byArray8[4] = 4;
            byArray8[5] = 1;
            byArray8[6] = 5;
            byArray8[7] = 7;
            byte[] byArray9 = new byte[8];
            byArray9[1] = 1;
            byArray9[2] = 2;
            byArray9[5] = 2;
            byArray9[6] = 1;
            byte[] byArray10 = new byte[12];
            byArray10[1] = 5;
            byArray10[2] = 9;
            byArray10[3] = 3;
            byArray10[4] = 4;
            byArray10[5] = 2;
            byArray10[6] = 6;
            byArray10[7] = 7;
            byArray10[8] = 8;
            byArray10[9] = 1;
            byArray10[10] = 10;
            byArray10[11] = 11;
            State moveR = new State(byArray8, byArray9, byArray10, new byte[12]);
            byte[] byArray11 = new byte[8];
            byArray11[1] = 1;
            byArray11[2] = 3;
            byArray11[3] = 7;
            byArray11[4] = 4;
            byArray11[5] = 5;
            byArray11[6] = 2;
            byArray11[7] = 6;
            byte[] byArray12 = new byte[8];
            byArray12[2] = 1;
            byArray12[3] = 2;
            byArray12[6] = 2;
            byArray12[7] = 1;
            byte[] byArray13 = new byte[12];
            byArray13[1] = 1;
            byArray13[2] = 6;
            byArray13[3] = 10;
            byArray13[4] = 4;
            byArray13[5] = 5;
            byArray13[6] = 3;
            byArray13[7] = 7;
            byArray13[8] = 8;
            byArray13[9] = 9;
            byArray13[10] = 2;
            byArray13[11] = 11;
            byte[] byArray14 = new byte[12];
            byArray14[2] = 1;
            byArray14[3] = 1;
            byArray14[6] = 1;
            byArray14[10] = 1;
            State moveF = new State(byArray11, byArray12, byArray13, byArray14);
            byte[] byArray15 = new byte[8];
            byArray15[0] = 1;
            byArray15[1] = 5;
            byArray15[2] = 2;
            byArray15[3] = 3;
            byArray15[5] = 4;
            byArray15[6] = 6;
            byArray15[7] = 7;
            byte[] byArray16 = new byte[8];
            byArray16[0] = 1;
            byArray16[1] = 2;
            byArray16[4] = 2;
            byArray16[5] = 1;
            byte[] byArray17 = new byte[12];
            byArray17[0] = 4;
            byArray17[1] = 8;
            byArray17[2] = 2;
            byArray17[3] = 3;
            byArray17[4] = 1;
            byArray17[5] = 5;
            byArray17[6] = 6;
            byArray17[7] = 7;
            byArray17[9] = 9;
            byArray17[10] = 10;
            byArray17[11] = 11;
            byte[] byArray18 = new byte[12];
            byArray18[0] = 1;
            byArray18[1] = 1;
            byArray18[4] = 1;
            byArray18[8] = 1;
            State moveB = new State(byArray15, byArray16, byArray17, byArray18);
            moves = new HashMap();
            moves.put("U", moveU);
            moves.put("U2", moveU.multiply(moveU));
            moves.put("U'", moveU.multiply(moveU).multiply(moveU));
            moves.put("D", moveD);
            moves.put("D2", moveD.multiply(moveD));
            moves.put("D'", moveD.multiply(moveD).multiply(moveD));
            moves.put("L", moveL);
            moves.put("L2", moveL.multiply(moveL));
            moves.put("L'", moveL.multiply(moveL).multiply(moveL));
            moves.put("R", moveR);
            moves.put("R2", moveR.multiply(moveR));
            moves.put("R'", moveR.multiply(moveR).multiply(moveR));
            moves.put("F", moveF);
            moves.put("F2", moveF.multiply(moveF));
            moves.put("F'", moveF.multiply(moveF).multiply(moveF));
            moves.put("B", moveB);
            moves.put("B2", moveB.multiply(moveB));
            moves.put("B'", moveB.multiply(moveB).multiply(moveB));
            id = new State(IndexMapping.indexToPermutation(0, 8), IndexMapping.indexToOrientation(0, 3, 8), IndexMapping.indexToPermutation(0, 12), IndexMapping.indexToOrientation(0, 2, 12));
        }

        public State(byte[] cornersPermutation, byte[] cornersOrientation, byte[] edgesPermutation, byte[] edgesOrientation) {
            this.cornersPermutation = cornersPermutation;
            this.cornersOrientation = cornersOrientation;
            this.edgesPermutation = edgesPermutation;
            this.edgesOrientation = edgesOrientation;
        }

        public State multiply(State move) {
            byte[] cornersPermutation = new byte[8];
            byte[] cornersOrientation = new byte[8];
            int i = 0;
            while (i < 8) {
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                cornersOrientation[i] = (byte)((this.cornersOrientation[move.cornersPermutation[i]] + move.cornersOrientation[i]) % 3);
                ++i;
            }
            byte[] edgesPermutation = new byte[12];
            byte[] edgesOrientation = new byte[12];
            int i2 = 0;
            while (i2 < 12) {
                edgesPermutation[i2] = this.edgesPermutation[move.edgesPermutation[i2]];
                edgesOrientation[i2] = (byte)((this.edgesOrientation[move.edgesPermutation[i2]] + move.edgesOrientation[i2]) % 2);
                ++i2;
            }
            return new State(cornersPermutation, cornersOrientation, edgesPermutation, edgesOrientation);
        }

        public State applySequence(String[] sequence) {
            State state = this;
            String[] stringArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                String move = stringArray[n2];
                state = state.multiply(moves.get(move));
                ++n2;
            }
            return state;
        }
    }
}

