/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class RubiksPocketCubeSolver {
    private final int N_PERMUTATIONS = 40320;
    private final int N_ORIENTATIONS = 2187;
    private int minScrambleLength;
    private ArrayList<State> moves;
    private ArrayList<String> moveNames;
    private boolean initialized;
    private int[][] permutationMove;
    private int[][] orientationMove;
    private byte[] permutationDistance;
    private byte[] orientationDistance;

    public RubiksPocketCubeSolver(int minScrambleLenght, String[] generatingSet) {
        this.minScrambleLength = minScrambleLenght;
        HashMap<String, State> table = new HashMap<String, State>();
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        table.put("U", new State(byArray, new byte[8]));
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 5;
        byArray2[5] = 6;
        byArray2[6] = 7;
        byArray2[7] = 4;
        table.put("D", new State(byArray2, new byte[8]));
        byte[] byArray3 = new byte[8];
        byArray3[0] = 4;
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[4] = 7;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 2;
        byArray4[3] = 1;
        byArray4[4] = 1;
        byArray4[7] = 2;
        table.put("L", new State(byArray3, byArray4));
        byte[] byArray5 = new byte[8];
        byArray5[1] = 2;
        byArray5[2] = 6;
        byArray5[3] = 3;
        byArray5[4] = 4;
        byArray5[5] = 1;
        byArray5[6] = 5;
        byArray5[7] = 7;
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[5] = 2;
        byArray6[6] = 1;
        table.put("R", new State(byArray5, byArray6));
        byte[] byArray7 = new byte[8];
        byArray7[1] = 1;
        byArray7[2] = 3;
        byArray7[3] = 7;
        byArray7[4] = 4;
        byArray7[5] = 5;
        byArray7[6] = 2;
        byArray7[7] = 6;
        byte[] byArray8 = new byte[8];
        byArray8[2] = 1;
        byArray8[3] = 2;
        byArray8[6] = 2;
        byArray8[7] = 1;
        table.put("F", new State(byArray7, byArray8));
        byte[] byArray9 = new byte[8];
        byArray9[0] = 1;
        byArray9[1] = 5;
        byArray9[2] = 2;
        byArray9[3] = 3;
        byArray9[5] = 4;
        byArray9[6] = 6;
        byArray9[7] = 7;
        byte[] byArray10 = new byte[8];
        byArray10[0] = 1;
        byArray10[1] = 2;
        byArray10[4] = 2;
        byArray10[5] = 1;
        table.put("B", new State(byArray9, byArray10));
        this.moves = new ArrayList();
        this.moveNames = new ArrayList();
        String[] stringArray = generatingSet;
        int n = generatingSet.length;
        int n2 = 0;
        while (n2 < n) {
            String moveName = stringArray[n2];
            State move = (State)table.get(moveName);
            this.moves.add(move);
            this.moveNames.add(moveName);
            this.moves.add(move.multiply(move));
            this.moveNames.add(String.valueOf(moveName) + "2");
            this.moves.add(move.multiply(move).multiply(move));
            this.moveNames.add(String.valueOf(moveName) + "'");
            ++n2;
        }
        this.initialized = false;
    }

    private void initialize() {
        int next;
        int j;
        int i;
        int nVisited;
        int j2;
        State state;
        this.permutationMove = new int[40320][this.moves.size()];
        int i2 = 0;
        while (i2 < this.permutationMove.length) {
            state = new State(IndexMapping.indexToPermutation(i2, 8), new byte[8]);
            j2 = 0;
            while (j2 < this.moves.size()) {
                this.permutationMove[i2][j2] = IndexMapping.permutationToIndex(state.multiply((State)this.moves.get((int)j2)).permutation);
                ++j2;
            }
            ++i2;
        }
        this.orientationMove = new int[2187][this.moves.size()];
        i2 = 0;
        while (i2 < this.orientationMove.length) {
            state = new State(new byte[8], IndexMapping.indexToZeroSumOrientation(i2, 3, 8));
            j2 = 0;
            while (j2 < this.moves.size()) {
                this.orientationMove[i2][j2] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)this.moves.get((int)j2)).orientation, 3);
                ++j2;
            }
            ++i2;
        }
        this.permutationDistance = new byte[40320];
        i2 = 0;
        while (i2 < this.permutationDistance.length) {
            this.permutationDistance[i2] = -1;
            ++i2;
        }
        this.permutationDistance[0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.permutationDistance.length) {
                if (this.permutationDistance[i] == depth) {
                    j = 0;
                    while (j < this.moves.size()) {
                        next = this.permutationMove[i][j];
                        if (this.permutationDistance[next] < 0) {
                            this.permutationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.orientationDistance = new byte[2187];
        i = 0;
        while (i < this.orientationDistance.length) {
            this.orientationDistance[i] = -1;
            ++i;
        }
        this.orientationDistance[0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.orientationDistance.length) {
                if (this.orientationDistance[i] == depth) {
                    j = 0;
                    while (j < this.moves.size()) {
                        next = this.orientationMove[i][j];
                        if (this.orientationDistance[next] < 0) {
                            this.orientationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.initialized = true;
    }

    public String[] solve(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        int permutation = IndexMapping.permutationToIndex(state.permutation);
        int orientation = IndexMapping.zeroSumOrientationToIndex(state.orientation, 3);
        int depth = this.minScrambleLength;
        while (true) {
            ArrayList<String> solution;
            if (this.search(permutation, orientation, depth, solution = new ArrayList<String>(), -1)) {
                String[] sequence = new String[solution.size()];
                solution.toArray(sequence);
                return sequence;
            }
            ++depth;
        }
    }

    private boolean search(int permutation, int orientation, int depth, ArrayList<String> solution, int lastFace) {
        if (depth == 0) {
            return permutation == 0 && orientation == 0;
        }
        if (this.permutationDistance[permutation] <= depth && this.orientationDistance[orientation] <= depth) {
            int i = 0;
            while (i < this.moves.size()) {
                if (i / 3 != lastFace) {
                    solution.add(this.moveNames.get(i));
                    if (this.search(this.permutationMove[permutation][i], this.orientationMove[orientation][i], depth - 1, solution, i / 3)) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    public String[] generate(State state) {
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U2", "U2");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("D", "D'");
        inverseMoveNames.put("D2", "D2");
        inverseMoveNames.put("D'", "D");
        inverseMoveNames.put("L", "L'");
        inverseMoveNames.put("L2", "L2");
        inverseMoveNames.put("L'", "L");
        inverseMoveNames.put("R", "R'");
        inverseMoveNames.put("R2", "R2");
        inverseMoveNames.put("R'", "R");
        inverseMoveNames.put("F", "F'");
        inverseMoveNames.put("F2", "F2");
        inverseMoveNames.put("F'", "F");
        inverseMoveNames.put("B", "B'");
        inverseMoveNames.put("B2", "B2");
        inverseMoveNames.put("B'", "B");
        String[] solution = this.solve(state);
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public State getRandomState(Random random) {
        State state = State.id;
        int i = 0;
        while (i < 100) {
            state = state.multiply(this.moves.get(random.nextInt(this.moves.size())));
            ++i;
        }
        return state;
    }

    public static class State {
        public byte[] permutation;
        public byte[] orientation;
        public static State id;

        static {
            byte[] byArray = new byte[8];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            id = new State(byArray, new byte[8]);
        }

        public State(byte[] permutation, byte[] orientation) {
            this.orientation = orientation;
            this.permutation = permutation;
        }

        public State multiply(State move) {
            byte[] resultPermutation = new byte[8];
            byte[] resultOrientation = new byte[8];
            int i = 0;
            while (i < 8) {
                resultPermutation[i] = this.permutation[move.permutation[i]];
                resultOrientation[i] = (byte)((this.orientation[move.permutation[i]] + move.orientation[i]) % 3);
                ++i;
            }
            return new State(resultPermutation, resultOrientation);
        }
    }
}

