/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class RubiksTowerSolver {
    private final int N_ORIENTATIONS = 2187;
    private final int N_EDGES_PERMUTATIONS = 40320;
    private final int N_EDGES_COMBINATIONS = 70;
    private final int N_CORNERS_PERMUTATIONS = 40320;
    private final int N_CORNERS_COMBINATIONS = 70;
    private boolean initialized = false;
    private State[] moves1;
    private String[] moveNames1;
    private int[] faces1;
    private State[] moves2;
    private String[] moveNames2;
    private int[] faces2;
    private int[][] orientationMove;
    private int[][] edgesPermutationMove;
    private int[][] edgesCombinationMove;
    private int[][] cornersPermutationMove;
    private int[][] cornersCombinationMove;
    private byte[] orientationDistance;
    private byte[][] edgesPermutationDistance;
    private byte[][] cornersPermutationDistance;

    private void initialize() {
        int nextCombination;
        int k;
        int j;
        int i;
        int nVisited;
        int k2;
        State result;
        int j2;
        State state;
        int nextBottom;
        int nextTop;
        boolean[] combination;
        int j3;
        State state2;
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 3;
        byArray2[2] = 1;
        byArray2[3] = 2;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        State moveUw = new State(new byte[8], byArray, byArray2);
        byte[] byArray3 = new byte[8];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 5;
        byArray3[5] = 6;
        byArray3[6] = 7;
        byArray3[7] = 4;
        byte[] byArray4 = new byte[8];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = 5;
        byArray4[5] = 6;
        byArray4[6] = 7;
        byArray4[7] = 4;
        State moveDw = new State(new byte[8], byArray3, byArray4);
        byte[] byArray5 = new byte[8];
        byArray5[0] = 2;
        byArray5[3] = 1;
        byArray5[4] = 1;
        byArray5[7] = 2;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 4;
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[4] = 7;
        byArray6[5] = 5;
        byArray6[6] = 6;
        byArray6[7] = 3;
        byte[] byArray7 = new byte[8];
        byArray7[0] = 4;
        byArray7[1] = 1;
        byArray7[2] = 2;
        byArray7[4] = 7;
        byArray7[5] = 5;
        byArray7[6] = 6;
        byArray7[7] = 3;
        State moveLw = new State(byArray5, byArray6, byArray7);
        byte[] byArray8 = new byte[8];
        byArray8[1] = 1;
        byArray8[2] = 2;
        byArray8[5] = 2;
        byArray8[6] = 1;
        byte[] byArray9 = new byte[8];
        byArray9[1] = 2;
        byArray9[2] = 6;
        byArray9[3] = 3;
        byArray9[4] = 4;
        byArray9[5] = 1;
        byArray9[6] = 5;
        byArray9[7] = 7;
        byte[] byArray10 = new byte[8];
        byArray10[1] = 2;
        byArray10[2] = 6;
        byArray10[3] = 3;
        byArray10[4] = 4;
        byArray10[5] = 1;
        byArray10[6] = 5;
        byArray10[7] = 7;
        State moveRw = new State(byArray8, byArray9, byArray10);
        byte[] byArray11 = new byte[8];
        byArray11[2] = 1;
        byArray11[3] = 2;
        byArray11[6] = 2;
        byArray11[7] = 1;
        byte[] byArray12 = new byte[8];
        byArray12[1] = 1;
        byArray12[2] = 3;
        byArray12[3] = 7;
        byArray12[4] = 4;
        byArray12[5] = 5;
        byArray12[6] = 2;
        byArray12[7] = 6;
        byte[] byArray13 = new byte[8];
        byArray13[1] = 1;
        byArray13[2] = 3;
        byArray13[3] = 7;
        byArray13[4] = 4;
        byArray13[5] = 5;
        byArray13[6] = 2;
        byArray13[7] = 6;
        State moveFw = new State(byArray11, byArray12, byArray13);
        byte[] byArray14 = new byte[8];
        byArray14[0] = 1;
        byArray14[1] = 2;
        byArray14[4] = 2;
        byArray14[5] = 1;
        byte[] byArray15 = new byte[8];
        byArray15[0] = 1;
        byArray15[1] = 5;
        byArray15[2] = 2;
        byArray15[3] = 3;
        byArray15[5] = 4;
        byArray15[6] = 6;
        byArray15[7] = 7;
        byte[] byArray16 = new byte[8];
        byArray16[0] = 1;
        byArray16[1] = 5;
        byArray16[2] = 2;
        byArray16[3] = 3;
        byArray16[5] = 4;
        byArray16[6] = 6;
        byArray16[7] = 7;
        State moveBw = new State(byArray14, byArray15, byArray16);
        byte[] byArray17 = new byte[8];
        byArray17[1] = 1;
        byArray17[2] = 2;
        byArray17[3] = 3;
        byArray17[4] = 4;
        byArray17[5] = 5;
        byArray17[6] = 6;
        byArray17[7] = 7;
        byte[] byArray18 = new byte[8];
        byArray18[0] = 3;
        byArray18[2] = 1;
        byArray18[3] = 2;
        byArray18[4] = 4;
        byArray18[5] = 5;
        byArray18[6] = 6;
        byArray18[7] = 7;
        State moveU = new State(new byte[8], byArray17, byArray18);
        byte[] byArray19 = new byte[8];
        byArray19[1] = 1;
        byArray19[2] = 2;
        byArray19[3] = 3;
        byArray19[4] = 4;
        byArray19[5] = 5;
        byArray19[6] = 6;
        byArray19[7] = 7;
        byte[] byArray20 = new byte[8];
        byArray20[1] = 1;
        byArray20[2] = 2;
        byArray20[3] = 3;
        byArray20[4] = 5;
        byArray20[5] = 6;
        byArray20[6] = 7;
        byArray20[7] = 4;
        State moveD = new State(new byte[8], byArray19, byArray20);
        this.moves1 = new State[]{moveUw, moveUw.multiply(moveUw), moveUw.multiply(moveUw).multiply(moveUw), moveDw, moveDw.multiply(moveDw), moveDw.multiply(moveDw).multiply(moveDw), moveLw, moveLw.multiply(moveLw), moveLw.multiply(moveLw).multiply(moveLw), moveRw, moveRw.multiply(moveRw), moveRw.multiply(moveRw).multiply(moveRw), moveFw, moveFw.multiply(moveFw), moveFw.multiply(moveFw).multiply(moveFw), moveBw, moveBw.multiply(moveBw), moveBw.multiply(moveBw).multiply(moveBw)};
        this.moveNames1 = new String[]{"Uw", "Uw2", "Uw'", "Dw", "Dw2", "Dw'", "Lw", "Lw2", "Lw'", "Rw", "Rw2", "Rw'", "Fw", "Fw2", "Fw'", "Bw", "Bw2", "Bw'"};
        int[] nArray = new int[18];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 4;
        nArray[13] = 4;
        nArray[14] = 4;
        nArray[15] = 5;
        nArray[16] = 5;
        nArray[17] = 5;
        this.faces1 = nArray;
        this.moves2 = new State[]{moveUw, moveUw.multiply(moveUw), moveUw.multiply(moveUw).multiply(moveUw), moveDw, moveDw.multiply(moveDw), moveDw.multiply(moveDw).multiply(moveDw), moveLw.multiply(moveLw), moveRw.multiply(moveRw), moveFw.multiply(moveFw), moveBw.multiply(moveBw), moveU, moveU.multiply(moveU), moveU.multiply(moveU).multiply(moveU), moveD, moveD.multiply(moveD), moveD.multiply(moveD).multiply(moveD)};
        this.moveNames2 = new String[]{"Uw", "Uw2", "Uw'", "Dw", "Dw2", "Dw'", "Lw2", "Rw2", "Fw2", "Bw2", "U", "U2", "U'", "D", "D2", "D'"};
        int[] nArray2 = new int[16];
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 4;
        nArray2[9] = 5;
        nArray2[10] = 6;
        nArray2[11] = 6;
        nArray2[12] = 6;
        nArray2[13] = 7;
        nArray2[14] = 7;
        nArray2[15] = 7;
        this.faces2 = nArray2;
        this.orientationMove = new int[2187][this.moves1.length];
        int i2 = 0;
        while (i2 < this.orientationMove.length) {
            state2 = new State(IndexMapping.indexToZeroSumOrientation(i2, 3, 8), new byte[8], new byte[8]);
            j3 = 0;
            while (j3 < this.moves1.length) {
                this.orientationMove[i2][j3] = IndexMapping.zeroSumOrientationToIndex(state2.multiply((State)this.moves1[j3]).orientation, 3);
                ++j3;
            }
            ++i2;
        }
        this.edgesPermutationMove = new int[40320][this.moves2.length];
        i2 = 0;
        while (i2 < this.edgesPermutationMove.length) {
            state2 = new State(new byte[8], IndexMapping.indexToPermutation(i2, 8), new byte[8]);
            j3 = 0;
            while (j3 < this.moves2.length) {
                this.edgesPermutationMove[i2][j3] = IndexMapping.permutationToIndex(state2.multiply((State)this.moves2[j3]).edgesPermutation);
                ++j3;
            }
            ++i2;
        }
        this.edgesCombinationMove = new int[70][this.moves2.length];
        i2 = 0;
        while (i2 < this.edgesCombinationMove.length) {
            combination = IndexMapping.indexToCombination(i2, 4, 8);
            byte[] edges = new byte[8];
            nextTop = 0;
            nextBottom = 4;
            int j4 = 0;
            while (j4 < edges.length) {
                if (combination[j4]) {
                    nextTop = (byte)(nextTop + 1);
                } else {
                    nextBottom = (byte)(nextBottom + 1);
                }
                ++j4;
            }
            state = new State(new byte[8], edges, new byte[8]);
            j2 = 0;
            while (j2 < this.moves2.length) {
                result = state.multiply(this.moves2[j2]);
                boolean[] isTopEdge = new boolean[8];
                k2 = 0;
                while (k2 < isTopEdge.length) {
                    isTopEdge[k2] = result.edgesPermutation[k2] < 4;
                    ++k2;
                }
                this.edgesCombinationMove[i2][j2] = IndexMapping.combinationToIndex(isTopEdge, 4);
                ++j2;
            }
            ++i2;
        }
        this.cornersPermutationMove = new int[40320][this.moves2.length];
        i2 = 0;
        while (i2 < this.cornersPermutationMove.length) {
            state2 = new State(new byte[8], new byte[8], IndexMapping.indexToPermutation(i2, 8));
            int j5 = 0;
            while (j5 < this.moves2.length) {
                this.cornersPermutationMove[i2][j5] = IndexMapping.permutationToIndex(state2.multiply((State)this.moves2[j5]).cornersPermutation);
                ++j5;
            }
            ++i2;
        }
        this.cornersCombinationMove = new int[70][this.moves2.length];
        i2 = 0;
        while (i2 < this.cornersCombinationMove.length) {
            combination = IndexMapping.indexToCombination(i2, 4, 8);
            byte[] corners = new byte[8];
            nextTop = 0;
            nextBottom = 4;
            int j6 = 0;
            while (j6 < corners.length) {
                if (combination[j6]) {
                    nextTop = (byte)(nextTop + 1);
                } else {
                    nextBottom = (byte)(nextBottom + 1);
                }
                ++j6;
            }
            state = new State(new byte[8], new byte[8], corners);
            j2 = 0;
            while (j2 < this.moves2.length) {
                result = state.multiply(this.moves2[j2]);
                boolean[] isTopCorner = new boolean[8];
                k2 = 0;
                while (k2 < isTopCorner.length) {
                    isTopCorner[k2] = result.cornersPermutation[k2] < 4;
                    ++k2;
                }
                this.cornersCombinationMove[i2][j2] = IndexMapping.combinationToIndex(isTopCorner, 4);
                ++j2;
            }
            ++i2;
        }
        this.orientationDistance = new byte[2187];
        i2 = 0;
        while (i2 < this.orientationDistance.length) {
            this.orientationDistance[i2] = -1;
            ++i2;
        }
        this.orientationDistance[0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.orientationDistance.length) {
                if (this.orientationDistance[i] == depth) {
                    j = 0;
                    while (j < this.moves1.length) {
                        int next = this.orientationMove[i][j];
                        if (this.orientationDistance[next] < 0) {
                            this.orientationDistance[next] = (byte)(depth + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.edgesPermutationDistance = new byte[40320][70];
        i = 0;
        while (i < this.edgesPermutationDistance.length) {
            j = 0;
            while (j < this.edgesPermutationDistance[i].length) {
                this.edgesPermutationDistance[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.edgesPermutationDistance[0][0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.edgesPermutationDistance.length) {
                j = 0;
                while (j < this.edgesPermutationDistance[i].length) {
                    if (this.edgesPermutationDistance[i][j] == depth) {
                        k = 0;
                        while (k < this.moves2.length) {
                            int nextPermutation = this.edgesPermutationMove[i][k];
                            nextCombination = this.cornersCombinationMove[j][k];
                            if (this.edgesPermutationDistance[nextPermutation][nextCombination] < 0) {
                                this.edgesPermutationDistance[nextPermutation][nextCombination] = (byte)(depth + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.cornersPermutationDistance = new byte[40320][70];
        i = 0;
        while (i < this.cornersPermutationDistance.length) {
            j = 0;
            while (j < this.cornersPermutationDistance[i].length) {
                this.cornersPermutationDistance[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.cornersPermutationDistance[0][0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.cornersPermutationDistance.length) {
                j = 0;
                while (j < this.cornersPermutationDistance[i].length) {
                    if (this.cornersPermutationDistance[i][j] == depth) {
                        k = 0;
                        while (k < this.moves2.length) {
                            int nextPermutation = this.cornersPermutationMove[i][k];
                            nextCombination = this.edgesCombinationMove[j][k];
                            if (this.cornersPermutationDistance[nextPermutation][nextCombination] < 0) {
                                this.cornersPermutationDistance[nextPermutation][nextCombination] = (byte)(depth + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.initialized = true;
    }

    public String[] solve(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        int orientation = IndexMapping.zeroSumOrientationToIndex(state.orientation, 3);
        int depth = 0;
        while (true) {
            ArrayList<Integer> solution;
            if (this.search(orientation, depth, solution = new ArrayList<Integer>(), -1)) {
                String[] solution2;
                ArrayList<String> sequence = new ArrayList<String>();
                State state2 = state;
                for (int moveIndex : solution) {
                    sequence.add(this.moveNames1[moveIndex]);
                    state2 = state2.multiply(this.moves1[moveIndex]);
                }
                String[] stringArray = solution2 = this.solve2(state2);
                int n = solution2.length;
                int n2 = 0;
                while (n2 < n) {
                    String move = stringArray[n2];
                    sequence.add(move);
                    ++n2;
                }
                String[] sequenceArray = new String[sequence.size()];
                sequence.toArray(sequenceArray);
                return sequenceArray;
            }
            ++depth;
        }
    }

    private boolean search(int orientation, int depth, ArrayList<Integer> solution, int lastFace) {
        if (depth == 0) {
            return orientation == 0;
        }
        if (this.orientationDistance[orientation] <= depth) {
            int i = 0;
            while (i < this.moves1.length) {
                if (this.faces1[i] != lastFace) {
                    solution.add(i);
                    if (this.search(this.orientationMove[orientation][i], depth - 1, solution, this.faces1[i])) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    private String[] solve2(State state) {
        int edgesPermutation = IndexMapping.permutationToIndex(state.edgesPermutation);
        boolean[] isTopEdge = new boolean[8];
        int k = 0;
        while (k < isTopEdge.length) {
            isTopEdge[k] = state.edgesPermutation[k] < 4;
            ++k;
        }
        int edgesCombination = IndexMapping.combinationToIndex(isTopEdge, 4);
        int cornersPermutation = IndexMapping.permutationToIndex(state.cornersPermutation);
        boolean[] isTopCorner = new boolean[8];
        int k2 = 0;
        while (k2 < isTopCorner.length) {
            isTopCorner[k2] = state.cornersPermutation[k2] < 4;
            ++k2;
        }
        int cornersCombination = IndexMapping.combinationToIndex(isTopCorner, 4);
        int depth = 0;
        while (true) {
            ArrayList<Integer> solution;
            if (this.search2(edgesPermutation, edgesCombination, cornersPermutation, cornersCombination, depth, solution = new ArrayList<Integer>(), -1)) {
                String[] sequence = new String[solution.size()];
                int i = 0;
                while (i < solution.size()) {
                    sequence[i] = this.moveNames2[solution.get(i)];
                    ++i;
                }
                return sequence;
            }
            ++depth;
        }
    }

    private boolean search2(int edgesPermutation, int edgesCombination, int cornersPermutation, int cornersCombination, int depth, ArrayList<Integer> solution, int lastFace) {
        if (depth == 0) {
            return edgesPermutation == 0 && cornersPermutation == 0;
        }
        if (this.edgesPermutationDistance[edgesPermutation][cornersCombination] <= depth && this.cornersPermutationDistance[cornersPermutation][edgesCombination] <= depth) {
            int i = 0;
            while (i < this.moves2.length) {
                if (this.faces2[i] != lastFace) {
                    solution.add(i);
                    if (this.search2(this.edgesPermutationMove[edgesPermutation][i], this.edgesCombinationMove[edgesCombination][i], this.cornersPermutationMove[cornersPermutation][i], this.cornersCombinationMove[cornersCombination][i], depth - 1, solution, this.faces2[i])) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    public String[] generate(State state) {
        String[] solution = this.solve(state);
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("Uw", "Uw'");
        inverseMoveNames.put("Uw2", "Uw2");
        inverseMoveNames.put("Uw'", "Uw");
        inverseMoveNames.put("Dw", "Dw'");
        inverseMoveNames.put("Dw2", "Dw2");
        inverseMoveNames.put("Dw'", "Dw");
        inverseMoveNames.put("Lw", "Lw'");
        inverseMoveNames.put("Lw2", "Lw2");
        inverseMoveNames.put("Lw'", "Lw");
        inverseMoveNames.put("Rw", "Rw'");
        inverseMoveNames.put("Rw2", "Rw2");
        inverseMoveNames.put("Rw'", "Rw");
        inverseMoveNames.put("Fw", "Fw'");
        inverseMoveNames.put("Fw2", "Fw2");
        inverseMoveNames.put("Fw'", "Fw");
        inverseMoveNames.put("Bw", "Bw'");
        inverseMoveNames.put("Bw2", "Bw2");
        inverseMoveNames.put("Bw'", "Bw");
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U2", "U2");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("D", "D'");
        inverseMoveNames.put("D2", "D2");
        inverseMoveNames.put("D'", "D");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public State getRandomState(Random random) {
        byte[] orientation = IndexMapping.indexToZeroSumOrientation(random.nextInt(2187), 3, 8);
        byte[] edgesPermutation = IndexMapping.indexToPermutation(random.nextInt(40320), 8);
        byte[] cornersPermutation = IndexMapping.indexToPermutation(random.nextInt(40320), 8);
        return new State(orientation, edgesPermutation, cornersPermutation);
    }

    public static class State {
        public byte[] orientation;
        public byte[] edgesPermutation;
        public byte[] cornersPermutation;

        public State(byte[] orientation, byte[] edgesPermutation, byte[] cornersPermutation) {
            this.orientation = orientation;
            this.edgesPermutation = edgesPermutation;
            this.cornersPermutation = cornersPermutation;
        }

        public State multiply(State move) {
            byte[] orientation = new byte[8];
            byte[] edgesPermutation = new byte[8];
            byte[] cornersPermutation = new byte[8];
            int i = 0;
            while (i < 8) {
                orientation[i] = (byte)((this.orientation[move.edgesPermutation[i]] + move.orientation[i]) % 3);
                edgesPermutation[i] = this.edgesPermutation[move.edgesPermutation[i]];
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                ++i;
            }
            return new State(orientation, edgesPermutation, cornersPermutation);
        }
    }
}

