/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Square1ShapeSolver {
    public static final int N_POSITIONS = 0x1000000;
    public static int[] distance;

    static {
        int nVisitedPositions;
        distance = new int[0x1000000];
        int i = 0;
        while (i < distance.length) {
            Square1ShapeSolver.distance[i] = -1;
            ++i;
        }
        Square1ShapeSolver.distance[State.id.index] = 0;
        int depth = 0;
        do {
            nVisitedPositions = 0;
            int i2 = 0;
            while (i2 < distance.length) {
                if (distance[i2] == depth) {
                    State state = new State(i2);
                    if (state.isTwistable()) {
                        State next = state.twist();
                        if (distance[next.index] == -1) {
                            Square1ShapeSolver.distance[next.index] = depth + 1;
                            ++nVisitedPositions;
                        }
                    }
                    State nextTop = new State(i2);
                    int j = 0;
                    while (j < 11) {
                        nextTop = nextTop.rotateTop();
                        if (distance[nextTop.index] == -1) {
                            Square1ShapeSolver.distance[nextTop.index] = depth + 1;
                            ++nVisitedPositions;
                        }
                        ++j;
                    }
                    State nextBottom = new State(i2);
                    int j2 = 0;
                    while (j2 < 11) {
                        nextBottom = nextBottom.rotateBottom();
                        if (distance[nextBottom.index] == -1) {
                            Square1ShapeSolver.distance[nextBottom.index] = depth + 1;
                            ++nVisitedPositions;
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
            ++depth;
        } while (nVisitedPositions > 0);
    }

    public static String[] solve(State state) {
        ArrayList<String> sequence = new ArrayList<String>();
        while (distance[state.index] > 0) {
            if (state.isTwistable()) {
                State next = state.twist();
                if (distance[next.index] == distance[state.index] - 1) {
                    sequence.add("/");
                    state = next;
                }
            }
            int x = 0;
            State nextTop = new State(state.index);
            int i = 0;
            while (i < 12) {
                if (distance[nextTop.index] == distance[state.index] - 1) {
                    x = i;
                    state = nextTop;
                    break;
                }
                nextTop = nextTop.rotateTop();
                ++i;
            }
            int y = 0;
            State nextBottom = new State(state.index);
            int j = 0;
            while (j < 12) {
                if (distance[nextBottom.index] == distance[state.index] - 1) {
                    y = j;
                    state = nextBottom;
                    break;
                }
                nextBottom = nextBottom.rotateBottom();
                ++j;
            }
            if (x == 0 && y == 0) continue;
            sequence.add("(" + (x <= 6 ? x : x - 12) + "," + (y <= 6 ? y : y - 12) + ")");
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    public static class State {
        public int index;
        public static State id;

        static {
            boolean[] blArray = new boolean[24];
            blArray[0] = true;
            blArray[2] = true;
            blArray[3] = true;
            blArray[5] = true;
            blArray[6] = true;
            blArray[8] = true;
            blArray[9] = true;
            blArray[11] = true;
            blArray[12] = true;
            blArray[13] = true;
            blArray[15] = true;
            blArray[16] = true;
            blArray[18] = true;
            blArray[19] = true;
            blArray[21] = true;
            blArray[22] = true;
            id = new State(blArray);
        }

        public State(int index) {
            this.index = index;
        }

        public State(boolean[] cuts) {
            this.index = 0;
            int i = 0;
            while (i < 12) {
                this.index <<= 1;
                if (cuts[23 - i]) {
                    this.index |= 1;
                }
                ++i;
            }
            i = 0;
            while (i < 12) {
                this.index <<= 1;
                if (cuts[11 - i]) {
                    this.index |= 1;
                }
                ++i;
            }
        }

        private static int rotate(int layer) {
            return layer << 1 & 0xFFE | layer >> 11 & 1;
        }

        private int getTop() {
            return this.index & 0xFFF;
        }

        private int getBottom() {
            return this.index >> 12 & 0xFFF;
        }

        public State rotateTop() {
            return new State(this.getBottom() << 12 | State.rotate(this.getTop()));
        }

        public State rotateBottom() {
            return new State(State.rotate(this.getBottom()) << 12 | this.getTop());
        }

        public State twist() {
            int top = this.getTop();
            int bottom = this.getBottom();
            int newTop = top & 0xF80 | bottom & 0x7F;
            int newBottom = bottom & 0xF80 | top & 0x7F;
            return new State(newBottom << 12 | newTop);
        }

        public boolean isTwistable() {
            int top = this.getTop();
            int bottom = this.getBottom();
            return (top & 1) != 0 && (top & 0x40) != 0 && (bottom & 1) != 0 && (bottom & 0x40) != 0;
        }

        public State applyMove(String move) {
            State state = this;
            if (move.equals("/")) {
                state = state.twist();
            } else {
                Pattern p = Pattern.compile("\\((-?\\d+),(-?\\d+)\\)");
                Matcher matcher = p.matcher(move.toString());
                matcher.find();
                int top = Integer.parseInt(matcher.group(1));
                int i = 0;
                while (i < top + 12) {
                    state = state.rotateTop();
                    ++i;
                }
                int bottom = Integer.parseInt(matcher.group(2));
                int i2 = 0;
                while (i2 < bottom + 12) {
                    state = state.rotateBottom();
                    ++i2;
                }
            }
            return state;
        }

        public State applySequence(String[] sequence) {
            State state = this;
            String[] stringArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                String move = stringArray[n2];
                state = state.applyMove(move);
                ++n2;
            }
            return state;
        }
    }
}

