/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class Square1Solver {
    private boolean initialized = false;
    private State[] moves1;
    private ArrayList<State> shapes;
    private HashMap<Integer, Integer> evenShapeDistance;
    private HashMap<Integer, Integer> oddShapeDistance;
    public final int N_CORNERS_PERMUTATIONS = 40320;
    public final int N_CORNERS_COMBINATIONS = 70;
    public final int N_EDGES_PERMUTATIONS = 40320;
    public final int N_EDGES_COMBINATIONS = 70;
    private CubeState[] moves2;
    private int[][] cornersPermutationMove;
    private int[][] cornersCombinationMove;
    private int[][] edgesPermutationMove;
    private int[][] edgesCombinationMove;
    private byte[][] cornersDistance;
    private byte[][] edgesDistance;

    private void initialize() {
        int k;
        int i;
        int nVisited;
        int k2;
        CubeState result;
        int j;
        CubeState state;
        int nextBottom;
        int nextTop;
        boolean[] combination;
        CubeState state2;
        State moveTwist;
        State move01;
        State move10;
        this.moves1 = new State[23];
        byte[] byArray = new byte[24];
        byArray[0] = 11;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 4;
        byArray[6] = 5;
        byArray[7] = 6;
        byArray[8] = 7;
        byArray[9] = 8;
        byArray[10] = 9;
        byArray[11] = 10;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        State move = move10 = new State(byArray);
        int i2 = 0;
        while (i2 < 11) {
            this.moves1[i2] = move;
            move = move.multiply(move10);
            ++i2;
        }
        byte[] byArray2 = new byte[24];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        byArray2[8] = 8;
        byArray2[9] = 9;
        byArray2[10] = 10;
        byArray2[11] = 11;
        byArray2[12] = 13;
        byArray2[13] = 14;
        byArray2[14] = 15;
        byArray2[15] = 16;
        byArray2[16] = 17;
        byArray2[17] = 18;
        byArray2[18] = 19;
        byArray2[19] = 20;
        byArray2[20] = 21;
        byArray2[21] = 22;
        byArray2[22] = 23;
        byArray2[23] = 12;
        move = move01 = new State(byArray2);
        int i3 = 0;
        while (i3 < 11) {
            this.moves1[11 + i3] = move;
            move = move.multiply(move01);
            ++i3;
        }
        byte[] byArray3 = new byte[24];
        byArray3[1] = 1;
        byArray3[2] = 19;
        byArray3[3] = 18;
        byArray3[4] = 17;
        byArray3[5] = 16;
        byArray3[6] = 15;
        byArray3[7] = 14;
        byArray3[8] = 8;
        byArray3[9] = 9;
        byArray3[10] = 10;
        byArray3[11] = 11;
        byArray3[12] = 12;
        byArray3[13] = 13;
        byArray3[14] = 7;
        byArray3[15] = 6;
        byArray3[16] = 5;
        byArray3[17] = 4;
        byArray3[18] = 3;
        byArray3[19] = 2;
        byArray3[20] = 20;
        byArray3[21] = 21;
        byArray3[22] = 22;
        byArray3[23] = 23;
        this.moves1[22] = moveTwist = new State(byArray3);
        this.shapes = new ArrayList();
        this.evenShapeDistance = new HashMap();
        this.oddShapeDistance = new HashMap();
        this.evenShapeDistance.put(State.id.getShapeIndex(), 0);
        ArrayList<State> fringe = new ArrayList<State>();
        fringe.add(State.id);
        int depth = 0;
        while (fringe.size() > 0) {
            ArrayList<State> newFringe = new ArrayList<State>();
            for (State state3 : fringe) {
                if (state3.isTwistable()) {
                    this.shapes.add(state3);
                }
                int i4 = 0;
                while (i4 < this.moves1.length) {
                    if (i4 != 22 || state3.isTwistable()) {
                        HashMap<Integer, Integer> distanceTable;
                        State next = state3.multiply(this.moves1[i4]);
                        HashMap<Integer, Integer> hashMap = distanceTable = this.isEvenPermutation(next.getPiecesPermutation()) ? this.evenShapeDistance : this.oddShapeDistance;
                        if (!distanceTable.containsKey(next.getShapeIndex())) {
                            distanceTable.put(next.getShapeIndex(), depth + 1);
                            newFringe.add(next);
                        }
                    }
                    ++i4;
                }
            }
            fringe = newFringe;
            ++depth;
        }
        byte[] byArray4 = new byte[8];
        byArray4[0] = 3;
        byArray4[2] = 1;
        byArray4[3] = 2;
        byArray4[4] = 4;
        byArray4[5] = 5;
        byArray4[6] = 6;
        byArray4[7] = 7;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 3;
        byArray5[2] = 1;
        byArray5[3] = 2;
        byArray5[4] = 4;
        byArray5[5] = 5;
        byArray5[6] = 6;
        byArray5[7] = 7;
        CubeState move30 = new CubeState(byArray4, byArray5);
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[3] = 3;
        byArray6[4] = 5;
        byArray6[5] = 6;
        byArray6[6] = 7;
        byArray6[7] = 4;
        byte[] byArray7 = new byte[8];
        byArray7[1] = 1;
        byArray7[2] = 2;
        byArray7[3] = 3;
        byArray7[4] = 5;
        byArray7[5] = 6;
        byArray7[6] = 7;
        byArray7[7] = 4;
        CubeState move03 = new CubeState(byArray6, byArray7);
        byte[] byArray8 = new byte[8];
        byArray8[1] = 6;
        byArray8[2] = 5;
        byArray8[3] = 3;
        byArray8[4] = 4;
        byArray8[5] = 2;
        byArray8[6] = 1;
        byArray8[7] = 7;
        byte[] byArray9 = new byte[8];
        byArray9[0] = 6;
        byArray9[1] = 5;
        byArray9[2] = 2;
        byArray9[3] = 3;
        byArray9[4] = 4;
        byArray9[5] = 1;
        byArray9[7] = 7;
        CubeState moveTwistTop = new CubeState(byArray8, byArray9);
        byte[] byArray10 = new byte[8];
        byArray10[1] = 6;
        byArray10[2] = 5;
        byArray10[3] = 3;
        byArray10[4] = 4;
        byArray10[5] = 2;
        byArray10[6] = 1;
        byArray10[7] = 7;
        byte[] byArray11 = new byte[8];
        byArray11[1] = 5;
        byArray11[2] = 4;
        byArray11[3] = 3;
        byArray11[4] = 2;
        byArray11[5] = 1;
        byArray11[6] = 6;
        byArray11[7] = 7;
        CubeState moveTwistBottom = new CubeState(byArray10, byArray11);
        this.moves2 = new CubeState[]{move30, move30.multiply(move30), move30.multiply(move30).multiply(move30), move03, move03.multiply(move03), move03.multiply(move03).multiply(move03), moveTwistTop, moveTwistBottom};
        this.cornersPermutationMove = new int[40320][this.moves2.length];
        int i5 = 0;
        while (i5 < this.cornersPermutationMove.length) {
            state2 = new CubeState(IndexMapping.indexToPermutation(i5, 8), new byte[8]);
            int j2 = 0;
            while (j2 < this.cornersPermutationMove[i5].length) {
                this.cornersPermutationMove[i5][j2] = IndexMapping.permutationToIndex(state2.multiply((CubeState)this.moves2[j2]).cornersPermutation);
                ++j2;
            }
            ++i5;
        }
        this.cornersCombinationMove = new int[70][this.moves2.length];
        i5 = 0;
        while (i5 < this.cornersCombinationMove.length) {
            combination = IndexMapping.indexToCombination(i5, 4, 8);
            byte[] corners = new byte[8];
            nextTop = 0;
            nextBottom = 4;
            int j3 = 0;
            while (j3 < corners.length) {
                if (combination[j3]) {
                    nextTop = (byte)(nextTop + 1);
                } else {
                    nextBottom = (byte)(nextBottom + 1);
                }
                ++j3;
            }
            state = new CubeState(corners, new byte[8]);
            j = 0;
            while (j < this.cornersCombinationMove[i5].length) {
                result = state.multiply(this.moves2[j]);
                boolean[] isTopCorner = new boolean[8];
                k2 = 0;
                while (k2 < isTopCorner.length) {
                    isTopCorner[k2] = result.cornersPermutation[k2] < 4;
                    ++k2;
                }
                this.cornersCombinationMove[i5][j] = IndexMapping.combinationToIndex(isTopCorner, 4);
                ++j;
            }
            ++i5;
        }
        this.edgesPermutationMove = new int[40320][this.moves2.length];
        i5 = 0;
        while (i5 < this.edgesPermutationMove.length) {
            state2 = new CubeState(new byte[8], IndexMapping.indexToPermutation(i5, 8));
            int j4 = 0;
            while (j4 < this.edgesPermutationMove[i5].length) {
                this.edgesPermutationMove[i5][j4] = IndexMapping.permutationToIndex(state2.multiply((CubeState)this.moves2[j4]).edgesPermutation);
                ++j4;
            }
            ++i5;
        }
        this.edgesCombinationMove = new int[70][this.moves2.length];
        i5 = 0;
        while (i5 < this.edgesCombinationMove.length) {
            combination = IndexMapping.indexToCombination(i5, 4, 8);
            byte[] edges = new byte[8];
            nextTop = 0;
            nextBottom = 4;
            int j5 = 0;
            while (j5 < edges.length) {
                if (combination[j5]) {
                    nextTop = (byte)(nextTop + 1);
                } else {
                    nextBottom = (byte)(nextBottom + 1);
                }
                ++j5;
            }
            state = new CubeState(new byte[8], edges);
            j = 0;
            while (j < this.edgesCombinationMove[i5].length) {
                result = state.multiply(this.moves2[j]);
                boolean[] isTopEdge = new boolean[8];
                k2 = 0;
                while (k2 < isTopEdge.length) {
                    isTopEdge[k2] = result.edgesPermutation[k2] < 4;
                    ++k2;
                }
                this.edgesCombinationMove[i5][j] = IndexMapping.combinationToIndex(isTopEdge, 4);
                ++j;
            }
            ++i5;
        }
        this.cornersDistance = new byte[40320][70];
        i5 = 0;
        while (i5 < this.cornersDistance.length) {
            int j6 = 0;
            while (j6 < this.cornersDistance[i5].length) {
                this.cornersDistance[i5][j6] = -1;
                ++j6;
            }
            ++i5;
        }
        this.cornersDistance[0][0] = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.cornersDistance.length) {
                int j7 = 0;
                while (j7 < this.cornersDistance[i].length) {
                    if (this.cornersDistance[i][j7] == depth) {
                        k = 0;
                        while (k < this.moves2.length) {
                            int nextCornerPermutation = this.cornersPermutationMove[i][k];
                            int nextEdgeCombination = this.edgesCombinationMove[j7][k];
                            if (this.cornersDistance[nextCornerPermutation][nextEdgeCombination] < 0) {
                                this.cornersDistance[nextCornerPermutation][nextEdgeCombination] = (byte)(depth + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j7;
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.edgesDistance = new byte[40320][70];
        i = 0;
        while (i < this.edgesDistance.length) {
            int j8 = 0;
            while (j8 < this.edgesDistance[i].length) {
                this.edgesDistance[i][j8] = -1;
                ++j8;
            }
            ++i;
        }
        this.edgesDistance[0][0] = 0;
        depth = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < this.edgesDistance.length) {
                int j9 = 0;
                while (j9 < this.edgesDistance[i].length) {
                    if (this.edgesDistance[i][j9] == depth) {
                        k = 0;
                        while (k < this.moves2.length) {
                            int nextEdgesPermutation = this.edgesPermutationMove[i][k];
                            int nextCornersCombination = this.cornersCombinationMove[j9][k];
                            if (this.edgesDistance[nextEdgesPermutation][nextCornersCombination] < 0) {
                                this.edgesDistance[nextEdgesPermutation][nextCornersCombination] = (byte)(depth + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j9;
                }
                ++i;
            }
            ++depth;
        } while (nVisited > 0);
        this.initialized = true;
    }

    private boolean isEvenPermutation(byte[] permutation) {
        int nInversions = 0;
        int i = 0;
        while (i < permutation.length) {
            int j = i + 1;
            while (j < permutation.length) {
                if (permutation[i] > permutation[j]) {
                    ++nInversions;
                }
                ++j;
            }
            ++i;
        }
        return nInversions % 2 == 0;
    }

    public String[] solve(State state) {
        ArrayList<String> sequence = new ArrayList<String>();
        int top = 0;
        int bottom = 0;
        int[] nArray = this.solution(state);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int moveIndex = nArray[n2];
            if (moveIndex < 11) {
                top += moveIndex + 1;
                top %= 12;
            } else if (moveIndex < 22) {
                bottom += moveIndex - 11 + 1;
                bottom %= 12;
            } else {
                if (top != 0 || bottom != 0) {
                    if (top > 6) {
                        top = -(12 - top);
                    }
                    if (bottom > 6) {
                        bottom = -(12 - bottom);
                    }
                    sequence.add(String.format("(%d,%d)", top, bottom));
                    top = 0;
                    bottom = 0;
                }
                sequence.add("/");
            }
            ++n2;
        }
        if (top != 0 || bottom != 0) {
            if (top > 6) {
                top = -(12 - top);
            }
            if (bottom > 6) {
                bottom = -(12 - bottom);
            }
            sequence.add(String.format("(%d,%d)", top, bottom));
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    public String[] generate(State state) {
        ArrayList<String> sequence = new ArrayList<String>();
        int top = 0;
        int bottom = 0;
        int[] solution = this.solution(state);
        int i = solution.length - 1;
        while (i >= 0) {
            if (solution[i] < 11) {
                top += 12 - (solution[i] + 1);
                top %= 12;
            } else if (solution[i] < 22) {
                bottom += 12 - (solution[i] - 11 + 1);
                bottom %= 12;
            } else {
                if (top != 0 || bottom != 0) {
                    if (top > 6) {
                        top = -(12 - top);
                    }
                    if (bottom > 6) {
                        bottom = -(12 - bottom);
                    }
                    sequence.add(String.format("(%d,%d)", top, bottom));
                    top = 0;
                    bottom = 0;
                }
                sequence.add("/");
            }
            --i;
        }
        if (top != 0 || bottom != 0) {
            if (top > 6) {
                top = -(12 - top);
            }
            if (bottom > 6) {
                bottom = -(12 - bottom);
            }
            sequence.add(String.format("(%d,%d)", top, bottom));
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    private int[] solution(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        int depth = 0;
        while (true) {
            ArrayList<Integer> solution1 = new ArrayList<Integer>();
            ArrayList<Integer> solution2 = new ArrayList<Integer>();
            if (this.search(state, this.isEvenPermutation(state.getPiecesPermutation()), depth, solution1, solution2)) {
                ArrayList<Integer> sequence = new ArrayList<Integer>();
                for (int moveIndex : solution1) {
                    sequence.add(moveIndex);
                }
                int[][] nArrayArray = new int[8][];
                nArrayArray[0] = new int[]{2};
                nArrayArray[1] = new int[]{5};
                nArrayArray[2] = new int[]{8};
                nArrayArray[3] = new int[]{13};
                nArrayArray[4] = new int[]{16};
                nArrayArray[5] = new int[]{19};
                int[] nArray = new int[3];
                nArray[1] = 22;
                nArray[2] = 10;
                nArrayArray[6] = nArray;
                nArrayArray[7] = new int[]{21, 22, 11};
                int[][] phase2MoveMapping = nArrayArray;
                for (int moveIndex : solution2) {
                    int[] nArray2 = phase2MoveMapping[moveIndex];
                    int n = nArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int phase1MoveIndex = nArray2[n2];
                        sequence.add(phase1MoveIndex);
                        ++n2;
                    }
                }
                int[] sequenceArray = new int[sequence.size()];
                int i = 0;
                while (i < sequenceArray.length) {
                    sequenceArray[i] = (Integer)sequence.get(i);
                    ++i;
                }
                return sequenceArray;
            }
            ++depth;
        }
    }

    private boolean search(State state, boolean isEvenPermutation, int depth, ArrayList<Integer> solution1, ArrayList<Integer> solution2) {
        if (depth == 0) {
            int[] sequence2;
            if (isEvenPermutation && state.getShapeIndex() == State.id.getShapeIndex() && (sequence2 = this.solution2(state.toCubeState(), 17)) != null) {
                int[] nArray = sequence2;
                int n = sequence2.length;
                int n2 = 0;
                while (n2 < n) {
                    int m = nArray[n2];
                    solution2.add(m);
                    ++n2;
                }
                return true;
            }
            return false;
        }
        int distance = isEvenPermutation ? this.evenShapeDistance.get(state.getShapeIndex()) : this.oddShapeDistance.get(state.getShapeIndex());
        if (distance <= depth) {
            int i = 0;
            while (i < this.moves1.length) {
                if (i != 22 || state.isTwistable()) {
                    State next = state.multiply(this.moves1[i]);
                    solution1.add(i);
                    if (this.search(next, this.isEvenPermutation(next.getPiecesPermutation()), depth - 1, solution1, solution2)) {
                        return true;
                    }
                    solution1.remove(solution1.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    private int[] solution2(CubeState state, int maxDepth) {
        int cornersPermutation = IndexMapping.permutationToIndex(state.cornersPermutation);
        boolean[] isTopCorner = new boolean[8];
        int k = 0;
        while (k < isTopCorner.length) {
            isTopCorner[k] = state.cornersPermutation[k] < 4;
            ++k;
        }
        int cornersCombination = IndexMapping.combinationToIndex(isTopCorner, 4);
        int edgesPermutation = IndexMapping.permutationToIndex(state.edgesPermutation);
        boolean[] isTopEdge = new boolean[8];
        int k2 = 0;
        while (k2 < isTopEdge.length) {
            isTopEdge[k2] = state.edgesPermutation[k2] < 4;
            ++k2;
        }
        int edgesCombination = IndexMapping.combinationToIndex(isTopEdge, 4);
        int depth = 0;
        while (depth <= maxDepth) {
            int[] solution = new int[depth];
            if (this.search2(cornersPermutation, cornersCombination, edgesPermutation, edgesCombination, depth, solution)) {
                return solution;
            }
            ++depth;
        }
        return null;
    }

    private boolean search2(int cornersPermutation, int cornersCombination, int edgesPermutation, int edgesCombination, int depth, int[] solution) {
        if (depth == 0) {
            return cornersPermutation == 0 && edgesPermutation == 0;
        }
        if (this.cornersDistance[cornersPermutation][edgesCombination] <= depth && this.edgesDistance[edgesPermutation][cornersCombination] <= depth) {
            int i = 0;
            while (i < this.moves2.length) {
                if (solution.length - depth - 1 < 0 || solution[solution.length - depth - 1] / 3 != i / 3) {
                    solution[solution.length - depth] = i;
                    if (this.search2(this.cornersPermutationMove[cornersPermutation][i], this.cornersCombinationMove[cornersCombination][i], this.edgesPermutationMove[edgesPermutation][i], this.edgesCombinationMove[edgesCombination][i], depth - 1, solution)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public State getRandomState(State shape, Random random) {
        byte[] cornersPermutation = IndexMapping.indexToPermutation(random.nextInt(40320), 8);
        byte[] edgesPermutation = IndexMapping.indexToPermutation(random.nextInt(40320), 8);
        byte[] permutation = new byte[shape.permutation.length];
        int i = 0;
        while (i < permutation.length) {
            permutation[i] = shape.permutation[i] < 8 ? cornersPermutation[shape.permutation[i]] : (byte)(8 + edgesPermutation[shape.permutation[i] - 8]);
            ++i;
        }
        return new State(permutation);
    }

    public State getRandomState(Random random) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.getRandomState(this.shapes.get(random.nextInt(this.shapes.size())), random);
    }

    private static class CubeState {
        public byte[] cornersPermutation;
        public byte[] edgesPermutation;

        public CubeState(byte[] cornersPermutation, byte[] edgesPermutation) {
            this.cornersPermutation = cornersPermutation;
            this.edgesPermutation = edgesPermutation;
        }

        public CubeState multiply(CubeState move) {
            byte[] cornersPermutation = new byte[8];
            byte[] edgesPermutation = new byte[8];
            int i = 0;
            while (i < 8) {
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                edgesPermutation[i] = this.edgesPermutation[move.edgesPermutation[i]];
                ++i;
            }
            return new CubeState(cornersPermutation, edgesPermutation);
        }
    }

    public static class State {
        public byte[] permutation;
        public static State id;

        static {
            byte[] byArray = new byte[24];
            byArray[1] = 8;
            byArray[2] = 1;
            byArray[3] = 1;
            byArray[4] = 9;
            byArray[5] = 2;
            byArray[6] = 2;
            byArray[7] = 10;
            byArray[8] = 3;
            byArray[9] = 3;
            byArray[10] = 11;
            byArray[12] = 4;
            byArray[13] = 12;
            byArray[14] = 5;
            byArray[15] = 5;
            byArray[16] = 13;
            byArray[17] = 6;
            byArray[18] = 6;
            byArray[19] = 14;
            byArray[20] = 7;
            byArray[21] = 7;
            byArray[22] = 15;
            byArray[23] = 4;
            id = new State(byArray);
        }

        public State(byte[] permutation) {
            this.permutation = permutation;
        }

        public boolean isTwistable() {
            return this.permutation[1] != this.permutation[2] && this.permutation[7] != this.permutation[8] && this.permutation[13] != this.permutation[14] && this.permutation[19] != this.permutation[20];
        }

        public State multiply(State move) {
            byte[] permutation = new byte[24];
            int i = 0;
            while (i < permutation.length) {
                permutation[i] = this.permutation[move.permutation[i]];
                ++i;
            }
            return new State(permutation);
        }

        public int getShapeIndex() {
            int next;
            byte[] cuts = new byte[24];
            int i = 0;
            while (i < cuts.length) {
                cuts[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 12) {
                next = (i + 1) % 12;
                if (this.permutation[i] != this.permutation[next]) {
                    cuts[i] = 1;
                }
                ++i;
            }
            i = 0;
            while (i < 12) {
                next = (i + 1) % 12;
                if (this.permutation[12 + i] != this.permutation[12 + next]) {
                    cuts[12 + i] = 1;
                }
                ++i;
            }
            return IndexMapping.orientationToIndex(cuts, 2);
        }

        public byte[] getPiecesPermutation() {
            int next;
            byte[] permutation = new byte[16];
            int nextSlot = 0;
            int i = 0;
            while (i < 12) {
                next = (i + 1) % 12;
                if (this.permutation[i] != this.permutation[next]) {
                    permutation[nextSlot++] = this.permutation[i];
                }
                ++i;
            }
            i = 0;
            while (i < 12) {
                next = 12 + (i + 1) % 12;
                if (this.permutation[12 + i] != this.permutation[next]) {
                    permutation[nextSlot++] = this.permutation[12 + i];
                }
                ++i;
            }
            return permutation;
        }

        public CubeState toCubeState() {
            int[] nArray = new int[8];
            nArray[1] = 3;
            nArray[2] = 6;
            nArray[3] = 9;
            nArray[4] = 12;
            nArray[5] = 15;
            nArray[6] = 18;
            nArray[7] = 21;
            int[] cornerIndices = nArray;
            byte[] cornersPermutation = new byte[8];
            int i = 0;
            while (i < cornersPermutation.length) {
                cornersPermutation[i] = this.permutation[cornerIndices[i]];
                ++i;
            }
            int[] edgeIndices = new int[]{1, 4, 7, 10, 13, 16, 19, 22};
            byte[] edgesPermutation = new byte[8];
            int i2 = 0;
            while (i2 < edgesPermutation.length) {
                edgesPermutation[i2] = (byte)(this.permutation[edgeIndices[i2]] - 8);
                ++i2;
            }
            return new CubeState(cornersPermutation, edgesPermutation);
        }
    }
}

