/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.Category;
import com.puzzletimer.state.CategoryListener;
import java.util.ArrayList;
import java.util.Arrays;

public class CategoryManager {
    private ArrayList<CategoryListener> listeners = new ArrayList();
    private ArrayList<Category> categories;
    private Category currentCategory;

    public CategoryManager(Category[] categories, Category currentCategory) {
        this.categories = new ArrayList<Category>(Arrays.asList(categories));
        this.currentCategory = currentCategory;
    }

    public Category[] getCategories() {
        return this.categories.toArray(new Category[this.categories.size()]);
    }

    public void addCategory(Category category) {
        this.categories.add(category);
        for (CategoryListener listener : this.listeners) {
            listener.categoryAdded(category);
        }
        this.notifyListeners();
    }

    public void removeCategory(Category category) {
        this.categories.remove(category);
        for (CategoryListener listener : this.listeners) {
            listener.categoryRemoved(category);
        }
        this.notifyListeners();
    }

    public void updateCategory(Category category) {
        int i = 0;
        while (i < this.categories.size()) {
            if (this.categories.get(i).getCategoryId().equals(category.getCategoryId())) {
                this.categories.set(i, category);
                break;
            }
            ++i;
        }
        for (CategoryListener listener : this.listeners) {
            listener.categoryUpdated(category);
        }
        this.notifyListeners();
    }

    public Category getCurrentCategory() {
        return this.currentCategory;
    }

    public void setCurrentCategory(Category category) {
        this.currentCategory = category;
        for (CategoryListener listener : this.listeners) {
            listener.currentCategoryChanged(this.currentCategory);
        }
        this.notifyListeners();
    }

    public void notifyListeners() {
        Category[] categories = this.getCategories();
        for (CategoryListener listener : this.listeners) {
            listener.categoriesUpdated(categories, this.currentCategory);
        }
    }

    public void addCategoryListener(CategoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeCategoryListener(CategoryListener listener) {
        this.listeners.remove(listener);
    }
}

