/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.util.SolutionUtils;

public class Average
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private long value;

    public Average(int minimumWindowSize, int maximumWindowSize) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return 0;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, false);
        int nDNFs = 0;
        long[] lArray = times;
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            if (time == Long.MAX_VALUE && ++nDNFs > 1) {
                this.value = Long.MAX_VALUE;
                return;
            }
            ++n2;
        }
        long worst = Long.MIN_VALUE;
        long best = Long.MAX_VALUE;
        long sum = 0L;
        long[] lArray2 = times;
        int n3 = times.length;
        int n4 = 0;
        while (n4 < n3) {
            long time = lArray2[n4];
            if (time > worst) {
                worst = time;
            }
            if (time < best) {
                best = time;
            }
            sum += time;
            ++n4;
        }
        this.value = (sum - worst - best) / (long)(solutions.length - 2);
    }
}

