/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.util.SolutionUtils;

public class StandardDeviation
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private long value;

    public StandardDeviation(int minimumWindowSize, int maximumWindowSize) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return 0;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, true);
        if (times.length == 0) {
            this.value = 0L;
            return;
        }
        double mean = 0.0;
        long[] lArray = times;
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            mean += (double)time;
            ++n2;
        }
        mean /= (double)times.length;
        double variance = 0.0;
        long[] lArray2 = times;
        int n3 = times.length;
        int n4 = 0;
        while (n4 < n3) {
            long time = lArray2[n4];
            variance += Math.pow((double)time - mean, 2.0);
            ++n4;
        }
        this.value = (long)Math.sqrt(variance /= (double)times.length);
    }
}

