/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.models.Timing;
import com.puzzletimer.state.TimerListener;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.timer.StackmatTimerReader;
import com.puzzletimer.timer.StackmatTimerReaderListener;
import com.puzzletimer.timer.Timer;
import java.util.Date;
import java.util.TimerTask;
import javax.sound.sampled.TargetDataLine;

public class StackmatTimer
implements StackmatTimerReaderListener,
Timer {
    private StackmatTimerReader stackmatTimerReader;
    private TimerManager timerManager;
    private boolean inspectionEnabled;
    private TimerListener timerListener;
    private java.util.Timer repeater;
    private Date start;
    private State state;

    public StackmatTimer(TargetDataLine targetDataLine, TimerManager timerManager) {
        this.stackmatTimerReader = new StackmatTimerReader(targetDataLine);
        this.timerManager = timerManager;
        this.inspectionEnabled = false;
        this.start = null;
        this.state = State.NOT_READY;
    }

    @Override
    public String getTimerId() {
        return "STACKMAT-TIMER";
    }

    @Override
    public void setInspectionEnabled(boolean inspectionEnabled) {
        this.inspectionEnabled = inspectionEnabled;
        switch (this.state) {
            case READY_FOR_INSPECTION: {
                if (inspectionEnabled) break;
                this.state = State.READY;
                break;
            }
            case READY: {
                if (!inspectionEnabled) break;
                this.state = State.READY_FOR_INSPECTION;
            }
        }
    }

    @Override
    public void start() {
        this.timerListener = new TimerListener(){

            @Override
            public void inspectionFinished() {
                StackmatTimer.this.state = State.NOT_READY;
            }
        };
        this.timerManager.addTimerListener(this.timerListener);
        this.stackmatTimerReader.addEventListener(this);
        Thread readerThread = new Thread(this.stackmatTimerReader);
        readerThread.start();
        this.repeater = new java.util.Timer();
        this.repeater.schedule(new TimerTask(){

            @Override
            public void run() {
                switch (StackmatTimer.this.state) {
                    case RUNNING: {
                        StackmatTimer.this.timerManager.updateSolutionTiming(new Timing(StackmatTimer.this.start, new Date()));
                    }
                }
            }
        }, 0L, 5L);
    }

    @Override
    public void stop() {
        this.timerManager.removeTimerListener(this.timerListener);
        this.stackmatTimerReader.removeEventListener(this);
        this.stackmatTimerReader.stop();
        this.repeater.cancel();
    }

    @Override
    public void dataReceived(byte[] data) {
        if (data[0] == 65 || data[0] == 67 || data[0] == 76) {
            this.timerManager.pressLeftHand();
        }
        if (data[0] == 32 || data[0] == 73 || data[0] == 82 || data[0] == 83) {
            this.timerManager.releaseLeftHand();
        }
        if (data[0] == 65 || data[0] == 67 || data[0] == 82) {
            this.timerManager.pressRightHand();
        }
        if (data[0] == 32 || data[0] == 73 || data[0] == 76 || data[0] == 83) {
            this.timerManager.releaseRightHand();
        }
        int minutes = data[1] - 48;
        int seconds = 10 * (data[2] - 48) + data[3] - 48;
        int centiseconds = 10 * (data[4] - 48) + data[5] - 48;
        long time = 60000 * minutes + 1000 * seconds + 10 * centiseconds;
        Date end = new Date();
        Date start = new Date(end.getTime() - time);
        Timing timing = new Timing(start, end);
        this.start = start;
        switch (this.state) {
            case NOT_READY: {
                if (data[0] != 73) break;
                this.state = this.inspectionEnabled ? State.READY_FOR_INSPECTION : State.READY;
                break;
            }
            case READY_FOR_INSPECTION: {
                if (data[0] != 67 && data[0] != 76 && data[0] != 82) break;
                this.timerManager.startInspection();
                this.state = State.READY;
                break;
            }
            case READY: {
                if (data[0] != 32) break;
                this.timerManager.startSolution();
                this.state = State.RUNNING;
                break;
            }
            case RUNNING: {
                if (data[0] != 67 && data[0] != 83) break;
                this.timerManager.finishSolution(timing);
                this.state = State.NOT_READY;
            }
        }
    }

    private static enum State {
        NOT_READY,
        READY_FOR_INSPECTION,
        READY,
        RUNNING;

    }
}

