/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.util;

import com.puzzletimer.models.Solution;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;

public class SolutionUtils {
    public static String formatSeconds(long time) {
        if (time == Long.MAX_VALUE) {
            return "DNF";
        }
        String sign = "";
        if (time < 0L) {
            sign = "-";
            time = -time;
        }
        time = (time + 5L) / 10L;
        return String.valueOf(sign) + String.format(Locale.ENGLISH, "%.2f", (double)time / 100.0);
    }

    public static String formatMinutes(long time) {
        if (time == Long.MAX_VALUE) {
            return "DNF";
        }
        String sign = "";
        if (time < 0L) {
            sign = "-";
            time = -time;
        }
        time = (time + 5L) / 10L;
        return String.valueOf(sign) + String.format(Locale.ENGLISH, "%02d:%05.2f", time / 6000L, (double)(time % 6000L) / 100.0);
    }

    public static long parseTime(String input) {
        long time;
        Scanner scanner = new Scanner(input.trim());
        scanner.useLocale(Locale.ENGLISH);
        if (input.contains(":")) {
            scanner.useDelimiter(":");
            if (!scanner.hasNextLong()) {
                return 0L;
            }
            long minutes = scanner.nextLong();
            if (minutes < 0L) {
                return 0L;
            }
            if (!scanner.hasNextDouble()) {
                return 0L;
            }
            double seconds = scanner.nextDouble();
            if (seconds < 0.0 || seconds >= 60.0) {
                return 0L;
            }
            time = (long)((double)(60000L * minutes) + 1000.0 * seconds);
        } else {
            if (!scanner.hasNextDouble()) {
                return 0L;
            }
            double seconds = scanner.nextDouble();
            if (seconds < 0.0) {
                return 0L;
            }
            time = (long)(1000.0 * seconds);
        }
        return 10L * ((time + 5L) / 10L);
    }

    public static long realTime(Solution solution) {
        if (solution.getPenalty().equals("DNF")) {
            return Long.MAX_VALUE;
        }
        if (solution.getPenalty().equals("+2")) {
            return solution.getTiming().getElapsedTime() + 2000L;
        }
        return solution.getTiming().getElapsedTime();
    }

    public static long[] realTimes(Solution[] solutions, boolean filterDNF) {
        ArrayList<Long> realTimes = new ArrayList<Long>();
        int i = 0;
        while (i < solutions.length) {
            long actualTime = SolutionUtils.realTime(solutions[i]);
            if (!filterDNF || actualTime != Long.MAX_VALUE) {
                realTimes.add(actualTime);
            }
            ++i;
        }
        long[] realTimesArray = new long[realTimes.size()];
        int i2 = 0;
        while (i2 < realTimesArray.length) {
            realTimesArray[i2] = (Long)realTimes.get(i2);
            ++i2;
        }
        return realTimesArray;
    }
}

