/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer;

import com.puzzletimer.Internationalization;
import com.puzzletimer.database.CategoryDAO;
import com.puzzletimer.database.ColorDAO;
import com.puzzletimer.database.ConfigurationDAO;
import com.puzzletimer.database.DatabaseException;
import com.puzzletimer.database.SolutionDAO;
import com.puzzletimer.gui.MainFrame;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.ConfigurationEntry;
import com.puzzletimer.models.Solution;
import com.puzzletimer.models.Timing;
import com.puzzletimer.parsers.ScrambleParserProvider;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ColorManager;
import com.puzzletimer.state.ConfigurationManager;
import com.puzzletimer.state.MessageManager;
import com.puzzletimer.state.ScrambleManager;
import com.puzzletimer.state.SessionManager;
import com.puzzletimer.state.SolutionManager;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.BestMean;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.timer.Timer;
import com.puzzletimer.tips.TipProvider;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.h2.tools.RunScript;

public class Main {
    private ConfigurationDAO configurationDAO;
    private ColorDAO colorDAO;
    private CategoryDAO categoryDAO;
    private SolutionDAO solutionDAO;
    private MessageManager messageManager;
    private ConfigurationManager configurationManager;
    private TimerManager timerManager;
    private PuzzleProvider puzzleProvider;
    private ColorManager colorManager;
    private ScrambleParserProvider scrambleParserProvider;
    private ScramblerProvider scramblerProvider;
    private TipProvider tipProvider;
    private CategoryManager categoryManager;
    private ScrambleManager scrambleManager;
    private SolutionManager solutionManager;
    private SessionManager sessionManager;

    public Main() {
        Connection connection;
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, Internationalization._("main.database_driver_load_error"), Internationalization._("main.prisma_puzzle_timer"), 0);
            System.exit(0);
        }
        File databaseFile = new File("puzzletimer.h2.db");
        if (!databaseFile.exists()) {
            try {
                connection = DriverManager.getConnection("jdbc:h2:puzzletimer", "sa", "");
                InputStreamReader script = new InputStreamReader(this.getClass().getResourceAsStream("/com/puzzletimer/resources/database/puzzletimer0.3.sql"));
                RunScript.execute(connection, script);
                connection.close();
            }
            catch (SQLException e) {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, String.format(Internationalization._("main.database_error_message"), e.getMessage()), Internationalization._("main.prisma_puzzle_timer"), 0);
                System.exit(0);
            }
        }
        connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:h2:puzzletimer;IFEXISTS=TRUE", "sa", "");
        }
        catch (SQLException e) {
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, Internationalization._("main.concurrent_database_access_error_message"), Internationalization._("main.prisma_puzzle_timer"), 0);
            System.exit(0);
        }
        Object[] versions = new String[]{"0.3", "0.4", "0.5"};
        while (true) {
            String currentVersion = "";
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT VALUE FROM CONFIGURATION WHERE KEY = 'VERSION'");
                while (resultSet.next()) {
                    currentVersion = resultSet.getString(1);
                }
            }
            catch (SQLException statement) {
                // empty catch block
            }
            int versionIndex = Arrays.binarySearch(versions, currentVersion);
            if (versionIndex < 0 || versionIndex == versions.length - 1) break;
            try {
                String scriptName = "puzzletimer" + (String)versions[versionIndex + 1] + ".sql";
                InputStreamReader script = new InputStreamReader(this.getClass().getResourceAsStream("/com/puzzletimer/resources/database/" + scriptName));
                RunScript.execute(connection, script);
            }
            catch (SQLException e) {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, String.format(Internationalization._("main.database_error_message"), e.getMessage()), Internationalization._("main.prisma_puzzle_timer"), 0);
                System.exit(0);
            }
        }
        this.messageManager = new MessageManager();
        this.configurationDAO = new ConfigurationDAO(connection);
        this.configurationManager = new ConfigurationManager(this.configurationDAO.getAll());
        this.configurationManager.addListener(new ConfigurationManager.Listener(){

            @Override
            public void configurationEntryUpdated(String key, String value) {
                try {
                    Main.this.configurationDAO.update(new ConfigurationEntry(key, value));
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }
        });
        this.timerManager = new TimerManager();
        this.timerManager.setInspectionEnabled(this.configurationManager.getConfiguration("INSPECTION-TIME-ENABLED").equals("TRUE"));
        this.timerManager.addListener(new TimerManager.Listener(){

            @Override
            public void solutionFinished(Timing timing, String penalty) {
                Main.this.solutionManager.addSolution(new Solution(UUID.randomUUID(), Main.this.categoryManager.getCurrentCategory().getCategoryId(), Main.this.scrambleManager.getCurrentScramble(), timing, penalty));
                StatisticalMeasure[] measures = new StatisticalMeasure[]{new Best(1, Integer.MAX_VALUE), new BestMean(3, 3), new BestMean(100, 100), new BestAverage(5, 5), new BestAverage(12, 12)};
                String[] descriptions = new String[]{Internationalization._("main.single"), Internationalization._("main.mean_of_3"), Internationalization._("main.mean_of_100"), Internationalization._("main.average_of_5"), Internationalization._("main.average_of_12")};
                Solution[] solutions = Main.this.solutionManager.getSolutions();
                Solution[] sessionSolutions = Main.this.sessionManager.getSolutions();
                int i = 0;
                while (i < measures.length) {
                    if (sessionSolutions.length >= measures[i].getMinimumWindowSize()) {
                        measures[i].setSolutions(solutions);
                        long allTimeBest = measures[i].getValue();
                        measures[i].setSolutions(sessionSolutions);
                        long sessionBest = measures[i].getValue();
                        if (measures[i].getWindowPosition() == 0 && sessionBest <= allTimeBest) {
                            Main.this.messageManager.enqueueMessage(MessageManager.MessageType.INFORMATION, String.format(Internationalization._("main.personal_record_message"), Main.this.categoryManager.getCurrentCategory().getDescription(), SolutionUtils.formatMinutes(measures[i].getValue()), descriptions[i]));
                        }
                    }
                    ++i;
                }
                Main.this.scrambleManager.changeScramble();
            }

            @Override
            public void timerChanged(Timer timer) {
                Main.this.configurationManager.setConfiguration("TIMER-TRIGGER", timer.getTimerId());
            }

            @Override
            public void inspectionEnabledSet(boolean inspectionEnabled) {
                Main.this.configurationManager.setConfiguration("INSPECTION-TIME-ENABLED", inspectionEnabled ? "TRUE" : "FALSE");
            }
        });
        this.puzzleProvider = new PuzzleProvider();
        this.colorDAO = new ColorDAO(connection);
        this.colorManager = new ColorManager(this.colorDAO.getAll());
        this.colorManager.addListener(new ColorManager.Listener(){

            @Override
            public void colorSchemeUpdated(ColorScheme colorScheme) {
                try {
                    Main.this.colorDAO.update(colorScheme);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }
        });
        this.scrambleParserProvider = new ScrambleParserProvider();
        this.scramblerProvider = new ScramblerProvider();
        this.tipProvider = new TipProvider();
        this.categoryDAO = new CategoryDAO(connection);
        Category[] categories = this.categoryDAO.getAll();
        UUID currentCategoryId = UUID.fromString(this.configurationManager.getConfiguration("CURRENT-CATEGORY"));
        Category currentCategory = null;
        Category[] categoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            if (category.getCategoryId().equals(currentCategoryId)) {
                currentCategory = category;
            }
            ++n2;
        }
        this.categoryManager = new CategoryManager(categories, currentCategory);
        this.categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void currentCategoryChanged(Category category) {
                Main.this.configurationManager.setConfiguration("CURRENT-CATEGORY", category.getCategoryId().toString());
                try {
                    Main.this.solutionManager.loadSolutions(Main.this.solutionDAO.getAll(category));
                    Main.this.sessionManager.clearSession();
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void categoryAdded(Category category) {
                try {
                    Main.this.categoryDAO.insert(category);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void categoryRemoved(Category category) {
                try {
                    Main.this.categoryDAO.delete(category);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void categoryUpdated(Category category) {
                try {
                    Main.this.categoryDAO.update(category);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }
        });
        this.scrambleManager = new ScrambleManager(this.scramblerProvider, this.scramblerProvider.get(currentCategory.getScramblerId()));
        this.categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void currentCategoryChanged(Category category) {
                Main.this.scrambleManager.setCategory(category);
            }
        });
        this.solutionDAO = new SolutionDAO(connection, this.scramblerProvider, this.scrambleParserProvider);
        this.solutionManager = new SolutionManager();
        this.solutionManager.addListener(new SolutionManager.Listener(){

            @Override
            public void solutionAdded(Solution solution) {
                Main.this.sessionManager.addSolution(solution);
                try {
                    Main.this.solutionDAO.insert(solution);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void solutionsAdded(Solution[] solutions) {
                try {
                    Main.this.solutionDAO.insert(solutions);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void solutionUpdated(Solution solution) {
                Main.this.sessionManager.updateSolution(solution);
                try {
                    Main.this.solutionDAO.update(solution);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }

            @Override
            public void solutionRemoved(Solution solution) {
                Main.this.sessionManager.removeSolution(solution);
                try {
                    Main.this.solutionDAO.delete(solution);
                }
                catch (DatabaseException e) {
                    Main.this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, String.format(Internationalization._("main.database_error_message"), e.getMessage()));
                }
            }
        });
        this.sessionManager = new SessionManager();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main main = new Main();
                Image icon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/puzzletimer/resources/icon.png"));
                MainFrame mainFrame = new MainFrame(main.messageManager, main.configurationManager, main.timerManager, main.puzzleProvider, main.colorManager, main.scrambleParserProvider, main.scramblerProvider, main.tipProvider, main.categoryManager, main.scrambleManager, main.solutionManager, main.sessionManager);
                mainFrame.setDefaultCloseOperation(3);
                mainFrame.setLocationRelativeTo(null);
                mainFrame.setIconImage(icon);
                main.categoryManager.setCurrentCategory(main.categoryManager.getCurrentCategory());
                mainFrame.setVisible(true);
            }
        });
    }
}

