/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.graphics;

import com.puzzletimer.graphics.Vector3;

public class Matrix44 {
    public final double[][] values;

    public Matrix44(double[][] matrix) {
        this.values = matrix;
    }

    public Matrix44 mul(Matrix44 m) {
        double[][] vals = new double[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                vals[i][j] = 0.0;
                int k = 0;
                while (k < 4) {
                    double[] dArray = vals[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.values[i][k] * m.values[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new Matrix44(vals);
    }

    public Vector3 mul(Vector3 v) {
        return new Vector3(this.values[0][0] * v.x + this.values[0][1] * v.y + this.values[0][2] * v.z + this.values[0][3], this.values[1][0] * v.x + this.values[1][1] * v.y + this.values[1][2] * v.z + this.values[1][3], this.values[2][0] * v.x + this.values[2][1] * v.y + this.values[2][2] * v.z + this.values[2][3]);
    }

    public static Matrix44 translation(Vector3 v) {
        return new Matrix44(new double[][]{{1.0, 0.0, 0.0, v.x}, {0.0, 1.0, 0.0, v.y}, {0.0, 0.0, 1.0, v.z}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix44 rotationX(double a) {
        return new Matrix44(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(a), Math.sin(a), 0.0}, {0.0, -Math.sin(a), Math.cos(a), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix44 rotationY(double a) {
        return new Matrix44(new double[][]{{Math.cos(a), 0.0, -Math.sin(a), 0.0}, {0.0, 1.0, 0.0, 0.0}, {Math.sin(a), 0.0, Math.cos(a), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix44 rotationZ(double a) {
        return new Matrix44(new double[][]{{Math.cos(a), Math.sin(a), 0.0, 0.0}, {-Math.sin(a), Math.cos(a), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }

    public static Matrix44 rotation(Vector3 v, double a) {
        double c = Math.cos(a);
        double s = Math.sin(a);
        double x = v.x;
        double y = v.y;
        double z = v.z;
        return new Matrix44(new double[][]{{1.0 + (1.0 - c) * (x * x - 1.0), -z * s + (1.0 - c) * x * y, y * s + (1.0 - c) * x * z, 0.0}, {z * s + (1.0 - c) * x * y, 1.0 + (1.0 - c) * (y * y - 1.0), -x * s + (1.0 - c) * y * z, 0.0}, {-y * s + (1.0 - c) * x * z, x * s + (1.0 - c) * y * z, 1.0 + (1.0 - c) * (z * z - 1.0), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }
}

