/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.graphics;

import com.puzzletimer.graphics.Face;
import com.puzzletimer.graphics.Matrix44;
import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.Plane;
import com.puzzletimer.graphics.Vector3;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JPanel;

public class Panel3D
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Mesh mesh = new Mesh(new Face[0]);
    private Vector3 lightDirection = new Vector3(0.0, 0.25, -1.0).unit();
    private Vector3 viewerPosition = new Vector3(0.0, 0.0, -325.0);
    private Vector3 cameraPosition = new Vector3(0.0, 0.0, -2.8);
    private Vector3 cameraRotation = new Vector3(0.0, 0.0, 0.0);
    private int lastX = 0;
    private int lastY = 0;

    public Panel3D() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
        this.repaint();
    }

    public void setLightDirection(Vector3 lightDirection) {
        this.lightDirection = lightDirection;
        this.repaint();
    }

    public void setViewerPosition(Vector3 viewerPosition) {
        this.viewerPosition = viewerPosition;
        this.repaint();
    }

    public void setCameraPosition(Vector3 cameraPosition) {
        this.cameraPosition = cameraPosition;
        this.repaint();
    }

    public void setCameraRotation(Vector3 cameraRotation) {
        this.cameraRotation = cameraRotation;
        this.repaint();
    }

    private Vector3 toCameraCoordinates(Vector3 v) {
        return Matrix44.rotationX(-this.cameraRotation.x).mul(Matrix44.rotationY(-this.cameraRotation.y).mul(Matrix44.rotationZ(-this.cameraRotation.z).mul(v.sub(this.cameraPosition))));
    }

    private Vector3 perspectiveProjection(Vector3 v) {
        return new Vector3((double)this.getWidth() / 2.0 + (-v.x - this.viewerPosition.x) * (this.viewerPosition.z / v.z), (double)this.getHeight() / 2.0 + (v.y - this.viewerPosition.y) * (this.viewerPosition.z / v.z), 0.0);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Face[] faces = Arrays.copyOf(this.mesh.faces, this.mesh.faces.length);
        Arrays.sort(faces, new Comparator<Face>(){

            @Override
            public int compare(Face f1, Face f2) {
                return Double.compare(f2.centroid().z, f1.centroid().z);
            }
        });
        Face[] pFaces = new Face[faces.length];
        int i = 0;
        while (i < pFaces.length) {
            Vector3[] vertices = new Vector3[faces[i].vertices.length];
            int j = 0;
            while (j < vertices.length) {
                vertices[j] = this.perspectiveProjection(this.toCameraCoordinates(faces[i].vertices[j]));
                ++j;
            }
            pFaces[i] = faces[i].setVertices(vertices);
            ++i;
        }
        Color backfacingColor = new Color((4 * this.getBackground().getRed() + 32) / 5, (4 * this.getBackground().getGreen() + 32) / 5, (4 * this.getBackground().getBlue() + 32) / 5);
        Face[] faceArray = pFaces;
        int n = pFaces.length;
        int n2 = 0;
        while (n2 < n) {
            Face pFace = faceArray[n2];
            Polygon polygon = new Polygon();
            Vector3[] vector3Array = pFace.vertices;
            int n3 = pFace.vertices.length;
            int n4 = 0;
            while (n4 < n3) {
                Vector3 v = vector3Array[n4];
                polygon.addPoint((int)v.x, (int)v.y);
                ++n4;
            }
            Plane plane = new Plane(pFace.vertices[0], pFace.vertices[1], pFace.vertices[2]);
            if (plane.n.z >= 0.0) {
                double light = Math.abs(this.lightDirection.dot(plane.n));
                float[] hsbColor = Color.RGBtoHSB(pFace.color.getRed(), pFace.color.getGreen(), pFace.color.getBlue(), null);
                Color fillColor = new Color(Color.HSBtoRGB(hsbColor[0], (float)(0.875 + 0.125 * light) * hsbColor[1], (float)(0.875 + 0.125 * light) * hsbColor[2]));
                g2.setColor(fillColor);
                g2.fillPolygon(polygon);
                Color outlineColor = new Color(Color.HSBtoRGB(hsbColor[0], (float)(0.9 * (0.875 + 0.125 * light) * (double)hsbColor[1]), (float)(0.9 * (0.875 + 0.125 * light) * (double)hsbColor[2])));
                g2.setColor(outlineColor);
                g2.drawPolygon(polygon);
            } else {
                g2.setColor(backfacingColor);
                g2.fillPolygon(polygon);
            }
            ++n2;
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double angleX = (double)(e.getY() - this.lastY) / 50.0;
        double angleY = (double)(e.getX() - this.lastX) / 50.0;
        this.mesh = this.mesh.transform(Matrix44.rotationZ(this.cameraRotation.z).mul(Matrix44.rotationY(this.cameraRotation.y).mul(Matrix44.rotationX(this.cameraRotation.x).mul(Matrix44.rotationX(angleX).mul(Matrix44.rotationY(angleY).mul(Matrix44.rotationX(-this.cameraRotation.x).mul(Matrix44.rotationY(-this.cameraRotation.y).mul(Matrix44.rotationZ(-this.cameraRotation.z)))))))));
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Vector3 direction = this.cameraPosition.unit();
        Vector3 newPosition = this.cameraPosition.add(direction.mul(0.1 * (double)e.getWheelRotation()));
        if (1.0 < newPosition.norm() && newPosition.norm() < 50.0) {
            this.cameraPosition = newPosition;
        }
        this.repaint();
    }
}

